   package robotics;

   import javax.comm.*;
   import java.util.*;
   import java.io.*;
   import javax.swing.*;
   import java.awt.*;
   import java.awt.event.*;

    class ProcessorInterface extends JFrame
   {
      SerialPort commPort;
   
      InputStream inputStream;
      OutputStream outputStream;
   
      JTextArea text = new JTextArea();
      JTextField field = new JTextField();
   
      RobotInterface robotInterface;
   
       ProcessorInterface()
      {
         Enumeration e = CommPortIdentifier.getPortIdentifiers();
         try
         {
            commPort = (SerialPort)((CommPortIdentifier)e.nextElement()).open("ProcessorInterface", 30000);
         
            inputStream = commPort.getInputStream();
            outputStream = commPort.getOutputStream();
         
            Thread inputThread = new Thread(new In());
            inputThread.start();
         }
             catch (PortInUseException ee) {
               System.out.println(ee);}
             catch (IOException ee) {
               System.out.println(ee);}
      }
   
       void userInterface()
      {
         Container c = getContentPane();
         c.setLayout(new BorderLayout());
      
         text.setEditable(true);
      
         c.add(new JScrollPane(text), BorderLayout.CENTER);
         c.add(field, BorderLayout.SOUTH);
      
         field.addKeyListener(
            
                new KeyAdapter()
               
               {
                   public void keyTyped(KeyEvent e)
                  {
                     int input = (int)e.getKeyChar();
                  
                     if (input == 10)
                     {
                        sendString(field.getText());
                        field.setText("");
                     }
                  
                     if (input == KeyEvent.VK_ESCAPE)
                        send(27);
                  }
               });
      
         setTitle("HC11 SCI-Interface");
         setSize(500,500);
         setLocation(250,250);
         show();
      }
   
       void send(int i)
      {
         try
         {
            outputStream.write(i);
            outputStream.flush();
         }
             catch (IOException e) {
               System.out.println(e);}
      }
   
       void sendString(String string)
      {
         for (int i = 0;i < string.length();i++)
            send((int)string.charAt(i));
      }
   
       void sendFile(String filename)
      {
         try
         {
            File file = new File(filename);
            FileInputStream fis = new FileInputStream(file);
         
            String s = "load t";
            sendString(s);
         
            int toSend = fis.read();
            while (toSend != -1)
            {
               send(toSend);
               toSend = fis.read();
            }
         }
             catch (FileNotFoundException e) {
               System.out.println(e);}
             catch (IOException e ){
               System.out.println(e);}
      }
   
       void done()
      {
         commPort.close();
         this.dispose();
      }
   
       class In implements Runnable
      {
         int keyPos = 0;
         String strKey = "Key:  ";
         BufferedReader br;
         String string;
      
          public void run()
         {
         
            br = new BufferedReader(new InputStreamReader(inputStream));
         
         
            System.out.println("GOING");
            while (true)
            {
               try
               {
                  string = br.readLine();
                  text.append(string + "\n");
                  text.setCaretPosition(text.getText().length());
               
                  if (string.equals("ready"))
                     if (robotInterface != null)
                        robotInterface.ready();
               }
                   catch (IOException ee) {
                     System.out.println(ee);}
            }
         }
      
          void checkSymbol(int in)
         {
            if (keyPos == strKey.length())
            {
               String s = new String("0" + (char)in);
               int keyPressed = Integer.parseInt(s);
               keyPos = 0;
            } 
            else if (strKey.charAt(keyPos) == in)
               keyPos++;
            else
               keyPos = 0;
         }
      }
   
   
       public static void main(String args[])
      {
         ProcessorInterface pi = new ProcessorInterface();
         //pi.userInterface();
      
         try
         {
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
         
            while (true)
            {
               String s = br.readLine();
               pi.sendString(s);
            }
         }
             catch (IOException e) {
               System.out.println(e);}  
      }
   
   }