   package robotics;

   import javax.swing.*;
   import java.awt.*;
   import java.io.*;
   import java.awt.event.*;
   import java.net.*;


    public class RobotInterface extends JFrame
   {
      boolean ready = false;
      int timeout = 30;
   
   //Communications Interfaces
      ProcessorInterface processorInterface = new ProcessorInterface();
      public ServerInterface serverInterface = new ServerInterface();
   
       public RobotInterface()
      {
         processorInterface.userInterface();
         processorInterface.robotInterface = this;
      
         Thread mediator = new Thread(new Mediator());
         mediator.start();
      //Create Speed Panel
         SpeedPanel speedPanel = new SpeedPanel();
         speedPanel.robotInterface = this;
      
      //Layout Frame
         Container container = getContentPane();
         container.setLayout(new BorderLayout());
         container.add(speedPanel);
         setSize(900, 300);
         show();
      }
   
       void ready()
      {
         ready = true;
         System.out.println("ready");
      }
   
       void sendNewServoValues(int a, int b)
      {
         String A = getStringValue(a);
         String B = getStringValue(b);
      
         processorInterface.sendString("1");
         processorInterface.sendString(A);
         wait(timeout);
         processorInterface.sendString("2");
         processorInterface.sendString(B);
         wait(timeout);
         System.out.println(A + ", " + B);
      }
   
       String getStringValue(int a)
      {
         if (a < 0)
            a = 65536+a;
         int b;
         String string = new String();
      
         b = a/10000;
         a = a%10000;
         string += Integer.toString(b);
      
         b = a/1000;
         a = a%1000;
         string += Integer.toString(b);
      
         b = a/100;
         a = a%100;
         string += Integer.toString(b);
      
         b = a/10;
         a = a%10;
         string += Integer.toString(b);
      
         b = a;
         string += Integer.toString(b);
      
         return string;
      }
   
       void wait(int time)
      {
         try
         {
            Thread.sleep(time);
         }
             catch (InterruptedException e) {
               System.out.println(e);};
      }
   
       public class ServerInterface implements Runnable
      {
         String command;
      
          ServerInterface()
         {	
         }
      
          public void sendCommand(String command)
         {
            this.command = command;
            Thread thread = new Thread(this);
            thread.start();
         }
      
          public void run()
         {
            if (ready)
            {
               if (command.equals("Forward"))
               {
                  ready = false;
                  System.out.println("MOVING FORWARD");
                  processorInterface.sendString("y");
               }
               if (command.equals("Shoot"))
               {
                  ready = false;
                  System.out.println("SHOOTING");
               
                  processorInterface.sendString("v");
               }
               if (command.equals("Left"))
               {
                  ready = false;
                  System.out.println("MOVING LEFT");
                  processorInterface.sendString("x");
               }
               if (command.equals("Toggle Gate"))
               {
                  ready = false;
                  System.out.println("TOGGLING GATE");
                  processorInterface.sendString("uv");
               }
            
               if (command.equals("Right"))
               {
                  ready = false;
                  System.out.println("MOVING RIGHT");
                  processorInterface.sendString("w");
               }
            
               while (!ready);
            }
         }
      }
   
       class Mediator implements Runnable
      {
         int count = 0;
         long timeout = 5000;
          public Mediator()
         {
         }
      
          public void run()
         {
            while (true)
            {
               if (!ready)
                  count++;
               else
               {
                  count = 0;
                  timeout = 5000;
               }
            
               if (count >= 5)
               {
                  timeout = 100;
                  ready = false;
                  processorInterface.sendString("0");
                  System.out.println("PINGING...");
               }
            
               try
               {
                  Thread.sleep(timeout);
               }
                   catch (InterruptedException e) {
                     System.out.println(e);}
            }
         }
      }
   
       public static void main(String args[])
      {
      
         RobotInterface robotInterface = new RobotInterface();
      
         try
         {
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
            System.out.println("INPUT:");
            while (true)
            {
               String s = br.readLine();
               //robotInterface.processorInterface.sendString(s);
            }
         }
             catch (IOException e) {
               System.out.println(e);}  
      }
   }