   package robotics;

   import javax.swing.*;
   import java.awt.*;
   import java.awt.event.*;
   import java.io.*;

    public class ServoAdjustmentPanel extends JPanel
   
   {
      static final int LOWERBOUND = -1000;
      static final int UPPERBOUND = 1000;
   
      int centerX = 3000;
      int centerY = 3000;
   
   //Servo Utilities
      JScrollBar servo1ScrollBar = new JScrollBar(JScrollBar.HORIZONTAL);
      JScrollBar servo2ScrollBar = new JScrollBar(JScrollBar.HORIZONTAL);
      JLabel servo1Label = new JLabel("3000");
      JLabel servo2Label = new JLabel("3000");
      JButton servoUpdateButton = new JButton("Update");
      JButton saveSettingsButton = new JButton("Save");
      JButton loadSettingsButton =new JButton("Load");
      JButton setCenterButton = new JButton("Set Center");
   
      ServoAdjustmentListener adjustmentListener = new ServoAdjustmentListener();
   
   //External Class References
      SpeedPanel speedPanel;
   
       public ServoAdjustmentPanel()
      {
         Container container = (Container)this;
         container.setLayout(null);
      
      //Set Scrollbar Bounds & Initial Values
         servo1ScrollBar.setMinimum(LOWERBOUND);
         servo1ScrollBar.setMaximum(UPPERBOUND);
         servo2ScrollBar.setMinimum(LOWERBOUND);
         servo2ScrollBar.setMaximum(UPPERBOUND);
         servo1ScrollBar.setValue(0);
         servo2ScrollBar.setValue(0);
      
      //Add Listeners
         servo1ScrollBar.addAdjustmentListener(adjustmentListener);
         servo2ScrollBar.addAdjustmentListener(adjustmentListener);
      
      //Layout Bars
         servo1ScrollBar.setBounds(0, 20, 300, 30);
         servo2ScrollBar.setBounds(0, 50, 300, 30);
      
         servo1Label.setBounds(300, 20, 75, 30);
         servo2Label.setBounds(300, 50, 75, 30);
      
         servoUpdateButton.addActionListener(
                new ActionListener()
               {
                   public void actionPerformed(ActionEvent e)
                  {
                     if (speedPanel != null)
                     {
                        speedPanel.speed[speedPanel.currentSpeed[0]][speedPanel.currentSpeed[1]][0] = servo1ScrollBar.getValue();
                        speedPanel.speed[speedPanel.currentSpeed[0]][speedPanel.currentSpeed[1]][1] = servo2ScrollBar.getValue();
                     }
                  }
               });
         servoUpdateButton.setBounds(0, 80, 75, 60);
      
         loadSettingsButton.addActionListener(
                new ActionListener()
               {
                   public void actionPerformed(ActionEvent e)
                  {
                     if (speedPanel != null)
                     {
                        try
                        {
                           FileInputStream fis = new FileInputStream("c:\\jdk1.3.1_01\\development\\robotics\\speedSettings.txt");
                           BufferedReader br = new BufferedReader(new InputStreamReader(fis));
                           centerX = Integer.parseInt(br.readLine());
                           centerY  = Integer.parseInt(br.readLine());
                           for (int i = 0;i < 5;i++)
                              for (int j = 0;j < 5;j++)
                              {
                                 speedPanel.speed[i][j][0] = Integer.parseInt(br.readLine());
                                 speedPanel.speed[i][j][1] = Integer.parseInt(br.readLine());
                              }
                        }
                            catch (FileNotFoundException ee) {
                              System.out.println(ee);}
                            catch (IOException ee) {
                              System.out.println(ee);}
                     }
                  }
               });         
         loadSettingsButton.setBounds(75, 80, 75, 60);
      
         saveSettingsButton.addActionListener(
                new ActionListener()
               {
                   public void actionPerformed(ActionEvent e)
                  {
                     if (speedPanel != null)
                     {
                        try
                        {
                           FileOutputStream fos = new FileOutputStream("c:\\jdk1.3.1_01\\development\\robotics\\speedSettings.txt");
                           PrintWriter pr = new PrintWriter(fos);
                           pr.println(centerX);
                           pr.println(centerY);
                           for (int i = 0;i < 5;i++)
                              for (int j = 0;j < 5;j++)
                              {
                                 pr.println(speedPanel.speed[i][j][0]);
                                 pr.println(speedPanel.speed[i][j][1]);
                              }
                           pr.flush();
                           fos.flush();
                           fos.close();
                        }
                            catch (FileNotFoundException ee) {
                              System.out.println(ee);}
                            catch (IOException ee) {
                              System.out.println(ee);}
                     }
                  }
               });
         saveSettingsButton.setBounds(150, 80, 75, 60);
      
      
         setCenterButton.addActionListener(
                new ActionListener()
               {
                   public void actionPerformed(ActionEvent e)
                  {
                     centerX = centerX + servo1ScrollBar.getValue();
                     centerY = centerY + servo2ScrollBar.getValue();
                  }
               });
         setCenterButton.setBounds(225, 80, 75, 60);
      
         container.add(servo1ScrollBar);
         container.add(servo2ScrollBar);
         container.add(servo1Label);
         container.add(servo2Label);
         container.add(servoUpdateButton);
         container.add(saveSettingsButton);
         container.add(loadSettingsButton);
         container.add(setCenterButton);
      }
   
       public void updateView()
      {
         if (speedPanel != null)
         {
            servo1ScrollBar.setValue(speedPanel.speed[speedPanel.currentSpeed[0]][speedPanel.currentSpeed[1]][0]);
            servo2ScrollBar.setValue(speedPanel.speed[speedPanel.currentSpeed[0]][speedPanel.currentSpeed[1]][1]);
            servo1Label.setText(Integer.toString(servo1ScrollBar.getValue()));
            servo2Label.setText(Integer.toString(servo2ScrollBar.getValue()));
         }
      }
   
       public class ServoAdjustmentListener implements AdjustmentListener
      {
          public void adjustmentValueChanged(AdjustmentEvent e)
         {
            servo1Label.setText(Integer.toString(servo1ScrollBar.getValue()));
            servo2Label.setText(Integer.toString(servo2ScrollBar.getValue()));
         
            if (speedPanel != null)
               speedPanel.updateServoValues();
         }
      }
   
       public static void main(String args[])
      {
         JFrame frame = new JFrame();
         frame.getContentPane().setLayout(new BorderLayout());
         frame.getContentPane().add(new ServoAdjustmentPanel(), BorderLayout.CENTER);
         frame.setSize(500, 500);
         frame.show();
      }
   }