   package vision;

   import javax.swing.*;
   import java.awt.*;
   import java.awt.image.*;
   import javax.swing.*;
   import java.awt.event.*;


    class ImageProcessor extends JFrame
   {
   //CONSTANTS
      int luminosityThreshold = 200;
      int lowerR = 92;
      int upperR = 110;
      int lowerG = 140;
      int upperG = 180;
      int lowerB = 125;
      int upperB = 180;
   
   //Global Variables
      BufferedImage inputImage;
      ImageProcessor imageProcessor;
   
   //Real-Time Debugging Viewing Objects
      BufferedImage outputImage = new BufferedImage(320,240, BufferedImage.TYPE_INT_RGB);
      Raster outputRaster;
   
      boolean view = true;
      boolean viewOutput = true;
      boolean viewInput = true;
   
      int blackPixel[] = {0, 0, 0};
   
   //FUNCTION VARIABLES
   //getMean()
      int pixel[] = new int[3];
      long pixelSq;
   
      long ySum = 0;
      long yS = 0;
      int scanY[] = new int[320];
      int Ey = 0;
   
      long xSum = 0;
      long xS;
      int xScan[] = new int[240];
      int Ex = 0;
      Raster  raster;
   
   //Interface Variables
      JTextField colorBounds[][] = new JTextField[3][2];
   
       ImageProcessor()
      {
         initializeVariables();
         initializeInterface();
      }
   
       void initializeVariables()
      {
         outputRaster = outputImage.getData();
         imageProcessor = this;
      }
   
       void initializeInterface()
      {
         JDialog dialog = new JDialog();
         dialog.setSize(500, 225);
         dialog.show();
         dialog.setLocation(400, 50);
         Container c = dialog.getContentPane();
         c.setLayout(new GridLayout(10, 3));
      
       //VIEW ANYTHING
         JLabel label00 = new JLabel("View Anything");
         final JTextField field00 = new JTextField((new Boolean(view)).toString());
         JButton button00 = new JButton("Update");
         button00.addActionListener(
                new ActionListener()
               {
                   public void actionPerformed(ActionEvent e)
                  {
                     if (field00.getText().equals("true"))
                        view = true;
                     else
                        view = false;
                  }
               });
         c.add(label00);
         c.add(field00);
         c.add(button00);
      
      //VIEW INPUT
         JLabel label01 = new JLabel("View Input Image");
         final JTextField field01 = new JTextField((new Boolean(viewInput)).toString());
         JButton button01 = new JButton("Update");
         button01.addActionListener(
                new ActionListener()
               {
                   public void actionPerformed(ActionEvent e)
                  {
                     if (field01.getText().equals("true"))
                        viewInput = true;
                     else
                        viewInput = false;
                  }
               });
         c.add(label01);
         c.add(field01);
         c.add(button01);
      
      //VIEW OUTPUT
         JLabel label02 = new JLabel("View Output Image");
         final JTextField field02 = new JTextField((new Boolean(viewOutput)).toString());
         JButton button02 = new JButton("Update");
         button01.addActionListener(
                new ActionListener()
               {
                   public void actionPerformed(ActionEvent e)
                  {
                     if (field02.getText().equals("true"))
                        viewOutput = true;
                     else
                        viewOutput = false;
                  }
               });
         c.add(label02);
         c.add(field02);
         c.add(button02);
      
      
      //LOWER R
         JLabel label1 = new JLabel("Lower R");
         colorBounds[0][0] = new JTextField((new Integer(lowerR)).toString());
         JButton button1 = new JButton("Update");
         button1.addActionListener(
                new ActionListener()
               {
                   public void actionPerformed(ActionEvent e)
                  {
                     lowerR = Integer.parseInt(colorBounds[0][0].getText());
                  }
               });
         c.add(label1);
         c.add(colorBounds[0][0]);
         c.add(button1);
      
      //UPPER R
         JLabel label2 = new JLabel("Upper R");
         colorBounds[0][1] = new JTextField((new Integer(upperR)).toString());
         JButton button2 = new JButton("Update");
         button2.addActionListener(
                new ActionListener()
               {
                   public void actionPerformed(ActionEvent e)
                  {
                     upperR = Integer.parseInt(colorBounds[0][1].getText());
                  }
               });
         c.add(label2);
         c.add(colorBounds[0][1]);
         c.add(button2);
      
      //LOWER G
         JLabel label3 = new JLabel("Lower G");
         colorBounds[1][0] = new JTextField((new Integer(lowerG)).toString());
         JButton button3 = new JButton("Update");
         button3.addActionListener(
                new ActionListener()
               {
                   public void actionPerformed(ActionEvent e)
                  {
                     lowerG = Integer.parseInt(colorBounds[1][1].getText());
                  }
               });
         c.add(label3);
         c.add(colorBounds[1][0]);
         c.add(button3);
      
      //UPPER G
         JLabel label4 = new JLabel("Upper G");
         colorBounds[1][1] = new JTextField((new Integer(upperG)).toString());
         JButton button4 = new JButton("Update");
         button4.addActionListener(
                new ActionListener()
               {
                   public void actionPerformed(ActionEvent e)
                  {
                     upperG = Integer.parseInt(colorBounds[1][1].getText());
                  }
               });
         c.add(label4);
         c.add(colorBounds[1][1]);
         c.add(button4);
      
      //LOWER G
         JLabel label5 = new JLabel("Lower B");
         colorBounds[2][0] = new JTextField((new Integer(lowerB)).toString());
         JButton button5 = new JButton("Update");
         button5.addActionListener(
                new ActionListener()
               {
                   public void actionPerformed(ActionEvent e)
                  {
                     lowerB = Integer.parseInt(colorBounds[2][0].getText());
                  }
               });
         c.add(label5);
         c.add(colorBounds[2][0]);
         c.add(button5);
      
      //UPPER G
         JLabel label6 = new JLabel("Upper B");
         colorBounds[2][1] = new JTextField((new Integer(upperB)).toString());
         JButton button6 = new JButton("Update");
         button6.addActionListener(
                new ActionListener()
               {
                   public void actionPerformed(ActionEvent e)
                  {
                     upperB = Integer.parseInt(colorBounds[2][1].getText());
                  }
               });
         c.add(label6);
         c.add(colorBounds[2][1]);
         c.add(button6);
      
      //Histogram Option
         JLabel label7 = new JLabel("Histogram Maker");
         JButton button7 = new JButton("Create Histogram");
         button7.addActionListener(
                new ActionListener()
               {
                   public void actionPerformed(ActionEvent e)
                  {
                     CircleHistogramMaker chm = new CircleHistogramMaker(inputImage);
                     chm.imageProcessor = imageProcessor;
                  }
               });
         c.add(label7);
         c.add(new JLabel("...nothing..."));  
         c.add(button7);   
      
      
      //Debugging Window
         setSize(500,300);
         setLocation(200, 400);
         show();
      }
   
       public void paint(Graphics g)
      
      {
         if (viewOutput)
            if (outputImage != null)
               g.drawImage(outputImage, 400, 0, 320, 240, this);
      
         if (viewInput)
            if (inputImage != null)
               g.drawImage(inputImage, 0, 0, 320, 240, this);
      }
   
       void getMean()
      {
         try
         {
            raster = inputImage.getData();
            ySum = 0;
            yS = 0;
            Ey = 0;
         
            xSum = 0;
            xS = 0;
            Ex = 0;
         
         //START:  Y Average
            {
               for (int i = 0;i < 320;i++)
               {
                  ySum = 0;
                  yS = 0;
                  for (int j = 0;j < 240;j++)
                  {
                     pixel = raster.getPixel(i, j, pixel);
                  
                  //Decide If Pixel Should Be Included
                     outputImage.setRGB(i, j, 0);
                     if (pixel[0] >= lowerR)
                        if (pixel[0] <= upperR)
                           if (pixel[1] >= lowerB)
                              if (pixel[1] <= upperG)
                                 if (pixel[2] >= lowerG)
                                    if (pixel[2] <= upperB)
                                    {
                                       ySum += j;
                                       yS++;
                                       outputImage.setRGB(i,j, 255);
                                    }
                  }
               
                  if (yS != 0)
                     Ey = (int)(ySum/yS);
                  else
                     Ey = 0;
                  scanY[i] = Ey;
               //System.out.println(i + ":" + Ey);	
               }
            
               ySum= 0;
               yS = 0;
               for (int i = 0;i < 320;i++)
               {
                  ySum += scanY[i];
                  if (scanY[i] > 0)
                     yS++;
               }
               Ey = (int)(ySum/yS);
               long time2 = System.currentTimeMillis();
            //System.out.println("Y-Average Time:  " + (time2-time1));
               System.err.print("<" + Ey + ",");
            }
         //END: Y Average
         
         //START: X Average
            {
               Ex = 0;
               long time1 = System.currentTimeMillis();
               for (int j = 0;j < 240;j++)
               {
                  xSum = 0;
                  xS = 0;
               
                  for (int i = 0;i < 320;i++)
                  {
                     pixel = raster.getPixel(i, j, pixel);
                     outputImage.setRGB(i, j, 0);
                     if (pixel[0] >= lowerR)
                     
                        if (pixel[0] <= upperR)
                           if (pixel[1] >= lowerB)
                              if (pixel[1] <= upperG)
                                 if (pixel[2] >= lowerG)
                                    if (pixel[2] <= upperB)
                                    {
                                       xSum += j;
                                       xS++;
                                       outputImage.setRGB(i,j, 255);
                                    }
                  }
               
                  if (xS > 0)
                     Ex = (int)(xSum/xS);
                  else
                     Ex = 0;
                  xScan[j] = Ex;
               }
            
               xSum = 0;
               xS = 0;
               for (int i = 0;i < 240;i++)
               {
                  xSum += xScan[i];
                  if (xScan[i] > 0)
                     xS++;
               }
               Ex = (int)(xSum/xS);
            
               long time2 = System.currentTimeMillis();
            //System.out.println("X-Average Time:  " + (time2-time1));
               System.err.println(Ex + ">");
            }
         //END:  X Average
         }
             catch (ArithmeticException e)
            {//System.out.println(e);
            }
      
      //Debugging Viewer Option
         if (view)
            repaint();
      }
   
       void updateView()
      {
         colorBounds[0][0].setText(Integer.toString(lowerR));
         colorBounds[0][1].setText(Integer.toString(upperR));
      
         colorBounds[1][0].setText(Integer.toString(lowerG));
         colorBounds[1][1].setText(Integer.toString(upperG));
      
         colorBounds[2][0].setText(Integer.toString(lowerB));
         colorBounds[2][1].setText(Integer.toString(upperB));
      }
   
       public static void main(String args[])
      {
         new ImageProcessor();
      }
   }