package robotics;

   import javax.swing.*;
   import java.awt.*;
   import java.awt.event.*;


   public class SpeedPanel extends JPanel
   {
   //Constants
      static final int LEFT = 0;
      static final int RIGHT = 1;
   
      int speed[][][] = new int[5][6][2];
      int currentSpeed[] = new int[2];
      int currentButton[] = new int[2];
      JButton speedButton[][] = new JButton[5][6];
   
      SpeedButtonListener speedButtonListener = new SpeedButtonListener();
   
   //External Class References
      ServoAdjustmentPanel servoAdjustmentPanel = new ServoAdjustmentPanel();
      RobotInterface robotInterface;
   
      public SpeedPanel()
      {
      //Create Button Panel
         JPanel buttonPanel = new JPanel();
         buttonPanel.setLayout(new GridLayout(5,5));
         for (int i = 0;i < 5;i++)
            for (int j = 0;j < 6;j++)
            {
               String string = i + ", " + j;
               speedButton[i][j] = new JButton(string);
               speedButton[i][j].addActionListener(speedButtonListener);
               speedButton[i][j].addMouseListener(speedButtonListener);
               buttonPanel.add(speedButton[i][j]);
            }
      
      //Create Servo Update Panel
         servoAdjustmentPanel.speedPanel = this;
      
      //Create Input Panel
         JPanel inputPanel = new JPanel();
         inputPanel.setLayout(new GridLayout(2,2));
         final JTextField field1 = new JTextField();
         final JTextField field2 = new JTextField();
         inputPanel.add(field1);
         inputPanel.add(field2);
         JButton setButton = new JButton("Manual Set");
         setButton.addActionListener(
               new ActionListener()
               {
                  public void actionPerformed(ActionEvent e)
                  {
                     speed[currentSpeed[0]][currentSpeed[1]][0] = Integer.parseInt(field1.getText());
                     speed[currentSpeed[0]][currentSpeed[1]][1] = Integer.parseInt(field2.getText());
                     field1.setText("");
                     field2.setText("");
                  }
               });
         inputPanel.add(setButton);
      
         JButton resetButton = new JButton("Reset");
         resetButton.addActionListener(
               new ActionListener()
               {
                  public void actionPerformed(ActionEvent e)
                  {
                     speed[currentSpeed[0]][currentSpeed[1]][0] = 0;
                     speed[currentSpeed[0]][currentSpeed[1]][1] = 0;
                     updateServoValues();
                  }
               });
         inputPanel.add(resetButton);      
      
      //Scale Window
         JPanel scalePanel = new JPanel();
         scalePanel.setLayout(new GridLayout(2,1));
         final JTextField scaleField= new JTextField();
         scalePanel.add(scaleField);
      //Scale Button
         JButton scaleButton = new JButton("Scale");
         scaleButton.addActionListener(
               new ActionListener()
               {
               
                  public void actionPerformed(ActionEvent e)
                  {
                     float temp = Float.parseFloat(scaleField.getText());
                     for (int i = 0;i < 5;i++)
                        for (int j = 0;j < 5;j++)
                        {
                           speed[i][j][0] = (int)((speed[i][j][0])*temp);
                           speed[i][j][1] = (int)((speed[i][j][1])*temp);
                        }
                  }
               }
            );
         scalePanel.add(scaleButton);
      //Download Button
         JButton downloadSpeedsButton = new JButton("Download");
         downloadSpeedsButton.addActionListener(
               new ActionListener()
               {
                  public void actionPerformed(ActionEvent e)
                  {
                     int i = currentSpeed[0];
                     int j = currentSpeed[1];
                     downloadSpeed(i, j);
                  }
               }
            );
         scalePanel.add(downloadSpeedsButton);
      //Download All Button
         JButton downloadAllSpeedsButton = new JButton("Download All");
         downloadAllSpeedsButton.addActionListener(
               new ActionListener()
               {
                  public void actionPerformed(ActionEvent e)
                  {
                     for (int i = 0;i < 5;i++)
                        for (int j = 0; j < 5;j++)
                        {
                           downloadSpeed(i, j);
                           try
                           {
                              Thread.sleep(30);
                           }
                              catch (InterruptedException ee) {
                                 System.out.println(ee);}
                        
                        }
                     downloadSpeed(0, 5);
                  }
               }
            );
         scalePanel.add(downloadAllSpeedsButton);                  
      
      //Layout Panel
         setLayout(new GridLayout(2,2));
         add(buttonPanel);
         add(servoAdjustmentPanel);
         add(inputPanel);
         add(scalePanel);
      
         System.out.println("done");
      }
   
      void downloadSpeed(int i, int j)
      {
         String s = "5";
      
      
         robotInterface.processorInterface.sendString(s);
      
            //Thread.sleep(30);
         s = Integer.toString(i);
         robotInterface.processorInterface.sendString(s);
      
            //Thread.sleep(30);
         s = Integer.toString(j);
         robotInterface.processorInterface.sendString(s);
         System.out.println(s + ":  Sent.");
      
      
         if ( ( (i == 0) && (j == 5) ) )
         {
               //Thread.sleep(30);
            s = robotInterface.getStringValue(servoAdjustmentPanel.centerX);
            robotInterface.processorInterface.sendString(s);
         
               //Thread.sleep(30);
            s= robotInterface.getStringValue(servoAdjustmentPanel.centerY);
            robotInterface.processorInterface.sendString(s);
         } 
         else
         {
               //Thread.sleep(30);
            s = robotInterface.getStringValue(speed[i][j][0]);
            robotInterface.processorInterface.sendString(s);
            System.out.println(s);
         
               //Thread.sleep(30);
            s= robotInterface.getStringValue(speed[i][j][1]);
            robotInterface.processorInterface.sendString(s);
            System.out.println(s);
         }
         System.out.println(i + ", " + j + " Updated");
      
      
      
      }
   
      class SpeedButtonListener extends MouseAdapter implements ActionListener
      {
      
         public void mouseClicked(MouseEvent e)
         {
            for (int i = 0;i < 5;i++)
               for (int j = 0;j < 5;j++)
               {
                  if (e.getSource() == speedButton[i][j])
                     System.out.println("easfd");
               }
         }
         public void actionPerformed(ActionEvent e)
         {
            for (int i = 0;i < 5;i++)
               for (int j = 0;j < 6;j++)
               {
                  if ( e.getSource() == speedButton[i][j])
                  {
                     System.out.println(i + ", " + j);
                     currentSpeed[0] = i;
                     currentSpeed[1] = j;
                  }
               }
         
            if (servoAdjustmentPanel != null)
               servoAdjustmentPanel.updateView();
         }
      }
   
      public void updateServoValues()
      {
         if (servoAdjustmentPanel == null)
            return;
      
         int speed1 = servoAdjustmentPanel.servo1ScrollBar.getValue()  + servoAdjustmentPanel.centerX;
         int speed2 = servoAdjustmentPanel.servo2ScrollBar.getValue() +  servoAdjustmentPanel.centerY;;
      
         if (robotInterface != null)
            robotInterface.sendNewServoValues(speed1, speed2);
         System.err.println("Sent - ");
      }
   
      public static void main(String args[])
      {
         JFrame frame = new JFrame();
         frame.getContentPane().setLayout(new BorderLayout());
         frame.getContentPane().add(new SpeedPanel(), BorderLayout.CENTER);
         frame.setSize(500, 500);
         frame.show();
      }
   
   }