   package vision;

   import javax.swing.*;
   import java.awt.*;
   import java.io.*;
   import java.awt.event.*;
   import java.awt.image.*;

    class CircleHistogramMaker extends JFrame
   
   {
      ImageProcessor imageProcessor;
   
      BufferedImage image;
      BufferedImage image2 = new BufferedImage(320,240,BufferedImage.TYPE_INT_RGB);
   
      int centerX, centerY, radius, colorNum;
      Color color[] = {new Color(255, 0, 0), new Color(0, 255, 0), new Color(0, 0, 255)};
      boolean firstClick = true;
      double deviations = 1.0;
   
   //Buttons
      JButton calculateStats = new JButton("Calculate");
      JButton increaseRadius = new JButton("Bigger");
      JButton decreaseRadius = new JButton("Smaller");
      JButton centerLeft = new JButton("Left");
      JButton centerRight = new JButton("Right");
      JButton centerUp = new JButton("Up");
      JButton centerDown = new JButton("Down");
      JTextField deviationText = new JTextField();
   
       CircleHistogramMaker(Image input)
      {
         MediaTracker mt = new MediaTracker(this);
         mt.addImage(input, 0);
         try{mt.waitForAll();}
             catch(InterruptedException e) {System.out.println(e);}
         image = new BufferedImage(320, 240, BufferedImage.TYPE_INT_RGB);
         Graphics2D g = (Graphics2D)image.getGraphics();
         g.drawImage(input, 0, 0, 320, 240, this);
         initializeClass();
      }
   
       CircleHistogramMaker(BufferedImage input)
      {
         this.image = input;
         initializeClass();
      }
   
       void initializeClass()
      {
         radius = 10;
         colorNum = 0;
      
      //Add Mouse Listener
         addMouseListener(
                new MouseAdapter()
               {
                   public void mouseClicked(MouseEvent e)
                  {
                     centerX = e.getX();
                     centerY = e.getY();
                     System.out.println(centerX + ", " + centerY);
                     repaint();
                  }
               }
            );
      //Add Buttons
      //Increase Radius
         increaseRadius.addActionListener(
                new ActionListener()
               {
                   public void actionPerformed(ActionEvent e)
                  {
                     radius++;
                     repaint();
                  }
               });
         increaseRadius.setBounds(0, 260, 75, 30);
      //Decrease Radius
         decreaseRadius.addActionListener(
                new ActionListener()
               {
                   public void actionPerformed(ActionEvent e)
                  {
                     radius--;
                     repaint();
                  }
               });
         decreaseRadius.setBounds(75, 260, 75, 30);
      //Center Left
         centerLeft.addActionListener(
                new ActionListener()
               {
                   public void actionPerformed(ActionEvent e)
                  {
                     centerX--;
                     repaint();
                  }
               });
         centerLeft.setBounds(0, 290, 75, 30);
      //CenterRight
         centerRight.addActionListener(
                new ActionListener()
               {
                   public void actionPerformed(ActionEvent e)
                  {
                     centerX++;
                     repaint();
                  }
               });
         centerRight.setBounds(75, 290, 75, 30);
      //Center Up
         centerUp.addActionListener(
                new ActionListener()
               {
                   public void actionPerformed(ActionEvent e)
                  {
                     centerY--;
                     repaint();
                  }
               });
         centerUp.setBounds(150, 290, 75, 30);
      //Center Down
         centerDown.addActionListener(
                new ActionListener()
               {
                   public void actionPerformed(ActionEvent e)
                  {
                     centerY++;
                     repaint();
                  }
               });
         centerDown.setBounds(225, 290, 75, 30);
      
      //Calculate Image Statistics
         calculateStats.addActionListener(
                new ActionListener()
               {
                   public void actionPerformed(ActionEvent e)
                  {
                     calculateImageStatistics();
                  }
               });
         calculateStats.setBounds(150, 260, 75, 30);
      
      //Deviations Input
         deviationText.setBounds(0,320, 150, 30);
      
      //Layout Window
         getContentPane().setLayout(null);
         getContentPane().add(calculateStats);
         getContentPane().add(increaseRadius);
         getContentPane().add(decreaseRadius);
         getContentPane().add(centerLeft);
         getContentPane().add(centerRight);
         getContentPane().add(centerUp);
         getContentPane().add(centerDown);
         getContentPane().add(deviationText);
      
         setSize(700,500);
         show();
      
      }
   
       public void paint(Graphics g)
      {
         super.paint(g);
      
         if (image != null)
            g.drawImage(image, 0, 20, 320, 240, this);
      
         if (image2 != null)
            g.drawImage(image2, 340, 20, 320, 240, this);
      
         g.setColor(color[colorNum]);
         g.drawOval(centerX-radius, centerY-radius, 2*radius, 2*radius);
      }
   
       void calculateHistogram()
      {
         int X = centerX;
         int Y = centerY - 20;
      
         int rMin = 900;
         int rMax = -1;
         int gMin = 900;
         int gMax = -1;
         int bMin = 900;
         int bMax = -1;
      
         BufferedImage bi = new BufferedImage(320, 240, BufferedImage.TYPE_INT_RGB);
         Graphics g = bi.getGraphics();
         g.drawImage(image, 0, 0, 320, 240, this);
      
         Raster r = bi.getData();
         for (int i = 0;i < 320;i++)
         {
            for (int j = 0;j < 240;j++)
            {
               int temp = (i-X)*(i-X) + (j-Y)*(j-Y);
               int temp2 = radius*radius;
               if (temp <= temp2)
               {
                  int pixel[] = r.getPixel(i, j, new int[3]);
               
                  if (pixel[0] < rMin)
                     rMin = pixel[0];
                  if (pixel[0] > rMax)
                     rMax = pixel[0];
               
                  if (pixel[1] < gMin)
                     gMin = pixel[1];
                  if (pixel[1] > gMax)
                     gMax = pixel[1];
               
                  if (pixel[2] < bMin)
                     bMin = pixel[2];
                  if (pixel[2] > bMax)
                     bMax = pixel[2];
               }
            }
         }
      
         imageProcessor.lowerR = rMin;
         imageProcessor.upperR = rMax;
         imageProcessor.lowerG = gMin;
         imageProcessor.upperG = gMax;
         imageProcessor.lowerB = bMin;
         imageProcessor.upperB = bMax;
      
         dispose();
      }
   
       void calculateImageStatistics()
      {
         Raster raster = image.getData();
         Graphics g = image2.getGraphics();
         g.fillRect(0, 0, 320, 240);
         WritableRaster wRaster = image2.getRaster();
         int pixel[] = new int[3];
      
         double avg[] = {0, 0, 0};
         double std[] = {0, 0, 0};
         int total = 0;
      
      //Calculate Avg
         for (int i = 0;i < 320;i++)
            for (int j = 0;j < 240;j++)
            {
               if ( (radius*radius) >= ( (i-centerX)*(i-centerX) + (j-centerY+20)*(j-centerY+20) ) )
               {
                  pixel = raster.getPixel(i, j, pixel);
                  wRaster.setPixel(i, j, pixel);
               
                  total++;
                  avg[0] += pixel[0];
                  avg[1] += pixel[1];
                  avg[2] += pixel[2];
               }
            }
      
         avg[0] /= total;
         avg[1] /= total;
         avg[2] /= total;
      
      //Calculate STD
         for (int i = 0;i < 320;i++)
            for (int j = 0;j < 240;j++)
            {
               if ( (radius*radius) >= ( (i-centerX)*(i-centerX) + (j-centerY+20)*(j-centerY+20) ) )
               {
                  pixel = raster.getPixel(i, j, pixel);
                  wRaster.setPixel(i, j, pixel);
               
                  std[0] += (avg[0] - pixel[0])*(avg[0] - pixel[0]);
                  std[1] += (avg[1] - pixel[1])*(avg[1] - pixel[1]);
                  std[2] += (avg[2] - pixel[2])*(avg[2] - pixel[2]);
               }
            }
      
      
         std[0] /= (total - 1);
         std[1] /= (total - 1);
         std[2] /= (total - 1);
         std[0] = Math.sqrt(std[0]);
         std[1] = Math.sqrt(std[1]);
         std[2] = Math.sqrt(std[2]);
      
         System.out.println("Total:  " + total);
         System.out.println("Average:  " + avg[0] + ", " + avg[1] + ", " + avg[2]);
         System.out.println("STD:  " + std[0] + ", " + std[1] + ", " + std[2]);
      
         repaint();
      
      //Image Processor Stuff
         deviations = Double.parseDouble(deviationText.getText());
      
         imageProcessor.lowerR = ensureLower((int)(avg[0] - deviations*std[0]));
         imageProcessor.upperR = ensureUpper((int)(avg[0] + deviations*std[0]));
      
         imageProcessor.lowerG = ensureLower((int)(avg[1] - deviations*std[1]));
         imageProcessor.upperG = ensureUpper((int)(avg[1] + deviations*std[1]));
      
         imageProcessor.lowerB = ensureLower((int)(avg[2] - deviations*std[2]));
         imageProcessor.upperB = ensureUpper((int)(avg[2] + deviations*std[2]));
      
         imageProcessor.updateView();
      }
   
       int ensureLower(int i)
      {
         if (i < 0)
            return 0;
         return i;
      }
   
       int ensureUpper(int i)
      {
         if (i > 255)
            return 255;
         return i;
      }
   
   
   
       public static void main(String args[])
      {
         Toolkit toolkit = Toolkit.getDefaultToolkit();
         Image image = toolkit.createImage("c:\\java programs\\vision\\image.jpg");
      
         CircleHistogramMaker chm = new CircleHistogramMaker(image);
         chm.imageProcessor = new ImageProcessor();
      }
   
   }