   package vision;

   import java.awt.*;
   import javax.media.*;
   import javax.media.control.TrackControl;
   import javax.media.Format;
   import javax.media.format.*;
   import javax.media.util.*;
   import java.util.*;
   import java.awt.image.*;
   import java.net.*;
   import java.io.*;
   import javax.swing.*;
   import java.awt.event.*;




    class Controls
   {
      ImageProcessor imageProcessor;
      FrameAccess frameAccess;
      robotics.RobotInterface robotInterface;
   
      Socket socket;
      PrintWriter pr;
   
   
   //Constraints
      long timeElapsed = 0;
      long lastTime = 0;
   
      int shootRange[][] = new int[2][2];
      float rightSlope, leftSlope, shootSlope;
      int rightIntercept, leftIntercept, shootIntercept;
   
      int avgAvg[][] = new int[5][2];
      int avgCount = 0;
      int i;
      int avgX;
      int avgY;
   
      int radiusThreshold = 2;
      int nothingCount = 0;
      int nothingInSightThreshold = 3;
      int imageSettleTimeThreshold = 1000;
      boolean communicateWithRobot = false;
      boolean haveBall = false;
   
       Controls()
      {
      //Get Stream
         Vector v = CaptureDeviceManager.getDeviceList(null);
         Iterator i = v.iterator();
         //while (i.hasNext())
            //System.out.println(i.next());
      
         CaptureDeviceInfo cdi = (CaptureDeviceInfo)v.lastElement();
         System.out.println(cdi);
         MediaLocator ml = cdi.getLocator();
         System.out.println(ml);
      
         /*
      args = new String[1];
         args[0] = "file:\\C:\\My Documents\\jo20.avi";
         if (args.length == 0) {
            prUsage();
            System.exit(0);
         }
      
         String url = args[0];
      
         if (url.indexOf(":") < 0) {
            prUsage();
            System.exit(0);
         }
      
         MediaLocator ml;
      
         if ((ml = new MediaLocator(url)) == null) {
            System.err.println("Cannot build media locator from: " + url);
            System.exit(0);
         }
      */
         frameAccess = new FrameAccess();
         frameAccess.controls = this;
      
         if (!frameAccess.open(ml))
            System.exit(0);
      
         imageProcessor = frameAccess.imageProcessor;
         imageProcessor.controls = this;
      
      //Instantiate RobotInterface
         robotInterface = new robotics.RobotInterface();
      }
   
       void processData()
      {
      //Update Visuals
         imageProcessor.outputGraphics.setColor(imageProcessor.green);
         imageProcessor.outputGraphics.drawOval(avgX - imageProcessor.totalSamples, avgY - imageProcessor.totalSamples, imageProcessor.totalSamples*2, imageProcessor.totalSamples*2);
         imageProcessor.repaint();
      
      //Make Sure There are enough samples
         if (imageProcessor.totalSamples < 2)
         {
         //Should the Robot Find SOmething to Hone In On?
            if (timeElapsed > imageSettleTimeThreshold)
            {
               System.out.println("Nothing++");
               nothingCount++;
               if (nothingCount > nothingInSightThreshold)
               {
                  if (communicateWithRobot)
                  {
                     robotInterface.serverInterface.sendCommand("Right");
                     System.out.println("Looking...");
                  }
                  else
                     System.out.println("Looking wo/ Robot...");
                  timeElapsed = 0;
                  lastTime = System.currentTimeMillis();
               }
            }
            else
            {
               timeElapsed += System.currentTimeMillis() - lastTime;
               lastTime = System.currentTimeMillis();
            }
         
            return;
         }
      
      //Update Average
         avgX = 0;
         avgY = 0;
      
         for (i = 0;i < 5;i++)
         {
            avgX += avgAvg[i][0];
            avgY += avgAvg[i][1];
         }
         avgX /= 5;
         avgY /= 5;
         avgCount++;
         avgCount = avgCount%5;
      
         avgAvg[avgCount][0] = imageProcessor.Ex;
         avgAvg[avgCount][1] = imageProcessor.Ey;
      
      
      //Give Time To Image To Settle
         if (timeElapsed < imageSettleTimeThreshold)
         {
            timeElapsed += System.currentTimeMillis() - lastTime;
            lastTime = System.currentTimeMillis();
            return;
         }
         else
         {
            lastTime = System.currentTimeMillis();
            timeElapsed = 0;
         }
      
         System.out.print("Processing Data - " + haveBall + " - " + imageProcessor.currentHistogram);
      
      
         if (!haveBall)
         {
            System.out.print("No Ball");
         //Have Ball - Lower Thing
            if ( (avgX >= shootRange[0][0]) && (avgX <= shootRange[1][0]) && (avgY >= shootRange[0][1]) && (avgY <= shootRange[1][1]) )
            {
               if (communicateWithRobot)
               {
                  robotInterface.serverInterface.sendCommand("Toggle Gate");
                  haveBall = true;
                  imageProcessor.switchHistogram();
               }
               else
                  System.out.println("Put Gate Down");
               return;
            }
         
         //Move Right
            if ( (avgY > (avgX*rightSlope + rightIntercept) ) )
            {
               if (communicateWithRobot)
                  robotInterface.serverInterface.sendCommand("Right");
               //System.out.println("Communicate - Right");
               else
                  System.out.println("Right");
               return;
            }
         
         //Move Left
            if ( (avgY < (avgX*leftSlope + leftIntercept) ) )
            {
               if (communicateWithRobot)
                  robotInterface.serverInterface.sendCommand("Left");
               //System.out.println("Communicate - Left");
               else
                  System.out.println("Left");
               return;
            }
         
         //Move Forward
            if (communicateWithRobot)
            {
               robotInterface.serverInterface.sendCommand("Forward");
            //System.out.println("Communicate - Forward");
            }
            else
               System.out.println("Forward");
            return;
         }
      
         if (haveBall)
         {
            System.out.print("Ball");
         //Move Left
            if ( (avgY < (avgX*shootSlope + shootIntercept - 10) ) )
            {
               if (communicateWithRobot)
                  robotInterface.serverInterface.sendCommand("Left");
               //System.out.println("Communicate - Left");
               else
                  System.out.println("Have Ball - Left");
               return;
            }
         
         //Move Right
            if ( (avgY > (avgX*shootSlope + shootIntercept + 10) ) )
            {
               if (communicateWithRobot)
                  robotInterface.serverInterface.sendCommand("Right");
               //System.out.println("Communicate - Right");
               else
                  System.out.println("Have Ball - Right");
               return;
            }
         
         //Shoot
            if (communicateWithRobot)
            {
               robotInterface.serverInterface.sendCommand("Shoot");
               imageProcessor.switchHistogram();
               haveBall = false;
            }
            else
               System.out.println("Shoot");
         }
      }
   
       void communicationsDialog()
      {
         JDialog dialog = new JDialog();
      //Create Button Panel
         JPanel buttonPanel = new JPanel();
         buttonPanel.setLayout(new GridLayout(1,2));
      //COnnect Button
         JButton connect = new JButton("Connect");
         connect.addActionListener(
                new ActionListener()
               {
                   public void actionPerformed(ActionEvent e)
                  {
                     communicateWithRobot = true;                  }
               });
         buttonPanel.add(connect);
      //DIsconnect Button
         JButton disconnect = new JButton("DisConnect");
         disconnect.addActionListener(
                new ActionListener()
               {
                   public void actionPerformed(ActionEvent e)
                  {
                     communicateWithRobot = false;
                  }
               });
         buttonPanel.add(disconnect);
      
      
         dialog.getContentPane().add(buttonPanel, BorderLayout.CENTER);
         dialog.setSize(250,75);
         dialog.setLocation(325, 230);
         dialog.show();
      
      }
   
       public static void main(String args[])
      {
         Controls controls = new Controls();
         controls.communicationsDialog();
      }
   
   }