   package vision;

   import javax.swing.*;
   import java.awt.*;
   import java.awt.image.*;
   import javax.swing.*;
   import java.awt.event.*;


    class ImageProcessor extends JFrame
   {
   //CONSTANTS
   
      int lowerR = 255;
      int upperR = 255;
      int lowerG = 255;
      int upperG = 255;
      int lowerB = 255;
      int upperB = 255;
   
      int bounds_RGB[][][] = new int[2][3][2];
      int currentHistogram = 0;
   
   //Global Variables
      BufferedImage inputImage;
      ImageProcessor imageProcessor;
      Controls controls;
   
   //Real-Time Debugging Viewing Objects
      BufferedImage outputImage = new BufferedImage(320,240, BufferedImage.TYPE_INT_RGB);
      Graphics outputGraphics;
      Raster outputRaster;
      Color black = new Color(0, 0, 0);
      Color red = new Color(255, 0, 0);
      Color green = new Color(0, 255, 0);
   
      boolean view = true;
      boolean viewOutput = true;
      boolean viewInput = true;
      boolean creatingMask = false;
   
      int blackPixel[] = {0, 0, 0};
   
   //FUNCTION VARIABLES
   //getMean()
      int pixel[] = new int[3];
      long pixelSq;
   
      long ySum = 0;
      long yS = 0;
      int scanY[] = new int[320];
      int Ey = 0;
   
      long xSum = 0;
      long xS;
      int xScan[] = new int[240];
      int Ex = 0;
      int totalSamples;
      Raster  raster;
   
      int i;
      int j;
   
      Column columns[];
      Row rows[];
      Column currentColumn;
      Row currentRow;
   
   //Interface Variables
      JTextField colorBounds[][] = new JTextField[3][2];
   
   //Performance Variables
      int count = 0;
      long startTime;
   
       ImageProcessor()
      {
         initializeVariables();
         initializeInterface();
      }
   
       void initializeVariables()
      {
         outputRaster = outputImage.getData();
         outputGraphics = outputImage.getGraphics();
         imageProcessor = this;
         createMask("c:\\jdk1.3.1_01\\development\\vision\\defaultmask.jpg");
      }
   
       void initializeInterface()
      {
         JDialog dialog = new JDialog();
         Container c = dialog.getContentPane();
         c.setLayout(new GridLayout(11, 3));
      
       //VIEW ANYTHING
         JLabel label00 = new JLabel("View Anything");
         final JTextField field00 = new JTextField((new Boolean(view)).toString());
         JButton button00 = new JButton("Update");
         button00.addActionListener(
                new ActionListener()
               {
                   public void actionPerformed(ActionEvent e)
                  {
                     if (field00.getText().equals("true"))
                        view = true;
                     else
                        view = false;
                  }
               });
         c.add(label00);
         c.add(field00);
         c.add(button00);
      
      //VIEW INPUT
         JLabel label01 = new JLabel("View Input Image");
         final JTextField field01 = new JTextField((new Boolean(viewInput)).toString());
         JButton button01 = new JButton("Update");
         button01.addActionListener(
                new ActionListener()
               {
                   public void actionPerformed(ActionEvent e)
                  {
                     if (field01.getText().equals("true"))
                        viewInput = true;
                     else
                        viewInput = false;
                  }
               });
         c.add(label01);
         c.add(field01);
         c.add(button01);
      
      //VIEW OUTPUT
         JLabel label02 = new JLabel("View Output Image");
         final JTextField field02 = new JTextField((new Boolean(viewOutput)).toString());
         JButton button02 = new JButton("Update");
         button01.addActionListener(
                new ActionListener()
               {
                   public void actionPerformed(ActionEvent e)
                  {
                     if (field02.getText().equals("true"))
                        viewOutput = true;
                     else
                        viewOutput = false;
                  }
               });
         c.add(label02);
         c.add(field02);
         c.add(button02);
      
      
      //LOWER R
         JLabel label1 = new JLabel("Lower R");
         colorBounds[0][0] = new JTextField((new Integer(lowerR)).toString());
         JButton button1 = new JButton("Update");
         button1.addActionListener(
                new ActionListener()
               {
                   public void actionPerformed(ActionEvent e)
                  {
                     lowerR = Integer.parseInt(colorBounds[0][0].getText());
                  }
               });
         c.add(label1);
         c.add(colorBounds[0][0]);
         c.add(button1);
      
      //UPPER R
         JLabel label2 = new JLabel("Upper R");
         colorBounds[0][1] = new JTextField((new Integer(upperR)).toString());
         JButton button2 = new JButton("Update");
         button2.addActionListener(
                new ActionListener()
               {
                   public void actionPerformed(ActionEvent e)
                  {
                     upperR = Integer.parseInt(colorBounds[0][1].getText());
                  }
               });
         c.add(label2);
         c.add(colorBounds[0][1]);
         c.add(button2);
      
      //LOWER G
         JLabel label3 = new JLabel("Lower G");
         colorBounds[1][0] = new JTextField((new Integer(lowerG)).toString());
         JButton button3 = new JButton("Update");
         button3.addActionListener(
                new ActionListener()
               {
                   public void actionPerformed(ActionEvent e)
                  {
                     lowerG = Integer.parseInt(colorBounds[1][1].getText());
                  }
               });
         c.add(label3);
         c.add(colorBounds[1][0]);
         c.add(button3);
      
      //UPPER G
         JLabel label4 = new JLabel("Upper G");
         colorBounds[1][1] = new JTextField((new Integer(upperG)).toString());
         JButton button4 = new JButton("Update");
         button4.addActionListener(
                new ActionListener()
               {
                   public void actionPerformed(ActionEvent e)
                  {
                     upperG = Integer.parseInt(colorBounds[1][1].getText());
                  }
               });
         c.add(label4);
         c.add(colorBounds[1][1]);
         c.add(button4);
      
      //LOWER G
         JLabel label5 = new JLabel("Lower B");
         colorBounds[2][0] = new JTextField((new Integer(lowerB)).toString());
         JButton button5 = new JButton("Update");
         button5.addActionListener(
                new ActionListener()
               {
                   public void actionPerformed(ActionEvent e)
                  {
                     lowerB = Integer.parseInt(colorBounds[2][0].getText());
                  }
               });
         c.add(label5);
         c.add(colorBounds[2][0]);
         c.add(button5);
      
      //UPPER G
         JLabel label6 = new JLabel("Upper B");
         colorBounds[2][1] = new JTextField((new Integer(upperB)).toString());
         JButton button6 = new JButton("Update");
         button6.addActionListener(
                new ActionListener()
               {
                   public void actionPerformed(ActionEvent e)
                  {
                     upperB = Integer.parseInt(colorBounds[2][1].getText());
                  }
               });
         c.add(label6);
         c.add(colorBounds[2][1]);
         c.add(button6);
      
      //Histogram Options
         JButton processImageButton = new JButton("Process Image");
         processImageButton.addActionListener(
                new ActionListener()
               {
                   public void actionPerformed(ActionEvent e)
                  {
                     processImage();
                  }
               });
         JButton createMaskButton = new JButton("Create Mask");
         createMaskButton.addActionListener(
                new ActionListener()
               {
                   public void actionPerformed(ActionEvent e)
                  {
                     createMask("C:\\jdk1.3.1_01\\development\\vision\\mask.jpg");
                  }
               });
         JButton button7 = new JButton("Create Histogram");
         button7.addActionListener(
                new ActionListener()
               {
                   public void actionPerformed(ActionEvent e)
                  {
                     CircleHistogramMaker chm = new CircleHistogramMaker(inputImage);
                     chm.imageProcessor = imageProcessor;
                  }
               });
         c.add(processImageButton);
         c.add(createMaskButton);  
         c.add(button7);   
      	//Switch Histograms
         JButton switchTarget = new JButton("Switch Histrogram");
         switchTarget.addActionListener(
                new ActionListener()
               {
                   public void actionPerformed(ActionEvent e)
                  {
                     switchHistogram();
                  }
               });
         c.add(switchTarget);
      //Calculate Control Bounds
         JButton setupBounds = new JButton("Setup Bounds");
         setupBounds.addActionListener(
                new ActionListener()
               {
                   public void actionPerformed(ActionEvent e)
                  {
                     (new SetupBounds(inputImage)).controls = controls;
                  }
               });
         c.add(setupBounds);
      
      
      
      
      //Debugging Window
         dialog.setSize(500, 225);
         dialog.show();
         dialog.validate();
         dialog.setLocation(325, 5);
      
         setSize(725,245);
         setLocation(5, 300);
         show();
      }
   
       void switchHistogram()
      {
         System.out.println("Switching Histogram -> " + currentHistogram);
         bounds_RGB[currentHistogram][0][0] = lowerR;
         bounds_RGB[currentHistogram][0][1] = upperR;
         bounds_RGB[currentHistogram][1][0] = lowerG;
         bounds_RGB[currentHistogram][1][1] = upperG;
         bounds_RGB[currentHistogram][2][0] = lowerB;
         bounds_RGB[currentHistogram][2][1] = upperB;
      
         currentHistogram += 1;
         currentHistogram = (currentHistogram++)%2;
      
         lowerR = bounds_RGB[currentHistogram][0][0];
         upperR = bounds_RGB[currentHistogram][0][1];
         lowerG = bounds_RGB[currentHistogram][1][0];
         upperG = bounds_RGB[currentHistogram][1][1];
         lowerB = bounds_RGB[currentHistogram][2][0];
         upperB = bounds_RGB[currentHistogram][2][1];
      
      }
   
       public void paint(Graphics g)
      
      {
         if (viewOutput)
            if (outputImage != null)
               g.drawImage(outputImage, 400, 0, 320, 240, this);
      
         if (viewInput)
            if (inputImage != null)
               g.drawImage(inputImage, 0, 0, 320, 240, this);
      }
   
       long getMean()
      {
         startTime = System.currentTimeMillis();
         try
         {
            raster = inputImage.getData();
            ySum = 0;
            yS = 0;
            Ey = 0;
         
            xSum = 0;
            xS = 0;
            Ex = 0;
         
         //START:  Y Average
            {
               for (i = 0;i < 320;i++)
               {
                  ySum = 0;
                  yS = 0;
                  for (j = 0;j < 240;j++)
                  {
                     pixel = raster.getPixel(i, j, pixel);
                  
                  //Decide If Pixel Should Be Included
                     outputImage.setRGB(i, j, 0);
                     if (pixel[0] >= lowerR)
                        if (pixel[0] <= upperR)
                           if (pixel[1] >= lowerB)
                              if (pixel[1] <= upperG)
                                 if (pixel[2] >= lowerG)
                                    if (pixel[2] <= upperB)
                                    {
                                       ySum += j;
                                       yS++;
                                       outputImage.setRGB(i,j, 255);
                                    }
                  }
               
                  if (yS != 0)
                     Ey = (int)(ySum/yS);
                  else
                     Ey = 0;
                  scanY[i] = Ey;
               }
            
               ySum= 0;
               yS = 0;
               for (i = 0;i < 320;i++)
               {
                  ySum += scanY[i];
                  if (scanY[i] > 0)
                     yS++;
               }
               Ey = (int)(ySum/yS);
            }
         //END: Y Average
         
         //START: X Average
            {
               Ex = 0;
               for (j = 0;j < 240;j++)
               {
                  xSum = 0;
                  xS = 0;
               
                  for (i = 0;i < 320;i++)
                  {
                     pixel = raster.getPixel(i, j, pixel);
                     outputImage.setRGB(i, j, 0);
                     if (pixel[0] >= lowerR)
                     
                        if (pixel[0] <= upperR)
                           if (pixel[1] >= lowerB)
                              if (pixel[1] <= upperG)
                                 if (pixel[2] >= lowerG)
                                    if (pixel[2] <= upperB)
                                    {
                                       xSum += j;
                                       xS++;
                                       outputImage.setRGB(i,j, 255);
                                    }
                  }
               
                  if (xS > 0)
                     Ex = (int)(xSum/xS);
                  else
                     Ex = 0;
                  xScan[j] = Ex;
               }
            
               xSum = 0;
               xS = 0;
               for (i = 0;i < 240;i++)
               {
                  xSum += xScan[i];
                  if (xScan[i] > 0)
                     xS++;
               }
               Ex = (int)(xSum/xS);
            }
         //END:  X Average
         }
             catch (ArithmeticException e)
            {//System.out.println(e);
            }
      
      //Debugging/Performace Viewer Option
         if (view)
            repaint();
         System.err.println("Time:  " + (System.currentTimeMillis() - startTime) + "<" + Ex + ", " + Ey + ">");
         return (System.currentTimeMillis() - startTime);
      }
   
       long processImage()
      {
         startTime = System.currentTimeMillis();
      
         if (!creatingMask)
         {
            totalSamples = 0;
            outputGraphics.setColor(black);
            outputGraphics.fillRect(0, 0, 320, 240);
            try
            {
               raster = inputImage.getData();
               ySum = 0;
               yS = 0;
               Ey = 0;
            
               xSum = 0;
               xS = 0;
               Ex = 0;
            
            //START:  Y Average
               {
                  for (i = 0;i < columns.length;i++)
                  {
                     currentColumn = columns[i];
                     ySum = 0;
                     yS = 0;
                     for (j = 0;j < currentColumn.yCoordinates.length;j++)
                     {
                        pixel = raster.getPixel(currentColumn.xCoordinate, currentColumn.yCoordinates[j], pixel);
                     
                     //Decide If Pixel Should Be Included
                        outputImage.setRGB(currentColumn.xCoordinate, currentColumn.yCoordinates[j], 0);
                        if (pixel[0] >= lowerR)
                           if (pixel[0] <= upperR)
                              if (pixel[1] >= lowerB)
                                 if (pixel[1] <= upperG)
                                    if (pixel[2] >= lowerG)
                                       if (pixel[2] <= upperB)
                                       {
                                          ySum += currentColumn.yCoordinates[j];
                                          yS++;
                                          outputImage.setRGB(currentColumn.xCoordinate,currentColumn.yCoordinates[j], 255);
                                          totalSamples++;
                                       }
                     }
                     if (yS != 0)
                        Ey = (int)(ySum/yS);
                     else
                        Ey = 0;
                     scanY[i] = Ey;
                  }
               
                  ySum= 0;
                  yS = 0;
                  for (i = 0;i < columns.length;i++)
                  {
                     ySum += scanY[i];
                     if (scanY[i] > 0)
                        yS++;
                  }
                  Ey = (int)(ySum/yS);
               }
            //END: Y Average
            
            //START: X Average
               {
                  Ex = 0;
                  for (j = 0;j < rows.length;j++)
                  {
                     currentRow = rows[j];
                     xSum = 0;
                     xS = 0;
                  
                     for (i = 0;i < currentRow.xCoordinates.length;i++)
                     {
                        pixel = raster.getPixel(currentRow.xCoordinates[i], currentRow.yCoordinate, pixel);
                        outputImage.setRGB(currentRow.xCoordinates[i], currentRow.yCoordinate, 0);
                        if (pixel[0] >= lowerR)
                           if (pixel[0] <= upperR)
                              if (pixel[1] >= lowerG)
                                 if (pixel[1] <= upperG)
                                    if (pixel[2] >= lowerB)
                                       if (pixel[2] <= upperB)
                                       {
                                          xSum += currentRow.xCoordinates[i];
                                          xS++;
                                          outputImage.setRGB(currentRow.xCoordinates[i], currentRow.yCoordinate, 255);
                                       }
                     }
                  
                     if (xS > 0)
                        Ex = (int)(xSum/xS);
                     else
                        Ex = 0;
                     xScan[j] = Ex;
                     totalSamples += xS;
                  }
               
                  xSum = 0;
                  xS = 0;
                  for (i = 0;i < rows.length;i++)
                  {
                     xSum += xScan[i];
                     if (xScan[i] > 0)
                        xS++;
                  }
                  Ex = (int)(xSum/xS);
               }
            //END:  X Average
            }
                catch (ArithmeticException e)
               {//System.out.println(e);
               }
                catch (ArrayIndexOutOfBoundsException e)
               {System.out.println(e);}
         //Debugging/Performace Viewer Option
         //System.err.println("Time:  " + (System.currentTimeMillis() - startTime) + " - <" + Ex + ", " + Ey + ">@" + totalSamples);
            totalSamples = (int)( Math.sqrt(totalSamples/Math.PI));
            outputGraphics.setColor(red);
            outputGraphics.drawOval(Ex - totalSamples, Ey-totalSamples, 2*totalSamples, 2*totalSamples);
            if (view)
               repaint();
         }
         return (System.currentTimeMillis() - startTime);
      }
   
       void updateView()
      {
         colorBounds[0][0].setText(Integer.toString(lowerR));
         colorBounds[0][1].setText(Integer.toString(upperR));
      
         colorBounds[1][0].setText(Integer.toString(lowerG));
         colorBounds[1][1].setText(Integer.toString(upperG));
      
         colorBounds[2][0].setText(Integer.toString(lowerB));
         colorBounds[2][1].setText(Integer.toString(upperB));
      }
   
   
   //Data Structures & Utilities
       void createMask(String filename)
      {
         creatingMask = true;
      //Load Image
         Toolkit toolkit = Toolkit.getDefaultToolkit();
         Image image = toolkit.createImage(filename);
         MediaTracker mt = new MediaTracker(this);
         mt.addImage(image, 0);
         try{mt.waitForAll();}
             catch(InterruptedException ee) {System.out.println(ee);}
         BufferedImage inputImage = new BufferedImage(320, 240, BufferedImage.TYPE_INT_RGB);
         Graphics2D g = (Graphics2D)inputImage.getGraphics();
         g.drawImage(image, 0, 0, 320, 240, this);
      
      //Create Data Structes Needed
         Column rootColumn = new Column();
         Column currentColumn = rootColumn;
      
         Row rootRow = new Row();
         Row currentRow = rootRow;
      
      //Initialize Variables
         raster = inputImage.getData();
         int temp[] = new int[320];
      
      //Get Valid COlumns
         int m = 0;
         for (i = 0;i < 320;i++)
         {
            int n = 0;
            for (j = 0;j < 240;j++)
            {
               pixel = raster.getPixel(i,j,pixel);
            
               if ( (pixel[0] == 255)  )
               {
                  temp[n] = j;
                  n++;
               }
            }
         
         //Create a Column If Data Exists
            if (n > 0)
            {
            //Copy Y Coordinates Into New Vector
               int yCoordinates[] = new int[n];
               for (j = 0;j < n;j++)
                  yCoordinates[j] = temp[j];
            
            //Create a new Column and Update CurrentColumn Pointer
               currentColumn.next = new Column();
               currentColumn = currentColumn.next;
            
            //Set Data In New Column
               currentColumn.xCoordinate = i;
               currentColumn.yCoordinates = yCoordinates;
            
            //Increase Column Total
               m++;
            }
         }
      
      //Make Arry Of Columns
         Column columns[] = new Column[m];
         currentColumn = rootColumn.next;
         for (i = 0;i < m;i++)
         {
            columns[i] = currentColumn;
            currentColumn = currentColumn.next;
         }
      
         for (i=0;i < columns.length;i++)
         {
            currentColumn = columns[i];
            for (j=0;j < currentColumn.yCoordinates.length;j++)
               outputImage.setRGB(currentColumn.xCoordinate, currentColumn.yCoordinates[j], 255);
         }
         this.columns = columns;
      
      //Getr Valkid Rows
         m = 0;
         for (j = 0;j < 240;j++)
         {
            int n = 0;
            for (i = 0;i < 320;i++)
            {
               pixel = raster.getPixel(i, j, pixel);
               if (pixel[0] == 255)
               {
                  temp[n] = i;
                  n++;
               }
            }
         //Create  a Row if Data Exists
            if (n > 0)
            {
            //Copy X Coordinates Into New Vector
               int xCoordinates[] = new int[n];
               for (i = 0;i < n;i++)
                  xCoordinates[i] = temp[i];
            
            //Create a new Row and Update CuurentRow Pointer
               currentRow.next = new Row();
               currentRow = currentRow.next;
            
            //Set Data In New Row
               currentRow.yCoordinate = j;
               currentRow.xCoordinates = xCoordinates;
            
            //Increase Row Total
               m++;
            }
         
         }
       //Make Array Of Columns
         Row rows[] = new Row[m];
         currentRow = rootRow.next;
         for (i = 0;i < m;i++)
         {
            rows[i] = currentRow;
            currentRow = currentRow.next;
         }
         this.rows = rows;
         creatingMask = false;
      }
   
       class Column
      {
         int xCoordinate;
         Column next;
         int yCoordinates[];
      }
   
       class Row
      {
         int yCoordinate;
         Row next;
         int xCoordinates[];
      }
   
       public static void main(String args[])
      {
         ImageProcessor im = new ImageProcessor();
      
         Toolkit toolkit = Toolkit.getDefaultToolkit();
         Image image = toolkit.createImage("c:\\java programs\\vision\\image.jpg");
         MediaTracker mt = new MediaTracker(im);
         mt.addImage(image, 0);
         try{mt.waitForAll();}
             catch(InterruptedException e) {System.out.println(e);}
      
         BufferedImage image2 = new BufferedImage(320, 240, BufferedImage.TYPE_INT_RGB);
         Graphics2D g = (Graphics2D)image2.getGraphics();
         g.drawImage(image, 0, 0, 320, 240, im);
         im.inputImage = image2;
         im.getMean();
      }
   }