   import javax.swing.*;
   import java.awt.*;
   import java.util.*;
   import java.awt.event.*;
   import java.io.*;

   public class MainFrame extends JFrame
   {
      int TAB_SIZE = 2;
   
      JTabbedPane pane = new JTabbedPane();
   
      Container container = getContentPane();
   
      JFileChooser fileDialog = new JFileChooser(new File("c:\\4744\\"));
      ProcessorInterface processorInterface;
   
      JMenuBar menuBar = new JMenuBar();
      JMenu file = new JMenu("File");
      JMenu utils = new JMenu("Utils");
      JMenuItem fileNew, fileOpen, fileClose, fileSave, fileCompile, fileInterface, fileUpload, fileExit;
      JMenuItem utilsLineNumber;
   
   
      boolean shiftDown = false;
      boolean updated = false;
      boolean interfaceOpen = false;
   
      public MainFrame()
      {
         setTitle("What is it?");
      
         fileNew = new JMenuItem("New");
         fileOpen = new JMenuItem("Open");
         fileSave = new JMenuItem("Save");
         fileClose = new JMenuItem("Close");
         fileCompile = new JMenuItem("Compile");
         fileInterface = new JMenuItem("Interface");
         fileUpload = new JMenuItem("Upload");
         fileExit = new JMenuItem("Exit");
      
         utilsLineNumber = new JMenuItem("Goto Line");
      
         menuBar.add(file);
         menuBar.add(utils);
         file.add(fileNew);
         file.add(fileOpen);
         file.add(fileSave);
         file.add(fileClose);
         file.addSeparator();
         file.add(fileInterface);
         file.add(fileCompile);
         file.add(fileUpload);
         file.addSeparator();
         file.add(fileExit);
         utils.add(utilsLineNumber);
      
         MenuListener menuListener = new MenuListener();
         fileNew.addActionListener(menuListener);
         fileSave.addActionListener(menuListener);
         fileOpen.addActionListener(menuListener);
         fileClose.addActionListener(menuListener);
         fileInterface.addActionListener(menuListener);
         fileCompile.addActionListener(menuListener);
         fileUpload.addActionListener(menuListener);
         fileExit.addActionListener(menuListener);
         utilsLineNumber.addActionListener(menuListener);
      
         addComponentListener(
                                new ComponentAdapter()
                                {
                                   public void componentResized(ComponentEvent e)
                                   {
                                   //scrollPanel.setViewPort
                                   //setBounds();
                                   }
                                });
      
         container.setLayout(new BorderLayout());
         container.add(pane, BorderLayout.CENTER);
      
         setJMenuBar(menuBar);
         setSize(500,500);
         show();
      }
   
      void setCaretToLine(int targetLine)
      {
         JScrollPane scrollPane = (JScrollPane)pane.getComponentAt(pane.getSelectedIndex());
         JTextArea text = (JTextArea)scrollPane.getViewport().getView();
         String string = text.getText();
      
         int position = 0;
         int start = 0;
         int end = 1;
         int line = 0;
      
         while ( (line != targetLine) && (position < string.length()) )
         {
            char c = string.charAt(position);
            if (c == '\n')
               line++;
         
            if (line == targetLine-2)
               start = position+1;
            position++;
         }
      
         end = position;
         text.setSelectionEnd(end);
         text.setSelectionStart(start);
      }
      void fileNew()
      {
         JTextArea text = new JTextArea();
         JScrollPane scrollPane = new JScrollPane(text);
         pane.add("Untitled", scrollPane);
         pane.setSelectedComponent(scrollPane);
      }
   
      void fileSave()
      {
         int status = JFileChooser.APPROVE_OPTION;
         String file = pane.getTitleAt(pane.getSelectedIndex());
      
         if (pane.getTitleAt(pane.getSelectedIndex()).equals("Untitled"))
         {
            status = fileDialog.showOpenDialog(this);
            if (status == JFileChooser.APPROVE_OPTION)
            {
               file = fileDialog.getSelectedFile().getName();
               pane.setTitleAt( pane.getSelectedIndex(), file );
            }
         }
      
         if (status == JFileChooser.APPROVE_OPTION)
            try
            {
               JScrollPane scrollPane = (JScrollPane)pane.getSelectedComponent();
               JTextArea text = (JTextArea)scrollPane.getViewport().getView();
            
               FileOutputStream fos = new FileOutputStream(file + ".asm");
               PrintWriter pr = new PrintWriter(fos);
            
               pr.print(text.getText());
            
               pr.flush();
               fos.close();
               updated = false;
            }
               catch (IOException e) {
                  System.out.println(e);}
      }
   
      void fileOpen()
      {
         int status = fileDialog.showOpenDialog(this);
      
         if (status == JFileChooser.APPROVE_OPTION)
            try
            {
               JTextArea text = new JTextArea();
               text.setTabSize(TAB_SIZE);
            
               FileInputStream fis = new FileInputStream(fileDialog.getSelectedFile());
               InputStreamReader isr = new InputStreamReader(fis);
               BufferedReader br = new BufferedReader(isr);
            
               text.setText("");
               String input = br.readLine();
               while (input != null)
               {
                  text.append(input + "\n");
                  input = br.readLine();
               }
            
               fis.close();
            
               text.setCaretPosition(1);
               String name = fileDialog.getSelectedFile().getName();
               name = name.substring(0, name.length()-4);
               JScrollPane scrollPane = new JScrollPane(text);
               pane.addTab(name, scrollPane);
               pane.setSelectedComponent(scrollPane);
               updated = false;
            }
               catch (IOException e) {
                  System.out.println(e);}
      }
   
      void fileClose()
      {
         pane.removeTabAt(pane.getSelectedIndex());
      }
   
      void fileCompile()
      {
         String filename = pane.getTitleAt(pane.getSelectedIndex());
      
         fileSave();
         try
         {
            //Create .BAT File
            {
               FileOutputStream fos = new FileOutputStream("temp.bat");
               PrintWriter pr = new PrintWriter(fos);
               pr.println("as11 " + filename + ".asm -l c > " + filename + ".lst");
               pr.flush();
               fos.close();
            }
         
            //Compile Program
            {
               Runtime runtime = Runtime.getRuntime();
               runtime.exec("temp.bat").waitFor();
            }
         
            //Delete .BAT File
            {
               File file = new File("temp.bat");
               file.delete();
            }
         
            //Check For Errors
            {
               final JDialog dialog = new JDialog();
            
               File file = new File(filename + ".lst");
               FileInputStream fis = new FileInputStream(file);
               InputStreamReader isr = new InputStreamReader(fis);
               BufferedReader br = new BufferedReader(isr);
            
               Vector buttons = new Vector();
               while (true)
               {
                  final String input = br.readLine();
                  if (input == null)
                     break;
                  final StringTokenizer str = new StringTokenizer(input, "|");
                  if (str.countTokens() > 1)
                  {
                     final JButton button = new JButton(input);
                     button.addActionListener(
                                             new ActionListener()
                                             {
                                                public void actionPerformed(ActionEvent e)
                                                {
                                                   dialog.remove(button);
                                                   setCaretToLine(Integer.parseInt(str.nextToken()));
                                                   dialog.repaint();
                                                }
                                             });
                     buttons.add(button);
                  }
               }
            
            
               dialog.getContentPane().setLayout(new GridLayout(buttons.size(), 1));
               for (int i = 0;i < buttons.size();i++)
               {
                  dialog.getContentPane().add( (JButton)buttons.elementAt(i));
               }
               dialog.setModal(false);
               dialog.setSize(500,250);
               dialog.setTitle("Compiler Errors");
               if (buttons.size() > 0)
                  dialog.show();
            }
         }
            catch (IOException e) {
               System.out.println(e);}
            catch (InterruptedException e) {
               System.out.println(e);}
      
         System.gc();
      }
   
      void fileInterface()
      {
         if (interfaceOpen)
         {
            processorInterface.done();
            interfaceOpen = false;
         }
         else
         {
            processorInterface = new ProcessorInterface();
            processorInterface.userInterface();
            interfaceOpen = true;
         }
      }
   
      void fileUpload()
      {
         if (interfaceOpen)
            processorInterface.sendFile(pane.getTitleAt(pane.getSelectedIndex()) + ".S19");
         else
         {
            processorInterface = new ProcessorInterface();
            processorInterface.userInterface();
            processorInterface.done();
         }
      }
   
      void fileExit()
      {
         System.exit(0);
      }
   
      void utilsLineNumber()
      {
         final JDialog dialog = new JDialog(this);
         dialog.setModal(true);
         dialog.setSize(150,50);
         dialog.setTitle("Line Destination");
         dialog.setLocation(250,250);
      
         final JTextField field = new JTextField();
      
         field.addKeyListener(
                                new KeyAdapter()
                                {
                                   public void keyTyped(KeyEvent e)
                                   {
                                      int c = (int)e.getKeyChar();
                                      if (c == 10)
                                      {
                                         dialog.dispose();
                                         setCaretToLine(Integer.parseInt(field.getText()));
                                      }
                                   }
                                });
      
         dialog.getContentPane().add(field);
         dialog.show();
      }
   
      class MenuListener implements ActionListener
      {
         public void actionPerformed(ActionEvent e)
         {
            if (e.getSource() == fileNew)
               fileNew();
         
            if (e.getSource() == fileSave)
               fileSave();
         
            if (e.getSource() == fileOpen)
               fileOpen();
         
            if (e.getSource() == fileCompile)
               fileCompile();
         
            if (e.getSource() == fileInterface)
               fileInterface();
         
            if (e.getSource() == fileUpload)
               fileUpload();
         
            if (e.getSource() == fileExit)
               fileExit();
         
            if (e.getSource() == fileClose)
               fileClose();
         
            if (e.getSource() == utilsLineNumber)
               utilsLineNumber();
         }
      }
   
      public static void main(String args[])
      {
         MainFrame mainFrame = new MainFrame();
      }
   }
