   package vision;

   import javax.swing.*;
   import java.awt.*;
   import java.awt.image.*;

   class ImageProcessor extends JFrame
   {
   //CONSTANTS
      int luminosityThreshold = 200;
   
   //Global Variables
      BufferedImage inputImage;
   
   //Real-Time Debugging Viewing Objects
      BufferedImage outputImage = new BufferedImage(320,240, BufferedImage.TYPE_INT_RGB);
      Raster outputRaster;
   
      boolean view = true;
      boolean viewOutput = true;
      boolean viewInput = true;
   
   //FUNCTION VARIABLES
   //getMean()
      int pixel[] = new int[3];
      long pixelSq;
   
      long ySum = 0;
      long yS = 0;
      int scanY[] = new int[320];
      int Ey = 0;
   
      long xSum = 0;
      long xS;
      int xScan[] = new int[240];
      int Ex = 0;
      Raster  raster;
   
   
   
      ImageProcessor()
      {
         initializeVariables();
      }
   
      void initializeVariables()
      {
         outputRaster = outputImage.getData();
      }
   
   
      public void paint(Graphics g)
      
      {
         if (viewOutput)
            if (outputImage != null)
               g.drawImage(outputImage, 400, 0, 320, 240, this);
      
         if (viewInput)
            if (inputImage != null)
               g.drawImage(inputImage, 0, 0, 320, 240, this);
      }
   
      void getMean()
      {
         raster = inputImage.getData();
         ySum = 0;
         yS = 0;
         Ey = 0;
      
         xSum = 0;
         xS = 0;
         Ex = 0;
      
      //START:  Y Average
         {
            for (int i = 0;i < 320;i++)
            {
               ySum = 0;
               yS = 0;
               for (int j = 0;j < 240;j++)
               {
                  pixel = raster.getPixel(i, j, pixel);
                  if (Math.sqrt(pixel[0]*pixel[0] + pixel[1]*pixel[1] + pixel[2]*pixel[2]) > luminosityThreshold)
                  {
                     ySum += j;
                     yS++;
                  }
               }
            
               if (yS != 0)
                  Ey = (int)(ySum/yS);
               else
                  Ey = 0;
               scanY[i] = Ey;
            //System.out.println(i + ":" + Ey);	
            }
         
            ySum= 0;
            yS = 0;
            for (int i = 0;i < 320;i++)
            {
               ySum += scanY[i];
               if (scanY[i] > 0)
                  yS++;
            }
            Ey = (int)(ySum/yS);
            long time2 = System.currentTimeMillis();
            //System.out.println("Y-Average Time:  " + (time2-time1));
            System.err.print("<" + Ey + ",");
         }
      //END: Y Average
      
      //START: X Average
         {
            Ex = 0;
            long time1 = System.currentTimeMillis();
            for (int j = 0;j < 240;j++)
            {
               xSum = 0;
               xS = 0;
            
               for (int i = 0;i < 320;i++)
               {
                  pixel = raster.getPixel(i, j, pixel);
                  if (Math.sqrt(pixel[0]*pixel[0] + pixel[1]*pixel[1] + pixel[2]*pixel[2]) > luminosityThreshold)
                  {
                     xSum += i;
                     xS++;
                  }
               }
            
               if (xS > 0)
                  Ex = (int)(xSum/xS);
               else
                  Ex = 0;
               xScan[j] = Ex;
            }
         
            xSum = 0;
            xS = 0;
            for (int i = 0;i < 240;i++)
            {
               xSum += xScan[i];
               if (xScan[i] > 0)
                  xS++;
            }
            Ex = (int)(xSum/xS);
         
            long time2 = System.currentTimeMillis();
            //System.out.println("X-Average Time:  " + (time2-time1));
            System.err.println(Ex + ">");
         }
      //END:  X Average
      
      //Debugging Viewer Option
         if (view)
            repaint();
      }
      public static void main(String args[])
      {
      }
   }