   package vision;

   import javax.swing.*;
   import java.awt.*;
   import java.awt.event.*;



    class CircleHistogramMaker extends JFrame
   
   {
      Image image;
      int centerX, centerY, radius, colorNum, ovalX, ovalY;
      Color color[] = {new Color(255, 0, 0), new Color(0, 255, 0), new Color(0, 0, 255)};
      boolean firstClick = true;
   
   
       CircleHistogramMaker(Image image)
      {
         this.image = image;
      
         ovalX = 320/2;
         ovalY = 240/2;
         radius = 50;
         colorNum = 0;
      
      //Add Mouse Listener
         addMouseListener(
                new MouseAdapter()
               {
                   public void mouseClicked(MouseEvent e)
                  {
                  
                     if (firstClick)
                     {
                        centerX = e.getX();
                        centerY = e.getY();
                        ovalX = centerX - 10;
                        ovalY = centerY - 10;
                     
                        radius = 20;
                        firstClick = !firstClick;
                        repaint();
                     }
                     else
                     {
                        int x = e.getX();
                        int y = e.getY();
                        radius = (int)Math.sqrt(Math.pow( (x - centerX), 2) + Math.pow( (y - centerY), 2));
                        ovalX = centerX - radius;
                        ovalY = centerY - radius;
                        radius = 2*radius;
                        firstClick = !firstClick;
                        repaint();
                     }
                  }
               });
      
         setSize(330,280);
         show();
      }
   
       public void paint(Graphics g)
      {
         super.paint(g);
      
         if (image != null)
            g.drawImage(image, 0, 20, 320, 240, this);
         g.setColor(color[colorNum]);
         g.drawOval(ovalX, ovalY, radius, radius);
      }
   
   
       public static void main(String args[])
      {
         Toolkit toolkit = Toolkit.getDefaultToolkit();
         new CircleHistogramMaker(toolkit.createImage("image.jpg"));
      }
   }