   package vision;

   import javax.swing.*;
   import java.awt.*;
   import java.awt.image.*;
   import java.awt.event.*;

    class SetupBounds extends JFrame
   {
      BufferedImage image;
   
      Controls controls;
   
      JLabel instructions;
   
      int onClick = 0;
   
      int shootUpperLeftX = 0;
      int shootUpperLeftY = 0;
      int shootLowerRightX = 0;
      int shootLowerRightY = 0;
   
      int rightLineStartX = 0;
      int rightLineStartY = 0;
      int rightLineEndX = 0;
      int rightLineEndY = 0;
   
      int leftLineStartX = 0;
      int leftLineStartY = 0;
      int leftLineEndX = 0;
      int leftLineEndY = 0;
   
      int shootLineStartX = 0;
      int shootLineStartY = 0;
      int shootLineEndX = 0;
      int shootLineEndY = 0;
   
       SetupBounds(BufferedImage image)
      {
         this.image = image;
      
         Container container = getContentPane();
         container.setLayout(new BorderLayout());
      
      //Layout Items
         DisplayPanel dp = new DisplayPanel();
         container.add(dp, BorderLayout.CENTER);
      
         instructions = new JLabel("Upper Corner For SHooting Bounds");
         container.add(instructions, BorderLayout.NORTH);
      
         dp.addMouseListener(
                new MouseAdapter()
               {
                   public void mouseClicked(MouseEvent e)
                  {
                     switch (onClick)
                     {
                        case 0:
                           shootUpperLeftX = e.getX();
                           shootUpperLeftY = e.getY();
                           onClick++;
                           instructions.setText("Click On Lower Right Shooting Bound");
                           repaint();
                           break;
                        case 1:
                           shootLowerRightX = e.getX();
                           shootLowerRightY = e.getY();
                           onClick++;
                           instructions.setText("Click On Line Start For Right Turning.");
                           repaint();
                           break;
                        case 2:
                           rightLineStartX = e.getX();
                           rightLineStartY = e.getY();
                           onClick++;
                           instructions.setText("Click On Line End For Right Turning.");
                           repaint();
                           break;
                        case 3:
                           rightLineEndX = e.getX();
                           rightLineEndY = e.getY();
                           onClick++;
                           instructions.setText("Click On Line Start For Left Turning.");
                           repaint();
                           break;
                        case 4:
                           leftLineStartX = e.getX();
                           leftLineStartY = e.getY();
                           onClick++;
                           instructions.setText("Click On Line End For Left Turning.");
                           repaint();
                           break;
                        case 5:
                           leftLineEndX = e.getX();
                           leftLineEndY = e.getY();
                           onClick++;
                           instructions.setText("Click On Line Start For Shooting");
                           repaint();
                           break;
                        case 6:
                           shootLineStartX = e.getX();
                           shootLineStartY = e.getY();
                           onClick++;
                           instructions.setText("Click On Line End For Shooting");
                           repaint();
                        
                           break;
                        case 7:
                           shootLineEndX = e.getX();
                           shootLineEndY = e.getY();
                           onClick++;
                           instructions.setText("DONE");
                           repaint();
                        
                           updateControls();
                           break;
                     }
                     validate();
                  }
               });
      
      //Frame Stuff
         setSize(400, 300);
         show();
      }
   
       void updateControls()
      {
         controls.shootRange[0][0] = shootUpperLeftX;
         controls.shootRange[0][1] = shootUpperLeftY;
         controls.shootRange[1][0] = shootLowerRightX;
         controls.shootRange[1][1] = shootLowerRightY;
      
         controls.rightSlope = ((float)(rightLineEndY - rightLineStartY))/((float)(rightLineEndX - rightLineStartX));
         controls.rightIntercept = (int)(rightLineEndY - controls.rightSlope*rightLineEndX);
      
         controls.leftSlope = ((float)(leftLineEndY - leftLineStartY))/((float)(leftLineEndX - leftLineEndY));
         controls.leftIntercept = (int)(leftLineEndY - controls.leftSlope*leftLineEndX);
      
         controls.shootSlope = ((float)(shootLineEndY - shootLineStartY))/((float)(shootLineEndX - shootLineEndY));
         controls.shootIntercept = (int)(shootLineEndY - controls.shootSlope*shootLineEndX);
      
         System.out.println(controls.rightSlope + ", " + controls.rightIntercept);
         System.out.println(controls.leftSlope + ", " + controls.leftIntercept);
      }
   
       class DisplayPanel extends JPanel
      {
          public void paint(Graphics g)
         {
            if (image != null)
               g.drawImage(image, 0, 0, 320, 240, this);
            g.setColor(new Color(255, 0, 0));
            if (onClick > 1)
               g.fillRect(shootUpperLeftX, shootUpperLeftY, shootLowerRightX-shootUpperLeftX, shootLowerRightY-shootUpperLeftY);
            if (onClick > 3)
               g.drawLine(rightLineStartX, rightLineStartY, rightLineEndX, rightLineEndY);
            if (onClick > 5)
               g.drawLine(leftLineStartX, leftLineStartY, leftLineEndX, leftLineEndY);
            if (onClick > 7)
               g.drawLine(shootLineStartX, shootLineStartY, shootLineEndX, shootLineEndY);
         }
      }
   }