#include <mega128.h> 

#define IR_Toggle PORTA.0
#define IR_Reset PORTA.1
#define IR_SelA PORTA.2
#define IR_SelB PORTA.3
#define IR_SelC PORTA.4

#define IR 0
#define S1 1;
#define S2 2;
#define A  3; 

#define FIRST_ADC_INPUT 0
#define LAST_ADC_INPUT 3
#define ADC_VREF_TYPE 0x00

#define motor_changespeed 1
#define sway_speed 50
char LB;
char adc_index;
char t2ctr;
void adjust_speed(); 
void TimeOutWD();

bit look;
char look_cntr;              
                    
void init_ADC()
{ 
// ADC initialization
// ADC Clock frequency: 115.200 kHz
// ADC Voltage Reference: AREF pin
ADMUX=ADC_VREF_TYPE;
ADCSRA=0xDF;

 IR_SelA=0;
 IR_SelB=0;
 IR_SelC=0;
 ir_sensor=0;
 IR_Toggle=0;
 IR_Reset=1;
} 

// ADC interrupt service routine
interrupt [ADC_INT] void adc_isr(void)
{
// Read the AD conversion result
adc_data[channel]=ADCW;
//sample rate: 115kHz 
// Select next ADC input
if(read_sonar==0)
        Avg_IR_Samples();
if(channel>0 & channel<3 & read_sonar==1)
        Read_Sonar();
if(channel==3)
        ammeter();
        
if(read_sonar==1)
{
 channel=sonar_sel+1;
}
else if(read_current==1)
{
 channel=3;
}
else
 {
 channel=0;
 }
ADMUX=(FIRST_ADC_INPUT|ADC_VREF_TYPE)+channel;
// Start the AD conversion
ADCSRA|=0x40;   //Start another conversion
} 

void init_timer2()
{
// Timer/Counter 2 initialization
// Clock source: System Clock
// Clock value: 14.400 kHz
// Mode: Normal top=FFh
// OC2 output: Disconnected
TCCR2=0x05;
TCNT2=0x00;
OCR2=0x00;
// Timer(s)/Counter(s) Interrupt(s) initialization
TIMSK|=0x40;
}

// Timer 2 overflow interrupt service routine
interrupt [TIM2_OVF] void timer2_ovf_isr(void)
{ 
 Enable_Sonar();
 TimeOutWD();
 
 t2ctr+=1;
 if(t2ctr == motor_changespeed)
 {
 t2ctr=0;
 adjust_speed();
 }
 
 LB+=1;
 
 if(look_cntr==sway_speed)
 {
 look_cntr=0;
 look^=1;
 }
 else
 {  
 look_cntr+=1;
 }
}

/*
// Read the AD conversion result
unsigned int read_adc(unsigned char adc_input)
{
ADMUX=adc_input | (ADC_VREF_TYPE & 0xff);
// Delay needed for the stabilization of the ADC input voltage
delay_us(10);
// Start the AD conversion
ADCSRA|=0x40;
// Wait for the AD conversion to complete
while ((ADCSRA & 0x10)==0);
ADCSRA|=0x10;
return ADCW;
} 
*/