




// Global variables  
int IR_Intensity=1;
int scnt;
//int cntr;
float IR_Result[16];
int IR_Hist[7];
float samples;
//bit lock;
//int adc_data;


/***********************************************************
	Function Name: Decrease_IR_Level
	Function Description: This function toggles the 
	IR level down one notch at a time, then resets the
	IR level to zero(Full power).
	NOTES: 
        Inputs: none
        Outputs: IR_Toggle, IR_Reset, IR_Intensity
***********************************************************/  
void Decrease_IR_Level(){
        PORTA.2 = 1;             //Keep clock line high until  a number of counts has passed
                  
        if (IR_Intensity==15){     //There are 16 levels. 1=High...15=off
                PORTA.3=0;        //Trigger the sync. memory reset    
                PORTA.2=0;
                IR_Intensity=1;
                delay_us(1);
        }                    
        else{ 
                PORTA.3 = 1;       //Active low reset
                PORTA.2 = 0;      //Pull counter clock line low,(Low-to-high edge trigger)
                IR_Intensity++;
                delay_us(1);
                }
        
      PORTA.2=1;
}        
/*
void Change_IR_Level(int level){
                int i;
                IR_Reset = 0;       //Active low reset
                IR_Toggle = 0;      //Pull counter clock line low,(Low-to-high edge trigger)
                IR_Intensity=0;
                delay_us(1);
                IR_Toggle = 1;
                delay_us(1); 
                IR_Reset = 1;       //Active low reset               
        for(i=1;i<=level;i++) {
                        delay_us(1);
                        IR_Toggle = 0;      //Pull counter clock line low,(Low-to-high edge trigger)
                        IR_Intensity++;
                        delay_us(1);
                        IR_Toggle = 1;
                        }          
      IR_Toggle=1;
}*/      

void Find_Levels(){
        int i;               
        if (IR_Intensity<=15) {          //If all 15 levels have been sampled
                IR_Result[0]=0;
                
               for(i=1;i<7;i++){
                      IR_Hist[i]=0;
                }
                for(i=1;i<15;i++){
                        IR_Result[0]=IR_Result[0]+IR_Result[i]; 
                        if (IR_Result[i]==0){
                                IR_Hist[0]=IR_Hist[0]+1;}
                        else if(IR_Result[i]==1){
                                IR_Hist[1]=IR_Hist[1]+1;}
                        else if(IR_Result[i]==2){
                                IR_Hist[2]=IR_Hist[2]+1;}
                        else if(IR_Result[i]==3){
                                IR_Hist[3]=IR_Hist[3]+1;}                                                             
                        else if(IR_Result[i]==4){
                                IR_Hist[4]=IR_Hist[4]+1;}                     
                        else if(IR_Result[i]==5){
                                IR_Hist[5]=IR_Hist[5]+1;}
                        else if(IR_Result[i]==6){
                                IR_Hist[6]=IR_Hist[6]+1;}                                                   
                                                               
               }
        }        
    } 
    
/***********************************************************
	Function Name: Avg_IR_Samples
	Function Description: This function collects a thousand samples
	from the IR sensors and averages them. This will produce a number
	between 207 to 500. This function is run in the ADISR.
	NOTES: 
        Inputs: adc_data
        Outputs: IR_Result
***********************************************************/
void Avg_IR_Samples(int adc_data){
        samples=samples+adc_data;
        if (scnt==250){
                IR_Result[IR_Intensity]=samples/250/50-4; 
                samples=0;
                scnt=0;
                //PORTB^=0x01;
                Decrease_IR_Level();
                Find_Levels(); 
                      
        }
        scnt++;
                                        
} 


   
