#define Lservo PORTB.7   //OC1C
#define Rservo PORTB.6   //OC1B
#define Gripper PORTB.5  //OC1A
#define Tilter PORTE.4     //OC3A


#define ls_och OCR1CH
#define ls_ocl OCR1CL

#define rs_och OCR1BH
#define rs_ocl OCR1BL

#define gr_och OCR1AH
#define gr_ocl OCR1AL

#define ti_och OCR3AH
#define ti_ocl OCR3AL

#define top 500
#define tilt_max 475

#define tilt_up 448
#define tilt_down 466

#define tilt_min 445 
#define center 456
#define grip_max 482
#define grip_min 462
#define stopped 482
#define l_neutral 456
#define r_neutral 484

#define grip_strength 22

#include <mega128.h> 

//Global Variables
signed int l_speed=top;
signed int r_speed=top;
int grip_pos=470;
int tilt_pos=center;
int cntr;
int lspd=0;
int rspd=0;
int gpos=470;
int tpos=center;
bit object_ready;

signed int left_speed;
signed int right_speed;

void init_timer1()
{
// Timer/Counter 1 initialization
// Clock source: System Clock
// Clock value: 56.700 kHz
// Mode: Ph. & fr. cor. PWM top=ICR1
// OC1A output: Inverted
// OC1B output: Inverted
// OC1C output: Inverted
// Noise Canceler: Off
// Input Capture on Rising Edge
// Timer 1 Overflow Interrupt: Off
// Input Capture Interrupt: On
// Compare A Match Interrupt: On
// Compare B Match Interrupt: On
// Compare C Match Interrupt: On
TCCR1A=0xFC;
TCCR1B=0x54;
TCNT1H=0x00;
TCNT1L=0x00;

ICR1H=0x01;  //TOP=500
ICR1L=0xF4;

gr_och=grip_min/256;         //OCR1AH
gr_ocl=grip_min%256;         //OCR1AL;

rs_och=top/256;         //OCR1BH
rs_ocl=top%256;         //OCR1BL

ls_och=top/256;         //OCR1CH
ls_ocl=top%256;         //OCR1CL

TIMSK|=0x18;
ETIMSK|=0x01;
}

void init_timer3()
{
 // Timer/Counter 3 initialization
// Clock source: System Clock
// Clock value: 56.700 kHz
// Mode: Ph. & fr. cor. PWM top=ICR3
// Noise Canceler: Off
// Input Capture on Rising Edge
// OC3A output: Inverted
// OC3B output: Discon.
// OC3C output: Discon.
// Timer 3 Overflow Interrupt: Off
// Input Capture Interrupt: On
// Compare A Match Interrupt: On
// Compare B Match Interrupt: Off
// Compare C Match Interrupt: Off
TCCR3A=0xC0;
TCCR3B=0x54;
TCNT3H=0x00;
TCNT3L=0x00;

ICR3H=0x01;     //TOP=500
ICR3L=0xF4;

ti_och=center/256;         //OCR3AH
ti_ocl=center%256;         //OCR3AL

OCR3BH=0x00;
OCR3BL=0x00;
OCR3CH=0x00;
OCR3CL=0x00;

ETIMSK|=0x10;
}

void Lmotor_ctrl(signed int spd){
                 if(spd>=-10 & spd<=10 & spd!=0)
                 {
                  l_speed=l_neutral-spd;
                 }
                 else if(spd==0)
                 {
                  l_speed=top;
                 }        
        
        ls_och=l_speed/256;
        ls_ocl=l_speed%256;     
}

void Rmotor_ctrl(signed int spd){ 
                 if(spd>=-10 & spd <=10 & spd!=0)
                {
                  r_speed=r_neutral+spd;
                 }
                 else if(spd==0)
                 {
                  r_speed=top;
                 }
 
        rs_och=r_speed/256;
        rs_ocl=r_speed%256;     
}

void grip_ctrl(char pos){
        
         if(pos=='O')
         {
          grip_pos=center;
         }
         else if(pos=='C')
         {
          if(Amps<=grip_strength & grip_pos<grip_max)
           {
                if(new_reading==1)
                {
                grip_pos+=1;
                new_reading=0;
                }
           }
           else if(Amps>grip_strength | grip_pos==grip_max)
           {
            object_ready=1;
           }
         }  
 
        gr_och=grip_pos/256;
        gr_ocl=grip_pos%256; 
}

void tilt_ctrl(char pos){
        if(pos=='D')
        {
        tilt_pos=tilt_down;
        }
        else if(pos=='C')
        {
        tilt_pos=center;
        }
        else if(pos=='U')
        {
        tilt_pos=tilt_up;
        }
        
        ti_och=tilt_pos/256;
        ti_ocl=tilt_pos%256; 
}


void adjust_speed()
{
if(rspd<right_speed)
{
rspd+=1;
}
else if(rspd>right_speed)
{
rspd-=1;
}

if(lspd<left_speed)
{
 lspd+=1;
}
else if(lspd>left_speed)
{
 lspd-=1;
}


}

// Timer 3 output compare A interrupt service routine
interrupt [TIM3_COMPA] void timer3_compa_isr(void)
{ 
/*
 if(button==3)
 {
  tpos+=2;
  tilt_ctrl(tpos);
  button=0;
 }
 else if(button==6)
 {
  tpos-=2;
  tilt_ctrl(tpos);
  button=0;
  }
  PORTB.0^=1; 
  */
}

// Timer 1 output compare A interrupt service routine
interrupt [TIM1_COMPA] void timer1_compa_isr(void)
{
 read_current=1;
 /*
 if(button==7)
 {
  gpos+=1;
  grip_ctrl(gpos);
  button=0;
 }
 else if(button==8)
 {
  grip_ctrl('C');
  
  }
*/ 
}

// Timer 1 output compare B interrupt service routine
interrupt [TIM1_COMPB] void timer1_compb_isr(void)
{

Rmotor_ctrl(rspd);
/*
 if(button==4)
 {
  right_speed+=1;
  Rmotor_ctrl(right_speed);
  button=0;
 }
 else if(button==5)
 {
  right_speed-=1;
  Rmotor_ctrl(right_speed);
  button=0;
  }
*/ 
}

// Timer 1 output compare C interrupt service routine
interrupt [TIM1_COMPC] void timer1_compc_isr(void)
{

Lmotor_ctrl(lspd);

/*
 if(button==1)
 {
  left_speed+=1;
  Lmotor_ctrl(left_speed);
  button=0;
 }
 else if(button==2)
 {
  left_speed-=1;
  Lmotor_ctrl(left_speed);
  button=0;
  }
*/
 } 
 
 
/**************************************
This function controls the motors.
**************************************/
void motor_ctrl(int direction)
{ 
 if(direction=='c')
 {
  left_speed=10;
  right_speed=-10;
 }
 else if(direction=='C')
 {
  left_speed=-10;
  right_speed=10;
 }
  else if(direction=='r')
 {
  left_speed=5;
  right_speed=2;
 }
 else if(direction=='l')
 {
  left_speed=2;
  right_speed=5;
 } 
 else if(direction=='R')
 {
  left_speed=10;
  right_speed=0;
 } 
 else if(direction=='L')
 {
  left_speed=0;
  right_speed=10;
 } 
 else if(direction=='S')
 {
  left_speed=10;
  right_speed=10;
 }
  else if(direction=='B')
 {
  left_speed=-10;
  right_speed=-10;
 }
 else if(direction=='P')
 {
  left_speed=0;
  right_speed=0;
 }
 else if(direction=='>')
 {
  left_speed=3;
  right_speed=1;
 }
 else if(direction=='<')
 {
  left_speed=1;
  right_speed=2;
 }
 else
 {
  left_speed=direction;
  right_speed=direction;   
 }
  
}

