






// CodeVisionAVR C Compiler
// (C) 1998-2004 Pavel Haiduc, HP InfoTech S.R.L.

// I/O registers definitions for the ATmega128


#pragma used+
#pragma used+
sfrb PINF=0;
sfrb PINE=1;
sfrb DDRE=2;
sfrb PORTE=3;
sfrb ADCL=4;
sfrb ADCH=5;
sfrw ADCW=4;      // 16 bit access
sfrb ADCSRA=6;
sfrb ADMUX=7;
sfrb ACSR=8;
sfrb UBRR0L=9;
sfrb UCSR0B=0xa;
sfrb UCSR0A=0xb;
sfrb UDR0=0xc;
sfrb SPCR=0xd;
sfrb SPSR=0xe;
sfrb SPDR=0xf;
sfrb PIND=0x10;
sfrb DDRD=0x11;
sfrb PORTD=0x12;
sfrb PINC=0x13;
sfrb DDRC=0x14;
sfrb PORTC=0x15;
sfrb PINB=0x16;
sfrb DDRB=0x17;
sfrb PORTB=0x18;
sfrb PINA=0x19;
sfrb DDRA=0x1a;
sfrb PORTA=0x1b;
sfrb EECR=0x1c;
sfrb EEDR=0x1d;
sfrb EEARL=0x1e;
sfrb EEARH=0x1f;
sfrw EEAR=0x1e;   // 16 bit access
sfrb SFIOR=0x20;
sfrb WDTCR=0x21;
sfrb OCDR=0x22;
sfrb OCR2=0x23;
sfrb TCNT2=0x24;
sfrb TCCR2=0x25;
sfrb ICR1L=0x26;
sfrb ICR1H=0x27;
sfrw ICR1=0x26;   // 16 bit access
sfrb OCR1BL=0x28;
sfrb OCR1BH=0x29;
sfrw OCR1B=0x28;  // 16 bit access
sfrb OCR1AL=0x2a;
sfrb OCR1AH=0x2b;
sfrw OCR1A=0x2a;  // 16 bit access
sfrb TCNT1L=0x2c;
sfrb TCNT1H=0x2d;
sfrw TCNT1=0x2c;  // 16 bit access
sfrb TCCR1B=0x2e;
sfrb TCCR1A=0x2f;
sfrb ASSR=0x30;
sfrb OCR0=0x31;
sfrb TCNT0=0x32;
sfrb TCCR0=0x33;
sfrb MCUCSR=0x34;
sfrb MCUCR=0x35;
sfrb TIFR=0x36;
sfrb TIMSK=0x37;
sfrb EIFR=0x38;
sfrb EIMSK=0x39;
sfrb EICRB=0x3a;
sfrb RAMPZ=0x3b;
sfrb XDIV=0x3c;
sfrb SPL=0x3d;
sfrb SPH=0x3e;
sfrb SREG=0x3f;
#pragma used-


// Interrupt vectors definitions


// Needed by the power management functions (sleep.h)
#asm
	#ifndef __SLEEP_DEFINED__
	#define __SLEEP_DEFINED__
	.EQU __se_bit=0x20
	.EQU __sm_mask=0x1C
	.EQU __sm_powerdown=0x10
	.EQU __sm_powersave=0x18
	.EQU __sm_standby=0x14
	.EQU __sm_ext_standby=0x1C
	.EQU __sm_adc_noise_red=0x08
	.SET power_ctrl_reg=mcucr
	#endif
#endasm



//Global Variables
int l_speed=0;
int r_speed=0;
//int RTempSpeed=stopped;
//int LTempSpeed=stopped;
int cntr;

void Lmotor_ctrl(int spd){
        (*(unsigned char *) 0x87)=(500-spd)/256;
        (*(unsigned char *) 0x86)=(500-spd)%256;     
}

void Rmotor_ctrl(int spd){  
        (*(unsigned char *) 0x85)=(500-spd)/256;
        (*(unsigned char *) 0x84)=(500-spd)%256;     
}

void adjust_speed(int LTempSpeed, int RTempSpeed){
        if (LTempSpeed > l_speed){
                Lmotor_ctrl(l_speed+1);
                }
        else if(LTempSpeed < l_speed){
                Lmotor_ctrl(l_speed-1);
                }                   
        
        if (RTempSpeed > r_speed){
                Rmotor_ctrl(r_speed+1);
                }
        else if(RTempSpeed < r_speed){
                Rmotor_ctrl(r_speed-1);
                }                               
}

// Timer 3 output compare A interrupt service routine
interrupt [27] void timer3_compa_isr(void)
{
// Place your code here
       if(cntr%50==0){
                adjust_speed(1,1);
                }
//Lmotor_ctrl(l_speed);
PORTB.0^=1; 
cntr++;
}

// Timer 3 output compare B interrupt service routine
interrupt [28] void timer3_compb_isr(void)
{
// Place your code here
//Rmotor_ctrl(l_speed);
}

// Timer 3 output compare C interrupt service routine
interrupt [29] void timer3_compc_isr(void)
{
// Place your code here

}
