#include <mega128.h>

#define Sonar1_EN PORTA.5
#define Sonar2_EN PORTA.6

//Global variables
unsigned int SonarResult;
//int SonarSelect;
float SonarInches[2];
int SR_H;

/*
/***********************************************************
	Function Name: Sonar_Capture
	Function Description: This function will evaluate the PW 
        sent from the sonar and return the distance.
	NOTES: 
        Inputs: none
        Outputs: SonarResult, SonarInches
***********************************************************/    
void Sonar1_Capture(){
if (TCCR1B==00x45){
        TCNT1H=0;
        TCNT1L=0;
        TCCR1B=0x05;     //Change the trigger to falling edge
        }        
else{ 
      
      SonarResult=ICR1L;
      SR_H=ICR1H;
      SonarResult|=(SR_H<<4); 
      TCCR1B=00x45;   //Change the trigger to rising edge
        
        SonarInches[0]=SonarResult*0.472;    //147us/inch                          
}              
//TIFR|=0x20;      //Clear ICF1              
}

void Sonar2_Capture(){
if (TCCR3B==00x45){
        TCNT3H=0;
        TCNT3L=0;
        TCCR3B=0x05;     //Change the trigger to falling edge
        }        
else{ 
      
      SonarResult=ICR3L;
      SR_H=ICR3H;
      SonarResult|=(SR_H<<4); 
        TCCR3B=00x45;   //Change the trigger to rising edge
        
        SonarInches[1]=SonarResult*0.472;    //147us/inch                          
}              
TIFR|=0x40;      //Clear ICF1              
}

// Timer 1 input capture interrupt service routine
interrupt [TIM1_CAPT] void timer1_capt_isr(void)
{
// Place your code here

}

// Timer 3 input capture interrupt service routine
interrupt [TIM3_CAPT] void timer3_capt_isr(void)
{
// Place your code here

}
