#include <mega128.h>

#define Sonar1_EN PORTA.5
#define Sonar2_EN PORTA.6
#define Sonar1 1
#define Sonar2 2
#define Samples 2
#define num_of_samples 2

//Global variables
int SonarInches[2];
unsigned int SonarResult;
int sonar_samples;
bit sonar_sel=0;
bit read_sonar;
char sonar_cntr=0;
char s_samp;

/*****************************************
This function averages the sonar samples 
from the ADC. It is called in the ADC ISR. 
*****************************************/

void Read_Sonar()
{
 SonarResult+=adc_data[channel];
 sonar_samples+=1;
        if(sonar_samples==num_of_samples)
        {
        SonarInches[sonar_sel]=SonarResult/sonar_samples/2;
        SonarResult=0;
        sonar_samples=0;
        read_sonar=0;
                if(sonar_sel==0) //alternate the sonar being sampled
                {
                sonar_sel=1;     
                }
                else                    
                {
                 sonar_sel=0;
                }
        }
 }



/********************************************
This enables the sonar to take a reading and
changes the A/D channel when a sample is ready.
*******************************************/

void Enable_Sonar()
{
if(sonar_cntr==1)
 {
        if(sonar_sel==0)
        {
         Sonar1_EN=1;
         }
         else
         {
          Sonar2_EN=1;
         }
 }
 else if(sonar_cntr==2)
 {
  Sonar2_EN=0;
  Sonar1_EN=0;
 }
  else if(sonar_cntr==10)
 {
  sonar_cntr=0;
  read_sonar=1;
 } 
   
sonar_cntr+=1;
}
