
;CodeVisionAVR C Compiler V1.25.8a Evaluation
;(C) Copyright 1998-2007 Pavel Haiduc, HP InfoTech s.r.l.
;http://www.hpinfotech.com

;Chip type              : ATmega128
;Program type           : Application
;Clock frequency        : 4.000000 MHz
;Memory model           : Small
;Optimize for           : Size
;(s)printf features     : int, width
;(s)scanf features      : int, width
;External SRAM size     : 0
;Data Stack size        : 1024 byte(s)
;Heap size              : 0 byte(s)
;Promote char to int    : No
;char is unsigned       : Yes
;8 bit enums            : Yes
;Word align FLASH struct: No
;Enhanced core instructions    : On
;Smart register allocation : On
;Automatic register allocation : On

	#pragma AVRPART ADMIN PART_NAME ATmega128
	#pragma AVRPART MEMORY PROG_FLASH 131072
	#pragma AVRPART MEMORY EEPROM 4096
	#pragma AVRPART MEMORY INT_SRAM SIZE 4096
	#pragma AVRPART MEMORY INT_SRAM START_ADDR 0x100

	.EQU UDRE=0x5
	.EQU RXC=0x7
	.EQU USR=0xB
	.EQU UDR=0xC
	.EQU SPSR=0xE
	.EQU SPDR=0xF
	.EQU EERE=0x0
	.EQU EEWE=0x1
	.EQU EEMWE=0x2
	.EQU EECR=0x1C
	.EQU EEDR=0x1D
	.EQU EEARL=0x1E
	.EQU EEARH=0x1F
	.EQU WDTCR=0x21
	.EQU MCUCR=0x35
	.EQU RAMPZ=0x3B
	.EQU SPL=0x3D
	.EQU SPH=0x3E
	.EQU SREG=0x3F
	.EQU XMCRA=0x6D
	.EQU XMCRB=0x6C

	.DEF R0X0=R0
	.DEF R0X1=R1
	.DEF R0X2=R2
	.DEF R0X3=R3
	.DEF R0X4=R4
	.DEF R0X5=R5
	.DEF R0X6=R6
	.DEF R0X7=R7
	.DEF R0X8=R8
	.DEF R0X9=R9
	.DEF R0XA=R10
	.DEF R0XB=R11
	.DEF R0XC=R12
	.DEF R0XD=R13
	.DEF R0XE=R14
	.DEF R0XF=R15
	.DEF R0X10=R16
	.DEF R0X11=R17
	.DEF R0X12=R18
	.DEF R0X13=R19
	.DEF R0X14=R20
	.DEF R0X15=R21
	.DEF R0X16=R22
	.DEF R0X17=R23
	.DEF R0X18=R24
	.DEF R0X19=R25
	.DEF R0X1A=R26
	.DEF R0X1B=R27
	.DEF R0X1C=R28
	.DEF R0X1D=R29
	.DEF R0X1E=R30
	.DEF R0X1F=R31

	.MACRO __CPD1N
	CPI  R30,LOW(@0)
	LDI  R26,HIGH(@0)
	CPC  R31,R26
	LDI  R26,BYTE3(@0)
	CPC  R22,R26
	LDI  R26,BYTE4(@0)
	CPC  R23,R26
	.ENDM

	.MACRO __CPD2N
	CPI  R26,LOW(@0)
	LDI  R30,HIGH(@0)
	CPC  R27,R30
	LDI  R30,BYTE3(@0)
	CPC  R24,R30
	LDI  R30,BYTE4(@0)
	CPC  R25,R30
	.ENDM

	.MACRO __CPWRR
	CP   R@0,R@2
	CPC  R@1,R@3
	.ENDM

	.MACRO __CPWRN
	CPI  R@0,LOW(@2)
	LDI  R30,HIGH(@2)
	CPC  R@1,R30
	.ENDM

	.MACRO __ADDB1MN
	SUBI R30,LOW(-@0-(@1))
	.ENDM
	.MACRO __ADDB2MN
	SUBI R26,LOW(-@0-(@1))
	.ENDM
	.MACRO __ADDW1MN
	SUBI R30,LOW(-@0-(@1))
	SBCI R31,HIGH(-@0-(@1))
	.ENDM
	.MACRO __ADDW2MN
	SUBI R26,LOW(-@0-(@1))
	SBCI R27,HIGH(-@0-(@1))
	.ENDM
	.MACRO __ADDW1FN
	SUBI R30,LOW(-2*@0-(@1))
	SBCI R31,HIGH(-2*@0-(@1))
	.ENDM
	.MACRO __ADDD1FN
	SUBI R30,LOW(-2*@0-(@1))
	SBCI R31,HIGH(-2*@0-(@1))
	SBCI R22,BYTE3(-2*@0-(@1))
	.ENDM
	.MACRO __ADDD1N
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	SBCI R22,BYTE3(-@0)
	SBCI R23,BYTE4(-@0)
	.ENDM

	.MACRO __ADDD2N
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	SBCI R24,BYTE3(-@0)
	SBCI R25,BYTE4(-@0)
	.ENDM

	.MACRO __SUBD1N
	SUBI R30,LOW(@0)
	SBCI R31,HIGH(@0)
	SBCI R22,BYTE3(@0)
	SBCI R23,BYTE4(@0)
	.ENDM

	.MACRO __SUBD2N
	SUBI R26,LOW(@0)
	SBCI R27,HIGH(@0)
	SBCI R24,BYTE3(@0)
	SBCI R25,BYTE4(@0)
	.ENDM

	.MACRO __ANDBMNN
	LDS  R30,@0+@1
	ANDI R30,LOW(@2)
	STS  @0+@1,R30
	.ENDM

	.MACRO __ANDWMNN
	LDS  R30,@0+@1
	ANDI R30,LOW(@2)
	STS  @0+@1,R30
	LDS  R30,@0+@1+1
	ANDI R30,HIGH(@2)
	STS  @0+@1+1,R30
	.ENDM

	.MACRO __ANDD1N
	ANDI R30,LOW(@0)
	ANDI R31,HIGH(@0)
	ANDI R22,BYTE3(@0)
	ANDI R23,BYTE4(@0)
	.ENDM

	.MACRO __ORBMNN
	LDS  R30,@0+@1
	ORI  R30,LOW(@2)
	STS  @0+@1,R30
	.ENDM

	.MACRO __ORWMNN
	LDS  R30,@0+@1
	ORI  R30,LOW(@2)
	STS  @0+@1,R30
	LDS  R30,@0+@1+1
	ORI  R30,HIGH(@2)
	STS  @0+@1+1,R30
	.ENDM

	.MACRO __ORD1N
	ORI  R30,LOW(@0)
	ORI  R31,HIGH(@0)
	ORI  R22,BYTE3(@0)
	ORI  R23,BYTE4(@0)
	.ENDM

	.MACRO __DELAY_USB
	LDI  R24,LOW(@0)
__DELAY_USB_LOOP:
	DEC  R24
	BRNE __DELAY_USB_LOOP
	.ENDM

	.MACRO __DELAY_USW
	LDI  R24,LOW(@0)
	LDI  R25,HIGH(@0)
__DELAY_USW_LOOP:
	SBIW R24,1
	BRNE __DELAY_USW_LOOP
	.ENDM

	.MACRO __CLRD1S
	LDI  R30,0
	STD  Y+@0,R30
	STD  Y+@0+1,R30
	STD  Y+@0+2,R30
	STD  Y+@0+3,R30
	.ENDM

	.MACRO __GETD1S
	LDD  R30,Y+@0
	LDD  R31,Y+@0+1
	LDD  R22,Y+@0+2
	LDD  R23,Y+@0+3
	.ENDM

	.MACRO __PUTD1S
	STD  Y+@0,R30
	STD  Y+@0+1,R31
	STD  Y+@0+2,R22
	STD  Y+@0+3,R23
	.ENDM

	.MACRO __PUTD2S
	STD  Y+@0,R26
	STD  Y+@0+1,R27
	STD  Y+@0+2,R24
	STD  Y+@0+3,R25
	.ENDM

	.MACRO __POINTB1MN
	LDI  R30,LOW(@0+@1)
	.ENDM

	.MACRO __POINTW1MN
	LDI  R30,LOW(@0+@1)
	LDI  R31,HIGH(@0+@1)
	.ENDM

	.MACRO __POINTD1M
	LDI  R30,LOW(@0)
	LDI  R31,HIGH(@0)
	LDI  R22,BYTE3(@0)
	LDI  R23,BYTE4(@0)
	.ENDM

	.MACRO __POINTW1FN
	LDI  R30,LOW(2*@0+@1)
	LDI  R31,HIGH(2*@0+@1)
	.ENDM

	.MACRO __POINTD1FN
	LDI  R30,LOW(2*@0+@1)
	LDI  R31,HIGH(2*@0+@1)
	LDI  R22,BYTE3(2*@0+@1)
	LDI  R23,BYTE4(2*@0+@1)
	.ENDM

	.MACRO __POINTB2MN
	LDI  R26,LOW(@0+@1)
	.ENDM

	.MACRO __POINTW2MN
	LDI  R26,LOW(@0+@1)
	LDI  R27,HIGH(@0+@1)
	.ENDM

	.MACRO __POINTBRM
	LDI  R@0,LOW(@1)
	.ENDM

	.MACRO __POINTWRM
	LDI  R@0,LOW(@2)
	LDI  R@1,HIGH(@2)
	.ENDM

	.MACRO __POINTBRMN
	LDI  R@0,LOW(@1+@2)
	.ENDM

	.MACRO __POINTWRMN
	LDI  R@0,LOW(@2+@3)
	LDI  R@1,HIGH(@2+@3)
	.ENDM

	.MACRO __POINTWRFN
	LDI  R@0,LOW(@2*2+@3)
	LDI  R@1,HIGH(@2*2+@3)
	.ENDM

	.MACRO __GETD1N
	LDI  R30,LOW(@0)
	LDI  R31,HIGH(@0)
	LDI  R22,BYTE3(@0)
	LDI  R23,BYTE4(@0)
	.ENDM

	.MACRO __GETD2N
	LDI  R26,LOW(@0)
	LDI  R27,HIGH(@0)
	LDI  R24,BYTE3(@0)
	LDI  R25,BYTE4(@0)
	.ENDM

	.MACRO __GETD2S
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	LDD  R24,Y+@0+2
	LDD  R25,Y+@0+3
	.ENDM

	.MACRO __GETB1MN
	LDS  R30,@0+@1
	.ENDM

	.MACRO __GETB1HMN
	LDS  R31,@0+@1
	.ENDM

	.MACRO __GETW1MN
	LDS  R30,@0+@1
	LDS  R31,@0+@1+1
	.ENDM

	.MACRO __GETD1MN
	LDS  R30,@0+@1
	LDS  R31,@0+@1+1
	LDS  R22,@0+@1+2
	LDS  R23,@0+@1+3
	.ENDM

	.MACRO __GETBRMN
	LDS  R@0,@1+@2
	.ENDM

	.MACRO __GETWRMN
	LDS  R@0,@2+@3
	LDS  R@1,@2+@3+1
	.ENDM

	.MACRO __GETWRZ
	LDD  R@0,Z+@2
	LDD  R@1,Z+@2+1
	.ENDM

	.MACRO __GETD2Z
	LDD  R26,Z+@0
	LDD  R27,Z+@0+1
	LDD  R24,Z+@0+2
	LDD  R25,Z+@0+3
	.ENDM

	.MACRO __GETB2MN
	LDS  R26,@0+@1
	.ENDM

	.MACRO __GETW2MN
	LDS  R26,@0+@1
	LDS  R27,@0+@1+1
	.ENDM

	.MACRO __GETD2MN
	LDS  R26,@0+@1
	LDS  R27,@0+@1+1
	LDS  R24,@0+@1+2
	LDS  R25,@0+@1+3
	.ENDM

	.MACRO __PUTB1MN
	STS  @0+@1,R30
	.ENDM

	.MACRO __PUTW1MN
	STS  @0+@1,R30
	STS  @0+@1+1,R31
	.ENDM

	.MACRO __PUTD1MN
	STS  @0+@1,R30
	STS  @0+@1+1,R31
	STS  @0+@1+2,R22
	STS  @0+@1+3,R23
	.ENDM

	.MACRO __PUTBR0MN
	STS  @0+@1,R0
	.ENDM

	.MACRO __PUTDZ2
	STD  Z+@0,R26
	STD  Z+@0+1,R27
	STD  Z+@0+2,R24
	STD  Z+@0+3,R25
	.ENDM

	.MACRO __PUTBMRN
	STS  @0+@1,R@2
	.ENDM

	.MACRO __PUTWMRN
	STS  @0+@1,R@2
	STS  @0+@1+1,R@3
	.ENDM

	.MACRO __PUTBZR
	STD  Z+@1,R@0
	.ENDM

	.MACRO __PUTWZR
	STD  Z+@2,R@0
	STD  Z+@2+1,R@1
	.ENDM

	.MACRO __GETW1R
	MOV  R30,R@0
	MOV  R31,R@1
	.ENDM

	.MACRO __GETW2R
	MOV  R26,R@0
	MOV  R27,R@1
	.ENDM

	.MACRO __GETWRN
	LDI  R@0,LOW(@2)
	LDI  R@1,HIGH(@2)
	.ENDM

	.MACRO __PUTW1R
	MOV  R@0,R30
	MOV  R@1,R31
	.ENDM

	.MACRO __PUTW2R
	MOV  R@0,R26
	MOV  R@1,R27
	.ENDM

	.MACRO __ADDWRN
	SUBI R@0,LOW(-@2)
	SBCI R@1,HIGH(-@2)
	.ENDM

	.MACRO __ADDWRR
	ADD  R@0,R@2
	ADC  R@1,R@3
	.ENDM

	.MACRO __SUBWRN
	SUBI R@0,LOW(@2)
	SBCI R@1,HIGH(@2)
	.ENDM

	.MACRO __SUBWRR
	SUB  R@0,R@2
	SBC  R@1,R@3
	.ENDM

	.MACRO __ANDWRN
	ANDI R@0,LOW(@2)
	ANDI R@1,HIGH(@2)
	.ENDM

	.MACRO __ANDWRR
	AND  R@0,R@2
	AND  R@1,R@3
	.ENDM

	.MACRO __ORWRN
	ORI  R@0,LOW(@2)
	ORI  R@1,HIGH(@2)
	.ENDM

	.MACRO __ORWRR
	OR   R@0,R@2
	OR   R@1,R@3
	.ENDM

	.MACRO __EORWRR
	EOR  R@0,R@2
	EOR  R@1,R@3
	.ENDM

	.MACRO __GETWRS
	LDD  R@0,Y+@2
	LDD  R@1,Y+@2+1
	.ENDM

	.MACRO __PUTWSR
	STD  Y+@2,R@0
	STD  Y+@2+1,R@1
	.ENDM

	.MACRO __MOVEWRR
	MOV  R@0,R@2
	MOV  R@1,R@3
	.ENDM

	.MACRO __INWR
	IN   R@0,@2
	IN   R@1,@2+1
	.ENDM

	.MACRO __OUTWR
	OUT  @2+1,R@1
	OUT  @2,R@0
	.ENDM

	.MACRO __CALL1MN
	LDS  R30,@0+@1
	LDS  R31,@0+@1+1
	ICALL
	.ENDM

	.MACRO __CALL1FN
	LDI  R30,LOW(2*@0+@1)
	LDI  R31,HIGH(2*@0+@1)
	CALL __GETW1PF
	ICALL
	.ENDM

	.MACRO __CALL2EN
	LDI  R26,LOW(@0+@1)
	LDI  R27,HIGH(@0+@1)
	CALL __EEPROMRDW
	ICALL
	.ENDM

	.MACRO __GETW1STACK
	IN   R26,SPL
	IN   R27,SPH
	ADIW R26,@0+1
	LD   R30,X+
	LD   R31,X
	.ENDM

	.MACRO __NBST
	BST  R@0,@1
	IN   R30,SREG
	LDI  R31,0x40
	EOR  R30,R31
	OUT  SREG,R30
	.ENDM


	.MACRO __PUTB1SN
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SN
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SN
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1SNS
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	ADIW R26,@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SNS
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	ADIW R26,@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SNS
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	ADIW R26,@1
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1PMN
	LDS  R26,@0
	LDS  R27,@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1PMN
	LDS  R26,@0
	LDS  R27,@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1PMN
	LDS  R26,@0
	LDS  R27,@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1PMNS
	LDS  R26,@0
	LDS  R27,@0+1
	ADIW R26,@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1PMNS
	LDS  R26,@0
	LDS  R27,@0+1
	ADIW R26,@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1PMNS
	LDS  R26,@0
	LDS  R27,@0+1
	ADIW R26,@1
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RN
	MOVW R26,R@0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RN
	MOVW R26,R@0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RN
	MOVW R26,R@0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RNS
	MOVW R26,R@0
	ADIW R26,@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RNS
	MOVW R26,R@0
	ADIW R26,@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RNS
	MOVW R26,R@0
	ADIW R26,@1
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RON
	MOV  R26,R@0
	MOV  R27,R@1
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RON
	MOV  R26,R@0
	MOV  R27,R@1
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RON
	MOV  R26,R@0
	MOV  R27,R@1
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RONS
	MOV  R26,R@0
	MOV  R27,R@1
	ADIW R26,@2
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RONS
	MOV  R26,R@0
	MOV  R27,R@1
	ADIW R26,@2
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RONS
	MOV  R26,R@0
	MOV  R27,R@1
	ADIW R26,@2
	CALL __PUTDP1
	.ENDM


	.MACRO __GETB1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R30,Z
	.ENDM

	.MACRO __GETB1HSX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R31,Z
	.ENDM

	.MACRO __GETW1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R0,Z+
	LD   R31,Z
	MOV  R30,R0
	.ENDM

	.MACRO __GETD1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R0,Z+
	LD   R1,Z+
	LD   R22,Z+
	LD   R23,Z
	MOVW R30,R0
	.ENDM

	.MACRO __GETB2SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R26,X
	.ENDM

	.MACRO __GETW2SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	.ENDM

	.MACRO __GETD2SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R1,X+
	LD   R24,X+
	LD   R25,X
	MOVW R26,R0
	.ENDM

	.MACRO __GETBRSX
	MOVW R30,R28
	SUBI R30,LOW(-@1)
	SBCI R31,HIGH(-@1)
	LD   R@0,Z
	.ENDM

	.MACRO __GETWRSX
	MOVW R30,R28
	SUBI R30,LOW(-@2)
	SBCI R31,HIGH(-@2)
	LD   R@0,Z+
	LD   R@1,Z
	.ENDM

	.MACRO __LSLW8SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R31,Z
	CLR  R30
	.ENDM

	.MACRO __PUTB1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X+,R31
	ST   X+,R22
	ST   X,R23
	.ENDM

	.MACRO __CLRW1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	CLR  R0
	ST   Z+,R0
	ST   Z,R0
	.ENDM

	.MACRO __CLRD1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	CLR  R0
	ST   Z+,R0
	ST   Z+,R0
	ST   Z+,R0
	ST   Z,R0
	.ENDM

	.MACRO __PUTB2SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z,R26
	.ENDM

	.MACRO __PUTW2SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z+,R26
	ST   Z,R27
	.ENDM

	.MACRO __PUTD2SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z+,R26
	ST   Z+,R27
	ST   Z+,R24
	ST   Z,R25
	.ENDM

	.MACRO __PUTBSRX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z,R@1
	.ENDM

	.MACRO __PUTWSRX
	MOVW R30,R28
	SUBI R30,LOW(-@2)
	SBCI R31,HIGH(-@2)
	ST   Z+,R@0
	ST   Z,R@1
	.ENDM

	.MACRO __PUTB1SNX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SNX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SNX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X+,R31
	ST   X+,R22
	ST   X,R23
	.ENDM

	.MACRO __MULBRR
	MULS R@0,R@1
	MOVW R30,R0
	.ENDM

	.MACRO __MULBRRU
	MUL  R@0,R@1
	MOVW R30,R0
	.ENDM

	.MACRO __MULBRR0
	MULS R@0,R@1
	.ENDM

	.MACRO __MULBRRU0
	MUL  R@0,R@1
	.ENDM

	.MACRO __MULBNWRU
	LDI  R26,@2
	MUL  R26,R@0
	MOVW R30,R0
	MUL  R26,R@1
	ADD  R31,R0
	.ENDM

	.CSEG
	.ORG 0

	.INCLUDE "test.vec"
	.INCLUDE "test.inc"

__RESET:
	CLI
	CLR  R30
	OUT  EECR,R30

;INTERRUPT VECTORS ARE PLACED
;AT THE START OF FLASH
	LDI  R31,1
	OUT  MCUCR,R31
	OUT  MCUCR,R30
	STS  XMCRB,R30

;DISABLE WATCHDOG
	LDI  R31,0x18
	OUT  WDTCR,R31
	OUT  WDTCR,R30

;CLEAR R2-R14
	LDI  R24,13
	LDI  R26,2
	CLR  R27
__CLEAR_REG:
	ST   X+,R30
	DEC  R24
	BRNE __CLEAR_REG

;CLEAR SRAM
	LDI  R24,LOW(0x1000)
	LDI  R25,HIGH(0x1000)
	LDI  R26,LOW(0x100)
	LDI  R27,HIGH(0x100)
__CLEAR_SRAM:
	ST   X+,R30
	SBIW R24,1
	BRNE __CLEAR_SRAM

	OUT  RAMPZ,R24

;GLOBAL VARIABLES INITIALIZATION
	LDI  R30,LOW(__GLOBAL_INI_TBL*2)
	LDI  R31,HIGH(__GLOBAL_INI_TBL*2)
__GLOBAL_INI_NEXT:
	LPM  R24,Z+
	LPM  R25,Z+
	SBIW R24,0
	BREQ __GLOBAL_INI_END
	LPM  R26,Z+
	LPM  R27,Z+
	LPM  R0,Z+
	LPM  R1,Z+
	MOVW R22,R30
	MOVW R30,R0
__GLOBAL_INI_LOOP:
	LPM  R0,Z+
	ST   X+,R0
	SBIW R24,1
	BRNE __GLOBAL_INI_LOOP
	MOVW R30,R22
	RJMP __GLOBAL_INI_NEXT
__GLOBAL_INI_END:

;STACK POINTER INITIALIZATION
	LDI  R30,LOW(0x10FF)
	OUT  SPL,R30
	LDI  R30,HIGH(0x10FF)
	OUT  SPH,R30

;DATA STACK POINTER INITIALIZATION
	LDI  R28,LOW(0x500)
	LDI  R29,HIGH(0x500)

	JMP  _main

	.ESEG
	.ORG 0

	.DSEG
	.ORG 0x500
;       1 /*****************************************************
;       2 This program was produced by the
;       3 CodeWizardAVR V1.25.8a Evaluation
;       4 Automatic Program Generator
;       5  Copyright 1998-2007 Pavel Haiduc, HP InfoTech s.r.l.
;       6 http://www.hpinfotech.com
;       7 
;       8 Project : L-DOR
;       9 Version : 1.0
;      10 Date    : 2/9/2008
;      11 Author  : Freeware, for evaluation and non-commercial use only
;      12 Company :
;      13 Comments:
;      14 
;      15 
;      16 Chip type           : ATmega128
;      17 Program type        : Application
;      18 Clock frequency     : 14.745600 MHz
;      19 Memory model        : Small
;      20 External SRAM size  : 0
;      21 Data Stack size     : 1024
;      22 *****************************************************/
;      23 
;      24 #include <mega128.h>
;      25 	#ifndef __SLEEP_DEFINED__
	#ifndef __SLEEP_DEFINED__
;      26 	#define __SLEEP_DEFINED__
	#define __SLEEP_DEFINED__
;      27 	.EQU __se_bit=0x20
	.EQU __se_bit=0x20
;      28 	.EQU __sm_mask=0x1C
	.EQU __sm_mask=0x1C
;      29 	.EQU __sm_powerdown=0x10
	.EQU __sm_powerdown=0x10
;      30 	.EQU __sm_powersave=0x18
	.EQU __sm_powersave=0x18
;      31 	.EQU __sm_standby=0x14
	.EQU __sm_standby=0x14
;      32 	.EQU __sm_ext_standby=0x1C
	.EQU __sm_ext_standby=0x1C
;      33 	.EQU __sm_adc_noise_red=0x08
	.EQU __sm_adc_noise_red=0x08
;      34 	.SET power_ctrl_reg=mcucr
	.SET power_ctrl_reg=mcucr
;      35 	#endif
	#endif
;      36 #include <stdlib.h>
;      37 #include <inttypes.h>
;      38 #include <delay.h>
;      39 #include <lcd.h>
;      40 
;      41 #define ADC_VREF_TYPE 0x00
;      42 
;      43 // Declare your global variables here
;      44 
;      45 
;      46 // Timer 0 overflow interrupt service routine
;      47 interrupt [TIM0_OVF] void timer0_ovf_isr(void)
;      48 {

	.CSEG
_timer0_ovf_isr:
;      49 }
	RETI
;      50 
;      51 // Timer 0 output compare interrupt service routine
;      52 interrupt [TIM0_COMP] void timer0_comp_isr(void)
;      53 {
_timer0_comp_isr:
;      54 }
	RETI
;      55 
;      56 // Timer 1 input capture interrupt service routine
;      57 interrupt [TIM1_CAPT] void timer1_capt_isr(void)
;      58 {
_timer1_capt_isr:
;      59 }
	RETI
;      60 
;      61 // Timer 1 overflow interrupt service routine
;      62 interrupt [TIM1_OVF] void timer1_ovf_isr(void)
;      63 {
_timer1_ovf_isr:
;      64 
;      65 }
	RETI
;      66 
;      67 
;      68 // Read the AD conversion result
;      69 unsigned int read_adc(unsigned char adc_input)
;      70 {
_read_adc:
	PUSH R15
;      71 ADMUX=adc_input | (ADC_VREF_TYPE & 0xff);
;	adc_input -> Y+0
	LD   R30,Y
	OUT  0x7,R30
;      72 // Delay needed for the stabilization of the ADC input voltage
;      73 delay_us(10);
	__DELAY_USB 13
;      74 // Start the AD conversion
;      75 ADCSRA|=0x40;
	SBI  0x6,6
;      76 // Wait for the AD conversion to complete
;      77 while ((ADCSRA & 0x10)==0);
_0x3:
	SBIC 0x6,4
	RJMP _0x5
	RJMP _0x3
_0x5:
;      78 ADCSRA|=0x10;
	SBI  0x6,4
;      79 return ADCW;
	IN   R30,0x4
	IN   R31,0x4+1
	ADIW R28,1
	RET
;      80 }
;      81 
;      82 // ADC interrupt service routine
;      83 interrupt [ADC_INT] void adc_isr(void)
;      84 {
_adc_isr:
;      85 unsigned int adc_data;
;      86 // Read the AD conversion result
;      87 adc_data=ADCW;
	ST   -Y,R17
	ST   -Y,R16
;	adc_data -> R16,R17
	__INWR 16,17,4
;      88 // Place your code here
;      89 //sample rate: 115kHz
;      90 }
	LD   R16,Y+
	LD   R17,Y+
	RETI
;      91 
;      92 void main(void)
;      93 {
_main:
;      94 delay_ms(500);
	LDI  R30,LOW(500)
	LDI  R31,HIGH(500)
	ST   -Y,R31
	ST   -Y,R30
	CALL _delay_ms
;      95 // Declare your local variables here
;      96 
;      97 // Input/Output Ports initialization
;      98 // Port A initialization
;      99 // Func7=Out Func6=Out Func5=Out Func4=Out Func3=Out Func2=Out Func1=Out Func0=Out
;     100 // State7=0 State6=0 State5=0 State4=0 State3=0 State2=0 State1=0 State0=0
;     101 PORTA=0x00;
	LDI  R30,LOW(0)
	OUT  0x1B,R30
;     102 DDRA=0xFF;
	LDI  R30,LOW(255)
	OUT  0x1A,R30
;     103 
;     104 // Port B initialization
;     105 // Func7=In Func6=In Func5=In Func4=In Func3=In Func2=In Func1=In Func0=OUT=>LED
;     106 // State7=T State6=T State5=T State4=T State3=T State2=T State1=T State0=T
;     107 PORTB=0x00;
	LDI  R30,LOW(0)
	OUT  0x18,R30
;     108 DDRB=0x01;
	LDI  R30,LOW(1)
	OUT  0x17,R30
;     109 
;     110 // Port C initialization
;     111 // Func7=Out Func6=Out Func5=Out Func4=Out Func3=Out Func2=Out Func1=Out Func0=Out
;     112 // State7=0 State6=0 State5=0 State4=0 State3=0 State2=0 State1=0 State0=0
;     113 PORTC=0x00;
	LDI  R30,LOW(0)
	OUT  0x15,R30
;     114 DDRC=0xFF;
	LDI  R30,LOW(255)
	OUT  0x14,R30
;     115 
;     116 // Port D initialization
;     117 // Func7=In Func6=In Func5=In Func4=In Func3=In Func2=In Func1=In Func0=In
;     118 // State7=T State6=T State5=T State4=T State3=T State2=T State1=T State0=T
;     119 PORTD=0x00;
	LDI  R30,LOW(0)
	OUT  0x12,R30
;     120 DDRD=0x00;
	OUT  0x11,R30
;     121 
;     122 // Port E initialization
;     123 // Func7=In Func6=In Func5=In Func4=In Func3=In Func2=In Func1=In Func0=In
;     124 // State7=T State6=T State5=T State4=T State3=T State2=T State1=T State0=T
;     125 PORTE=0x00;
	OUT  0x3,R30
;     126 DDRE=0x00;
	OUT  0x2,R30
;     127 
;     128 // Port F initialization
;     129 // Func7=In Func6=In Func5=In Func4=In Func3=In Func2=In Func1=In Func0=In
;     130 // State7=T State6=T State5=T State4=T State3=T State2=T State1=T State0=T
;     131 PORTF=0x00;
	STS  98,R30
;     132 DDRF=0x00;
	STS  97,R30
;     133 
;     134 // Port G initialization
;     135 // Func4=In Func3=In Func2=In Func1=In Func0=In
;     136 // State4=T State3=T State2=T State1=T State0=T
;     137 PORTG=0x00;
	STS  101,R30
;     138 DDRG=0x00;
	STS  100,R30
;     139 
;     140 // Timer/Counter 0 initialization
;     141 // Clock source: System Clock
;     142 // Clock value: 14.400 kHz
;     143 // Mode: Normal top=FFh
;     144 // OC0 output: Disconnected
;     145 ASSR=0x00;
	OUT  0x30,R30
;     146 TCCR0=0x07;
	LDI  R30,LOW(7)
	OUT  0x33,R30
;     147 TCNT0=0x00;
	LDI  R30,LOW(0)
	OUT  0x32,R30
;     148 //OCR0=0x0E;
;     149 
;     150 // Timer/Counter 1 initialization
;     151 // Clock source: System Clock
;     152 // Clock value: 14.400 kHz
;     153 // Mode: Normal Mode
;     154 // OC1A output: Discon.
;     155 // OC1B output: Discon.
;     156 // OC1C output: Discon.
;     157 // Noise Canceler: Off
;     158 // Input Capture on Rising Edge
;     159 // Timer 1 Overflow Interrupt: Off
;     160 // Input Capture Interrupt: on
;     161 // Compare A Match Interrupt: Off
;     162 // Compare B Match Interrupt: Off
;     163 // Compare C Match Interrupt: Off
;     164 TCCR1A=0x00;
	OUT  0x2F,R30
;     165 TCCR1B=0x45;
	LDI  R30,LOW(69)
	OUT  0x2E,R30
;     166 TCNT1H=0x00;
	LDI  R30,LOW(0)
	OUT  0x2D,R30
;     167 TCNT1L=0x00;
	OUT  0x2C,R30
;     168 ICR1H=0x00;
	OUT  0x27,R30
;     169 ICR1L=0x00;
	OUT  0x26,R30
;     170 OCR1AH=0x00;
	OUT  0x2B,R30
;     171 OCR1AL=0x00;
	OUT  0x2A,R30
;     172 OCR1BH=0x00;
	OUT  0x29,R30
;     173 OCR1BL=0x00;
	OUT  0x28,R30
;     174 OCR1CH=0x00;
	STS  121,R30
;     175 OCR1CL=0x00;
	STS  120,R30
;     176 
;     177 // Timer/Counter 2 initialization
;     178 // Clock source: System Clock
;     179 // Clock value: Timer 2 Stopped
;     180 // Mode: Normal top=FFh
;     181 // OC2 output: Disconnected
;     182 TCCR2=0x00;
	OUT  0x25,R30
;     183 TCNT2=0x00;
	OUT  0x24,R30
;     184 OCR2=0x00;
	OUT  0x23,R30
;     185 
;     186 // Timer/Counter 3 initialization
;     187 // Clock source: System Clock
;     188 // Clock value: Timer 3 Stopped
;     189 // Mode: Normal top=FFFFh
;     190 // Noise Canceler: Off
;     191 // Input Capture on Falling Edge
;     192 // OC3A output: Discon.
;     193 // OC3B output: Discon.
;     194 // OC3C output: Discon.
;     195 // Timer 3 Overflow Interrupt: Off
;     196 // Input Capture Interrupt: Off
;     197 // Compare A Match Interrupt: Off
;     198 // Compare B Match Interrupt: Off
;     199 // Compare C Match Interrupt: Off
;     200 TCCR3A=0x00;
	STS  139,R30
;     201 TCCR3B=0x00;
	STS  138,R30
;     202 TCNT3H=0x00;
	STS  137,R30
;     203 TCNT3L=0x00;
	STS  136,R30
;     204 ICR3H=0x00;
	STS  129,R30
;     205 ICR3L=0x00;
	STS  128,R30
;     206 OCR3AH=0x00;
	STS  135,R30
;     207 OCR3AL=0x00;
	STS  134,R30
;     208 OCR3BH=0x00;
	STS  133,R30
;     209 OCR3BL=0x00;
	STS  132,R30
;     210 OCR3CH=0x00;
	STS  131,R30
;     211 OCR3CL=0x00;
	STS  130,R30
;     212 
;     213 // External Interrupt(s) initialization
;     214 // INT0: Off
;     215 // INT1: Off
;     216 // INT2: Off
;     217 // INT3: Off
;     218 // INT4: Off
;     219 // INT5: Off
;     220 // INT6: Off
;     221 // INT7: Off
;     222 EICRA=0x00;
	STS  106,R30
;     223 EICRB=0x00;
	OUT  0x3A,R30
;     224 EIMSK=0x00;
	OUT  0x39,R30
;     225 
;     226 // Timer(s)/Counter(s) Interrupt(s) initialization
;     227 TIMSK=0x23; //Timer0 OF and OC
	LDI  R30,LOW(35)
	OUT  0x37,R30
;     228 ETIMSK=0x00;
	LDI  R30,LOW(0)
	STS  125,R30
;     229 
;     230 // Analog Comparator initialization
;     231 // Analog Comparator: Off
;     232 // Analog Comparator Input Capture by Timer/Counter 1: Off
;     233 ACSR=0x80;
	LDI  R30,LOW(128)
	OUT  0x8,R30
;     234 SFIOR=0x00;
	LDI  R30,LOW(0)
	OUT  0x20,R30
;     235 
;     236 // ADC initialization
;     237 // ADC Clock frequency: 115.200 kHz
;     238 // ADC Voltage Reference: AREF pin
;     239 ADMUX=ADC_VREF_TYPE & 0xff;
	OUT  0x7,R30
;     240 ADCSRA=0xAF;
	LDI  R30,LOW(175)
	OUT  0x6,R30
;     241 
;     242 // LCD module initialization
;     243 lcd_init(20);
	LDI  R30,LOW(20)
	ST   -Y,R30
	CALL _lcd_init
;     244 
;     245 // Global enable interrupts
;     246 #asm("sei")
	sei
;     247 motor_ctrl('f',100);
	LDI  R30,LOW(102)
	LDI  R30,LOW(100)
;     248 while (1)
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
_0x6:
;     249       {
;     250       // Place your code here
;     251         lcd_clear();
	CALL _lcd_clear
;     252         i=read_adc(3);
	LDI  R30,LOW(3)
	ST   -Y,R30
	CALL _read_adc
;     253         j=(i/k);
;     254         lcd_putsf("IR ");
	__POINTW1FN _0,0
	ST   -Y,R31
	ST   -Y,R30
	CALL _lcd_putsf
;     255         lcd_PrintInt(cntr/200);
	MOVW R26,R30
	MOVW R24,R22
	__GETD1N 0x43480000
	CALL __DIVF21
;     256         lcd_gotoxy(0,1);
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _lcd_gotoxy
;     257         lcd_PrintInt(IR_Result);
;     258       // lcd_PrintInt(SonarResult);
;     259 
;     260 
;     261         delay_ms(50);
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	LDI  R30,LOW(50)
	LDI  R31,HIGH(50)
	ST   -Y,R31
	ST   -Y,R30
	CALL _delay_ms
;     262 
;     263       };
	RJMP _0x6
_0x8:
;     264 }
_0x9:
	RJMP _0x9
;     265 //Global variables
;     266 unsigned int SonarResult;
;     267 //unsigned int SonarResult_2;
;     268 //int SonarSelect;
;     269 float SonarInches;

	.DSEG
_SonarInches:
	.BYTE 0x4
;     270 int SR_H;
;     271 
;     272 /***********************************************************
;     273 	Function Name: Sonar_Capture
;     274 	Function Description: This function will evaluate the PW
;     275         sent from the sonar and return the distance.
;     276 	NOTES:
;     277         Inputs: none
;     278         Outputs: SonarResult, SonarInches
;     279 ***********************************************************/
;     280 void Sonar_Capture(){

	.CSEG
_Sonar_Capture:
	PUSH R15
;     281 if (TCCR1B==00x45){
	IN   R30,0x2E
	CPI  R30,LOW(0x45)
	BREQ PC+3
	JMP _0xA
;     282         TCNT1H=0;
	LDI  R30,LOW(0)
	OUT  0x2D,R30
;     283         TCNT1L=0;
	OUT  0x2C,R30
;     284 
;     285         PORTB = 0x01;
	LDI  R30,LOW(1)
	OUT  0x18,R30
;     286         TCCR1B=00x05;     //Change the trigger to falling edge
	LDI  R30,LOW(5)
	OUT  0x2E,R30
;     287         }
;     288 else{
	RJMP _0xB
_0xA:
;     289 
;     290       SonarResult=ICR1L;
	IN   R4,38
	CLR  R5
;     291       SR_H=ICR1H;
	IN   R6,39
	CLR  R7
;     292       SonarResult|=(SR_H<<4);
	MOVW R30,R6
	CALL __LSLW4
	__ORWRR 4,5,30,31
;     293 
;     294         PORTB = 0x00;
	LDI  R30,LOW(0)
	OUT  0x18,R30
;     295         TCCR1B=00x45;   //Change the trigger to rising edge
	LDI  R30,LOW(69)
	OUT  0x2E,R30
;     296 
;     297         SonarInches=SonarResult*0.472;    //147us/inch
	MOVW R30,R4
	CLR  R22
	CLR  R23
	CALL __CDF1
	__GETD2N 0x3EF1A9FC
	CALL __MULF12
	STS  _SonarInches,R30
	STS  _SonarInches+1,R31
	STS  _SonarInches+2,R22
	STS  _SonarInches+3,R23
;     298 }
_0xB:
;     299 TIFR|=0x40;      //Clear ICF1
	IN   R30,0x36
	ORI  R30,0x40
	OUT  0x36,R30
;     300 }
	RET
;     301 
;     302 #define IR_Level PORTA.2
;     303 #define IR_Level_Reset PORTA.3
;     304 #define IR_Cycle_Speed 200
;     305 
;     306 
;     307 // Global variables
;     308 int scnt;
;     309 float IR_Result=0;

	.DSEG
_IR_Result:
	.BYTE 0x4
;     310 float samples=0;
_samples:
	.BYTE 0x4
;     311 
;     312 
;     313 /***********************************************************
;     314 	Function Name: Change_IR_Level
;     315 	Function Description: This function toggles the
;     316 	IR level down one notch at a time, then resets the
;     317 	IR level to zero each time it is called.
;     318 	NOTES:
;     319         Inputs: none
;     320         Outputs: IR_Level, IR_Level_Reset
;     321 ***********************************************************/
;     322 void Change_IR_Level(){

	.CSEG
_Change_IR_Level:
	PUSH R15
;     323         IR_Level = 0;
	CBI  0x1B,2
;     324         //PORTB^=0x01;
;     325 
;     326         if (cntr%IR_Cycle_Speed==0){
	MOVW R26,R30
	MOVW R24,R22
	__GETD1N 0x43480000
	CALL __CPD10
	BREQ PC+3
	JMP _0xE
;     327                 IR_Level = 1;
	SBI  0x1B,2
;     328                 IR_Level_Reset=1;
	SBI  0x1B,3
;     329         }
;     330         if (cntr>7*IR_Cycle_Speed){
_0xE:
	MOVW R26,R30
	MOVW R24,R22
	__GETD1N 0x44AF0000
	CALL __CMPF12
	BREQ PC+2
	BRCC PC+3
	JMP  _0x13
;     331                 IR_Level_Reset=0;
	CBI  0x1B,3
;     332                 cntr=0;
;     333         }
;     334         cntr++;
_0x13:
;     335 }
	RET
;     336 
;     337 
;     338 /***********************************************************
;     339 	Function Name: Avg_IR_Samples
;     340 	Function Description: This function collects a thousand samples
;     341 	from the IR sensors and averages them. This will produce a number
;     342 	between 207 to 500. This function is run in the ADISR.
;     343 	NOTES:
;     344         Inputs: adc_data
;     345         Outputs: IR_Result
;     346 ***********************************************************/
;     347 void Avg_IR_Samples(){
_Avg_IR_Samples:
	PUSH R15
;     348 samples=samples+adc_data;
	LDS  R30,_samples
	LDS  R31,_samples+1
	LDS  R22,_samples+2
	LDS  R23,_samples+3
	MOVW R26,R30
	MOVW R24,R22
	CALL __ADDF12
	STS  _samples,R30
	STS  _samples+1,R31
	STS  _samples+2,R22
	STS  _samples+3,R23
;     349 if (scnt==1000){
	LDI  R30,LOW(1000)
	LDI  R31,HIGH(1000)
	CP   R30,R8
	CPC  R31,R9
	BREQ PC+3
	JMP _0x16
;     350         IR_Result=samples/1000; //208 is approximately 1V
	LDS  R26,_samples
	LDS  R27,_samples+1
	LDS  R24,_samples+2
	LDS  R25,_samples+3
	__GETD1N 0x447A0000
	CALL __DIVF21
	STS  _IR_Result,R30
	STS  _IR_Result+1,R31
	STS  _IR_Result+2,R22
	STS  _IR_Result+3,R23
;     351         samples=0;
	__GETD1N 0x0
	STS  _samples,R30
	STS  _samples+1,R31
	STS  _samples+2,R22
	STS  _samples+3,R23
;     352         scnt=0;
	CLR  R8
	CLR  R9
;     353         }
;     354         scnt++;
_0x16:
	MOVW R30,R8
	ADIW R30,1
	MOVW R8,R30
;     355 }
	RET
;     356 
;     357 
;     358 #define Lservo PORTA.0
;     359 #define Rservo PORTA.1
;     360 #define center 0x15
;     361 #define fast 0x08
;     362 #define medium 0x04
;     363 #define slow 0x02
;     364 
;     365 //Global Variables
;     366 //int Lmtr_en=0;
;     367 //int Rmtr_en=0;
;     368 int mtr_en=0;
;     369 int Lpwm=0;
;     370 int Rpwm=0;

	.DSEG
_Rpwm:
	.BYTE 0x2
;     371 int T0Q0;
_T0Q0:
	.BYTE 0x2
;     372 int T0Q1;
_T0Q1:
	.BYTE 0x2
;     373 
;     374 void motor_ctrl(char dir,int spd){

	.CSEG
_motor_ctrl:
	PUSH R15
;     375 mtr_en=1;
;	dir -> Y+2
;	spd -> Y+0
	LDI  R30,LOW(1)
	LDI  R31,HIGH(1)
	MOVW R10,R30
;     376 if (dir=='f') {
	LDD  R26,Y+2
	CPI  R26,LOW(0x66)
	BREQ PC+3
	JMP _0x17
;     377     Lpwm=((8*spd)/100+center);   //spd is 0 to 100
	LD   R30,Y
	LDD  R31,Y+1
	CALL __LSLW3
	MOVW R26,R30
	LDI  R30,LOW(100)
	LDI  R31,HIGH(100)
	CALL __DIVW21
	ADIW R30,21
	MOVW R12,R30
;     378     Rpwm=((8*spd)/100+center);
	LD   R30,Y
	LDD  R31,Y+1
	CALL __LSLW3
	MOVW R26,R30
	LDI  R30,LOW(100)
	LDI  R31,HIGH(100)
	CALL __DIVW21
	ADIW R30,21
	STS  _Rpwm,R30
	STS  _Rpwm+1,R31
;     379     }
;     380 else if (dir=='r') {
	RJMP _0x18
_0x17:
	LDD  R26,Y+2
	CPI  R26,LOW(0x72)
	BREQ PC+3
	JMP _0x19
;     381         Lpwm=(center-(8*spd)/100);
	LD   R30,Y
	LDD  R31,Y+1
	CALL __LSLW3
	MOVW R26,R30
	LDI  R30,LOW(100)
	LDI  R31,HIGH(100)
	CALL __DIVW21
	LDI  R26,LOW(21)
	LDI  R27,HIGH(21)
	SUB  R26,R30
	SBC  R27,R31
	MOVW R12,R26
;     382         Rpwm=(center+(8*spd)/100);
	LD   R30,Y
	LDD  R31,Y+1
	CALL __LSLW3
	MOVW R26,R30
	LDI  R30,LOW(100)
	LDI  R31,HIGH(100)
	CALL __DIVW21
	ADIW R30,21
	STS  _Rpwm,R30
	STS  _Rpwm+1,R31
;     383         }
;     384 else if (dir=='l') {
	RJMP _0x1A
_0x19:
	LDD  R26,Y+2
	CPI  R26,LOW(0x6C)
	BREQ PC+3
	JMP _0x1B
;     385         Lpwm=(center+(8*spd)/100);
	LD   R30,Y
	LDD  R31,Y+1
	CALL __LSLW3
	MOVW R26,R30
	LDI  R30,LOW(100)
	LDI  R31,HIGH(100)
	CALL __DIVW21
	ADIW R30,21
	MOVW R12,R30
;     386         Rpwm=(center-(8*spd)/100);
	LD   R30,Y
	LDD  R31,Y+1
	CALL __LSLW3
	MOVW R26,R30
	LDI  R30,LOW(100)
	LDI  R31,HIGH(100)
	CALL __DIVW21
	LDI  R26,LOW(21)
	LDI  R27,HIGH(21)
	SUB  R26,R30
	SBC  R27,R31
	STS  _Rpwm,R26
	STS  _Rpwm+1,R27
;     387         }
;     388 else if (dir=='b') {
	RJMP _0x1C
_0x1B:
	LDD  R26,Y+2
	CPI  R26,LOW(0x62)
	BREQ PC+3
	JMP _0x1D
;     389         Lpwm=(center-(8*spd)/100);
	LD   R30,Y
	LDD  R31,Y+1
	CALL __LSLW3
	MOVW R26,R30
	LDI  R30,LOW(100)
	LDI  R31,HIGH(100)
	CALL __DIVW21
	LDI  R26,LOW(21)
	LDI  R27,HIGH(21)
	SUB  R26,R30
	SBC  R27,R31
	MOVW R12,R26
;     390         Rpwm=(center-(8*spd)/100);
	LD   R30,Y
	LDD  R31,Y+1
	CALL __LSLW3
	MOVW R26,R30
	LDI  R30,LOW(100)
	LDI  R31,HIGH(100)
	CALL __DIVW21
	LDI  R26,LOW(21)
	LDI  R27,HIGH(21)
	SUB  R26,R30
	SBC  R27,R31
	STS  _Rpwm,R26
	STS  _Rpwm+1,R27
;     391         }
;     392 else{
	RJMP _0x1E
_0x1D:
;     393         mtr_en=0;
	CLR  R10
	CLR  R11
;     394     };
_0x1E:
_0x1C:
_0x1A:
_0x18:
;     395 }
	ADIW R28,3
	RET
;     396 
;     397 void motor_pwm_Rising(){
_motor_pwm_Rising:
	PUSH R15
;     398 if (mtr_en==1){                 //PWM for L&R Servos
	LDI  R30,LOW(1)
	LDI  R31,HIGH(1)
	CP   R30,R10
	CPC  R31,R11
	BREQ PC+3
	JMP _0x1F
;     399         Lservo ^= 0x01;         //Toggle the servo signal
	LDI  R30,0
	SBIC 0x1B,0
	LDI  R30,1
	LDI  R26,LOW(1)
	EOR  R30,R26
	BRNE _0x20
	CBI  0x1B,0
	RJMP _0x21
_0x20:
	SBI  0x1B,0
_0x21:
;     400         Rservo ^= 0x01;
	LDI  R30,0
	SBIC 0x1B,1
	LDI  R30,1
	LDI  R26,LOW(1)
	EOR  R30,R26
	BRNE _0x22
	CBI  0x1B,1
	RJMP _0x23
_0x22:
	SBI  0x1B,1
_0x23:
;     401 
;     402         if (Lpwm<Rpwm){
	LDS  R30,_Rpwm
	LDS  R31,_Rpwm+1
	CP   R12,R30
	CPC  R13,R31
	BRLT PC+3
	JMP _0x24
;     403                 T0Q1=Rpwm;      //Load the next OC into que
	STS  _T0Q1,R30
	STS  _T0Q1+1,R31
;     404                 T0Q0=Lpwm;}     //Load first OC
	__PUTWMRN _T0Q0,0,12,13
;     405                 else{
	RJMP _0x25
_0x24:
;     406                 T0Q1=Lpwm;
	__PUTWMRN _T0Q1,0,12,13
;     407                 T0Q0=Rpwm;}
	LDS  R30,_Rpwm
	LDS  R31,_Rpwm+1
	STS  _T0Q0,R30
	STS  _T0Q0+1,R31
_0x25:
;     408        OCR0=T0Q0;}              //OC triggers on first que
	LDS  R30,_T0Q0
	LDS  R31,_T0Q0+1
	OUT  0x31,R30
;     409 else{
	RJMP _0x26
_0x1F:
;     410         OCR0=0;
	LDI  R30,LOW(0)
	OUT  0x31,R30
;     411         Lservo = 0x00;
	CBI  0x1B,0
;     412         Rservo = 0x00;}         //Turn off servos
	CBI  0x1B,1
_0x26:
;     413 
;     414 }
	RET
;     415 
;     416 void motor_pwn_Falling(){
_motor_pwn_Falling:
	PUSH R15
;     417 if (T0Q0==T0Q1){        //Servos going the same speed/dir
	LDS  R30,_T0Q1
	LDS  R31,_T0Q1+1
	LDS  R26,_T0Q0
	LDS  R27,_T0Q0+1
	CP   R30,R26
	CPC  R31,R27
	BREQ PC+3
	JMP _0x2B
;     418         Lservo=0;
	CBI  0x1B,0
;     419         Rservo=0;}
	CBI  0x1B,1
;     420 else if (T0Q0==Rpwm){   //Rservo low before left
	RJMP _0x30
_0x2B:
	LDS  R30,_Rpwm
	LDS  R31,_Rpwm+1
	LDS  R26,_T0Q0
	LDS  R27,_T0Q0+1
	CP   R30,R26
	CPC  R31,R27
	BREQ PC+3
	JMP _0x31
;     421         Rservo=0;}
	CBI  0x1B,1
;     422 else if (T0Q0==Lpwm){   //Lservo low before right
	RJMP _0x34
_0x31:
	LDS  R26,_T0Q0
	LDS  R27,_T0Q0+1
	CP   R12,R26
	CPC  R13,R27
	BREQ PC+3
	JMP _0x35
;     423         Lservo=0;}
	CBI  0x1B,0
;     424 
;     425         OCR0=T0Q1;      //Load next on que
_0x35:
_0x34:
_0x30:
	LDS  R30,_T0Q1
	LDS  R31,_T0Q1+1
	OUT  0x31,R30
;     426         T0Q1=T0Q0;
	LDS  R30,_T0Q0
	LDS  R31,_T0Q0+1
	STS  _T0Q1,R30
	STS  _T0Q1+1,R31
;     427 }
	RET
;     428 
;     429 // Alphanumeric LCD Module functions
;     430 #asm
;     431    .equ __lcd_port=0x15 ;PORTC
   .equ __lcd_port=0x15 ;PORTC
;     432 #endasm
;     433 
;     434 
;     435 
;     436 void lcd_PrintFloat(float number)
;     437 {
_lcd_PrintFloat:
	PUSH R15
;     438  char decimal[1];
;     439  ftoa(number, *decimal, decimal);
	SBIW R28,1
;	number -> Y+1
;	decimal -> Y+0
	__GETD1S 1
	CALL __PUTPARD1
	LDD  R30,Y+4
	ST   -Y,R30
	MOVW R30,R28
	ADIW R30,5
	ST   -Y,R31
	ST   -Y,R30
	CALL _ftoa
;     440  lcd_puts(decimal);
	MOVW R30,R28
	ST   -Y,R31
	ST   -Y,R30
	CALL _lcd_puts
;     441 }
	ADIW R28,5
	RET
;     442 
;     443 void lcd_PrintInt(int number)
;     444 {
_lcd_PrintInt:
	PUSH R15
;     445 char character[1];
;     446         itoa(number, character);
	SBIW R28,1
;	number -> Y+1
;	character -> Y+0
	LDD  R30,Y+1
	LDD  R31,Y+1+1
	ST   -Y,R31
	ST   -Y,R30
	MOVW R30,R28
	ADIW R30,2
	ST   -Y,R31
	ST   -Y,R30
	CALL _itoa
;     447         lcd_puts(character);
	MOVW R30,R28
	ST   -Y,R31
	ST   -Y,R30
	CALL _lcd_puts
;     448 }
	ADIW R28,3
	RET
_delay_ms:
	ld   r30,y+
	ld   r31,y+
	adiw r30,0
	breq __delay_ms1
__delay_ms0:
	__DELAY_USW 0x3E8
	wdr
	sbiw r30,1
	brne __delay_ms0
__delay_ms1:
	ret

__ANEGW1:
	NEG  R31
	NEG  R30
	SBCI R31,0
	RET

__ANEGD1:
	COM  R31
	COM  R22
	COM  R23
	NEG  R30
	SBCI R31,-1
	SBCI R22,-1
	SBCI R23,-1
	RET

__LSLW4:
	LSL  R30
	ROL  R31
__LSLW3:
	LSL  R30
	ROL  R31
__LSLW2:
	LSL  R30
	ROL  R31
	LSL  R30
	ROL  R31
	RET

__CWD1:
	MOV  R22,R31
	ADD  R22,R22
	SBC  R22,R22
	MOV  R23,R22
	RET

__DIVW21U:
	CLR  R0
	CLR  R1
	LDI  R25,16
__DIVW21U1:
	LSL  R26
	ROL  R27
	ROL  R0
	ROL  R1
	SUB  R0,R30
	SBC  R1,R31
	BRCC __DIVW21U2
	ADD  R0,R30
	ADC  R1,R31
	RJMP __DIVW21U3
__DIVW21U2:
	SBR  R26,1
__DIVW21U3:
	DEC  R25
	BRNE __DIVW21U1
	MOVW R30,R26
	MOVW R26,R0
	RET

__DIVW21:
	RCALL __CHKSIGNW
	RCALL __DIVW21U
	BRTC __DIVW211
	RCALL __ANEGW1
__DIVW211:
	RET

__CHKSIGNW:
	CLT
	SBRS R31,7
	RJMP __CHKSW1
	RCALL __ANEGW1
	SET
__CHKSW1:
	SBRS R27,7
	RJMP __CHKSW2
	COM  R26
	COM  R27
	ADIW R26,1
	BLD  R0,0
	INC  R0
	BST  R0,0
__CHKSW2:
	RET

__PUTPARD1:
	ST   -Y,R23
	ST   -Y,R22
	ST   -Y,R31
	ST   -Y,R30
	RET

__ROUND_REPACK:
	TST  R21
	BRPL __REPACK
	CPI  R21,0x80
	BRNE __ROUND_REPACK0
	SBRS R30,0
	RJMP __REPACK
__ROUND_REPACK0:
	ADIW R30,1
	ADC  R22,R25
	ADC  R23,R25
	BRVS __REPACK1

__REPACK:
	LDI  R21,0x80
	EOR  R21,R23
	BRNE __REPACK0
	PUSH R21
	RJMP __ZERORES
__REPACK0:
	CPI  R21,0xFF
	BREQ __REPACK1
	LSL  R22
	LSL  R0
	ROR  R21
	ROR  R22
	MOV  R23,R21
	RET
__REPACK1:
	PUSH R21
	TST  R0
	BRMI __REPACK2
	RJMP __MAXRES
__REPACK2:
	RJMP __MINRES

__UNPACK:
	LDI  R21,0x80
	MOV  R1,R25
	AND  R1,R21
	LSL  R24
	ROL  R25
	EOR  R25,R21
	LSL  R21
	ROR  R24

__UNPACK1:
	LDI  R21,0x80
	MOV  R0,R23
	AND  R0,R21
	LSL  R22
	ROL  R23
	EOR  R23,R21
	LSL  R21
	ROR  R22
	RET

__CDF1U:
	SET
	RJMP __CDF1U0
__CDF1:
	CLT
__CDF1U0:
	SBIW R30,0
	SBCI R22,0
	SBCI R23,0
	BREQ __CDF10
	CLR  R0
	BRTS __CDF11
	TST  R23
	BRPL __CDF11
	COM  R0
	RCALL __ANEGD1
__CDF11:
	MOV  R1,R23
	LDI  R23,30
	TST  R1
__CDF12:
	BRMI __CDF13
	DEC  R23
	LSL  R30
	ROL  R31
	ROL  R22
	ROL  R1
	RJMP __CDF12
__CDF13:
	MOV  R30,R31
	MOV  R31,R22
	MOV  R22,R1
	PUSH R21
	RCALL __REPACK
	POP  R21
__CDF10:
	RET

__SWAPACC:
	PUSH R20
	MOVW R20,R30
	MOVW R30,R26
	MOVW R26,R20
	MOVW R20,R22
	MOVW R22,R24
	MOVW R24,R20
	MOV  R20,R0
	MOV  R0,R1
	MOV  R1,R20
	POP  R20
	RET

__UADD12:
	ADD  R30,R26
	ADC  R31,R27
	ADC  R22,R24
	RET

__NEGMAN1:
	COM  R30
	COM  R31
	COM  R22
	SUBI R30,-1
	SBCI R31,-1
	SBCI R22,-1
	RET

__ADDF12:
	PUSH R21
	RCALL __UNPACK
	CPI  R25,0x80
	BREQ __ADDF129

__ADDF120:
	CPI  R23,0x80
	BREQ __ADDF128
__ADDF121:
	MOV  R21,R23
	SUB  R21,R25
	BRVS __ADDF129
	BRPL __ADDF122
	RCALL __SWAPACC
	RJMP __ADDF121
__ADDF122:
	CPI  R21,24
	BRLO __ADDF123
	CLR  R26
	CLR  R27
	CLR  R24
__ADDF123:
	CPI  R21,8
	BRLO __ADDF124
	MOV  R26,R27
	MOV  R27,R24
	CLR  R24
	SUBI R21,8
	RJMP __ADDF123
__ADDF124:
	TST  R21
	BREQ __ADDF126
__ADDF125:
	LSR  R24
	ROR  R27
	ROR  R26
	DEC  R21
	BRNE __ADDF125
__ADDF126:
	MOV  R21,R0
	EOR  R21,R1
	BRMI __ADDF127
	RCALL __UADD12
	BRCC __ADDF129
	ROR  R22
	ROR  R31
	ROR  R30
	INC  R23
	BRVC __ADDF129
	RJMP __MAXRES
__ADDF128:
	RCALL __SWAPACC
__ADDF129:
	RCALL __REPACK
	POP  R21
	RET
__ADDF127:
	SUB  R30,R26
	SBC  R31,R27
	SBC  R22,R24
	BREQ __ZERORES
	BRCC __ADDF1210
	COM  R0
	RCALL __NEGMAN1
__ADDF1210:
	TST  R22
	BRMI __ADDF129
	LSL  R30
	ROL  R31
	ROL  R22
	DEC  R23
	BRVC __ADDF1210

__ZERORES:
	CLR  R30
	CLR  R31
	CLR  R22
	CLR  R23
	POP  R21
	RET

__MINRES:
	SER  R30
	SER  R31
	LDI  R22,0x7F
	SER  R23
	POP  R21
	RET

__MAXRES:
	SER  R30
	SER  R31
	LDI  R22,0x7F
	LDI  R23,0x7F
	POP  R21
	RET

__MULF12:
	PUSH R21
	RCALL __UNPACK
	CPI  R23,0x80
	BREQ __ZERORES
	CPI  R25,0x80
	BREQ __ZERORES
	EOR  R0,R1
	SEC
	ADC  R23,R25
	BRVC __MULF124
	BRLT __ZERORES
__MULF125:
	TST  R0
	BRMI __MINRES
	RJMP __MAXRES
__MULF124:
	PUSH R0
	PUSH R17
	PUSH R18
	PUSH R19
	PUSH R20
	CLR  R17
	CLR  R18
	CLR  R25
	MUL  R22,R24
	MOVW R20,R0
	MUL  R24,R31
	MOV  R19,R0
	ADD  R20,R1
	ADC  R21,R25
	MUL  R22,R27
	ADD  R19,R0
	ADC  R20,R1
	ADC  R21,R25
	MUL  R24,R30
	RCALL __MULF126
	MUL  R27,R31
	RCALL __MULF126
	MUL  R22,R26
	RCALL __MULF126
	MUL  R27,R30
	RCALL __MULF127
	MUL  R26,R31
	RCALL __MULF127
	MUL  R26,R30
	ADD  R17,R1
	ADC  R18,R25
	ADC  R19,R25
	ADC  R20,R25
	ADC  R21,R25
	MOV  R30,R19
	MOV  R31,R20
	MOV  R22,R21
	MOV  R21,R18
	POP  R20
	POP  R19
	POP  R18
	POP  R17
	POP  R0
	TST  R22
	BRMI __MULF122
	LSL  R21
	ROL  R30
	ROL  R31
	ROL  R22
	RJMP __MULF123
__MULF122:
	INC  R23
	BRVS __MULF125
__MULF123:
	RCALL __ROUND_REPACK
	POP  R21
	RET

__MULF127:
	ADD  R17,R0
	ADC  R18,R1
	ADC  R19,R25
	RJMP __MULF128
__MULF126:
	ADD  R18,R0
	ADC  R19,R1
__MULF128:
	ADC  R20,R25
	ADC  R21,R25
	RET

__DIVF21:
	PUSH R21
	RCALL __UNPACK
	CPI  R23,0x80
	BRNE __DIVF210
	TST  R1
__DIVF211:
	BRPL __DIVF219
	RJMP __MINRES
__DIVF219:
	RJMP __MAXRES
__DIVF210:
	CPI  R25,0x80
	BRNE __DIVF218
__DIVF217:
	RJMP __ZERORES
__DIVF218:
	EOR  R0,R1
	SEC
	SBC  R25,R23
	BRVC __DIVF216
	BRLT __DIVF217
	TST  R0
	RJMP __DIVF211
__DIVF216:
	MOV  R23,R25
	PUSH R17
	PUSH R18
	PUSH R19
	PUSH R20
	CLR  R1
	CLR  R17
	CLR  R18
	CLR  R19
	CLR  R20
	CLR  R21
	LDI  R25,32
__DIVF212:
	CP   R26,R30
	CPC  R27,R31
	CPC  R24,R22
	CPC  R20,R17
	BRLO __DIVF213
	SUB  R26,R30
	SBC  R27,R31
	SBC  R24,R22
	SBC  R20,R17
	SEC
	RJMP __DIVF214
__DIVF213:
	CLC
__DIVF214:
	ROL  R21
	ROL  R18
	ROL  R19
	ROL  R1
	ROL  R26
	ROL  R27
	ROL  R24
	ROL  R20
	DEC  R25
	BRNE __DIVF212
	MOVW R30,R18
	MOV  R22,R1
	POP  R20
	POP  R19
	POP  R18
	POP  R17
	TST  R22
	BRMI __DIVF215
	LSL  R21
	ROL  R30
	ROL  R31
	ROL  R22
	DEC  R23
	BRVS __DIVF217
__DIVF215:
	RCALL __ROUND_REPACK
	POP  R21
	RET

__CMPF12:
	TST  R25
	BRMI __CMPF120
	TST  R23
	BRMI __CMPF121
	CP   R25,R23
	BRLO __CMPF122
	BRNE __CMPF121
	CP   R26,R30
	CPC  R27,R31
	CPC  R24,R22
	BRLO __CMPF122
	BREQ __CMPF123
__CMPF121:
	CLZ
	CLC
	RET
__CMPF122:
	CLZ
	SEC
	RET
__CMPF123:
	SEZ
	CLC
	RET
__CMPF120:
	TST  R23
	BRPL __CMPF122
	CP   R25,R23
	BRLO __CMPF121
	BRNE __CMPF122
	CP   R30,R26
	CPC  R31,R27
	CPC  R22,R24
	BRLO __CMPF122
	BREQ __CMPF123
	RJMP __CMPF121

__CPD10:
	SBIW R30,0
	SBCI R22,0
	SBCI R23,0
	RET

;END OF CODE MARKER
__END_OF_CODE:
