#include <mega128.h>
#include <lcd.h> 
#include <delay.h>
#include <stdlib.h>
#include <stdio.h> 

#define RXC 7
#define EOL 0xFF        //end of line
#define SOL 0x0A        //start of line
#define CR 13           // carriage return
#define TTL 30 

#define x_min 12
#define x_max 175
#define y_min 1
#define y_max 143
#define x_center 82
#define y_center 71

 
char blob_info[8][5];
char blobs;

char blob_xsize;
char blob_ysize;
char blob_xcenter;
char blob_ycenter;

bit TimeOut;
char ttl_cntr;

bit camera_ready = 0;
int test;
char i;

void init_UART0()
{
// USART0 initialization
// Communication Parameters: 8 Data, 1 Stop, No Parity
// USART0 Receiver: On
// USART0 Transmitter: On
// USART0 Mode: Asynchronous
// USART0 Baud rate: 115200
UCSR0A=0x00;
UCSR0B=0x18;
UCSR0C=0x06;
UBRR0H=0x00;
UBRR0L=0x07;
}

unsigned char UART_Rx(void){
        TimeOut=1;
        ttl_cntr=0;
        //wait for data to be received or ttl to expire
        while(!(UCSR0A & (1<<RXC)) & TimeOut==1);
        //Return Rx data from buffer
        if (TimeOut==1)
        {
                return UDR0;  
        }
        else
        {
                return 0;     //Return zero because TTL expired
        }
}

void TimeOutWD()
{ 
if (TimeOut==1)
{
 if(ttl_cntr==TTL)
 {
  TimeOut=0;
 }
 else
 {
 ttl_cntr+=1;
 }
}
}


char get_ack(void)
{
 char i;
 char status;
 char ack[]="ACK\r"; 

        for(i=0;i<4;i++)
        {
         if(UART_Rx()==ack[i])  
         {
          status = 1;
         }
         else{
          lcd_clear();
          lcd_putsf("No ACK!");
          delay_ms(500);
          status = 0;
          break;
          }
         }
return status;
}

char ping_cam(void)
{
 printf("PG\r");
 if( get_ack() )
 {
  return 1;
  }
  else{
  return 0;
  }
} 


void track_colors(void)
{
 char i,j;
 char start;
 char data;
 PORTB.0^=1;
 i=0;
 j=0;
 
 while( start!= SOL )      //wait for start of packet
{
 start=UART_Rx();
}

blobs=UART_Rx();        //This is read as the start byte
blobs=UART_Rx();        //This is the actual number of blobs

while(data!=EOL)
{
 data=UART_Rx();
 if(data!=EOL)
 {
 blob_info[i][j]=data;
 j+=1;
        if(j==5)
        {
         j=0;
         i+=1;
        }
 }
}

data=0;
start=0; 
}



void disable_tracking(void)
{
        printf("DT\r");
        
        get_ack();      //verify that the command was received
} 

void enable_tracking(void)
{
        printf("ET\r");
        if(get_ack()) //verify that the command was received
        { 
         //track_colors();
         }   
 }
 
 void init_camera()
{



lcd_clear();
lcd_putsf("Waiting for Camera");
delay_ms(6000);
while(!ping_cam());
lcd_clear();
lcd_putsf("Camera Ready!");
enable_tracking(); 
camera_ready=1;
delay_ms(1000);
} 


void track_laser()
{

 blob_xsize=(blob_info[0][3]-blob_info[0][1])/2;
 blob_ysize=(blob_info[0][4]-blob_info[0][2])/2;
 blob_xcenter=blob_xsize+blob_info[0][1];
 blob_ycenter=blob_ysize+blob_info[0][2];
 
 if(blob_xcenter>x_center)
 {
  motor_ctrl('c');
 }
 else if(blob_xcenter<x_center)
 {
  motor_ctrl('C');
 } 
}
    

void track()
{
while (1)
      {
       lcd_clear();
       lcd_putsf("TI ");
       for(i=0;i<5;i++)
       {
        test=blob_info[0][i];
        lcd_PrintInt(test);
        lcd_putsf(" ");
        delay_ms(1);
        }
        
        
        lcd_gotoxy(0,1);
        lcd_PrintInt(blob_xcenter);
        lcd_putsf(" ");
        lcd_PrintInt(blob_ycenter);
       delay_ms(50);
       
       track_colors();
       if(button==0)
       {
       track_laser();
       }
       else if(button==1)
       {
        left_speed=0;
        right_speed=0;
       }
      
} 
        
}
      