#include <mega128.h>
#include <lcd.h> 
#include <delay.h>
#include <stdlib.h>
#include <stdio.h> 

#define EOL 0xFF        //end of line
#define SOL 0x0A        //start of line
#define CR 13           // carriage return
#define TTL 30 

#define x_min 12
#define x_max 175
#define y_min 1
#define y_max 143
#define x_center 82
#define y_center 71
#define offset 20 

#define RXB8 1
#define TXB8 0
#define UPE 2
#define OVR 3
#define FE 4
#define UDRE 5
#define RXC 7

#define FRAMING_ERROR (1<<FE)
#define PARITY_ERROR (1<<UPE)
#define DATA_OVERRUN (1<<OVR)
#define DATA_REGISTER_EMPTY (1<<UDRE)
#define RX_COMPLETE (1<<RXC)

// USART0 Receiver buffer
#define RX_BUFFER_SIZE0 8
char rx_buffer0[RX_BUFFER_SIZE0];

#if RX_BUFFER_SIZE0<256
unsigned char rx_wr_index0,rx_rd_index0,rx_counter0;
#else
unsigned int rx_wr_index0,rx_rd_index0,rx_counter0;
#endif

// This flag is set on USART0 Receiver buffer overflow
bit rx_buffer_overflow0;
 
char blob_info[8][5];
char blobs;
char num_blobs;

char blob_xsize;
char blob_ysize;
char blob_xcenter;
char blob_ycenter;
bit cam_mtr_ctrl=0;

bit TimeOut;
char ttl_cntr;

bit camera_ready = 0;
bit new_trackdata;
bit ACK;
int test;
unsigned char object[8][4];     // blob[color][size]

char i;

void get_ack();

void init_UART0()
{
// USART0 initialization
// Communication Parameters: 8 Data, 1 Stop, No Parity
// USART0 Receiver: On
// USART0 Transmitter: On
// USART0 Mode: Asynchronous
// USART0 Baud rate: 115200
UCSR0A=0x00;
UCSR0B=0x98;
UCSR0C=0x06;
UBRR0H=0x00;
UBRR0L=0x07;
}

unsigned char UART_Rx(void){
        TimeOut=1;
        ttl_cntr=0;
        //wait for data to be received or ttl to expire
        while(!(UCSR0A & (1<<RXC)));// & TimeOut==1);
        //Return Rx data from buffer
     //   if (TimeOut==1)
     //   {
                return UDR0;  
     //   }
     //   else
     //   {
     //           return 0;     //Return zero because TTL expired
     //   }
}

void TimeOutWD()
{ 
if (TimeOut==1)
{
 if(ttl_cntr==TTL)
 {
  TimeOut=0;
 }
 else
 {
 ttl_cntr+=1;
 }
}
}


void get_ack()
{
 char i;
 char ack[]="ACK\r"; 

        for(i=0;i<4;i++)
        { 
         
         if(UART_Rx()==ack[i])  
         {
          ACK=1;
         }
         else{
          lcd_clear();
          lcd_putsf("No ACK!");
          delay_ms(500);
          ACK=0;
          break;
          }
         }

}

char ping_cam(void)
{

  //turn off UART interrupt
  UCSR0B=0x18;
 printf("DT\r");       //disable tracking
 get_ack();
 delay_ms(500);
 ACK=0;
 //printf("PG\r");       //ping

 do
 {
  delay_ms(10);
  printf("PG\r");       //ping
  get_ack();
 }
  while(ACK==0);
  //turn on UART interrupt  
UCSR0B=0x98; 
 if( ACK==1 )
 {
  return 1;
  ACK=0;
  }
  else{
  return 0;
  }
}
 
/********************************************
This function will return relative position
of the color of the object in the function call.
********************************************/
char track_object(char slot)
{
if(slot<8)
{
 if(object[slot][2]>(x_center+offset))
 {
  return 'r';
 }
 else if(object[slot][2]<(x_center-offset))
 {
  return 'l';
 }
 else if(object[slot][2]<=(x_center+offset) & object[slot][2]>=(x_center-offset))
 {
  return 'S';
 } 
}
else
{
 return 0;
}
}

/********************************************
This function receives the tracking packet
from the camera and stores it in blob_info.
It is called from the UART_ISR.
********************************************/
void tracking_packet(void)
{
 int xlength,ylength;
 char i,j;
 char start;
 char data;
 i=0;
 j=0;
 blobs=UART_Rx();        //This is the number of blobs
 num_blobs=blobs;
while(data!=EOL)       //Read the tracking packet
{
 data=UART_Rx();
 if(data!=EOL)
 {
 blob_info[i][j]=data;
 j+=1;
        if(j==5)
        {
         j=0;
         i+=1;
        }
 }
}

for(i=0;i<blobs;i+=1)
 {
         xlength=(blob_info[i][3]-blob_info[i][1])/2;    
         ylength=(blob_info[i][4]-blob_info[i][2])/2;
         object[i][0]=blob_info[i][0];                     //color
         object[i][1]=xlength*ylength;                     //area
         object[i][2]=xlength+blob_info[i][1];             //x position of blob
         
 }
 
new_trackdata=1;         //signal that data is new
data=0;
start=0;
UCSR0B=0x98; 
}



void disable_tracking(void)
{
        printf("DT\r");   
} 

void enable_tracking(void)
{ 
#asm ("cli")
        printf("ET\r");
#asm ("sei")    
 }
 
 void toggle_AWB()
 {
 /*
 reg:0x12 AWB                   on=>0x2C/44     off=>0x28/40 
 reg:0x2D Light Filter          on=>0x07        off=>0x03 
 reg:0x13 Enable AutoAdjust     on=>0x01        off=>0x00
 */
  printf("CR 18 40 45 3 19 0\r");
  get_ack();
  printf("CR 18 44 45 7 19 1\r"); 
  get_ack();
 }
 
 void init_camera()
{
lcd_clear();
lcd_putsf("Waiting for Camera");
delay_ms(1000);
ping_cam();        
lcd_clear();
lcd_putsf("Camera Ready!"); 
toggle_AWB();
enable_tracking();
camera_ready=1;
delay_ms(1000);
} 

void track()
{ 

while (1)
      {
       lcd_clear();
       lcd_putsf("TI ");
       for(i=0;i<5;i++)
       {
        test=blob_info[0][i];
        lcd_PrintInt(test);
        lcd_putsf(" ");
        delay_ms(1);
        }
        
        
        lcd_gotoxy(0,1);
        lcd_PrintInt(blob_xcenter);
        lcd_putsf(" ");
        lcd_PrintInt(blob_ycenter);
        delay_ms(50);
       
       if(button==1)
       {
        cam_mtr_ctrl=1;
        button=0;
       }
       else if(button==2)
       {
        cam_mtr_ctrl=0;
        left_speed=0;
        right_speed=0;
        button=0;
       }
      
} 
        
}

// USART0 Receiver interrupt service routine
interrupt [USART0_RXC] void usart0_rx_isr(void)
{
char status,data;
status=UCSR0A;
data=UDR0;

if(data==SOL)
{
PORTB.0^=1;
 //turn off UART interrupt
  UCSR0B=0x18;
  tracking_packet();  
}


}
      