#include <mega128.h>

#define LeftSwitch PINE.7
#define RightSwitch PINE.4

#define ir_N    5
#define ir_VF   10
#define ir_F    15
#define ir_Near    25
#define ir_VN   35

 int left_front;
 int right_front;
 int center_front;
 bit got_object;

char find_object_color();
char wait_for_trackdata();
void adjust_leds();
char color;
 
/********************************************
This function takes all the ir sensor data
and returns a value indicating the proximity
of an object in front of it.
********************************************/
int analyse_ir()
{
 char L_distance;
 char R_distance;
 char LF_distance;
 char RF_distance;
 char C_distance;
 unsigned int left;
 unsigned int right;
 unsigned int l_front;
 unsigned int r_front;
 unsigned int c_front;

/*
S=straight
l=slight left
L=left
C=Counter Clockwise rotation
r=slight right
R=right
c=clockwise rotation
B=backwards
*/
int table[6][6] = {{'S','S','l','L','L','C'}, //L_distance=0
                   {'S','S','l','L','C','C'},
                   {'r','r','S','C','C','C'},
                   {'r','R','c','S','C','C'},
                   {'r','R','c','c','B','B'},
                   {'c','c','c','c','B','B'}};//L_distance=5
 
 left=IR_Result[0][18];
 right=IR_Result[1][18];
 l_front=IR_Result[3][18];
 r_front=IR_Result[2][18];
 c_front=IR_Result[4][18];
           
 if(left>=16)
 {
  L_distance=5;
 }
 else if(left>=13 & left<16)
 {
  L_distance=4;
 }
 else if(left>=11 & left<13)
 {
  L_distance=3;
 }
 else if(left>=8 & left<11)
 {
  L_distance=2;
 }
 else if(left>=4 & left<8)
 {
  L_distance=1;
 }
 else if(left<4)
 {
  L_distance=0;
 }
 

  if(right>=16)
 {
  R_distance=5;
 }
 else if(right>=13 & right<16)
 {
  R_distance=4;
 }
 else if(right>=11 & right<13)
 {
  R_distance=3;
 }
 else if(right>=8 & right<11)
 {
  R_distance=2;
 }
 else if(right>=4 & right<8)
 {
  R_distance=1;
 }
 else if(right<4)
 {
  R_distance=0;
 }
 
 if(r_front>=16)
 {
  RF_distance=5;
 }
 else if(r_front>=13 & r_front<16)
 {
  RF_distance=4;
 }
 else if(r_front>=11 & r_front<13)
 {
  RF_distance=3;
 }
 else if(r_front>=8 & r_front<11)
 {
  RF_distance=2;
 }
 else if(r_front>=4 & r_front<8)
 {
  RF_distance=1;
 }
 else if(r_front<4)
 {
  RF_distance=0;
 }
 
 if(l_front>=18)
 {
  LF_distance=5;
 }
 else if(l_front>=14 & l_front<18)
 {
  LF_distance=4;
 }
 else if(l_front>=11 & l_front<14)
 {
  LF_distance=3;
 }
 else if(l_front>=8 & l_front<11)
 {
  LF_distance=2;
 }
 else if(l_front>=4 & l_front<8)
 {
  LF_distance=1;
 }
 else if(l_front<4)
 {
  LF_distance=0;
 }
 
 if(c_front>=IRMAX)
 {
  C_distance=6;
 }
 else if(c_front>=18 & c_front<IRMAX)
 {
  C_distance=5;
 }
 else if(c_front>=14 & c_front<18)
 {
  C_distance=4;
 }
 else if(c_front>=11 & c_front<14)
 {
  C_distance=3;
 }
 else if(c_front>=8 & c_front<11)
 {
  C_distance=2;
 }
 else if(c_front>=2 & c_front<8)
 {
  C_distance=1;
 }
 else if(c_front<2)
 {
  C_distance=0;
 }
 
 left_front=LF_distance;
 right_front=RF_distance;
 center_front=C_distance;
 
 if(LF_distance>L_distance)
 {
  L_distance=LF_distance;
 }
 
 if(RF_distance>R_distance)
 {
  R_distance=RF_distance;
 }
 
 return table[L_distance,R_distance];
} 


/********************************************
This function analyses the sonar readings and
figures out how the motors should react.
********************************************/
int analyse_sonar()
{
 char L_distance;
 char R_distance;
 char left;
 char right;
/*
S=straight
l=slight left
L=left
C=Counter Clockwise rotation
r=slight right
R=right
c=clockwise rotation
B=backwards
*/
int table[5][5] = {{'S','S','l','L','C'}, //L_distance=0
                   {'S','S','l','L','C'},
                   {'r','l','L','C','C'},
                   {'r','R','c','c','c'},
                   {'R','R','c','c','B'}};//L_distance=4
 
 left=SonarInches[0];
 right=SonarInches[1];
           
 if(left<=7)
 {
  L_distance=4;
 }
 else if(left>=8 & left<=9)
 {
  L_distance=3;
 }
 else if(left>=10 & left<=11)
 {
  L_distance=2;
 }
 else if(left>=12 & left<=13)
 {
  L_distance=1;
 }
 else if(left>13)
 {
  L_distance=0;
 }
 

 if(right<=7)
 {
  R_distance=4;
 }
 else if(right>=8 & right<=9)
 {
  R_distance=3;
 }
 else if(right>=10 & right<=11)
 {
  R_distance=2;
 }
 else if(right>=12 & right<=13)
 {
  R_distance=1;
 }
 else if(right>13)
 {
  R_distance=0;
 } 
 
 return table[L_distance,R_distance];
}


void arbitrator(char sonar_dir, char ir_dir)
{
PORTB.0^=1;
 if(LeftSwitch==0 & RightSwitch==1)
 {
  motor_ctrl('B');
 }
 else if(RightSwitch==0 & LeftSwitch==1)
 {
  motor_ctrl('B');
 }
 else if(LeftSwitch==0 & RightSwitch==0)
 {
  motor_ctrl('B');
 }
 else if(sonar_dir==ir_dir)
 {
  motor_ctrl(sonar_dir);
 }
 else if(sonar_dir=='S' & ir_dir!='S')
 {
  motor_ctrl(ir_dir);
 }
 else if(sonar_dir!='S' & ir_dir=='S')
 {
  motor_ctrl(sonar_dir);
 }
 else if((sonar_dir=='l'|sonar_dir=='r') & (ir_dir=='R'|ir_dir=='L'|ir_dir=='C'|ir_dir=='c'|ir_dir=='B')) 
 {
  motor_ctrl(ir_dir);
 } 
 else if((ir_dir=='l'|ir_dir=='r') & (sonar_dir=='R'|sonar_dir=='L'|sonar_dir=='C'|sonar_dir=='c'|sonar_dir=='B')) 
 {
  motor_ctrl(sonar_dir);
 }
 else
 {
  motor_ctrl(sonar_dir);
  }
} 
  
void gripper()
{
  motor_ctrl('P');
  delay_ms(500);
  new_reading=0;
        while(object_ready==0)
        {  
        grip_ctrl('C');
        }
  object_ready=0;
  delay_ms(500);
  tilt_ctrl('U');
  got_object=1;
 
}

char approach_object()
{
 char dir;
 analyse_ir(); 
 
 if(center_front==0)
 {
  dir=0;
 }
 else if(center_front==6 & got_object==0)
 {
  dir='G';
 }
 else if((center_front>0 & center_front<6 & right_front==left_front)|(center_front==4)|(center_front==5))
 {
  dir=2;
 }
 else if(center_front>0 & center_front<4 & right_front>left_front)
 {
  dir='>';
 }
 else if(center_front>0 & center_front<4 & right_front<left_front)
 {
   dir='<';
 }
 else
 {
  dir=0;
 }
 
return dir; 
}

char GetObject()
{
 char cam_dir;
 char ir_dir;

 ir_dir=approach_object();
 
        if(wait_for_trackdata()==1 & color<8)
        {
        new_trackdata=0;
        cam_dir=track_object(find_object_color());
        }
        else
        {
        cam_dir=0;
        adjust_leds();
        }
 
 if(ir_dir=='G')
 { 
 gripper();
 }
 else if(cam_dir==0 & ir_dir==0)
 {
 motor_ctrl('P');
 }
 else if(cam_dir!=0 & (ir_dir==0|center_front<2) )
 {
  motor_ctrl(cam_dir);
 }
 else if(ir_dir!='G' & ir_dir!=0 & center_front>1)
 {
  motor_ctrl(ir_dir);
 }
 else
 {
  motor_ctrl('P');
 }

LCD_Display(50); 
return ir_dir; 
}
