#include <mega128.h>

#define laser_size      5

char object_cd[8];
unsigned char laser_center;
char dest;


void LookForLaser();
void LookForHome(char known);
void FindLaserOnObject();
void TakeHome();
void FindObject();
void DropObject();
char find_laser();
char track_laser();
void look_around();


void adjust_leds()
{
led_dc+=5;
 if(led_dc>125)
 {
 led_dc=0;
 }
 
}


/********************************************
This is the main behavior routine.
********************************************/
void LookForLaser()
{
led_dc=0;
color=0;
dest=0;
FindLaserOnObject();
FindObject();
} 

/************************************************
This looks for a laser. If the laser was near
a color, it calls GetObject then LookForHome.
************************************************/
void FindLaserOnObject()
{
char Loaded;
char i;
Loaded=0;
color=0;
dest=0;
laser_center=0;
                     
if(track_laser()==1)
{
led_dc=75;
new_trackdata=0;
}

LCD_Display(100);

if(wait_for_trackdata()==1 & laser_center!=0)
{
 new_trackdata=0; 
        for(i=0;i<blobs;i+=1)           //cycle through all tracked colors looking for known color
        { 
                if(object[i][0]<8 & object[i][0]>0 & (object[i][2]-laser_center)<15)     //test for proximity to laser center
                {
                color=object[i][0];
                        while(Loaded!='G')              //Approach and then pickup with gripper
                        { 
                        Loaded=GetObject();
                        if(Loaded=='G')
                                break;
                        }
                        motor_ctrl('c'); 
                        LCD_Display(1750);    
                        LookForHome(0);          //Look for Destination and then transfer it
                        new_trackdata=0;
                        break;                                //Start process over again
                }              
      
      }
 }
}

/*********************************************
This function tracks the laser until it no
longer is seen. If a laser was seen it returns
a one.
*********************************************/
char track_laser()
{
char laser;
bit found_once;
led_dc=0;
found_once=0;
 while(1)            //approach while the laser is trackable,get location
 {
        LCD_Display(100);
        laser=find_laser();
        if(laser==8)      //break if no laser is found
        {
        break;
        }
        found_once=1;        
        motor_ctrl(track_object(laser));
        laser_center=object[laser][2];         //x position of laser
 }
 return found_once;  
}

char wait_for_trackdata()
{
bit new_data;
new_data=1;
LB=0;
while(new_trackdata==0)             //wait for new packets
{ 
 if(LB>2)                        //LB is inc in T2OVF
 {
  new_data=0;                                  //if too many, break out of loop    
  break;
 }
 
} 
return new_data;                 //return one if new data available, zero if no new packets rx before timeout(LB)
}

char find_laser()
{
char k,laser;
 
if(wait_for_trackdata()==1)
{
for(k=0;k<blobs;k+=1)
        {
        if(object[k][0]==0)             //Find slot
                {
                laser=k;
                break;                  //break out and go home
                }
        if(k==blobs-1)
                {
                laser=8;
                motor_ctrl('P');        //turn off motors
                }
        }
  new_trackdata=0;
  LB=0;
}
else                            //No new tracking packets have come in
{
 motor_ctrl('P');
 laser=8;
}  
 return laser;
}

char find_dest_color()
{
 char k,slot;
 k=0;
  for(k=0;k<blobs;k+=1)         //look for a colors slot position in tracking packet
        {
        if(object[k][0]==dest)              //Find destination slot
                {
                slot=k;
                break;                                        //break out and go home
                }
        if(k==blobs-1)
                {
                slot=8;
                adjust_leds();
                motor_ctrl('C');        //turn off motors,could be stuck in loop until dest is found
                }
        }
 return slot;
} 

char find_object_color()
{
 char k,slot;
 k=0;
 for(k=0;k<blobs;k+=1)
 {
        if(object[k][0]==color)              //Find destination slot
                {
                slot=k;
                break;                                        //break out and go home
                }
        if(k==blobs-1)
                {
                slot=8;
                adjust_leds();
                //motor_ctrl('P');        //turn off motors,could be stuck in loop until object is found
                }
 }
 
 return slot;
} 
 
void LookForHome(char known)
{
char k;
laser_center=0;
k=0;
 if(known==0)
 { 
 while(got_object==1)
 {
        if(track_laser()==1)
        {
        led_dc=75;
        new_trackdata=0;
        }
        else
        {
         //motor_ctrl('>');
         left_speed=2;
         right_speed=-2;
        }
        LCD_Display(50);
     
        if(wait_for_trackdata()==1 & laser_center!=8)         //look for laser
        {
        new_trackdata=0;
                for(k=0;k<blobs;k+=1)
                { 
                if(object[k][0]<8 & object[k][0]>0 & object[k][0]!=color & (object[k][2]-laser_center)<15)      //test for proximity
                {
                object_cd[color]=object[k][0];      //store objects color and destination
                dest=object_cd[color];             //assign destination
                TakeHome();                        //Look for destination to take it
                break;
                }       
                }
        }
        else
        {
        // left_speed=3;
        // right_speed=-3;
        motor_ctrl('P');
        }
 }
 }
//the object is recognized and its destination known.
else
{   
   TakeHome();
} 
color=0;
dest=0; 
} 

void TakeHome()
{ 
char camera_dir;
while(1)
{
        if(wait_for_trackdata()==1)
        {
        camera_dir=track_object(find_dest_color());
        new_trackdata=0;
        }
        else
        {
         camera_dir='>';
        }
        
 analyse_ir();
 
        if(((right_front==left_front & right_front>2)|SonarInches[0]<6|SonarInches[1]<6)&camera_dir=='S')
        {
        DropObject();
        break;
        }
        else if(camera_dir!=0)
        {
         motor_ctrl(camera_dir);
        }
        else if(camera_dir==0)
        {
         motor_ctrl('>');
        }
 LCD_Display(100);
}
}

void DropObject()
{
 motor_ctrl('P');
 delay_ms(250);
 tilt_ctrl('C');
 delay_ms(500);
 grip_ctrl('O');        //open clamp
 motor_ctrl('B');
 delay_ms(500);
 motor_ctrl('C');
 delay_ms(1400);
 got_object=0;
}

void FindObject()
{
char Loaded;
Loaded=0;

if(wait_for_trackdata()==1)
{
 new_trackdata=0;
 for (i=0;i<blobs;i+=1) 
   {
     if(object[i][0]<8 & object[i][0]>0 & object_cd[object[i][0]]!=0)  //Determine if familiar
     {          
        color=object[i][0];         //object color
        dest=object_cd[color];
        break;       
     }
     else if(i==blobs-1)
     {
     adjust_leds(); 
     //color=0;   //non-existant color choice
     break; 
     }
    }
    
if(color!=0)
{
while(Loaded!='G')
{       
 Loaded=GetObject();
}
 motor_ctrl('c'); 
 LCD_Display(1750);
 LookForHome(1);
}
}

}

