#include <mega128.h>
#define ADC_VREF_TYPE 0x00


#define IR_Toggle PORTA.0
#define IR_Reset PORTA.1
#define IR_SelA PORTA.2
#define IR_SelB PORTA.3
#define IR_SelC PORTA.4


#define IR_Cycle_Speed 50
#define NumSamples 20
#define Number_of_Sensors 5


// Global variables  
int IR_Intensity=0;
int scnt;
//int cntr;
double IR_Result[Number_of_Sensors][19];
int temp;
double samples;
char ir_sensor;
char IRMAX=25;




void Change_IR_Sensor()
{
 if((ir_sensor+1)==Number_of_Sensors)
 {
  IR_SelA=0;
  IR_SelB=0;
  IR_SelC=0;
  ir_sensor=0;
 }
 else if(ir_sensor==0)
 {
  IR_SelA=1;
  IR_SelB=0;
  IR_SelC=0;
  ir_sensor=1;
  }
  else if(ir_sensor==1)
  {
  IR_SelA=0;
  IR_SelB=1;
  IR_SelC=0;
  ir_sensor=2;
  }
  else if(ir_sensor==2)
  {
   IR_SelA=1;
   IR_SelB=1;
   IR_SelC=0;
   ir_sensor=3;
  }
  else if(ir_sensor==3)
  {
   IR_SelA=0;
   IR_SelB=0;
   IR_SelC=1;
   ir_sensor=4;
  }
  else if(ir_sensor==4)
  {
   IR_SelA=1;
   IR_SelB=0;
   IR_SelC=1;
   ir_sensor=5;
  }
  else if(ir_sensor==5)
  {
   
   IR_SelA=0;
   IR_SelB=1;
   IR_SelC=1;
   ir_sensor=6;
  }
  else if(ir_sensor==6)
  {
   
   IR_SelA=0;
   IR_SelB=0;
   IR_SelC=0;
   ir_sensor=0;
  }
  
}


/***********************************************************
	Function Name: Decrease_IR_Level
	Function Description: This function toggles the 
	IR level down one notch at a time, then resets the
	IR level to zero(Full power).
	NOTES: 
        Inputs: none
        Outputs: IR_Toggle, IR_Reset, IR_Intensity
***********************************************************/  
void Decrease_IR_Level(){
        char i;
        IR_Toggle = 1;             //Keep clock line high until  a number of counts has passed
                  
        if (IR_Intensity==15){     //There are 16 levels. 1=High...15=off
                IR_Reset=0;        //Trigger the sync. memory reset    
                IR_Toggle=0;
                IR_Intensity=0;
                IR_Result[ir_sensor][16]=0;
                IR_Result[ir_sensor][17]=0;
                IR_Result[ir_sensor][18]=0;
                for(i=0;i<16;i++)
                {
                 IR_Result[ir_sensor][16]+=IR_Result[ir_sensor][i];
                }
                for(i=2;i<16;i++)
                { 
                        temp=IR_Result[ir_sensor][i];
                        if(temp>0 & i<7)
                        {
                         IR_Result[ir_sensor][18]+=temp/4;
                        }
                        else if(temp>0 & i>=7 & i<8)
                        {
                        IR_Result[ir_sensor][18]+=temp/3;
                        }
                        else if(temp>0 & i>=8 & i<10)
                        {
                        IR_Result[ir_sensor][18]+=temp;
                        }
                        else if(temp>0 & i>=10)
                        {                             
                        IR_Result[ir_sensor][18]+=temp*2;
                        }
                
                }
                
                
                Change_IR_Sensor();
                delay_us(10);
        }                    
        else{ 
                IR_Reset = 1;       //Active low reset
                IR_Toggle = 0;      //Pull counter clock line low,(Low-to-high edge trigger)
                IR_Intensity++;
                delay_us(1);
                }
        
      IR_Toggle=1;
}            
    
    
/***********************************************************
	Function Name: Avg_IR_Samples
	Function Description: This function collects a thousand samples
	from the IR sensors and averages them. This will produce a number
	between 207 to 500. This function is run in the ADISR.
	NOTES: 
        Inputs: adc_data
        Outputs: IR_Result
***********************************************************/
void Avg_IR_Samples()
{
        samples=samples+adc_data[0];
        scnt+=1;
        if (scnt==NumSamples)
        {
                IR_Result[ir_sensor][IR_Intensity]=samples/NumSamples/50-4; 
                samples=0;
                scnt=0;
                Decrease_IR_Level();             
        }                                          
} 


/*
void Change_IR_Level(int level){
                int i;
                IR_Reset = 0;       //Active low reset
                IR_Toggle = 0;      //Pull counter clock line low,(Low-to-high edge trigger)
                IR_Intensity=0;
                delay_us(1);
                IR_Toggle = 1;
                delay_us(1); 
                IR_Reset = 1;       //Active low reset               
        for(i=1;i<=level;i++) {
                        delay_us(1);
                        IR_Toggle = 0;      //Pull counter clock line low,(Low-to-high edge trigger)
                        IR_Intensity++;
                        delay_us(1);
                        IR_Toggle = 1;
                        }          
      IR_Toggle=1;
}*/




   
