#include <mega128.h>
#include <io.h>

#define R1 PORTB.2 
#define R2 PORTB.3
#define R3 PORTD.6
#define R4 PORTD.7

#define C1 PIND.0
#define C2 PIND.1
#define C3 PINE.5
#define C4 PINE.6

char row; 
char col;
char button;




void init_keypad()
{
R1=0;
R2=0;
R3=0;
R4=0;
// External Interrupt(s) initialization
// INT0: On
// INT0 Mode: Low level
// INT1: On
// INT1 Mode: Low level
// INT2: Off
// INT3: Off
// INT4: Off
// INT5: On
// INT5 Mode: Low level
// INT6: On
// INT6 Mode: Low level
// INT7: Off
EICRA=0x00;
EICRB=0x00;
EIMSK=0x63;
EIFR=0x63;
} 

// External Interrupt 0 service routine
interrupt [EXT_INT0] void ext_int0_isr(void)
{ 
PORTB.0^=1;

R1=1;
col=~C1;
R1=0;
if(col==0)
{
button=1;
}
else{
        R2=1;
        col=~C1;
        R2=0;
        if(col==0)
        {
        button=4;
        }
        else{
                R3=1;
                col=~C1;
                R3=0;
                if(col==0)
                {
                button=7;
                }
                else{
                        R4=1;
                        col=~C1;
                        R4=0;
                        if(col==0)
                        {
                        button=14;
                        }
                }
        }
}             


delay_ms(100);
}


// External Interrupt 1 service routine
interrupt [EXT_INT1] void ext_int1_isr(void)
{
PORTB.0^=1;
R1=1;
col=~C2;
R1=0;
if(col==0)
{
button=2;
}
else{
        R2=1;
        col=~C2;
        R2=0;
        if(col==0)
        {
        button=5;
        }
        else{
                R3=1;
                col=~C2;
                R3=0;
                if(col==0)
                {
                button=8;
                }
                else{
                        R4=1;
                        col=~C2;
                        R4=0;
                        if(col==0)
                        {
                        button=0;
                        }
                }
        }
}
delay_ms(100);
}

// External Interrupt 5 service routine
interrupt [EXT_INT5] void ext_int5_isr(void)
{
PORTB.0^=1;
R1=1;
col=~C3;
R1=0;
if(col==0)
{
button=3;
}
else{
        R2=1;
        col=~C3;
        R2=0;
        if(col==0)
        {
        button=6;
        }
        else{
                R3=1;
                col=~C3;
                R3=0;
                if(col==0)
                {
                button=9;
                }
                else{
                        R4=1;
                        col=~C3;
                        R4=0;
                        if(col==0)
                        {
                        button=15;
                        }
                }
        }
}
delay_ms(100);
}

// External Interrupt 6 service routine
interrupt [EXT_INT6] void ext_int6_isr(void)
{ 
PORTB.0^=1;
R1=1;
col=~C4;
R1=0;
if(col==0)
{
button=10;
}
else{
        R2=1;
        col=~C4;
        R2=0;
        if(col==0)
        {
        button=11;
        }
        else{
                R3=1;
                col=~C4;
                R3=0;
                if(col==0)
                {
                button=12;
                }
                else{
                        R4=1;
                        col=~C4;
                        R4=0;
                        if(col==0)
                        {
                        button=13;
                        }
                }
        }
}
delay_ms(100);
}
