;CodeVisionAVR C Compiler V1.24.6 Standard
;(C) Copyright 1998-2005 Pavel Haiduc, HP InfoTech s.r.l.
;http://www.hpinfotech.com
;e-mail:office@hpinfotech.com

;Chip type              : ATmega128
;Program type           : Application
;Clock frequency        : 14.745600 MHz
;Memory model           : Small
;Optimize for           : Size
;(s)printf features     : int, width
;(s)scanf features      : int, width
;External SRAM size     : 0
;Data Stack size        : 1024 byte(s)
;Heap size              : 0 byte(s)
;Promote char to int    : No
;char is unsigned       : Yes
;8 bit enums            : Yes
;Word align FLASH struct: No
;Enhanced core instructions    : On
;Automatic register allocation : On

	.EQU UDRE=0x5
	.EQU RXC=0x7
	.EQU USR=0xB
	.EQU UDR=0xC
	.EQU SPSR=0xE
	.EQU SPDR=0xF
	.EQU EERE=0x0
	.EQU EEWE=0x1
	.EQU EEMWE=0x2
	.EQU EECR=0x1C
	.EQU EEDR=0x1D
	.EQU EEARL=0x1E
	.EQU EEARH=0x1F
	.EQU WDTCR=0x21
	.EQU MCUCR=0x35
	.EQU RAMPZ=0x3B
	.EQU SPL=0x3D
	.EQU SPH=0x3E
	.EQU SREG=0x3F
	.EQU XMCRA=0x6D
	.EQU XMCRB=0x6C

	.DEF R0X0=R0
	.DEF R0X1=R1
	.DEF R0X2=R2
	.DEF R0X3=R3
	.DEF R0X4=R4
	.DEF R0X5=R5
	.DEF R0X6=R6
	.DEF R0X7=R7
	.DEF R0X8=R8
	.DEF R0X9=R9
	.DEF R0XA=R10
	.DEF R0XB=R11
	.DEF R0XC=R12
	.DEF R0XD=R13
	.DEF R0XE=R14
	.DEF R0XF=R15
	.DEF R0X10=R16
	.DEF R0X11=R17
	.DEF R0X12=R18
	.DEF R0X13=R19
	.DEF R0X14=R20
	.DEF R0X15=R21
	.DEF R0X16=R22
	.DEF R0X17=R23
	.DEF R0X18=R24
	.DEF R0X19=R25
	.DEF R0X1A=R26
	.DEF R0X1B=R27
	.DEF R0X1C=R28
	.DEF R0X1D=R29
	.DEF R0X1E=R30
	.DEF R0X1F=R31

	.EQU __se_bit=0x20
	.EQU __sm_mask=0x1C
	.EQU __sm_adc_noise_red=0x08
	.EQU __sm_powerdown=0x10
	.EQU __sm_powersave=0x18
	.EQU __sm_standby=0x14
	.EQU __sm_ext_standby=0x1C

	.MACRO __CPD1N
	CPI  R30,LOW(@0)
	LDI  R26,HIGH(@0)
	CPC  R31,R26
	LDI  R26,BYTE3(@0)
	CPC  R22,R26
	LDI  R26,BYTE4(@0)
	CPC  R23,R26
	.ENDM

	.MACRO __CPD2N
	CPI  R26,LOW(@0)
	LDI  R30,HIGH(@0)
	CPC  R27,R30
	LDI  R30,BYTE3(@0)
	CPC  R24,R30
	LDI  R30,BYTE4(@0)
	CPC  R25,R30
	.ENDM

	.MACRO __CPWRR
	CP   R@0,R@2
	CPC  R@1,R@3
	.ENDM

	.MACRO __CPWRN
	CPI  R@0,LOW(@2)
	LDI  R30,HIGH(@2)
	CPC  R@1,R30
	.ENDM

	.MACRO __ADDD1N
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	SBCI R22,BYTE3(-@0)
	SBCI R23,BYTE4(-@0)
	.ENDM

	.MACRO __ADDD2N
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	SBCI R24,BYTE3(-@0)
	SBCI R25,BYTE4(-@0)
	.ENDM

	.MACRO __SUBD1N
	SUBI R30,LOW(@0)
	SBCI R31,HIGH(@0)
	SBCI R22,BYTE3(@0)
	SBCI R23,BYTE4(@0)
	.ENDM

	.MACRO __SUBD2N
	SUBI R26,LOW(@0)
	SBCI R27,HIGH(@0)
	SBCI R24,BYTE3(@0)
	SBCI R25,BYTE4(@0)
	.ENDM

	.MACRO __ANDD1N
	ANDI R30,LOW(@0)
	ANDI R31,HIGH(@0)
	ANDI R22,BYTE3(@0)
	ANDI R23,BYTE4(@0)
	.ENDM

	.MACRO __ORD1N
	ORI  R30,LOW(@0)
	ORI  R31,HIGH(@0)
	ORI  R22,BYTE3(@0)
	ORI  R23,BYTE4(@0)
	.ENDM

	.MACRO __DELAY_USB
	LDI  R24,LOW(@0)
__DELAY_USB_LOOP:
	DEC  R24
	BRNE __DELAY_USB_LOOP
	.ENDM

	.MACRO __DELAY_USW
	LDI  R24,LOW(@0)
	LDI  R25,HIGH(@0)
__DELAY_USW_LOOP:
	SBIW R24,1
	BRNE __DELAY_USW_LOOP
	.ENDM

	.MACRO __CLRD1S
	LDI  R30,0
	STD  Y+@0,R30
	STD  Y+@0+1,R30
	STD  Y+@0+2,R30
	STD  Y+@0+3,R30
	.ENDM

	.MACRO __GETD1S
	LDD  R30,Y+@0
	LDD  R31,Y+@0+1
	LDD  R22,Y+@0+2
	LDD  R23,Y+@0+3
	.ENDM

	.MACRO __PUTD1S
	STD  Y+@0,R30
	STD  Y+@0+1,R31
	STD  Y+@0+2,R22
	STD  Y+@0+3,R23
	.ENDM

	.MACRO __POINTB1MN
	LDI  R30,LOW(@0+@1)
	.ENDM

	.MACRO __POINTW1MN
	LDI  R30,LOW(@0+@1)
	LDI  R31,HIGH(@0+@1)
	.ENDM

	.MACRO __POINTW1FN
	LDI  R30,LOW(2*@0+@1)
	LDI  R31,HIGH(2*@0+@1)
	.ENDM

	.MACRO __POINTB2MN
	LDI  R26,LOW(@0+@1)
	.ENDM

	.MACRO __POINTW2MN
	LDI  R26,LOW(@0+@1)
	LDI  R27,HIGH(@0+@1)
	.ENDM

	.MACRO __POINTBRM
	LDI  R@0,LOW(@1)
	.ENDM

	.MACRO __POINTWRM
	LDI  R@0,LOW(@2)
	LDI  R@1,HIGH(@2)
	.ENDM

	.MACRO __POINTBRMN
	LDI  R@0,LOW(@1+@2)
	.ENDM

	.MACRO __POINTWRMN
	LDI  R@0,LOW(@2+@3)
	LDI  R@1,HIGH(@2+@3)
	.ENDM

	.MACRO __GETD1N
	LDI  R30,LOW(@0)
	LDI  R31,HIGH(@0)
	LDI  R22,BYTE3(@0)
	LDI  R23,BYTE4(@0)
	.ENDM

	.MACRO __GETD2N
	LDI  R26,LOW(@0)
	LDI  R27,HIGH(@0)
	LDI  R24,BYTE3(@0)
	LDI  R25,BYTE4(@0)
	.ENDM

	.MACRO __GETD2S
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	LDD  R24,Y+@0+2
	LDD  R25,Y+@0+3
	.ENDM

	.MACRO __GETB1MN
	LDS  R30,@0+@1
	.ENDM

	.MACRO __GETW1MN
	LDS  R30,@0+@1
	LDS  R31,@0+@1+1
	.ENDM

	.MACRO __GETD1MN
	LDS  R30,@0+@1
	LDS  R31,@0+@1+1
	LDS  R22,@0+@1+2
	LDS  R23,@0+@1+3
	.ENDM

	.MACRO __GETBRMN
	LDS  R@0,@1+@2
	.ENDM

	.MACRO __GETWRMN
	LDS  R@0,@2+@3
	LDS  R@1,@2+@3+1
	.ENDM

	.MACRO __GETWRZ
	LDD  R@0,Z+@2
	LDD  R@1,Z+@2+1
	.ENDM

	.MACRO __GETD2Z
	LDD  R26,Z+@0
	LDD  R27,Z+@0+1
	LDD  R24,Z+@0+2
	LDD  R25,Z+@0+3
	.ENDM

	.MACRO __GETB2MN
	LDS  R26,@0+@1
	.ENDM

	.MACRO __GETW2MN
	LDS  R26,@0+@1
	LDS  R27,@0+@1+1
	.ENDM

	.MACRO __GETD2MN
	LDS  R26,@0+@1
	LDS  R27,@0+@1+1
	LDS  R24,@0+@1+2
	LDS  R25,@0+@1+3
	.ENDM

	.MACRO __PUTB1MN
	STS  @0+@1,R30
	.ENDM

	.MACRO __PUTW1MN
	STS  @0+@1,R30
	STS  @0+@1+1,R31
	.ENDM

	.MACRO __PUTD1MN
	STS  @0+@1,R30
	STS  @0+@1+1,R31
	STS  @0+@1+2,R22
	STS  @0+@1+3,R23
	.ENDM

	.MACRO __PUTDZ2
	STD  Z+@0,R26
	STD  Z+@0+1,R27
	STD  Z+@0+2,R24
	STD  Z+@0+3,R25
	.ENDM

	.MACRO __PUTBMRN
	STS  @0+@1,R@2
	.ENDM

	.MACRO __PUTWMRN
	STS  @0+@1,R@2
	STS  @0+@1+1,R@3
	.ENDM

	.MACRO __PUTBZR
	STD  Z+@1,R@0
	.ENDM

	.MACRO __PUTWZR
	STD  Z+@2,R@0
	STD  Z+@2+1,R@1
	.ENDM

	.MACRO __GETW1R
	MOV  R30,R@0
	MOV  R31,R@1
	.ENDM

	.MACRO __GETW2R
	MOV  R26,R@0
	MOV  R27,R@1
	.ENDM

	.MACRO __GETWRN
	LDI  R@0,LOW(@2)
	LDI  R@1,HIGH(@2)
	.ENDM

	.MACRO __PUTW1R
	MOV  R@0,R30
	MOV  R@1,R31
	.ENDM

	.MACRO __PUTW2R
	MOV  R@0,R26
	MOV  R@1,R27
	.ENDM

	.MACRO __ADDWRN
	SUBI R@0,LOW(-@2)
	SBCI R@1,HIGH(-@2)
	.ENDM

	.MACRO __ADDWRR
	ADD  R@0,R@2
	ADC  R@1,R@3
	.ENDM

	.MACRO __SUBWRN
	SUBI R@0,LOW(@2)
	SBCI R@1,HIGH(@2)
	.ENDM

	.MACRO __SUBWRR
	SUB  R@0,R@2
	SBC  R@1,R@3
	.ENDM

	.MACRO __ANDWRN
	ANDI R@0,LOW(@2)
	ANDI R@1,HIGH(@2)
	.ENDM

	.MACRO __ANDWRR
	AND  R@0,R@2
	AND  R@1,R@3
	.ENDM

	.MACRO __ORWRN
	ORI  R@0,LOW(@2)
	ORI  R@1,HIGH(@2)
	.ENDM

	.MACRO __ORWRR
	OR   R@0,R@2
	OR   R@1,R@3
	.ENDM

	.MACRO __EORWRR
	EOR  R@0,R@2
	EOR  R@1,R@3
	.ENDM

	.MACRO __GETWRS
	LDD  R@0,Y+@2
	LDD  R@1,Y+@2+1
	.ENDM

	.MACRO __PUTWSR
	STD  Y+@2,R@0
	STD  Y+@2+1,R@1
	.ENDM

	.MACRO __MOVEWRR
	MOV  R@0,R@2
	MOV  R@1,R@3
	.ENDM

	.MACRO __INWR
	IN   R@0,@2
	IN   R@1,@2+1
	.ENDM

	.MACRO __OUTWR
	OUT  @2+1,R@1
	OUT  @2,R@0
	.ENDM

	.MACRO __CALL1MN
	LDS  R30,@0+@1
	LDS  R31,@0+@1+1
	ICALL
	.ENDM


	.MACRO __CALL1FN
	LDI  R30,LOW(2*@0+@1)
	LDI  R31,HIGH(2*@0+@1)
	CALL __GETW1PF
	ICALL
	.ENDM


	.MACRO __CALL2EN
	LDI  R26,LOW(@0+@1)
	LDI  R27,HIGH(@0+@1)
	CALL __EEPROMRDW
	ICALL
	.ENDM


	.MACRO __GETW1STACK
	IN   R26,SPL
	IN   R27,SPH
	ADIW R26,@0+1
	LD   R30,X+
	LD   R31,X
	.ENDM

	.MACRO __NBST
	BST  R@0,@1
	IN   R30,SREG
	LDI  R31,0x40
	EOR  R30,R31
	OUT  SREG,R30
	.ENDM


	.MACRO __PUTB1SN
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SN
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SN
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1SNS
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	ADIW R26,@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SNS
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	ADIW R26,@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SNS
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	ADIW R26,@1
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1PMN
	LDS  R26,@0
	LDS  R27,@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1PMN
	LDS  R26,@0
	LDS  R27,@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1PMN
	LDS  R26,@0
	LDS  R27,@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1PMNS
	LDS  R26,@0
	LDS  R27,@0+1
	ADIW R26,@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1PMNS
	LDS  R26,@0
	LDS  R27,@0+1
	ADIW R26,@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1PMNS
	LDS  R26,@0
	LDS  R27,@0+1
	ADIW R26,@1
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RN
	MOVW R26,R@0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RN
	MOVW R26,R@0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RN
	MOVW R26,R@0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RNS
	MOVW R26,R@0
	ADIW R26,@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RNS
	MOVW R26,R@0
	ADIW R26,@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RNS
	MOVW R26,R@0
	ADIW R26,@1
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RON
	MOV  R26,R@0
	MOV  R27,R@1
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RON
	MOV  R26,R@0
	MOV  R27,R@1
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RON
	MOV  R26,R@0
	MOV  R27,R@1
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RONS
	MOV  R26,R@0
	MOV  R27,R@1
	ADIW R26,@2
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RONS
	MOV  R26,R@0
	MOV  R27,R@1
	ADIW R26,@2
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RONS
	MOV  R26,R@0
	MOV  R27,R@1
	ADIW R26,@2
	CALL __PUTDP1
	.ENDM


	.MACRO __GETB1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R30,Z
	.ENDM

	.MACRO __GETW1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R0,Z+
	LD   R31,Z
	MOV  R30,R0
	.ENDM

	.MACRO __GETD1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R0,Z+
	LD   R1,Z+
	LD   R22,Z+
	LD   R23,Z
	MOVW R30,R0
	.ENDM

	.MACRO __GETB2SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R26,X
	.ENDM

	.MACRO __GETW2SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	.ENDM

	.MACRO __GETD2SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R1,X+
	LD   R24,X+
	LD   R25,X
	MOVW R26,R0
	.ENDM

	.MACRO __GETBRSX
	MOVW R30,R28
	SUBI R30,LOW(-@1)
	SBCI R31,HIGH(-@1)
	LD   R@0,Z
	.ENDM

	.MACRO __GETWRSX
	MOVW R30,R28
	SUBI R30,LOW(-@2)
	SBCI R31,HIGH(-@2)
	LD   R@0,Z+
	LD   R@1,Z
	.ENDM

	.MACRO __LSLW8SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R31,Z
	CLR  R30
	.ENDM

	.MACRO __PUTB1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X+,R31
	ST   X+,R22
	ST   X,R23
	.ENDM

	.MACRO __CLRW1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	CLR  R0
	ST   Z+,R0
	ST   Z,R0
	.ENDM

	.MACRO __CLRD1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	CLR  R0
	ST   Z+,R0
	ST   Z+,R0
	ST   Z+,R0
	ST   Z,R0
	.ENDM

	.MACRO __PUTB2SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z,R26
	.ENDM

	.MACRO __PUTW2SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z+,R26
	ST   Z,R27
	.ENDM

	.MACRO __PUTBSRX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z,R@1
	.ENDM

	.MACRO __PUTWSRX
	MOVW R30,R28
	SUBI R30,LOW(-@2)
	SBCI R31,HIGH(-@2)
	ST   Z+,R@0
	ST   Z,R@1
	.ENDM

	.MACRO __PUTB1SNX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SNX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SNX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X+,R31
	ST   X+,R22
	ST   X,R23
	.ENDM

	.MACRO __MULBRR
	MULS R@0,R@1
	MOV  R30,R0
	.ENDM

	.MACRO __MULBRRU
	MUL  R@0,R@1
	MOV  R30,R0
	.ENDM

	.CSEG
	.ORG 0

	.INCLUDE "main.vec"
	.INCLUDE "main.inc"

__RESET:
	CLI
	CLR  R30
	OUT  EECR,R30

;INTERRUPT VECTORS ARE PLACED
;AT THE START OF FLASH
	LDI  R31,1
	OUT  MCUCR,R31
	OUT  MCUCR,R30
	STS  XMCRB,R30
	OUT  RAMPZ,R30

;DISABLE WATCHDOG
	LDI  R31,0x18
	OUT  WDTCR,R31
	OUT  WDTCR,R30

;CLEAR R2-R14
	LDI  R24,13
	LDI  R26,2
	CLR  R27
__CLEAR_REG:
	ST   X+,R30
	DEC  R24
	BRNE __CLEAR_REG

;CLEAR SRAM
	LDI  R24,LOW(0x1000)
	LDI  R25,HIGH(0x1000)
	LDI  R26,LOW(0x100)
	LDI  R27,HIGH(0x100)
__CLEAR_SRAM:
	ST   X+,R30
	SBIW R24,1
	BRNE __CLEAR_SRAM

;GLOBAL VARIABLES INITIALIZATION
	LDI  R30,LOW(__GLOBAL_INI_TBL*2)
	LDI  R31,HIGH(__GLOBAL_INI_TBL*2)
__GLOBAL_INI_NEXT:
	LPM  R24,Z+
	LPM  R25,Z+
	SBIW R24,0
	BREQ __GLOBAL_INI_END
	LPM  R26,Z+
	LPM  R27,Z+
	LPM  R0,Z+
	LPM  R1,Z+
	MOVW R22,R30
	MOVW R30,R0
__GLOBAL_INI_LOOP:
	LPM  R0,Z+
	ST   X+,R0
	SBIW R24,1
	BRNE __GLOBAL_INI_LOOP
	MOVW R30,R22
	RJMP __GLOBAL_INI_NEXT
__GLOBAL_INI_END:

;STACK POINTER INITIALIZATION
	LDI  R30,LOW(0x10FF)
	OUT  SPL,R30
	LDI  R30,HIGH(0x10FF)
	OUT  SPH,R30

;DATA STACK POINTER INITIALIZATION
	LDI  R28,LOW(0x500)
	LDI  R29,HIGH(0x500)

	JMP  _main

	.ESEG
	.ORG 0

	.DSEG
	.ORG 0x500
;       1 /*****************************************************
;       2 This program was produced by the
;       3 CodeWizardAVR V1.25.8a Evaluation
;       4 Automatic Program Generator
;       5  Copyright 1998-2007 Pavel Haiduc, HP InfoTech s.r.l.
;       6 http://www.hpinfotech.com
;       7 
;       8 Project : L-DOR
;       9 Version : 1.0
;      10 Date    : 2/9/2008
;      11 Author  : Freeware, for evaluation and non-commercial use only
;      12 Company : 
;      13 Comments: 
;      14 
;      15 
;      16 Chip type           : ATmega128
;      17 Program type        : Application
;      18 Clock frequency     : 14.745600 MHz
;      19 Memory model        : Small
;      20 External SRAM size  : 0
;      21 Data Stack size     : 1024
;      22 *****************************************************/
;      23 
;      24 #include <mega128.h> 
;      25 #include <stdlib.h> 
;      26 //#include <inttypes.h>
;      27 #include <delay.h> 
;      28 #include <lcd.h>
;      29 
;      30 #define IR_Cycle_Speed 50
;      31 
;      32 int analyse_ir();
;      33 void LCD_Display(int delay);
;      34 // Declare your global variables here 
;      35 char channel=0;
;      36 unsigned int adc_data[4];
_adc_data:
	.BYTE 0x8
;      37 
;      38 
;      39 
;      40 // Alphanumeric LCD Module functions
;      41 #asm
;      42    .equ __lcd_port=0x15 ;PORTC
   .equ __lcd_port=0x15 ;PORTC
;      43 #endasm
;      44 #include <stdlib.h>
;      45 #include <lcd.h>
;      46 /*
;      47 void lcd_PrintFloat(float number)
;      48 {
;      49  char decimal[1];
;      50  ftoa(number, *decimal, decimal);
;      51  lcd_puts(decimal);
;      52 } */             
;      53 
;      54 void lcd_PrintInt(int number)
;      55 {

	.CSEG
_lcd_PrintInt:
;      56 unsigned char character[1];
;      57         itoa(number, character);
	SBIW R28,1
;	number -> Y+1
;	character -> Y+0
	LDD  R30,Y+1
	LDD  R31,Y+1+1
	ST   -Y,R31
	ST   -Y,R30
	MOVW R30,R28
	ADIW R30,2
	ST   -Y,R31
	ST   -Y,R30
	CALL _itoa
;      58         lcd_puts(character);
	MOVW R30,R28
	ST   -Y,R31
	ST   -Y,R30
	CALL _lcd_puts
;      59 }
	ADIW R28,3
	RET
;      60 #include <mega128.h>
;      61 #include <io.h>
;      62 
;      63 #define R1 PORTB.2 
;      64 #define R2 PORTB.3
;      65 #define R3 PORTD.6
;      66 #define R4 PORTD.7
;      67 
;      68 #define C1 PIND.0
;      69 #define C2 PIND.1
;      70 #define C3 PINE.5
;      71 #define C4 PINE.6
;      72 
;      73 char row; 
;      74 char col;
;      75 char button;
;      76 
;      77 
;      78 
;      79 
;      80 void init_keypad()
;      81 {
_init_keypad:
;      82 R1=0;
	CBI  0x18,2
;      83 R2=0;
	CBI  0x18,3
;      84 R3=0;
	CBI  0x12,6
;      85 R4=0;
	CBI  0x12,7
;      86 // External Interrupt(s) initialization
;      87 // INT0: On
;      88 // INT0 Mode: Low level
;      89 // INT1: On
;      90 // INT1 Mode: Low level
;      91 // INT2: Off
;      92 // INT3: Off
;      93 // INT4: Off
;      94 // INT5: On
;      95 // INT5 Mode: Low level
;      96 // INT6: On
;      97 // INT6 Mode: Low level
;      98 // INT7: Off
;      99 EICRA=0x00;
	LDI  R30,LOW(0)
	STS  0x6A,R30
;     100 EICRB=0x00;
	OUT  0x3A,R30
;     101 EIMSK=0x63;
	LDI  R30,LOW(99)
	OUT  0x39,R30
;     102 EIFR=0x63;
	OUT  0x38,R30
;     103 } 
	RET
;     104 
;     105 // External Interrupt 0 service routine
;     106 interrupt [EXT_INT0] void ext_int0_isr(void)
;     107 { 
_ext_int0_isr:
	CALL SUBOPT_0x0
;     108 PORTB.0^=1;
	LDI  R30,0
	SBIC 0x18,0
	LDI  R30,1
	CALL SUBOPT_0x1
;     109 
;     110 R1=1;
	SBI  0x18,2
;     111 col=~C1;
	LDI  R30,0
	SBIS 0x10,0
	LDI  R30,1
	MOV  R6,R30
;     112 R1=0;
	CBI  0x18,2
;     113 if(col==0)
	TST  R6
	BRNE _0x3
;     114 {
;     115 button=1;
	LDI  R30,LOW(1)
	RJMP _0x1FE
;     116 }
;     117 else{
_0x3:
;     118         R2=1;
	SBI  0x18,3
;     119         col=~C1;
	LDI  R30,0
	SBIS 0x10,0
	LDI  R30,1
	MOV  R6,R30
;     120         R2=0;
	CBI  0x18,3
;     121         if(col==0)
	TST  R6
	BRNE _0x5
;     122         {
;     123         button=4;
	LDI  R30,LOW(4)
	RJMP _0x1FE
;     124         }
;     125         else{
_0x5:
;     126                 R3=1;
	SBI  0x12,6
;     127                 col=~C1;
	LDI  R30,0
	SBIS 0x10,0
	LDI  R30,1
	MOV  R6,R30
;     128                 R3=0;
	CBI  0x12,6
;     129                 if(col==0)
	TST  R6
	BRNE _0x7
;     130                 {
;     131                 button=7;
	LDI  R30,LOW(7)
	RJMP _0x1FE
;     132                 }
;     133                 else{
_0x7:
;     134                         R4=1;
	SBI  0x12,7
;     135                         col=~C1;
	LDI  R30,0
	SBIS 0x10,0
	LDI  R30,1
	MOV  R6,R30
;     136                         R4=0;
	CBI  0x12,7
;     137                         if(col==0)
	TST  R6
	BRNE _0x9
;     138                         {
;     139                         button=14;
	LDI  R30,LOW(14)
_0x1FE:
	MOV  R7,R30
;     140                         }
;     141                 }
_0x9:
;     142         }
;     143 }             
;     144 
;     145 
;     146 delay_ms(100);
	CALL SUBOPT_0x2
;     147 }
	RETI
;     148 
;     149 
;     150 // External Interrupt 1 service routine
;     151 interrupt [EXT_INT1] void ext_int1_isr(void)
;     152 {
_ext_int1_isr:
	CALL SUBOPT_0x0
;     153 PORTB.0^=1;
	LDI  R30,0
	SBIC 0x18,0
	LDI  R30,1
	CALL SUBOPT_0x1
;     154 R1=1;
	SBI  0x18,2
;     155 col=~C2;
	LDI  R30,0
	SBIS 0x10,1
	LDI  R30,1
	MOV  R6,R30
;     156 R1=0;
	CBI  0x18,2
;     157 if(col==0)
	TST  R6
	BRNE _0xA
;     158 {
;     159 button=2;
	LDI  R30,LOW(2)
	MOV  R7,R30
;     160 }
;     161 else{
	RJMP _0xB
_0xA:
;     162         R2=1;
	SBI  0x18,3
;     163         col=~C2;
	LDI  R30,0
	SBIS 0x10,1
	LDI  R30,1
	MOV  R6,R30
;     164         R2=0;
	CBI  0x18,3
;     165         if(col==0)
	TST  R6
	BRNE _0xC
;     166         {
;     167         button=5;
	LDI  R30,LOW(5)
	MOV  R7,R30
;     168         }
;     169         else{
	RJMP _0xD
_0xC:
;     170                 R3=1;
	SBI  0x12,6
;     171                 col=~C2;
	LDI  R30,0
	SBIS 0x10,1
	LDI  R30,1
	MOV  R6,R30
;     172                 R3=0;
	CBI  0x12,6
;     173                 if(col==0)
	TST  R6
	BRNE _0xE
;     174                 {
;     175                 button=8;
	LDI  R30,LOW(8)
	MOV  R7,R30
;     176                 }
;     177                 else{
	RJMP _0xF
_0xE:
;     178                         R4=1;
	SBI  0x12,7
;     179                         col=~C2;
	LDI  R30,0
	SBIS 0x10,1
	LDI  R30,1
	MOV  R6,R30
;     180                         R4=0;
	CBI  0x12,7
;     181                         if(col==0)
	TST  R6
	BRNE _0x10
;     182                         {
;     183                         button=0;
	CLR  R7
;     184                         }
;     185                 }
_0x10:
_0xF:
;     186         }
_0xD:
;     187 }
_0xB:
;     188 delay_ms(100);
	CALL SUBOPT_0x2
;     189 }
	RETI
;     190 
;     191 // External Interrupt 5 service routine
;     192 interrupt [EXT_INT5] void ext_int5_isr(void)
;     193 {
_ext_int5_isr:
	CALL SUBOPT_0x0
;     194 PORTB.0^=1;
	LDI  R30,0
	SBIC 0x18,0
	LDI  R30,1
	CALL SUBOPT_0x1
;     195 R1=1;
	SBI  0x18,2
;     196 col=~C3;
	LDI  R30,0
	SBIS 0x1,5
	LDI  R30,1
	MOV  R6,R30
;     197 R1=0;
	CBI  0x18,2
;     198 if(col==0)
	TST  R6
	BRNE _0x11
;     199 {
;     200 button=3;
	LDI  R30,LOW(3)
	RJMP _0x1FF
;     201 }
;     202 else{
_0x11:
;     203         R2=1;
	SBI  0x18,3
;     204         col=~C3;
	LDI  R30,0
	SBIS 0x1,5
	LDI  R30,1
	MOV  R6,R30
;     205         R2=0;
	CBI  0x18,3
;     206         if(col==0)
	TST  R6
	BRNE _0x13
;     207         {
;     208         button=6;
	LDI  R30,LOW(6)
	RJMP _0x1FF
;     209         }
;     210         else{
_0x13:
;     211                 R3=1;
	SBI  0x12,6
;     212                 col=~C3;
	LDI  R30,0
	SBIS 0x1,5
	LDI  R30,1
	MOV  R6,R30
;     213                 R3=0;
	CBI  0x12,6
;     214                 if(col==0)
	TST  R6
	BRNE _0x15
;     215                 {
;     216                 button=9;
	LDI  R30,LOW(9)
	RJMP _0x1FF
;     217                 }
;     218                 else{
_0x15:
;     219                         R4=1;
	SBI  0x12,7
;     220                         col=~C3;
	LDI  R30,0
	SBIS 0x1,5
	LDI  R30,1
	MOV  R6,R30
;     221                         R4=0;
	CBI  0x12,7
;     222                         if(col==0)
	TST  R6
	BRNE _0x17
;     223                         {
;     224                         button=15;
	LDI  R30,LOW(15)
_0x1FF:
	MOV  R7,R30
;     225                         }
;     226                 }
_0x17:
;     227         }
;     228 }
;     229 delay_ms(100);
	CALL SUBOPT_0x2
;     230 }
	RETI
;     231 
;     232 // External Interrupt 6 service routine
;     233 interrupt [EXT_INT6] void ext_int6_isr(void)
;     234 { 
_ext_int6_isr:
	CALL SUBOPT_0x0
;     235 PORTB.0^=1;
	LDI  R30,0
	SBIC 0x18,0
	LDI  R30,1
	CALL SUBOPT_0x1
;     236 R1=1;
	SBI  0x18,2
;     237 col=~C4;
	LDI  R30,0
	SBIS 0x1,6
	LDI  R30,1
	MOV  R6,R30
;     238 R1=0;
	CBI  0x18,2
;     239 if(col==0)
	TST  R6
	BRNE _0x18
;     240 {
;     241 button=10;
	LDI  R30,LOW(10)
	RJMP _0x200
;     242 }
;     243 else{
_0x18:
;     244         R2=1;
	SBI  0x18,3
;     245         col=~C4;
	LDI  R30,0
	SBIS 0x1,6
	LDI  R30,1
	MOV  R6,R30
;     246         R2=0;
	CBI  0x18,3
;     247         if(col==0)
	TST  R6
	BRNE _0x1A
;     248         {
;     249         button=11;
	LDI  R30,LOW(11)
	RJMP _0x200
;     250         }
;     251         else{
_0x1A:
;     252                 R3=1;
	SBI  0x12,6
;     253                 col=~C4;
	LDI  R30,0
	SBIS 0x1,6
	LDI  R30,1
	MOV  R6,R30
;     254                 R3=0;
	CBI  0x12,6
;     255                 if(col==0)
	TST  R6
	BRNE _0x1C
;     256                 {
;     257                 button=12;
	LDI  R30,LOW(12)
	RJMP _0x200
;     258                 }
;     259                 else{
_0x1C:
;     260                         R4=1;
	SBI  0x12,7
;     261                         col=~C4;
	LDI  R30,0
	SBIS 0x1,6
	LDI  R30,1
	MOV  R6,R30
;     262                         R4=0;
	CBI  0x12,7
;     263                         if(col==0)
	TST  R6
	BRNE _0x1E
;     264                         {
;     265                         button=13;
	LDI  R30,LOW(13)
_0x200:
	MOV  R7,R30
;     266                         }
;     267                 }
_0x1E:
;     268         }
;     269 }
;     270 delay_ms(100);
	CALL SUBOPT_0x2
;     271 }
	RETI
;     272 #include <mega128.h>
;     273 
;     274 #define led_ocr OCR0
;     275 #define LED     PORTB.4
;     276 
;     277 char led_dc=75;

	.DSEG
;     278 
;     279 void led_off()
;     280 {

	.CSEG
_led_off:
;     281 if(TCCR0!=0x4E)
	IN   R30,0x33
	CPI  R30,LOW(0x4E)
	BREQ _0x20
;     282 {
;     283  TCCR0&=0xCF;
	IN   R30,0x33
	ANDI R30,LOW(0xCF)
	OUT  0x33,R30
;     284 }
;     285 }
_0x20:
	RET
;     286 
;     287 void led_on()
;     288 {
_led_on:
;     289 if(TCCR0!=0x6E)
	IN   R30,0x33
	CPI  R30,LOW(0x6E)
	BREQ _0x21
;     290 {
;     291  TCCR0|=0x20;
	IN   R30,0x33
	ORI  R30,0x20
	OUT  0x33,R30
;     292  }
;     293 }
_0x21:
	RET
;     294 
;     295 void adj_led()
;     296 {                                     
_adj_led:
;     297  if(button==14)
	LDI  R30,LOW(14)
	CP   R30,R7
	BRNE _0x22
;     298  {
;     299         if(led_dc<=120)
	LDI  R30,LOW(120)
	CP   R30,R8
	BRLO _0x23
;     300         {
;     301         led_dc+=5;
	LDI  R30,LOW(5)
	ADD  R8,R30
;     302         }
;     303         else
	RJMP _0x24
_0x23:
;     304         {
;     305          LED=0;
	CBI  0x18,4
;     306          led_dc=0;
	CLR  R8
;     307         }
_0x24:
;     308   button=0; 
	CLR  R7
;     309  }
;     310  
;     311  if(button==15)
_0x22:
	LDI  R30,LOW(15)
	CP   R30,R7
	BRNE _0x25
;     312  {
;     313         if(led_dc>=5)
	LDI  R30,LOW(5)
	CP   R8,R30
	BRLO _0x26
;     314         {
;     315         led_dc-=5;
	SUB  R8,R30
;     316         }
;     317         else
	RJMP _0x27
_0x26:
;     318         {
;     319          led_dc=125;
	LDI  R30,LOW(125)
	MOV  R8,R30
;     320         }
_0x27:
;     321  button=0;
	CLR  R7
;     322  }
;     323 
;     324 }
_0x25:
	RET
;     325 
;     326 // Timer 0 overflow interrupt service routine
;     327 interrupt [TIM0_OVF] void timer0_ovf_isr(void)
;     328 { 
_timer0_ovf_isr:
	CALL SUBOPT_0x0
;     329 
;     330 adj_led();
	CALL _adj_led
;     331 
;     332 if(led_dc!=0 & led_dc!=125)
	MOV  R26,R8
	LDI  R30,LOW(0)
	CALL __NEB12
	PUSH R30
	LDI  R30,LOW(125)
	CALL __NEB12
	POP  R26
	AND  R30,R26
	BREQ _0x28
;     333 {
;     334 led_on();
	CALL _led_on
;     335 LED=0;
	CBI  0x18,4
;     336 led_ocr=led_dc;
	OUT  0x31,R8
;     337 }
;     338 else if(led_dc==0)
	RJMP _0x29
_0x28:
	TST  R8
	BRNE _0x2A
;     339 {
;     340  led_off();
	CALL _led_off
;     341 }
;     342 else if(led_dc==125)
	RJMP _0x2B
_0x2A:
	LDI  R30,LOW(125)
	CP   R30,R8
	BRNE _0x2C
;     343 {
;     344  led_off();
	CALL _led_off
;     345  LED=1;
	SBI  0x18,4
;     346 }
;     347 }
_0x2C:
_0x2B:
_0x29:
	CALL SUBOPT_0x3
	RETI
;     348 
;     349 
;     350 // Timer 0 output compare interrupt service routine
;     351 interrupt [TIM0_COMP] void timer0_comp_isr(void)
;     352 {
_timer0_comp_isr:
;     353 
;     354 }
	RETI
;     355 
;     356 void init_timer0()
;     357 {
_init_timer0:
;     358 // Timer/Counter 0 initialization
;     359 // Clock source: System Clock
;     360 // Clock value: 14.400 kHz
;     361 // Mode: Fast PWM top=FFh
;     362 // OC0 output: Non-Inverted PWM
;     363 ASSR=0x00;
	LDI  R30,LOW(0)
	OUT  0x30,R30
;     364 TCCR0=0x6E;
	LDI  R30,LOW(110)
	OUT  0x33,R30
;     365 TCNT0=0x00;
	LDI  R30,LOW(0)
	OUT  0x32,R30
;     366 led_ocr=0x00;   //OCR0
	OUT  0x31,R30
;     367 
;     368 // Timer(s)/Counter(s) Interrupt(s) initialization
;     369 TIMSK|=0x03;
	IN   R30,0x37
	ORI  R30,LOW(0x3)
	OUT  0x37,R30
;     370 
;     371 } 
	RET
;     372 
;     373 #include <mega128.h>
;     374 
;     375 bit read_current;
;     376 unsigned int amp_smpl;
;     377 int Amps;
;     378 char smpl;
;     379 bit new_reading;
;     380 
;     381 void ammeter()
;     382 {
_ammeter:
;     383  amp_smpl+=adc_data[3]/10;
	__GETW2MN _adc_data,6
	LDI  R30,LOW(10)
	LDI  R31,HIGH(10)
	CALL __DIVW21U
	__ADDWRR 9,10,30,31
;     384  smpl+=1;
	INC  R13
;     385  if(smpl==20)
	LDI  R30,LOW(20)
	CP   R30,R13
	BRNE _0x2D
;     386  {
;     387   Amps=amp_smpl/20;
	__GETW2R 9,10
	LDI  R30,LOW(20)
	LDI  R31,HIGH(20)
	CALL __DIVW21U
	__PUTW1R 11,12
;     388   smpl=0;
	CLR  R13
;     389   amp_smpl=0;
	CLR  R9
	CLR  R10
;     390   new_reading=1;
	SET
	BLD  R2,1
;     391  }
;     392  read_current=0;
_0x2D:
	CLT
	BLD  R2,0
;     393 }
	RET
;     394 #include <mega128.h>
;     395 
;     396 #define Sonar1_EN PORTA.5
;     397 #define Sonar2_EN PORTA.6
;     398 #define Sonar1 1
;     399 #define Sonar2 2
;     400 #define Samples 2
;     401 #define num_of_samples 2
;     402 
;     403 //Global variables
;     404 int SonarInches[2];

	.DSEG
_SonarInches:
	.BYTE 0x4
;     405 unsigned int SonarResult;
_SonarResult:
	.BYTE 0x2
;     406 int sonar_samples;
_sonar_samples:
	.BYTE 0x2
;     407 bit sonar_sel=0;
;     408 bit read_sonar;
;     409 char sonar_cntr=0;
;     410 char s_samp;
_s_samp:
	.BYTE 0x1
;     411 
;     412 /*****************************************
;     413 This function averages the sonar samples 
;     414 from the ADC. It is called in the ADC ISR. 
;     415 *****************************************/
;     416 
;     417 void Read_Sonar()
;     418 {

	.CSEG
_Read_Sonar:
;     419  SonarResult+=adc_data[channel];
	CALL SUBOPT_0x4
	ADD  R26,R30
	ADC  R27,R31
	CALL __GETW1P
	LDS  R26,_SonarResult
	LDS  R27,_SonarResult+1
	ADD  R30,R26
	ADC  R31,R27
	STS  _SonarResult,R30
	STS  _SonarResult+1,R31
;     420  sonar_samples+=1;
	LDS  R30,_sonar_samples
	LDS  R31,_sonar_samples+1
	ADIW R30,1
	STS  _sonar_samples,R30
	STS  _sonar_samples+1,R31
;     421         if(sonar_samples==num_of_samples)
	LDS  R26,_sonar_samples
	LDS  R27,_sonar_samples+1
	CPI  R26,LOW(0x2)
	LDI  R30,HIGH(0x2)
	CPC  R27,R30
	BRNE _0x2E
;     422         {
;     423         SonarInches[sonar_sel]=SonarResult/sonar_samples/2;
	LDI  R30,0
	SBRC R2,2
	LDI  R30,1
	LDI  R26,LOW(_SonarInches)
	LDI  R27,HIGH(_SonarInches)
	LDI  R31,0
	LSL  R30
	ROL  R31
	ADD  R30,R26
	ADC  R31,R27
	PUSH R31
	PUSH R30
	LDS  R30,_sonar_samples
	LDS  R31,_sonar_samples+1
	LDS  R26,_SonarResult
	LDS  R27,_SonarResult+1
	CALL __DIVW21U
	LSR  R31
	ROR  R30
	POP  R26
	POP  R27
	ST   X+,R30
	ST   X,R31
;     424         SonarResult=0;
	LDI  R30,0
	STS  _SonarResult,R30
	STS  _SonarResult+1,R30
;     425         sonar_samples=0;
	LDI  R30,0
	STS  _sonar_samples,R30
	STS  _sonar_samples+1,R30
;     426         read_sonar=0;
	CLT
	BLD  R2,3
;     427                 if(sonar_sel==0) //alternate the sonar being sampled
	SBRC R2,2
	RJMP _0x2F
;     428                 {
;     429                 sonar_sel=1;     
	SET
	BLD  R2,2
;     430                 }
;     431                 else                    
	RJMP _0x30
_0x2F:
;     432                 {
;     433                  sonar_sel=0;
	CLT
	BLD  R2,2
;     434                 }
_0x30:
;     435         }
;     436  }
_0x2E:
	RET
;     437 
;     438 
;     439 
;     440 /********************************************
;     441 This enables the sonar to take a reading and
;     442 changes the A/D channel when a sample is ready.
;     443 *******************************************/
;     444 
;     445 void Enable_Sonar()
;     446 {
_Enable_Sonar:
;     447 if(sonar_cntr==1)
	LDI  R30,LOW(1)
	CP   R30,R14
	BRNE _0x31
;     448  {
;     449         if(sonar_sel==0)
	SBRC R2,2
	RJMP _0x32
;     450         {
;     451          Sonar1_EN=1;
	SBI  0x1B,5
;     452          }
;     453          else
	RJMP _0x33
_0x32:
;     454          {
;     455           Sonar2_EN=1;
	SBI  0x1B,6
;     456          }
_0x33:
;     457  }
;     458  else if(sonar_cntr==2)
	RJMP _0x34
_0x31:
	LDI  R30,LOW(2)
	CP   R30,R14
	BRNE _0x35
;     459  {
;     460   Sonar2_EN=0;
	CBI  0x1B,6
;     461   Sonar1_EN=0;
	CBI  0x1B,5
;     462  }
;     463   else if(sonar_cntr==10)
	RJMP _0x36
_0x35:
	LDI  R30,LOW(10)
	CP   R30,R14
	BRNE _0x37
;     464  {
;     465   sonar_cntr=0;
	CLR  R14
;     466   read_sonar=1;
	SET
	BLD  R2,3
;     467  } 
;     468    
;     469 sonar_cntr+=1;
_0x37:
_0x36:
_0x34:
	INC  R14
;     470 }
	RET
;     471 #include <mega128.h>
;     472 #define ADC_VREF_TYPE 0x00
;     473 
;     474 
;     475 #define IR_Toggle PORTA.0
;     476 #define IR_Reset PORTA.1
;     477 #define IR_SelA PORTA.2
;     478 #define IR_SelB PORTA.3
;     479 #define IR_SelC PORTA.4
;     480 
;     481 
;     482 #define IR_Cycle_Speed 50
;     483 #define NumSamples 20
;     484 #define Number_of_Sensors 5
;     485 
;     486 
;     487 // Global variables  
;     488 int IR_Intensity=0;

	.DSEG
_IR_Intensity:
	.BYTE 0x2
;     489 int scnt;
_scnt:
	.BYTE 0x2
;     490 //int cntr;
;     491 double IR_Result[Number_of_Sensors][19];
_IR_Result:
	.BYTE 0x17C
;     492 int temp;
_temp:
	.BYTE 0x2
;     493 double samples;
_samples:
	.BYTE 0x4
;     494 char ir_sensor;
_ir_sensor:
	.BYTE 0x1
;     495 char IRMAX=25;
_IRMAX:
	.BYTE 0x1
;     496 
;     497 
;     498 
;     499 
;     500 void Change_IR_Sensor()
;     501 {

	.CSEG
_Change_IR_Sensor:
;     502  if((ir_sensor+1)==Number_of_Sensors)
	LDS  R30,_ir_sensor
	SUBI R30,-LOW(1)
	CPI  R30,LOW(0x5)
	BRNE _0x39
;     503  {
;     504   IR_SelA=0;
	CBI  0x1B,2
;     505   IR_SelB=0;
	CBI  0x1B,3
;     506   IR_SelC=0;
	CBI  0x1B,4
;     507   ir_sensor=0;
	RJMP _0x201
;     508  }
;     509  else if(ir_sensor==0)
_0x39:
	LDS  R30,_ir_sensor
	CPI  R30,0
	BRNE _0x3B
;     510  {
;     511   IR_SelA=1;
	SBI  0x1B,2
;     512   IR_SelB=0;
	CBI  0x1B,3
;     513   IR_SelC=0;
	CBI  0x1B,4
;     514   ir_sensor=1;
	LDI  R30,LOW(1)
	RJMP _0x202
;     515   }
;     516   else if(ir_sensor==1)
_0x3B:
	LDS  R26,_ir_sensor
	CPI  R26,LOW(0x1)
	BRNE _0x3D
;     517   {
;     518   IR_SelA=0;
	CBI  0x1B,2
;     519   IR_SelB=1;
	SBI  0x1B,3
;     520   IR_SelC=0;
	CBI  0x1B,4
;     521   ir_sensor=2;
	LDI  R30,LOW(2)
	RJMP _0x202
;     522   }
;     523   else if(ir_sensor==2)
_0x3D:
	LDS  R26,_ir_sensor
	CPI  R26,LOW(0x2)
	BRNE _0x3F
;     524   {
;     525    IR_SelA=1;
	SBI  0x1B,2
;     526    IR_SelB=1;
	SBI  0x1B,3
;     527    IR_SelC=0;
	CBI  0x1B,4
;     528    ir_sensor=3;
	LDI  R30,LOW(3)
	RJMP _0x202
;     529   }
;     530   else if(ir_sensor==3)
_0x3F:
	LDS  R26,_ir_sensor
	CPI  R26,LOW(0x3)
	BRNE _0x41
;     531   {
;     532    IR_SelA=0;
	CBI  0x1B,2
;     533    IR_SelB=0;
	CBI  0x1B,3
;     534    IR_SelC=1;
	SBI  0x1B,4
;     535    ir_sensor=4;
	LDI  R30,LOW(4)
	RJMP _0x202
;     536   }
;     537   else if(ir_sensor==4)
_0x41:
	LDS  R26,_ir_sensor
	CPI  R26,LOW(0x4)
	BRNE _0x43
;     538   {
;     539    IR_SelA=1;
	SBI  0x1B,2
;     540    IR_SelB=0;
	CBI  0x1B,3
;     541    IR_SelC=1;
	SBI  0x1B,4
;     542    ir_sensor=5;
	LDI  R30,LOW(5)
	RJMP _0x202
;     543   }
;     544   else if(ir_sensor==5)
_0x43:
	LDS  R26,_ir_sensor
	CPI  R26,LOW(0x5)
	BRNE _0x45
;     545   {
;     546    
;     547    IR_SelA=0;
	CBI  0x1B,2
;     548    IR_SelB=1;
	SBI  0x1B,3
;     549    IR_SelC=1;
	SBI  0x1B,4
;     550    ir_sensor=6;
	LDI  R30,LOW(6)
	RJMP _0x202
;     551   }
;     552   else if(ir_sensor==6)
_0x45:
	LDS  R26,_ir_sensor
	CPI  R26,LOW(0x6)
	BRNE _0x47
;     553   {
;     554    
;     555    IR_SelA=0;
	CBI  0x1B,2
;     556    IR_SelB=0;
	CBI  0x1B,3
;     557    IR_SelC=0;
	CBI  0x1B,4
;     558    ir_sensor=0;
_0x201:
	LDI  R30,LOW(0)
_0x202:
	STS  _ir_sensor,R30
;     559   }
;     560   
;     561 }
_0x47:
	RET
;     562 
;     563 
;     564 /***********************************************************
;     565 	Function Name: Decrease_IR_Level
;     566 	Function Description: This function toggles the 
;     567 	IR level down one notch at a time, then resets the
;     568 	IR level to zero(Full power).
;     569 	NOTES: 
;     570         Inputs: none
;     571         Outputs: IR_Toggle, IR_Reset, IR_Intensity
;     572 ***********************************************************/  
;     573 void Decrease_IR_Level(){
_Decrease_IR_Level:
;     574         char i;
;     575         IR_Toggle = 1;             //Keep clock line high until  a number of counts has passed
	ST   -Y,R16
;	i -> R16
	SBI  0x1B,0
;     576                   
;     577         if (IR_Intensity==15){     //There are 16 levels. 1=High...15=off
	LDS  R26,_IR_Intensity
	LDS  R27,_IR_Intensity+1
	CPI  R26,LOW(0xF)
	LDI  R30,HIGH(0xF)
	CPC  R27,R30
	BREQ PC+3
	JMP _0x48
;     578                 IR_Reset=0;        //Trigger the sync. memory reset    
	CBI  0x1B,1
;     579                 IR_Toggle=0;
	CBI  0x1B,0
;     580                 IR_Intensity=0;
	LDI  R30,0
	STS  _IR_Intensity,R30
	STS  _IR_Intensity+1,R30
;     581                 IR_Result[ir_sensor][16]=0;
	CALL SUBOPT_0x5
	PUSH R27
	PUSH R26
	LDI  R26,LOW(76)
	LDI  R27,HIGH(76)
	CALL __MULW12U
	POP  R26
	POP  R27
	ADD  R26,R30
	ADC  R27,R31
	SUBI R26,LOW(-64)
	SBCI R27,HIGH(-64)
	CALL SUBOPT_0x6
;     582                 IR_Result[ir_sensor][17]=0;
	PUSH R27
	PUSH R26
	LDI  R26,LOW(76)
	LDI  R27,HIGH(76)
	CALL __MULW12U
	POP  R26
	POP  R27
	ADD  R26,R30
	ADC  R27,R31
	SUBI R26,LOW(-68)
	SBCI R27,HIGH(-68)
	CALL SUBOPT_0x6
;     583                 IR_Result[ir_sensor][18]=0;
	PUSH R27
	PUSH R26
	LDI  R26,LOW(76)
	LDI  R27,HIGH(76)
	CALL __MULW12U
	POP  R26
	POP  R27
	ADD  R26,R30
	ADC  R27,R31
	SUBI R26,LOW(-72)
	SBCI R27,HIGH(-72)
	__GETD1N 0x0
	CALL __PUTDP1
;     584                 for(i=0;i<16;i++)
	LDI  R16,LOW(0)
_0x4A:
	CPI  R16,16
	BRSH _0x4B
;     585                 {
;     586                  IR_Result[ir_sensor][16]+=IR_Result[ir_sensor][i];
	CALL SUBOPT_0x5
	PUSH R27
	PUSH R26
	LDI  R26,LOW(76)
	LDI  R27,HIGH(76)
	CALL __MULW12U
	POP  R26
	POP  R27
	ADD  R30,R26
	ADC  R31,R27
	SUBI R30,LOW(-64)
	SBCI R31,HIGH(-64)
	PUSH R31
	PUSH R30
	MOVW R26,R30
	CALL __GETD1P
	PUSH R23
	PUSH R22
	PUSH R31
	PUSH R30
	CALL SUBOPT_0x5
	PUSH R27
	PUSH R26
	LDI  R26,LOW(76)
	LDI  R27,HIGH(76)
	CALL __MULW12U
	POP  R26
	POP  R27
	CALL SUBOPT_0x7
	POP  R26
	POP  R27
	POP  R24
	POP  R25
	CALL __ADDF12
	POP  R26
	POP  R27
	CALL __PUTDP1
;     587                 }
	SUBI R16,-1
	RJMP _0x4A
_0x4B:
;     588                 for(i=2;i<16;i++)
	LDI  R16,LOW(2)
_0x4D:
	CPI  R16,16
	BRLO PC+3
	JMP _0x4E
;     589                 { 
;     590                         temp=IR_Result[ir_sensor][i];
	CALL SUBOPT_0x5
	PUSH R27
	PUSH R26
	LDI  R26,LOW(76)
	LDI  R27,HIGH(76)
	CALL __MULW12U
	POP  R26
	POP  R27
	CALL SUBOPT_0x7
	CALL __CFD1
	STS  _temp,R30
	STS  _temp+1,R31
;     591                         if(temp>0 & i<7)
	CALL SUBOPT_0x8
	PUSH R30
	MOV  R26,R16
	LDI  R30,LOW(7)
	CALL __LTB12U
	POP  R26
	AND  R30,R26
	BREQ _0x4F
;     592                         {
;     593                          IR_Result[ir_sensor][18]+=temp/4;
	CALL SUBOPT_0x5
	PUSH R27
	PUSH R26
	LDI  R26,LOW(76)
	LDI  R27,HIGH(76)
	CALL __MULW12U
	POP  R26
	POP  R27
	ADD  R30,R26
	ADC  R31,R27
	SUBI R30,LOW(-72)
	SBCI R31,HIGH(-72)
	PUSH R31
	PUSH R30
	MOVW R26,R30
	CALL __GETD1P
	PUSH R23
	PUSH R22
	PUSH R31
	PUSH R30
	LDS  R26,_temp
	LDS  R27,_temp+1
	LDI  R30,LOW(4)
	LDI  R31,HIGH(4)
	CALL __DIVW21
	POP  R26
	POP  R27
	POP  R24
	POP  R25
	CALL __CWD1
	CALL __CDF1
	CALL __ADDF12
	POP  R26
	POP  R27
	RJMP _0x203
;     594                         }
;     595                         else if(temp>0 & i>=7 & i<8)
_0x4F:
	CALL SUBOPT_0x8
	PUSH R30
	MOV  R26,R16
	LDI  R30,LOW(7)
	CALL __GEB12U
	POP  R26
	AND  R30,R26
	PUSH R30
	MOV  R26,R16
	LDI  R30,LOW(8)
	CALL __LTB12U
	POP  R26
	AND  R30,R26
	BREQ _0x51
;     596                         {
;     597                         IR_Result[ir_sensor][18]+=temp/3;
	CALL SUBOPT_0x5
	PUSH R27
	PUSH R26
	LDI  R26,LOW(76)
	LDI  R27,HIGH(76)
	CALL __MULW12U
	POP  R26
	POP  R27
	ADD  R30,R26
	ADC  R31,R27
	SUBI R30,LOW(-72)
	SBCI R31,HIGH(-72)
	PUSH R31
	PUSH R30
	MOVW R26,R30
	CALL __GETD1P
	PUSH R23
	PUSH R22
	PUSH R31
	PUSH R30
	LDS  R26,_temp
	LDS  R27,_temp+1
	LDI  R30,LOW(3)
	LDI  R31,HIGH(3)
	CALL __DIVW21
	POP  R26
	POP  R27
	POP  R24
	POP  R25
	CALL __CWD1
	CALL __CDF1
	CALL __ADDF12
	POP  R26
	POP  R27
	RJMP _0x203
;     598                         }
;     599                         else if(temp>0 & i>=8 & i<10)
_0x51:
	CALL SUBOPT_0x8
	PUSH R30
	MOV  R26,R16
	LDI  R30,LOW(8)
	CALL __GEB12U
	POP  R26
	AND  R30,R26
	PUSH R30
	MOV  R26,R16
	LDI  R30,LOW(10)
	CALL __LTB12U
	POP  R26
	AND  R30,R26
	BREQ _0x53
;     600                         {
;     601                         IR_Result[ir_sensor][18]+=temp;
	CALL SUBOPT_0x5
	PUSH R27
	PUSH R26
	LDI  R26,LOW(76)
	LDI  R27,HIGH(76)
	CALL __MULW12U
	POP  R26
	POP  R27
	ADD  R30,R26
	ADC  R31,R27
	SUBI R30,LOW(-72)
	SBCI R31,HIGH(-72)
	PUSH R31
	PUSH R30
	MOVW R26,R30
	CALL __GETD1P
	MOVW R26,R30
	MOVW R24,R22
	LDS  R30,_temp
	LDS  R31,_temp+1
	CALL __CWD1
	CALL __CDF1
	CALL __ADDF12
	POP  R26
	POP  R27
	RJMP _0x203
;     602                         }
;     603                         else if(temp>0 & i>=10)
_0x53:
	CALL SUBOPT_0x8
	PUSH R30
	MOV  R26,R16
	LDI  R30,LOW(10)
	CALL __GEB12U
	POP  R26
	AND  R30,R26
	BREQ _0x55
;     604                         {                             
;     605                         IR_Result[ir_sensor][18]+=temp*2;
	CALL SUBOPT_0x5
	PUSH R27
	PUSH R26
	LDI  R26,LOW(76)
	LDI  R27,HIGH(76)
	CALL __MULW12U
	POP  R26
	POP  R27
	ADD  R30,R26
	ADC  R31,R27
	SUBI R30,LOW(-72)
	SBCI R31,HIGH(-72)
	PUSH R31
	PUSH R30
	MOVW R26,R30
	CALL __GETD1P
	MOVW R26,R30
	MOVW R24,R22
	LDS  R30,_temp
	LDS  R31,_temp+1
	LSL  R30
	ROL  R31
	CALL __CWD1
	CALL __CDF1
	CALL __ADDF12
	POP  R26
	POP  R27
_0x203:
	CALL __PUTDP1
;     606                         }
;     607                 
;     608                 }
_0x55:
	SUBI R16,-1
	RJMP _0x4D
_0x4E:
;     609                 
;     610                 
;     611                 Change_IR_Sensor();
	CALL _Change_IR_Sensor
;     612                 delay_us(10);
	__DELAY_USB 49
;     613         }                    
;     614         else{ 
	RJMP _0x56
_0x48:
;     615                 IR_Reset = 1;       //Active low reset
	SBI  0x1B,1
;     616                 IR_Toggle = 0;      //Pull counter clock line low,(Low-to-high edge trigger)
	CBI  0x1B,0
;     617                 IR_Intensity++;
	LDS  R30,_IR_Intensity
	LDS  R31,_IR_Intensity+1
	ADIW R30,1
	STS  _IR_Intensity,R30
	STS  _IR_Intensity+1,R31
;     618                 delay_us(1);
	__DELAY_USB 5
;     619                 }
_0x56:
;     620         
;     621       IR_Toggle=1;
	SBI  0x1B,0
;     622 }            
	LD   R16,Y+
	RET
;     623     
;     624     
;     625 /***********************************************************
;     626 	Function Name: Avg_IR_Samples
;     627 	Function Description: This function collects a thousand samples
;     628 	from the IR sensors and averages them. This will produce a number
;     629 	between 207 to 500. This function is run in the ADISR.
;     630 	NOTES: 
;     631         Inputs: adc_data
;     632         Outputs: IR_Result
;     633 ***********************************************************/
;     634 void Avg_IR_Samples()
;     635 {
_Avg_IR_Samples:
;     636         samples=samples+adc_data[0];
	LDS  R30,_adc_data
	LDS  R31,_adc_data+1
	LDS  R26,_samples
	LDS  R27,_samples+1
	LDS  R24,_samples+2
	LDS  R25,_samples+3
	CLR  R22
	CLR  R23
	CALL __CDF1
	CALL __ADDF12
	STS  _samples,R30
	STS  _samples+1,R31
	STS  _samples+2,R22
	STS  _samples+3,R23
;     637         scnt+=1;
	LDS  R30,_scnt
	LDS  R31,_scnt+1
	ADIW R30,1
	STS  _scnt,R30
	STS  _scnt+1,R31
;     638         if (scnt==NumSamples)
	LDS  R26,_scnt
	LDS  R27,_scnt+1
	CPI  R26,LOW(0x14)
	LDI  R30,HIGH(0x14)
	CPC  R27,R30
	BREQ PC+3
	JMP _0x57
;     639         {
;     640                 IR_Result[ir_sensor][IR_Intensity]=samples/NumSamples/50-4; 
	CALL SUBOPT_0x5
	PUSH R27
	PUSH R26
	LDI  R26,LOW(76)
	LDI  R27,HIGH(76)
	CALL __MULW12U
	POP  R26
	POP  R27
	ADD  R26,R30
	ADC  R27,R31
	LDS  R30,_IR_Intensity
	LDS  R31,_IR_Intensity+1
	CALL __LSLW2
	ADD  R30,R26
	ADC  R31,R27
	PUSH R31
	PUSH R30
	LDS  R26,_samples
	LDS  R27,_samples+1
	LDS  R24,_samples+2
	LDS  R25,_samples+3
	__GETD1N 0x41A00000
	CALL __DIVF21
	MOVW R26,R30
	MOVW R24,R22
	__GETD1N 0x42480000
	CALL __DIVF21
	MOVW R26,R30
	MOVW R24,R22
	__GETD1N 0x40800000
	CALL __SWAPD12
	CALL __SUBF12
	POP  R26
	POP  R27
	CALL __PUTDP1
;     641                 samples=0;
	__GETD1N 0x0
	STS  _samples,R30
	STS  _samples+1,R31
	STS  _samples+2,R22
	STS  _samples+3,R23
;     642                 scnt=0;
	LDI  R30,0
	STS  _scnt,R30
	STS  _scnt+1,R30
;     643                 Decrease_IR_Level();             
	CALL _Decrease_IR_Level
;     644         }                                          
;     645 } 
_0x57:
	RET
;     646 
;     647 
;     648 /*
;     649 void Change_IR_Level(int level){
;     650                 int i;
;     651                 IR_Reset = 0;       //Active low reset
;     652                 IR_Toggle = 0;      //Pull counter clock line low,(Low-to-high edge trigger)
;     653                 IR_Intensity=0;
;     654                 delay_us(1);
;     655                 IR_Toggle = 1;
;     656                 delay_us(1); 
;     657                 IR_Reset = 1;       //Active low reset               
;     658         for(i=1;i<=level;i++) {
;     659                         delay_us(1);
;     660                         IR_Toggle = 0;      //Pull counter clock line low,(Low-to-high edge trigger)
;     661                         IR_Intensity++;
;     662                         delay_us(1);
;     663                         IR_Toggle = 1;
;     664                         }          
;     665       IR_Toggle=1;
;     666 }*/
;     667 
;     668 
;     669 
;     670 
;     671    
;     672 #include <mega128.h> 
;     673 
;     674 #define IR_Toggle PORTA.0
;     675 #define IR_Reset PORTA.1
;     676 #define IR_SelA PORTA.2
;     677 #define IR_SelB PORTA.3
;     678 #define IR_SelC PORTA.4
;     679 
;     680 #define IR 0
;     681 #define S1 1;
;     682 #define S2 2;
;     683 #define A  3; 
;     684 
;     685 #define FIRST_ADC_INPUT 0
;     686 #define LAST_ADC_INPUT 3
;     687 #define ADC_VREF_TYPE 0x00
;     688 
;     689 #define motor_changespeed 1
;     690 #define sway_speed 50
;     691 char LB;

	.DSEG
_LB:
	.BYTE 0x1
;     692 char adc_index;
_adc_index:
	.BYTE 0x1
;     693 char t2ctr;
_t2ctr:
	.BYTE 0x1
;     694 void adjust_speed(); 
;     695 void TimeOutWD();
;     696 
;     697 bit look;
;     698 char look_cntr;              
_look_cntr:
	.BYTE 0x1
;     699                     
;     700 void init_ADC()
;     701 { 

	.CSEG
_init_ADC:
;     702 // ADC initialization
;     703 // ADC Clock frequency: 115.200 kHz
;     704 // ADC Voltage Reference: AREF pin
;     705 ADMUX=ADC_VREF_TYPE;
	LDI  R30,LOW(0)
	OUT  0x7,R30
;     706 ADCSRA=0xDF;
	LDI  R30,LOW(223)
	OUT  0x6,R30
;     707 
;     708  IR_SelA=0;
	CBI  0x1B,2
;     709  IR_SelB=0;
	CBI  0x1B,3
;     710  IR_SelC=0;
	CBI  0x1B,4
;     711  ir_sensor=0;
	LDI  R30,LOW(0)
	STS  _ir_sensor,R30
;     712  IR_Toggle=0;
	CBI  0x1B,0
;     713  IR_Reset=1;
	SBI  0x1B,1
;     714 } 
	RET
;     715 
;     716 // ADC interrupt service routine
;     717 interrupt [ADC_INT] void adc_isr(void)
;     718 {
_adc_isr:
	CALL SUBOPT_0x0
;     719 // Read the AD conversion result
;     720 adc_data[channel]=ADCW;
	CALL SUBOPT_0x4
	ADD  R26,R30
	ADC  R27,R31
	IN   R30,0x4
	IN   R31,0x4+1
	ST   X+,R30
	ST   X,R31
;     721 //sample rate: 115kHz 
;     722 // Select next ADC input
;     723 if(read_sonar==0)
	SBRC R2,3
	RJMP _0x58
;     724         Avg_IR_Samples();
	CALL _Avg_IR_Samples
;     725 if(channel>0 & channel<3 & read_sonar==1)
_0x58:
	MOV  R26,R4
	LDI  R30,LOW(0)
	CALL __GTB12U
	PUSH R30
	LDI  R30,LOW(3)
	CALL __LTB12U
	POP  R26
	AND  R30,R26
	PUSH R30
	LDI  R30,0
	SBRC R2,3
	LDI  R30,1
	LDI  R26,LOW(1)
	CALL __EQB12
	POP  R26
	AND  R30,R26
	BREQ _0x59
;     726         Read_Sonar();
	CALL _Read_Sonar
;     727 if(channel==3)
_0x59:
	LDI  R30,LOW(3)
	CP   R30,R4
	BRNE _0x5A
;     728         ammeter();
	CALL _ammeter
;     729         
;     730 if(read_sonar==1)
_0x5A:
	SBRS R2,3
	RJMP _0x5B
;     731 {
;     732  channel=sonar_sel+1;
	LDI  R30,0
	SBRC R2,2
	LDI  R30,1
	SUBI R30,-LOW(1)
	MOV  R4,R30
;     733 }
;     734 else if(read_current==1)
	RJMP _0x5C
_0x5B:
	SBRS R2,0
	RJMP _0x5D
;     735 {
;     736  channel=3;
	LDI  R30,LOW(3)
	MOV  R4,R30
;     737 }
;     738 else
	RJMP _0x5E
_0x5D:
;     739  {
;     740  channel=0;
	CLR  R4
;     741  }
_0x5E:
_0x5C:
;     742 ADMUX=(FIRST_ADC_INPUT|ADC_VREF_TYPE)+channel;
	MOV  R30,R4
	OUT  0x7,R30
;     743 // Start the AD conversion
;     744 ADCSRA|=0x40;   //Start another conversion
	SBI  0x6,6
;     745 } 
	CALL SUBOPT_0x3
	RETI
;     746 
;     747 void init_timer2()
;     748 {
_init_timer2:
;     749 // Timer/Counter 2 initialization
;     750 // Clock source: System Clock
;     751 // Clock value: 14.400 kHz
;     752 // Mode: Normal top=FFh
;     753 // OC2 output: Disconnected
;     754 TCCR2=0x05;
	LDI  R30,LOW(5)
	OUT  0x25,R30
;     755 TCNT2=0x00;
	LDI  R30,LOW(0)
	OUT  0x24,R30
;     756 OCR2=0x00;
	OUT  0x23,R30
;     757 // Timer(s)/Counter(s) Interrupt(s) initialization
;     758 TIMSK|=0x40;
	IN   R30,0x37
	ORI  R30,0x40
	OUT  0x37,R30
;     759 }
	RET
;     760 
;     761 // Timer 2 overflow interrupt service routine
;     762 interrupt [TIM2_OVF] void timer2_ovf_isr(void)
;     763 { 
_timer2_ovf_isr:
	CALL SUBOPT_0x0
;     764  Enable_Sonar();
	CALL _Enable_Sonar
;     765  TimeOutWD();
	RCALL _TimeOutWD
;     766  
;     767  t2ctr+=1;
	LDS  R30,_t2ctr
	SUBI R30,-LOW(1)
	STS  _t2ctr,R30
;     768  if(t2ctr == motor_changespeed)
	LDS  R26,_t2ctr
	CPI  R26,LOW(0x1)
	BRNE _0x5F
;     769  {
;     770  t2ctr=0;
	LDI  R30,LOW(0)
	STS  _t2ctr,R30
;     771  adjust_speed();
	RCALL _adjust_speed
;     772  }
;     773  
;     774  LB+=1;
_0x5F:
	LDS  R30,_LB
	SUBI R30,-LOW(1)
	STS  _LB,R30
;     775  
;     776  if(look_cntr==sway_speed)
	LDS  R26,_look_cntr
	CPI  R26,LOW(0x32)
	BRNE _0x60
;     777  {
;     778  look_cntr=0;
	LDI  R30,LOW(0)
	STS  _look_cntr,R30
;     779  look^=1;
	LDI  R30,0
	SBRC R2,4
	LDI  R30,1
	LDI  R26,LOW(1)
	EOR  R30,R26
	CALL __BSTB1
	BLD  R2,4
;     780  }
;     781  else
	RJMP _0x61
_0x60:
;     782  {  
;     783  look_cntr+=1;
	LDS  R30,_look_cntr
	SUBI R30,-LOW(1)
	STS  _look_cntr,R30
;     784  }
_0x61:
;     785 }
	CALL SUBOPT_0x3
	RETI
;     786 
;     787 /*
;     788 // Read the AD conversion result
;     789 unsigned int read_adc(unsigned char adc_input)
;     790 {
;     791 ADMUX=adc_input | (ADC_VREF_TYPE & 0xff);
;     792 // Delay needed for the stabilization of the ADC input voltage
;     793 delay_us(10);
;     794 // Start the AD conversion
;     795 ADCSRA|=0x40;
;     796 // Wait for the AD conversion to complete
;     797 while ((ADCSRA & 0x10)==0);
;     798 ADCSRA|=0x10;
;     799 return ADCW;
;     800 } 
;     801 */
;     802 #define Lservo PORTB.7   //OC1C
;     803 #define Rservo PORTB.6   //OC1B
;     804 #define Gripper PORTB.5  //OC1A
;     805 #define Tilter PORTE.4     //OC3A
;     806 
;     807 
;     808 #define ls_och OCR1CH
;     809 #define ls_ocl OCR1CL
;     810 
;     811 #define rs_och OCR1BH
;     812 #define rs_ocl OCR1BL
;     813 
;     814 #define gr_och OCR1AH
;     815 #define gr_ocl OCR1AL
;     816 
;     817 #define ti_och OCR3AH
;     818 #define ti_ocl OCR3AL
;     819 
;     820 #define top 500
;     821 #define tilt_max 475
;     822 
;     823 #define tilt_up 448
;     824 #define tilt_down 466
;     825 
;     826 #define tilt_min 445 
;     827 #define center 456
;     828 #define grip_max 482
;     829 #define grip_min 462
;     830 #define stopped 482
;     831 #define l_neutral 456
;     832 #define r_neutral 484
;     833 
;     834 #define grip_strength 22
;     835 
;     836 #include <mega128.h> 
;     837 
;     838 //Global Variables
;     839 signed int l_speed=top;

	.DSEG
_l_speed:
	.BYTE 0x2
;     840 signed int r_speed=top;
_r_speed:
	.BYTE 0x2
;     841 int grip_pos=470;
_grip_pos:
	.BYTE 0x2
;     842 int tilt_pos=center;
_tilt_pos:
	.BYTE 0x2
;     843 int cntr;
_cntr:
	.BYTE 0x2
;     844 int lspd=0;
_lspd:
	.BYTE 0x2
;     845 int rspd=0;
_rspd:
	.BYTE 0x2
;     846 int gpos=470;
_gpos:
	.BYTE 0x2
;     847 int tpos=center;
_tpos:
	.BYTE 0x2
;     848 bit object_ready;
;     849 
;     850 signed int left_speed;
_left_speed:
	.BYTE 0x2
;     851 signed int right_speed;
_right_speed:
	.BYTE 0x2
;     852 
;     853 void init_timer1()
;     854 {

	.CSEG
_init_timer1:
;     855 // Timer/Counter 1 initialization
;     856 // Clock source: System Clock
;     857 // Clock value: 56.700 kHz
;     858 // Mode: Ph. & fr. cor. PWM top=ICR1
;     859 // OC1A output: Inverted
;     860 // OC1B output: Inverted
;     861 // OC1C output: Inverted
;     862 // Noise Canceler: Off
;     863 // Input Capture on Rising Edge
;     864 // Timer 1 Overflow Interrupt: Off
;     865 // Input Capture Interrupt: On
;     866 // Compare A Match Interrupt: On
;     867 // Compare B Match Interrupt: On
;     868 // Compare C Match Interrupt: On
;     869 TCCR1A=0xFC;
	LDI  R30,LOW(252)
	OUT  0x2F,R30
;     870 TCCR1B=0x54;
	LDI  R30,LOW(84)
	OUT  0x2E,R30
;     871 TCNT1H=0x00;
	LDI  R30,LOW(0)
	OUT  0x2D,R30
;     872 TCNT1L=0x00;
	OUT  0x2C,R30
;     873 
;     874 ICR1H=0x01;  //TOP=500
	LDI  R30,LOW(1)
	OUT  0x27,R30
;     875 ICR1L=0xF4;
	LDI  R30,LOW(244)
	OUT  0x26,R30
;     876 
;     877 gr_och=grip_min/256;         //OCR1AH
	LDI  R30,LOW(1)
	OUT  0x2B,R30
;     878 gr_ocl=grip_min%256;         //OCR1AL;
	LDI  R30,LOW(206)
	OUT  0x2A,R30
;     879 
;     880 rs_och=top/256;         //OCR1BH
	LDI  R30,LOW(1)
	OUT  0x29,R30
;     881 rs_ocl=top%256;         //OCR1BL
	LDI  R30,LOW(244)
	OUT  0x28,R30
;     882 
;     883 ls_och=top/256;         //OCR1CH
	LDI  R30,LOW(1)
	STS  0x79,R30
;     884 ls_ocl=top%256;         //OCR1CL
	LDI  R30,LOW(244)
	STS  0x78,R30
;     885 
;     886 TIMSK|=0x18;
	IN   R30,0x37
	ORI  R30,LOW(0x18)
	OUT  0x37,R30
;     887 ETIMSK|=0x01;
	LDS  R30,125
	ORI  R30,1
	STS  125,R30
;     888 }
	RET
;     889 
;     890 void init_timer3()
;     891 {
_init_timer3:
;     892  // Timer/Counter 3 initialization
;     893 // Clock source: System Clock
;     894 // Clock value: 56.700 kHz
;     895 // Mode: Ph. & fr. cor. PWM top=ICR3
;     896 // Noise Canceler: Off
;     897 // Input Capture on Rising Edge
;     898 // OC3A output: Inverted
;     899 // OC3B output: Discon.
;     900 // OC3C output: Discon.
;     901 // Timer 3 Overflow Interrupt: Off
;     902 // Input Capture Interrupt: On
;     903 // Compare A Match Interrupt: On
;     904 // Compare B Match Interrupt: Off
;     905 // Compare C Match Interrupt: Off
;     906 TCCR3A=0xC0;
	LDI  R30,LOW(192)
	STS  0x8B,R30
;     907 TCCR3B=0x54;
	LDI  R30,LOW(84)
	STS  0x8A,R30
;     908 TCNT3H=0x00;
	LDI  R30,LOW(0)
	STS  0x89,R30
;     909 TCNT3L=0x00;
	STS  0x88,R30
;     910 
;     911 ICR3H=0x01;     //TOP=500
	LDI  R30,LOW(1)
	STS  0x81,R30
;     912 ICR3L=0xF4;
	LDI  R30,LOW(244)
	STS  0x80,R30
;     913 
;     914 ti_och=center/256;         //OCR3AH
	LDI  R30,LOW(1)
	STS  0x87,R30
;     915 ti_ocl=center%256;         //OCR3AL
	LDI  R30,LOW(200)
	STS  0x86,R30
;     916 
;     917 OCR3BH=0x00;
	LDI  R30,LOW(0)
	STS  0x85,R30
;     918 OCR3BL=0x00;
	STS  0x84,R30
;     919 OCR3CH=0x00;
	STS  0x83,R30
;     920 OCR3CL=0x00;
	STS  0x82,R30
;     921 
;     922 ETIMSK|=0x10;
	LDS  R30,125
	ORI  R30,0x10
	STS  125,R30
;     923 }
	RET
;     924 
;     925 void Lmotor_ctrl(signed int spd){
_Lmotor_ctrl:
;     926                  if(spd>=-10 & spd<=10 & spd!=0)
	CALL SUBOPT_0x9
	PUSH R30
	CALL SUBOPT_0xA
	POP  R26
	AND  R30,R26
	PUSH R30
	CALL SUBOPT_0xB
	POP  R26
	AND  R30,R26
	BREQ _0x68
;     927                  {
;     928                   l_speed=l_neutral-spd;
	LD   R26,Y
	LDD  R27,Y+1
	LDI  R30,LOW(456)
	LDI  R31,HIGH(456)
	SUB  R30,R26
	SBC  R31,R27
	RJMP _0x204
;     929                  }
;     930                  else if(spd==0)
_0x68:
	LD   R30,Y
	LDD  R31,Y+1
	SBIW R30,0
	BRNE _0x6A
;     931                  {
;     932                   l_speed=top;
	LDI  R30,LOW(500)
	LDI  R31,HIGH(500)
_0x204:
	STS  _l_speed,R30
	STS  _l_speed+1,R31
;     933                  }        
;     934         
;     935         ls_och=l_speed/256;
_0x6A:
	LDS  R26,_l_speed
	LDS  R27,_l_speed+1
	LDI  R30,LOW(256)
	LDI  R31,HIGH(256)
	CALL __DIVW21
	STS  0x79,R30
;     936         ls_ocl=l_speed%256;     
	LDS  R26,_l_speed
	LDS  R27,_l_speed+1
	LDI  R30,LOW(256)
	LDI  R31,HIGH(256)
	CALL __MODW21
	STS  0x78,R30
;     937 }
	RJMP _0x1FD
;     938 
;     939 void Rmotor_ctrl(signed int spd){ 
_Rmotor_ctrl:
;     940                  if(spd>=-10 & spd <=10 & spd!=0)
	CALL SUBOPT_0x9
	PUSH R30
	CALL SUBOPT_0xA
	POP  R26
	AND  R30,R26
	PUSH R30
	CALL SUBOPT_0xB
	POP  R26
	AND  R30,R26
	BREQ _0x6B
;     941                 {
;     942                   r_speed=r_neutral+spd;
	LD   R30,Y
	LDD  R31,Y+1
	SUBI R30,LOW(-484)
	SBCI R31,HIGH(-484)
	RJMP _0x205
;     943                  }
;     944                  else if(spd==0)
_0x6B:
	LD   R30,Y
	LDD  R31,Y+1
	SBIW R30,0
	BRNE _0x6D
;     945                  {
;     946                   r_speed=top;
	LDI  R30,LOW(500)
	LDI  R31,HIGH(500)
_0x205:
	STS  _r_speed,R30
	STS  _r_speed+1,R31
;     947                  }
;     948  
;     949         rs_och=r_speed/256;
_0x6D:
	LDS  R26,_r_speed
	LDS  R27,_r_speed+1
	LDI  R30,LOW(256)
	LDI  R31,HIGH(256)
	CALL __DIVW21
	OUT  0x29,R30
;     950         rs_ocl=r_speed%256;     
	LDS  R26,_r_speed
	LDS  R27,_r_speed+1
	LDI  R30,LOW(256)
	LDI  R31,HIGH(256)
	CALL __MODW21
	OUT  0x28,R30
;     951 }
	RJMP _0x1FD
;     952 
;     953 void grip_ctrl(char pos){
_grip_ctrl:
;     954         
;     955          if(pos=='O')
	LD   R26,Y
	CPI  R26,LOW(0x4F)
	BRNE _0x6E
;     956          {
;     957           grip_pos=center;
	LDI  R30,LOW(456)
	LDI  R31,HIGH(456)
	STS  _grip_pos,R30
	STS  _grip_pos+1,R31
;     958          }
;     959          else if(pos=='C')
	RJMP _0x6F
_0x6E:
	LD   R26,Y
	CPI  R26,LOW(0x43)
	BRNE _0x70
;     960          {
;     961           if(Amps<=grip_strength & grip_pos<grip_max)
	__GETW2R 11,12
	LDI  R30,LOW(22)
	LDI  R31,HIGH(22)
	CALL __LEW12
	PUSH R30
	LDS  R26,_grip_pos
	LDS  R27,_grip_pos+1
	LDI  R30,LOW(482)
	LDI  R31,HIGH(482)
	CALL __LTW12
	POP  R26
	AND  R30,R26
	BREQ _0x71
;     962            {
;     963                 if(new_reading==1)
	SBRS R2,1
	RJMP _0x72
;     964                 {
;     965                 grip_pos+=1;
	LDS  R30,_grip_pos
	LDS  R31,_grip_pos+1
	ADIW R30,1
	STS  _grip_pos,R30
	STS  _grip_pos+1,R31
;     966                 new_reading=0;
	CLT
	BLD  R2,1
;     967                 }
;     968            }
_0x72:
;     969            else if(Amps>grip_strength | grip_pos==grip_max)
	RJMP _0x73
_0x71:
	__GETW2R 11,12
	LDI  R30,LOW(22)
	LDI  R31,HIGH(22)
	CALL __GTW12
	PUSH R30
	LDS  R26,_grip_pos
	LDS  R27,_grip_pos+1
	LDI  R30,LOW(482)
	LDI  R31,HIGH(482)
	CALL __EQW12
	POP  R26
	OR   R30,R26
	BREQ _0x74
;     970            {
;     971             object_ready=1;
	SET
	BLD  R2,5
;     972            }
;     973          }  
_0x74:
_0x73:
;     974  
;     975         gr_och=grip_pos/256;
_0x70:
_0x6F:
	LDS  R26,_grip_pos
	LDS  R27,_grip_pos+1
	LDI  R30,LOW(256)
	LDI  R31,HIGH(256)
	CALL __DIVW21
	OUT  0x2B,R30
;     976         gr_ocl=grip_pos%256; 
	LDS  R26,_grip_pos
	LDS  R27,_grip_pos+1
	LDI  R30,LOW(256)
	LDI  R31,HIGH(256)
	CALL __MODW21
	OUT  0x2A,R30
;     977 }
	RJMP _0x1FC
;     978 
;     979 void tilt_ctrl(char pos){
_tilt_ctrl:
;     980         if(pos=='D')
	LD   R26,Y
	CPI  R26,LOW(0x44)
	BRNE _0x75
;     981         {
;     982         tilt_pos=tilt_down;
	LDI  R30,LOW(466)
	LDI  R31,HIGH(466)
	RJMP _0x206
;     983         }
;     984         else if(pos=='C')
_0x75:
	LD   R26,Y
	CPI  R26,LOW(0x43)
	BRNE _0x77
;     985         {
;     986         tilt_pos=center;
	LDI  R30,LOW(456)
	LDI  R31,HIGH(456)
	RJMP _0x206
;     987         }
;     988         else if(pos=='U')
_0x77:
	LD   R26,Y
	CPI  R26,LOW(0x55)
	BRNE _0x79
;     989         {
;     990         tilt_pos=tilt_up;
	LDI  R30,LOW(448)
	LDI  R31,HIGH(448)
_0x206:
	STS  _tilt_pos,R30
	STS  _tilt_pos+1,R31
;     991         }
;     992         
;     993         ti_och=tilt_pos/256;
_0x79:
	LDS  R26,_tilt_pos
	LDS  R27,_tilt_pos+1
	LDI  R30,LOW(256)
	LDI  R31,HIGH(256)
	CALL __DIVW21
	STS  0x87,R30
;     994         ti_ocl=tilt_pos%256; 
	LDS  R26,_tilt_pos
	LDS  R27,_tilt_pos+1
	LDI  R30,LOW(256)
	LDI  R31,HIGH(256)
	CALL __MODW21
	STS  0x86,R30
;     995 }
	RJMP _0x1FC
;     996 
;     997 
;     998 void adjust_speed()
;     999 {
_adjust_speed:
;    1000 if(rspd<right_speed)
	LDS  R30,_right_speed
	LDS  R31,_right_speed+1
	LDS  R26,_rspd
	LDS  R27,_rspd+1
	CP   R26,R30
	CPC  R27,R31
	BRGE _0x7A
;    1001 {
;    1002 rspd+=1;
	LDS  R30,_rspd
	LDS  R31,_rspd+1
	ADIW R30,1
	RJMP _0x207
;    1003 }
;    1004 else if(rspd>right_speed)
_0x7A:
	LDS  R30,_right_speed
	LDS  R31,_right_speed+1
	LDS  R26,_rspd
	LDS  R27,_rspd+1
	CP   R30,R26
	CPC  R31,R27
	BRGE _0x7C
;    1005 {
;    1006 rspd-=1;
	LDS  R30,_rspd
	LDS  R31,_rspd+1
	SBIW R30,1
_0x207:
	STS  _rspd,R30
	STS  _rspd+1,R31
;    1007 }
;    1008 
;    1009 if(lspd<left_speed)
_0x7C:
	LDS  R30,_left_speed
	LDS  R31,_left_speed+1
	LDS  R26,_lspd
	LDS  R27,_lspd+1
	CP   R26,R30
	CPC  R27,R31
	BRGE _0x7D
;    1010 {
;    1011  lspd+=1;
	LDS  R30,_lspd
	LDS  R31,_lspd+1
	ADIW R30,1
	RJMP _0x208
;    1012 }
;    1013 else if(lspd>left_speed)
_0x7D:
	LDS  R30,_left_speed
	LDS  R31,_left_speed+1
	LDS  R26,_lspd
	LDS  R27,_lspd+1
	CP   R30,R26
	CPC  R31,R27
	BRGE _0x7F
;    1014 {
;    1015  lspd-=1;
	LDS  R30,_lspd
	LDS  R31,_lspd+1
	SBIW R30,1
_0x208:
	STS  _lspd,R30
	STS  _lspd+1,R31
;    1016 }
;    1017 
;    1018 
;    1019 }
_0x7F:
	RET
;    1020 
;    1021 // Timer 3 output compare A interrupt service routine
;    1022 interrupt [TIM3_COMPA] void timer3_compa_isr(void)
;    1023 { 
_timer3_compa_isr:
;    1024 /*
;    1025  if(button==3)
;    1026  {
;    1027   tpos+=2;
;    1028   tilt_ctrl(tpos);
;    1029   button=0;
;    1030  }
;    1031  else if(button==6)
;    1032  {
;    1033   tpos-=2;
;    1034   tilt_ctrl(tpos);
;    1035   button=0;
;    1036   }
;    1037   PORTB.0^=1; 
;    1038   */
;    1039 }
	RETI
;    1040 
;    1041 // Timer 1 output compare A interrupt service routine
;    1042 interrupt [TIM1_COMPA] void timer1_compa_isr(void)
;    1043 {
_timer1_compa_isr:
	ST   -Y,R30
	IN   R30,SREG
;    1044  read_current=1;
	SET
	BLD  R2,0
;    1045  /*
;    1046  if(button==7)
;    1047  {
;    1048   gpos+=1;
;    1049   grip_ctrl(gpos);
;    1050   button=0;
;    1051  }
;    1052  else if(button==8)
;    1053  {
;    1054   grip_ctrl('C');
;    1055   
;    1056   }
;    1057 */ 
;    1058 }
	OUT  SREG,R30
	LD   R30,Y+
	RETI
;    1059 
;    1060 // Timer 1 output compare B interrupt service routine
;    1061 interrupt [TIM1_COMPB] void timer1_compb_isr(void)
;    1062 {
_timer1_compb_isr:
	CALL SUBOPT_0x0
;    1063 
;    1064 Rmotor_ctrl(rspd);
	LDS  R30,_rspd
	LDS  R31,_rspd+1
	ST   -Y,R31
	ST   -Y,R30
	CALL _Rmotor_ctrl
;    1065 /*
;    1066  if(button==4)
;    1067  {
;    1068   right_speed+=1;
;    1069   Rmotor_ctrl(right_speed);
;    1070   button=0;
;    1071  }
;    1072  else if(button==5)
;    1073  {
;    1074   right_speed-=1;
;    1075   Rmotor_ctrl(right_speed);
;    1076   button=0;
;    1077   }
;    1078 */ 
;    1079 }
	CALL SUBOPT_0x3
	RETI
;    1080 
;    1081 // Timer 1 output compare C interrupt service routine
;    1082 interrupt [TIM1_COMPC] void timer1_compc_isr(void)
;    1083 {
_timer1_compc_isr:
	CALL SUBOPT_0x0
;    1084 
;    1085 Lmotor_ctrl(lspd);
	LDS  R30,_lspd
	LDS  R31,_lspd+1
	ST   -Y,R31
	ST   -Y,R30
	CALL _Lmotor_ctrl
;    1086 
;    1087 /*
;    1088  if(button==1)
;    1089  {
;    1090   left_speed+=1;
;    1091   Lmotor_ctrl(left_speed);
;    1092   button=0;
;    1093  }
;    1094  else if(button==2)
;    1095  {
;    1096   left_speed-=1;
;    1097   Lmotor_ctrl(left_speed);
;    1098   button=0;
;    1099   }
;    1100 */
;    1101  } 
	CALL SUBOPT_0x3
	RETI
;    1102  
;    1103  
;    1104 /**************************************
;    1105 This function controls the motors.
;    1106 **************************************/
;    1107 void motor_ctrl(int direction)
;    1108 { 
_motor_ctrl:
;    1109  if(direction=='c')
	LD   R26,Y
	LDD  R27,Y+1
	CPI  R26,LOW(0x63)
	LDI  R30,HIGH(0x63)
	CPC  R27,R30
	BRNE _0x80
;    1110  {
;    1111   left_speed=10;
	LDI  R30,LOW(10)
	LDI  R31,HIGH(10)
	STS  _left_speed,R30
	STS  _left_speed+1,R31
;    1112   right_speed=-10;
	LDI  R30,LOW(65526)
	LDI  R31,HIGH(65526)
	RJMP _0x209
;    1113  }
;    1114  else if(direction=='C')
_0x80:
	LD   R26,Y
	LDD  R27,Y+1
	CPI  R26,LOW(0x43)
	LDI  R30,HIGH(0x43)
	CPC  R27,R30
	BRNE _0x82
;    1115  {
;    1116   left_speed=-10;
	LDI  R30,LOW(65526)
	LDI  R31,HIGH(65526)
	STS  _left_speed,R30
	STS  _left_speed+1,R31
;    1117   right_speed=10;
	LDI  R30,LOW(10)
	LDI  R31,HIGH(10)
	RJMP _0x209
;    1118  }
;    1119   else if(direction=='r')
_0x82:
	LD   R26,Y
	LDD  R27,Y+1
	CPI  R26,LOW(0x72)
	LDI  R30,HIGH(0x72)
	CPC  R27,R30
	BRNE _0x84
;    1120  {
;    1121   left_speed=5;
	LDI  R30,LOW(5)
	LDI  R31,HIGH(5)
	STS  _left_speed,R30
	STS  _left_speed+1,R31
;    1122   right_speed=2;
	LDI  R30,LOW(2)
	LDI  R31,HIGH(2)
	RJMP _0x209
;    1123  }
;    1124  else if(direction=='l')
_0x84:
	LD   R26,Y
	LDD  R27,Y+1
	CPI  R26,LOW(0x6C)
	LDI  R30,HIGH(0x6C)
	CPC  R27,R30
	BRNE _0x86
;    1125  {
;    1126   left_speed=2;
	LDI  R30,LOW(2)
	LDI  R31,HIGH(2)
	STS  _left_speed,R30
	STS  _left_speed+1,R31
;    1127   right_speed=5;
	LDI  R30,LOW(5)
	LDI  R31,HIGH(5)
	RJMP _0x209
;    1128  } 
;    1129  else if(direction=='R')
_0x86:
	LD   R26,Y
	LDD  R27,Y+1
	CPI  R26,LOW(0x52)
	LDI  R30,HIGH(0x52)
	CPC  R27,R30
	BRNE _0x88
;    1130  {
;    1131   left_speed=10;
	LDI  R30,LOW(10)
	LDI  R31,HIGH(10)
	STS  _left_speed,R30
	STS  _left_speed+1,R31
;    1132   right_speed=0;
	LDI  R30,0
	STS  _right_speed,R30
	STS  _right_speed+1,R30
;    1133  } 
;    1134  else if(direction=='L')
	RJMP _0x89
_0x88:
	LD   R26,Y
	LDD  R27,Y+1
	CPI  R26,LOW(0x4C)
	LDI  R30,HIGH(0x4C)
	CPC  R27,R30
	BRNE _0x8A
;    1135  {
;    1136   left_speed=0;
	LDI  R30,0
	STS  _left_speed,R30
	STS  _left_speed+1,R30
;    1137   right_speed=10;
	LDI  R30,LOW(10)
	LDI  R31,HIGH(10)
	RJMP _0x209
;    1138  } 
;    1139  else if(direction=='S')
_0x8A:
	LD   R26,Y
	LDD  R27,Y+1
	CPI  R26,LOW(0x53)
	LDI  R30,HIGH(0x53)
	CPC  R27,R30
	BRNE _0x8C
;    1140  {
;    1141   left_speed=10;
	LDI  R30,LOW(10)
	LDI  R31,HIGH(10)
	STS  _left_speed,R30
	STS  _left_speed+1,R31
;    1142   right_speed=10;
	RJMP _0x209
;    1143  }
;    1144   else if(direction=='B')
_0x8C:
	LD   R26,Y
	LDD  R27,Y+1
	CPI  R26,LOW(0x42)
	LDI  R30,HIGH(0x42)
	CPC  R27,R30
	BRNE _0x8E
;    1145  {
;    1146   left_speed=-10;
	LDI  R30,LOW(65526)
	LDI  R31,HIGH(65526)
	STS  _left_speed,R30
	STS  _left_speed+1,R31
;    1147   right_speed=-10;
	RJMP _0x209
;    1148  }
;    1149  else if(direction=='P')
_0x8E:
	LD   R26,Y
	LDD  R27,Y+1
	CPI  R26,LOW(0x50)
	LDI  R30,HIGH(0x50)
	CPC  R27,R30
	BRNE _0x90
;    1150  {
;    1151   left_speed=0;
	LDI  R30,0
	STS  _left_speed,R30
	STS  _left_speed+1,R30
;    1152   right_speed=0;
	LDI  R30,0
	STS  _right_speed,R30
	STS  _right_speed+1,R30
;    1153  }
;    1154  else if(direction=='>')
	RJMP _0x91
_0x90:
	LD   R26,Y
	LDD  R27,Y+1
	CPI  R26,LOW(0x3E)
	LDI  R30,HIGH(0x3E)
	CPC  R27,R30
	BRNE _0x92
;    1155  {
;    1156   left_speed=3;
	LDI  R30,LOW(3)
	LDI  R31,HIGH(3)
	STS  _left_speed,R30
	STS  _left_speed+1,R31
;    1157   right_speed=1;
	LDI  R30,LOW(1)
	LDI  R31,HIGH(1)
	RJMP _0x209
;    1158  }
;    1159  else if(direction=='<')
_0x92:
	LD   R26,Y
	LDD  R27,Y+1
	CPI  R26,LOW(0x3C)
	LDI  R30,HIGH(0x3C)
	CPC  R27,R30
	BRNE _0x94
;    1160  {
;    1161   left_speed=1;
	LDI  R30,LOW(1)
	LDI  R31,HIGH(1)
	STS  _left_speed,R30
	STS  _left_speed+1,R31
;    1162   right_speed=2;
	LDI  R30,LOW(2)
	LDI  R31,HIGH(2)
	RJMP _0x209
;    1163  }
;    1164  else
_0x94:
;    1165  {
;    1166   left_speed=direction;
	LD   R30,Y
	LDD  R31,Y+1
	STS  _left_speed,R30
	STS  _left_speed+1,R31
;    1167   right_speed=direction;   
_0x209:
	STS  _right_speed,R30
	STS  _right_speed+1,R31
;    1168  }
_0x91:
_0x89:
;    1169   
;    1170 }
_0x1FD:
	ADIW R28,2
	RET
;    1171 
;    1172 #include <mega128.h>
;    1173 #include <lcd.h> 
;    1174 #include <delay.h>
;    1175 #include <stdlib.h>
;    1176 #include <stdio.h> 
;    1177 
;    1178 #define EOL 0xFF        //end of line
;    1179 #define SOL 0x0A        //start of line
;    1180 #define CR 13           // carriage return
;    1181 #define TTL 30 
;    1182 
;    1183 #define x_min 12
;    1184 #define x_max 175
;    1185 #define y_min 1
;    1186 #define y_max 143
;    1187 #define x_center 82
;    1188 #define y_center 71
;    1189 #define offset 20 
;    1190 
;    1191 #define RXB8 1
;    1192 #define TXB8 0
;    1193 #define UPE 2
;    1194 #define OVR 3
;    1195 #define FE 4
;    1196 #define UDRE 5
;    1197 #define RXC 7
;    1198 
;    1199 #define FRAMING_ERROR (1<<FE)
;    1200 #define PARITY_ERROR (1<<UPE)
;    1201 #define DATA_OVERRUN (1<<OVR)
;    1202 #define DATA_REGISTER_EMPTY (1<<UDRE)
;    1203 #define RX_COMPLETE (1<<RXC)
;    1204 
;    1205 // USART0 Receiver buffer
;    1206 #define RX_BUFFER_SIZE0 8
;    1207 char rx_buffer0[RX_BUFFER_SIZE0];

	.DSEG
_rx_buffer0:
	.BYTE 0x8
;    1208 
;    1209 #if RX_BUFFER_SIZE0<256
;    1210 unsigned char rx_wr_index0,rx_rd_index0,rx_counter0;
_rx_wr_index0:
	.BYTE 0x1
_rx_rd_index0:
	.BYTE 0x1
_rx_counter0:
	.BYTE 0x1
;    1211 #else
;    1212 unsigned int rx_wr_index0,rx_rd_index0,rx_counter0;
;    1213 #endif
;    1214 
;    1215 // This flag is set on USART0 Receiver buffer overflow
;    1216 bit rx_buffer_overflow0;
;    1217  
;    1218 char blob_info[8][5];
_blob_info:
	.BYTE 0x28
;    1219 char blobs;
_blobs:
	.BYTE 0x1
;    1220 char num_blobs;
_num_blobs:
	.BYTE 0x1
;    1221 
;    1222 char blob_xsize;
_blob_xsize:
	.BYTE 0x1
;    1223 char blob_ysize;
_blob_ysize:
	.BYTE 0x1
;    1224 char blob_xcenter;
_blob_xcenter:
	.BYTE 0x1
;    1225 char blob_ycenter;
_blob_ycenter:
	.BYTE 0x1
;    1226 bit cam_mtr_ctrl=0;
;    1227 
;    1228 bit TimeOut;
;    1229 char ttl_cntr;
_ttl_cntr:
	.BYTE 0x1
;    1230 
;    1231 bit camera_ready = 0;
;    1232 bit new_trackdata;
;    1233 bit ACK;
;    1234 int test;
_test:
	.BYTE 0x2
;    1235 unsigned char object[8][4];     // blob[color][size]
_object:
	.BYTE 0x20
;    1236 
;    1237 char i;
_i:
	.BYTE 0x1
;    1238 
;    1239 void get_ack();
;    1240 
;    1241 void init_UART0()
;    1242 {

	.CSEG
_init_UART0:
;    1243 // USART0 initialization
;    1244 // Communication Parameters: 8 Data, 1 Stop, No Parity
;    1245 // USART0 Receiver: On
;    1246 // USART0 Transmitter: On
;    1247 // USART0 Mode: Asynchronous
;    1248 // USART0 Baud rate: 115200
;    1249 UCSR0A=0x00;
	LDI  R30,LOW(0)
	OUT  0xB,R30
;    1250 UCSR0B=0x98;
	LDI  R30,LOW(152)
	OUT  0xA,R30
;    1251 UCSR0C=0x06;
	LDI  R30,LOW(6)
	STS  0x95,R30
;    1252 UBRR0H=0x00;
	LDI  R30,LOW(0)
	STS  0x90,R30
;    1253 UBRR0L=0x07;
	LDI  R30,LOW(7)
	OUT  0x9,R30
;    1254 }
	RET
;    1255 
;    1256 unsigned char UART_Rx(void){
_UART_Rx:
;    1257         TimeOut=1;
	SET
	BLD  R3,0
;    1258         ttl_cntr=0;
	LDI  R30,LOW(0)
	STS  _ttl_cntr,R30
;    1259         //wait for data to be received or ttl to expire
;    1260         while(!(UCSR0A & (1<<RXC)));// & TimeOut==1);
_0x96:
	SBIS 0xB,7
	RJMP _0x96
;    1261         //Return Rx data from buffer
;    1262      //   if (TimeOut==1)
;    1263      //   {
;    1264                 return UDR0;  
	IN   R30,0xC
	RET
;    1265      //   }
;    1266      //   else
;    1267      //   {
;    1268      //           return 0;     //Return zero because TTL expired
;    1269      //   }
;    1270 }
;    1271 
;    1272 void TimeOutWD()
;    1273 { 
_TimeOutWD:
;    1274 if (TimeOut==1)
	SBRS R3,0
	RJMP _0x99
;    1275 {
;    1276  if(ttl_cntr==TTL)
	LDS  R26,_ttl_cntr
	CPI  R26,LOW(0x1E)
	BRNE _0x9A
;    1277  {
;    1278   TimeOut=0;
	CLT
	BLD  R3,0
;    1279  }
;    1280  else
	RJMP _0x9B
_0x9A:
;    1281  {
;    1282  ttl_cntr+=1;
	LDS  R30,_ttl_cntr
	SUBI R30,-LOW(1)
	STS  _ttl_cntr,R30
;    1283  }
_0x9B:
;    1284 }
;    1285 }
_0x99:
	RET
;    1286 
;    1287 
;    1288 void get_ack()
;    1289 {
_get_ack:
;    1290  char i;
;    1291  char ack[]="ACK\r"; 
;    1292 
;    1293         for(i=0;i<4;i++)
	SBIW R28,5
	LDI  R24,5
	LDI  R26,LOW(0)
	LDI  R27,HIGH(0)
	LDI  R30,LOW(_0x9C*2)
	LDI  R31,HIGH(_0x9C*2)
	CALL __INITLOCB
	ST   -Y,R16
;	i -> R16
;	ack -> Y+1
	LDI  R16,LOW(0)
_0x9E:
	CPI  R16,4
	BRSH _0x9F
;    1294         { 
;    1295          
;    1296          if(UART_Rx()==ack[i])  
	CALL _UART_Rx
	PUSH R30
	MOV  R30,R16
	LDI  R31,0
	MOVW R26,R28
	ADIW R26,1
	ADD  R26,R30
	ADC  R27,R31
	LD   R30,X
	POP  R26
	CP   R30,R26
	BRNE _0xA0
;    1297          {
;    1298           ACK=1;
	SET
	BLD  R3,3
;    1299          }
;    1300          else{
	RJMP _0xA1
_0xA0:
;    1301           lcd_clear();
	CALL _lcd_clear
;    1302           lcd_putsf("No ACK!");
	__POINTW1FN _0,0
	ST   -Y,R31
	ST   -Y,R30
	CALL _lcd_putsf
;    1303           delay_ms(500);
	CALL SUBOPT_0xC
;    1304           ACK=0;
	BLD  R3,3
;    1305           break;
	RJMP _0x9F
;    1306           }
_0xA1:
;    1307          }
	SUBI R16,-1
	RJMP _0x9E
_0x9F:
;    1308 
;    1309 }
	LDD  R16,Y+0
	ADIW R28,6
	RET
;    1310 
;    1311 char ping_cam(void)
;    1312 {
_ping_cam:
;    1313 
;    1314   //turn off UART interrupt
;    1315   UCSR0B=0x18;
	LDI  R30,LOW(24)
	OUT  0xA,R30
;    1316  printf("DT\r");       //disable tracking
	__POINTW1FN _0,8
	ST   -Y,R31
	ST   -Y,R30
	LDI  R24,0
	CALL SUBOPT_0xD
;    1317  get_ack();
;    1318  delay_ms(500);
	CALL SUBOPT_0xC
;    1319  ACK=0;
	BLD  R3,3
;    1320  //printf("PG\r");       //ping
;    1321 
;    1322  do
_0xA3:
;    1323  {
;    1324   delay_ms(10);
	LDI  R30,LOW(10)
	LDI  R31,HIGH(10)
	ST   -Y,R31
	ST   -Y,R30
	CALL _delay_ms
;    1325   printf("PG\r");       //ping
	__POINTW1FN _0,12
	ST   -Y,R31
	ST   -Y,R30
	LDI  R24,0
	CALL SUBOPT_0xD
;    1326   get_ack();
;    1327  }
;    1328   while(ACK==0);
	SBRS R3,3
	RJMP _0xA3
;    1329   //turn on UART interrupt  
;    1330 UCSR0B=0x98; 
	LDI  R30,LOW(152)
	OUT  0xA,R30
;    1331  if( ACK==1 )
	SBRS R3,3
	RJMP _0xA5
;    1332  {
;    1333   return 1;
	LDI  R30,LOW(1)
	RET
;    1334   ACK=0;
	CLT
	BLD  R3,3
;    1335   }
;    1336   else{
	RJMP _0xA6
_0xA5:
;    1337   return 0;
	LDI  R30,LOW(0)
	RET
;    1338   }
_0xA6:
;    1339 }
	RET
;    1340  
;    1341 /********************************************
;    1342 This function will return relative position
;    1343 of the color of the object in the function call.
;    1344 ********************************************/
;    1345 char track_object(char slot)
;    1346 {
_track_object:
;    1347 if(slot<8)
	LD   R26,Y
	CPI  R26,LOW(0x8)
	BRSH _0xA7
;    1348 {
;    1349  if(object[slot][2]>(x_center+offset))
	CALL SUBOPT_0xE
	MOV  R26,R30
	LDI  R30,LOW(102)
	CP   R30,R26
	BRSH _0xA8
;    1350  {
;    1351   return 'r';
	LDI  R30,LOW(114)
	RJMP _0x1FC
;    1352  }
;    1353  else if(object[slot][2]<(x_center-offset))
_0xA8:
	CALL SUBOPT_0xE
	CPI  R30,LOW(0x3E)
	BRSH _0xAA
;    1354  {
;    1355   return 'l';
	LDI  R30,LOW(108)
	RJMP _0x1FC
;    1356  }
;    1357  else if(object[slot][2]<=(x_center+offset) & object[slot][2]>=(x_center-offset))
_0xAA:
	CALL SUBOPT_0xE
	MOV  R26,R30
	LDI  R30,LOW(102)
	CALL __LEB12U
	PUSH R30
	CALL SUBOPT_0xE
	MOV  R26,R30
	LDI  R30,LOW(62)
	CALL __GEB12U
	POP  R26
	AND  R30,R26
	BREQ _0xAC
;    1358  {
;    1359   return 'S';
	LDI  R30,LOW(83)
	RJMP _0x1FC
;    1360  } 
;    1361 }
_0xAC:
;    1362 else
	RJMP _0xAD
_0xA7:
;    1363 {
;    1364  return 0;
	LDI  R30,LOW(0)
;    1365 }
_0xAD:
;    1366 }
_0x1FC:
	ADIW R28,1
	RET
;    1367 
;    1368 /********************************************
;    1369 This function receives the tracking packet
;    1370 from the camera and stores it in blob_info.
;    1371 It is called from the UART_ISR.
;    1372 ********************************************/
;    1373 void tracking_packet(void)
;    1374 {
_tracking_packet:
;    1375  int xlength,ylength;
;    1376  char i,j;
;    1377  char start;
;    1378  char data;
;    1379  i=0;
	SBIW R28,2
	CALL __SAVELOCR6
;	xlength -> R16,R17
;	ylength -> R18,R19
;	i -> R20
;	j -> R21
;	start -> Y+7
;	data -> Y+6
	LDI  R20,LOW(0)
;    1380  j=0;
	LDI  R21,LOW(0)
;    1381  blobs=UART_Rx();        //This is the number of blobs
	CALL _UART_Rx
	STS  _blobs,R30
;    1382  num_blobs=blobs;
	STS  _num_blobs,R30
;    1383 while(data!=EOL)       //Read the tracking packet
_0xAE:
	LDD  R26,Y+6
	CPI  R26,LOW(0xFF)
	BREQ _0xB0
;    1384 {
;    1385  data=UART_Rx();
	CALL _UART_Rx
	STD  Y+6,R30
;    1386  if(data!=EOL)
	LDD  R26,Y+6
	CPI  R26,LOW(0xFF)
	BREQ _0xB1
;    1387  {
;    1388  blob_info[i][j]=data;
	CALL SUBOPT_0xF
	PUSH R27
	PUSH R26
	LDI  R26,LOW(5)
	LDI  R27,HIGH(5)
	CALL __MULW12U
	POP  R26
	POP  R27
	ADD  R26,R30
	ADC  R27,R31
	MOV  R30,R21
	LDI  R31,0
	ADD  R30,R26
	ADC  R31,R27
	LDD  R26,Y+6
	STD  Z+0,R26
;    1389  j+=1;
	SUBI R21,-LOW(1)
;    1390         if(j==5)
	CPI  R21,5
	BRNE _0xB2
;    1391         {
;    1392          j=0;
	LDI  R21,LOW(0)
;    1393          i+=1;
	SUBI R20,-LOW(1)
;    1394         }
;    1395  }
_0xB2:
;    1396 }
_0xB1:
	RJMP _0xAE
_0xB0:
;    1397 
;    1398 for(i=0;i<blobs;i+=1)
	LDI  R20,LOW(0)
_0xB4:
	LDS  R30,_blobs
	CP   R20,R30
	BRLO PC+3
	JMP _0xB5
;    1399  {
;    1400          xlength=(blob_info[i][3]-blob_info[i][1])/2;    
	CALL SUBOPT_0xF
	PUSH R27
	PUSH R26
	LDI  R26,LOW(5)
	LDI  R27,HIGH(5)
	CALL __MULW12U
	POP  R26
	POP  R27
	ADD  R30,R26
	ADC  R31,R27
	LDD  R30,Z+3
	PUSH R30
	CALL SUBOPT_0xF
	PUSH R27
	PUSH R26
	LDI  R26,LOW(5)
	LDI  R27,HIGH(5)
	CALL __MULW12U
	POP  R26
	POP  R27
	ADD  R30,R26
	ADC  R31,R27
	LDD  R30,Z+1
	POP  R26
	CALL SUBOPT_0x10
	__PUTW1R 16,17
;    1401          ylength=(blob_info[i][4]-blob_info[i][2])/2;
	CALL SUBOPT_0xF
	PUSH R27
	PUSH R26
	LDI  R26,LOW(5)
	LDI  R27,HIGH(5)
	CALL __MULW12U
	POP  R26
	POP  R27
	ADD  R30,R26
	ADC  R31,R27
	LDD  R30,Z+4
	PUSH R30
	CALL SUBOPT_0xF
	PUSH R27
	PUSH R26
	LDI  R26,LOW(5)
	LDI  R27,HIGH(5)
	CALL __MULW12U
	POP  R26
	POP  R27
	ADD  R30,R26
	ADC  R31,R27
	LDD  R30,Z+2
	POP  R26
	CALL SUBOPT_0x10
	__PUTW1R 18,19
;    1402          object[i][0]=blob_info[i][0];                     //color
	CALL SUBOPT_0x11
	PUSH R31
	PUSH R30
	CALL SUBOPT_0xF
	PUSH R27
	PUSH R26
	LDI  R26,LOW(5)
	LDI  R27,HIGH(5)
	CALL __MULW12U
	POP  R26
	POP  R27
	ADD  R26,R30
	ADC  R27,R31
	LD   R30,X
	POP  R26
	POP  R27
	ST   X,R30
;    1403          object[i][1]=xlength*ylength;                     //area
	CALL SUBOPT_0x11
	ADIW R30,1
	PUSH R31
	PUSH R30
	__GETW1R 18,19
	__GETW2R 16,17
	CALL __MULW12
	POP  R26
	POP  R27
	ST   X,R30
;    1404          object[i][2]=xlength+blob_info[i][1];             //x position of blob
	CALL SUBOPT_0x11
	ADIW R30,2
	PUSH R31
	PUSH R30
	CALL SUBOPT_0xF
	PUSH R27
	PUSH R26
	LDI  R26,LOW(5)
	LDI  R27,HIGH(5)
	CALL __MULW12U
	POP  R26
	POP  R27
	ADD  R30,R26
	ADC  R31,R27
	LDD  R30,Z+1
	__GETW2R 16,17
	LDI  R31,0
	ADD  R30,R26
	ADC  R31,R27
	POP  R26
	POP  R27
	ST   X,R30
;    1405          
;    1406  }
	SUBI R20,-LOW(1)
	RJMP _0xB4
_0xB5:
;    1407  
;    1408 new_trackdata=1;         //signal that data is new
	SET
	BLD  R3,2
;    1409 data=0;
	LDI  R30,LOW(0)
	STD  Y+6,R30
;    1410 start=0;
	STD  Y+7,R30
;    1411 UCSR0B=0x98; 
	LDI  R30,LOW(152)
	OUT  0xA,R30
;    1412 }
	CALL __LOADLOCR6
	ADIW R28,8
	RET
;    1413 
;    1414 
;    1415 
;    1416 void disable_tracking(void)
;    1417 {
;    1418         printf("DT\r");   
;    1419 } 
;    1420 
;    1421 void enable_tracking(void)
;    1422 { 
_enable_tracking:
;    1423 #asm ("cli")
	cli
;    1424         printf("ET\r");
	__POINTW1FN _0,16
	ST   -Y,R31
	ST   -Y,R30
	LDI  R24,0
	CALL _printf
	ADIW R28,2
;    1425 #asm ("sei")    
	sei
;    1426  }
	RET
;    1427  
;    1428  void toggle_AWB()
;    1429  {
_toggle_AWB:
;    1430  /*
;    1431  reg:0x12 AWB                   on=>0x2C/44     off=>0x28/40 
;    1432  reg:0x2D Light Filter          on=>0x07        off=>0x03 
;    1433  reg:0x13 Enable AutoAdjust     on=>0x01        off=>0x00
;    1434  */
;    1435   printf("CR 18 40 45 3 19 0\r");
	__POINTW1FN _0,20
	ST   -Y,R31
	ST   -Y,R30
	LDI  R24,0
	CALL SUBOPT_0xD
;    1436   get_ack();
;    1437   printf("CR 18 44 45 7 19 1\r"); 
	__POINTW1FN _0,40
	ST   -Y,R31
	ST   -Y,R30
	LDI  R24,0
	CALL SUBOPT_0xD
;    1438   get_ack();
;    1439  }
	RET
;    1440  
;    1441  void init_camera()
;    1442 {
_init_camera:
;    1443 lcd_clear();
	CALL _lcd_clear
;    1444 lcd_putsf("Waiting for Camera");
	__POINTW1FN _0,60
	ST   -Y,R31
	ST   -Y,R30
	CALL _lcd_putsf
;    1445 delay_ms(1000);
	CALL SUBOPT_0x12
;    1446 ping_cam();        
	CALL _ping_cam
;    1447 lcd_clear();
	CALL _lcd_clear
;    1448 lcd_putsf("Camera Ready!"); 
	__POINTW1FN _0,79
	ST   -Y,R31
	ST   -Y,R30
	CALL _lcd_putsf
;    1449 toggle_AWB();
	CALL _toggle_AWB
;    1450 enable_tracking();
	CALL _enable_tracking
;    1451 camera_ready=1;
	SET
	BLD  R3,1
;    1452 delay_ms(1000);
	CALL SUBOPT_0x12
;    1453 } 
	RET
;    1454 
;    1455 void track()
;    1456 { 
;    1457 
;    1458 while (1)
;    1459       {
;    1460        lcd_clear();
;    1461        lcd_putsf("TI ");
;    1462        for(i=0;i<5;i++)
;    1463        {
;    1464         test=blob_info[0][i];
;    1465         lcd_PrintInt(test);
;    1466         lcd_putsf(" ");
;    1467         delay_ms(1);
;    1468         }
;    1469         
;    1470         
;    1471         lcd_gotoxy(0,1);
;    1472         lcd_PrintInt(blob_xcenter);
;    1473         lcd_putsf(" ");
;    1474         lcd_PrintInt(blob_ycenter);
;    1475         delay_ms(50);
;    1476        
;    1477        if(button==1)
;    1478        {
;    1479         cam_mtr_ctrl=1;
;    1480         button=0;
;    1481        }
;    1482        else if(button==2)
;    1483        {
;    1484         cam_mtr_ctrl=0;
;    1485         left_speed=0;
;    1486         right_speed=0;
;    1487         button=0;
;    1488        }
;    1489       
;    1490 } 
;    1491         
;    1492 }
;    1493 
;    1494 // USART0 Receiver interrupt service routine
;    1495 interrupt [USART0_RXC] void usart0_rx_isr(void)
;    1496 {
_usart0_rx_isr:
	CALL SUBOPT_0x0
;    1497 char status,data;
;    1498 status=UCSR0A;
	ST   -Y,R17
	ST   -Y,R16
;	status -> R16
;	data -> R17
	IN   R16,11
;    1499 data=UDR0;
	IN   R17,12
;    1500 
;    1501 if(data==SOL)
	CPI  R17,10
	BRNE _0xBF
;    1502 {
;    1503 PORTB.0^=1;
	LDI  R30,0
	SBIC 0x18,0
	LDI  R30,1
	CALL SUBOPT_0x1
;    1504  //turn off UART interrupt
;    1505   UCSR0B=0x18;
	LDI  R30,LOW(24)
	OUT  0xA,R30
;    1506   tracking_packet();  
	CALL _tracking_packet
;    1507 }
;    1508 
;    1509 
;    1510 }
_0xBF:
	LD   R16,Y+
	LD   R17,Y+
	CALL SUBOPT_0x3
	RETI
;    1511       
;    1512 #include <mega128.h>
;    1513 
;    1514 #define LeftSwitch PINE.7
;    1515 #define RightSwitch PINE.4
;    1516 
;    1517 #define ir_N    5
;    1518 #define ir_VF   10
;    1519 #define ir_F    15
;    1520 #define ir_Near    25
;    1521 #define ir_VN   35
;    1522 
;    1523  int left_front;

	.DSEG
_left_front:
	.BYTE 0x2
;    1524  int right_front;
_right_front:
	.BYTE 0x2
;    1525  int center_front;
_center_front:
	.BYTE 0x2
;    1526  bit got_object;
;    1527 
;    1528 char find_object_color();
;    1529 char wait_for_trackdata();
;    1530 void adjust_leds();
;    1531 char color;
_color:
	.BYTE 0x1
;    1532  
;    1533 /********************************************
;    1534 This function takes all the ir sensor data
;    1535 and returns a value indicating the proximity
;    1536 of an object in front of it.
;    1537 ********************************************/
;    1538 int analyse_ir()
;    1539 {

	.CSEG
_analyse_ir:
;    1540  char L_distance;
;    1541  char R_distance;
;    1542  char LF_distance;
;    1543  char RF_distance;
;    1544  char C_distance;
;    1545  unsigned int left;
;    1546  unsigned int right;
;    1547  unsigned int l_front;
;    1548  unsigned int r_front;
;    1549  unsigned int c_front;
;    1550 
;    1551 /*
;    1552 S=straight
;    1553 l=slight left
;    1554 L=left
;    1555 C=Counter Clockwise rotation
;    1556 r=slight right
;    1557 R=right
;    1558 c=clockwise rotation
;    1559 B=backwards
;    1560 */
;    1561 int table[6][6] = {{'S','S','l','L','L','C'}, //L_distance=0
;    1562                    {'S','S','l','L','C','C'},
;    1563                    {'r','r','S','C','C','C'},
;    1564                    {'r','R','c','S','C','C'},
;    1565                    {'r','R','c','c','B','B'},
;    1566                    {'c','c','c','c','B','B'}};//L_distance=5
;    1567  
;    1568  left=IR_Result[0][18];
	SBIW R28,63
	SBIW R28,19
	LDI  R24,72
	LDI  R26,LOW(0)
	LDI  R27,HIGH(0)
	LDI  R30,LOW(_0xC0*2)
	LDI  R31,HIGH(_0xC0*2)
	CALL __INITLOCB
	CALL __SAVELOCR5
;	L_distance -> R16
;	R_distance -> R17
;	LF_distance -> R18
;	RF_distance -> R19
;	C_distance -> R20
;	left -> Y+85
;	right -> Y+83
;	l_front -> Y+81
;	r_front -> Y+79
;	c_front -> Y+77
;	table -> Y+5
	__GETD1MN _IR_Result,72
	MOVW R26,R28
	SUBI R26,LOW(-(85))
	SBCI R27,HIGH(-(85))
	CALL __CFD1
	ST   X+,R30
	ST   X,R31
;    1569  right=IR_Result[1][18];
	__GETD1MN _IR_Result,148
	MOVW R26,R28
	SUBI R26,LOW(-(83))
	SBCI R27,HIGH(-(83))
	CALL __CFD1
	ST   X+,R30
	ST   X,R31
;    1570  l_front=IR_Result[3][18];
	__GETD1MN _IR_Result,300
	MOVW R26,R28
	SUBI R26,LOW(-(81))
	SBCI R27,HIGH(-(81))
	CALL __CFD1
	ST   X+,R30
	ST   X,R31
;    1571  r_front=IR_Result[2][18];
	__GETD1MN _IR_Result,224
	MOVW R26,R28
	SUBI R26,LOW(-(79))
	SBCI R27,HIGH(-(79))
	CALL __CFD1
	ST   X+,R30
	ST   X,R31
;    1572  c_front=IR_Result[4][18];
	__GETD1MN _IR_Result,376
	MOVW R26,R28
	SUBI R26,LOW(-(77))
	SBCI R27,HIGH(-(77))
	CALL __CFD1
	ST   X+,R30
	ST   X,R31
;    1573            
;    1574  if(left>=16)
	__GETW2SX 85
	CPI  R26,LOW(0x10)
	LDI  R30,HIGH(0x10)
	CPC  R27,R30
	BRLO _0xC1
;    1575  {
;    1576   L_distance=5;
	LDI  R16,LOW(5)
;    1577  }
;    1578  else if(left>=13 & left<16)
	RJMP _0xC2
_0xC1:
	__GETW2SX 85
	LDI  R30,LOW(13)
	LDI  R31,HIGH(13)
	CALL __GEW12U
	PUSH R30
	LDI  R30,LOW(16)
	LDI  R31,HIGH(16)
	CALL __LTW12U
	POP  R26
	AND  R30,R26
	BREQ _0xC3
;    1579  {
;    1580   L_distance=4;
	LDI  R16,LOW(4)
;    1581  }
;    1582  else if(left>=11 & left<13)
	RJMP _0xC4
_0xC3:
	__GETW2SX 85
	LDI  R30,LOW(11)
	LDI  R31,HIGH(11)
	CALL __GEW12U
	PUSH R30
	LDI  R30,LOW(13)
	LDI  R31,HIGH(13)
	CALL __LTW12U
	POP  R26
	AND  R30,R26
	BREQ _0xC5
;    1583  {
;    1584   L_distance=3;
	LDI  R16,LOW(3)
;    1585  }
;    1586  else if(left>=8 & left<11)
	RJMP _0xC6
_0xC5:
	__GETW2SX 85
	LDI  R30,LOW(8)
	LDI  R31,HIGH(8)
	CALL __GEW12U
	PUSH R30
	LDI  R30,LOW(11)
	LDI  R31,HIGH(11)
	CALL __LTW12U
	POP  R26
	AND  R30,R26
	BREQ _0xC7
;    1587  {
;    1588   L_distance=2;
	LDI  R16,LOW(2)
;    1589  }
;    1590  else if(left>=4 & left<8)
	RJMP _0xC8
_0xC7:
	__GETW2SX 85
	LDI  R30,LOW(4)
	LDI  R31,HIGH(4)
	CALL __GEW12U
	PUSH R30
	LDI  R30,LOW(8)
	LDI  R31,HIGH(8)
	CALL __LTW12U
	POP  R26
	AND  R30,R26
	BREQ _0xC9
;    1591  {
;    1592   L_distance=1;
	LDI  R16,LOW(1)
;    1593  }
;    1594  else if(left<4)
	RJMP _0xCA
_0xC9:
	__GETW2SX 85
	CPI  R26,LOW(0x4)
	LDI  R30,HIGH(0x4)
	CPC  R27,R30
	BRSH _0xCB
;    1595  {
;    1596   L_distance=0;
	LDI  R16,LOW(0)
;    1597  }
;    1598  
;    1599 
;    1600   if(right>=16)
_0xCB:
_0xCA:
_0xC8:
_0xC6:
_0xC4:
_0xC2:
	__GETW2SX 83
	CPI  R26,LOW(0x10)
	LDI  R30,HIGH(0x10)
	CPC  R27,R30
	BRLO _0xCC
;    1601  {
;    1602   R_distance=5;
	LDI  R17,LOW(5)
;    1603  }
;    1604  else if(right>=13 & right<16)
	RJMP _0xCD
_0xCC:
	__GETW2SX 83
	LDI  R30,LOW(13)
	LDI  R31,HIGH(13)
	CALL __GEW12U
	PUSH R30
	LDI  R30,LOW(16)
	LDI  R31,HIGH(16)
	CALL __LTW12U
	POP  R26
	AND  R30,R26
	BREQ _0xCE
;    1605  {
;    1606   R_distance=4;
	LDI  R17,LOW(4)
;    1607  }
;    1608  else if(right>=11 & right<13)
	RJMP _0xCF
_0xCE:
	__GETW2SX 83
	LDI  R30,LOW(11)
	LDI  R31,HIGH(11)
	CALL __GEW12U
	PUSH R30
	LDI  R30,LOW(13)
	LDI  R31,HIGH(13)
	CALL __LTW12U
	POP  R26
	AND  R30,R26
	BREQ _0xD0
;    1609  {
;    1610   R_distance=3;
	LDI  R17,LOW(3)
;    1611  }
;    1612  else if(right>=8 & right<11)
	RJMP _0xD1
_0xD0:
	__GETW2SX 83
	LDI  R30,LOW(8)
	LDI  R31,HIGH(8)
	CALL __GEW12U
	PUSH R30
	LDI  R30,LOW(11)
	LDI  R31,HIGH(11)
	CALL __LTW12U
	POP  R26
	AND  R30,R26
	BREQ _0xD2
;    1613  {
;    1614   R_distance=2;
	LDI  R17,LOW(2)
;    1615  }
;    1616  else if(right>=4 & right<8)
	RJMP _0xD3
_0xD2:
	__GETW2SX 83
	LDI  R30,LOW(4)
	LDI  R31,HIGH(4)
	CALL __GEW12U
	PUSH R30
	LDI  R30,LOW(8)
	LDI  R31,HIGH(8)
	CALL __LTW12U
	POP  R26
	AND  R30,R26
	BREQ _0xD4
;    1617  {
;    1618   R_distance=1;
	LDI  R17,LOW(1)
;    1619  }
;    1620  else if(right<4)
	RJMP _0xD5
_0xD4:
	__GETW2SX 83
	CPI  R26,LOW(0x4)
	LDI  R30,HIGH(0x4)
	CPC  R27,R30
	BRSH _0xD6
;    1621  {
;    1622   R_distance=0;
	LDI  R17,LOW(0)
;    1623  }
;    1624  
;    1625  if(r_front>=16)
_0xD6:
_0xD5:
_0xD3:
_0xD1:
_0xCF:
_0xCD:
	__GETW2SX 79
	CPI  R26,LOW(0x10)
	LDI  R30,HIGH(0x10)
	CPC  R27,R30
	BRLO _0xD7
;    1626  {
;    1627   RF_distance=5;
	LDI  R19,LOW(5)
;    1628  }
;    1629  else if(r_front>=13 & r_front<16)
	RJMP _0xD8
_0xD7:
	__GETW2SX 79
	LDI  R30,LOW(13)
	LDI  R31,HIGH(13)
	CALL __GEW12U
	PUSH R30
	LDI  R30,LOW(16)
	LDI  R31,HIGH(16)
	CALL __LTW12U
	POP  R26
	AND  R30,R26
	BREQ _0xD9
;    1630  {
;    1631   RF_distance=4;
	LDI  R19,LOW(4)
;    1632  }
;    1633  else if(r_front>=11 & r_front<13)
	RJMP _0xDA
_0xD9:
	__GETW2SX 79
	LDI  R30,LOW(11)
	LDI  R31,HIGH(11)
	CALL __GEW12U
	PUSH R30
	LDI  R30,LOW(13)
	LDI  R31,HIGH(13)
	CALL __LTW12U
	POP  R26
	AND  R30,R26
	BREQ _0xDB
;    1634  {
;    1635   RF_distance=3;
	LDI  R19,LOW(3)
;    1636  }
;    1637  else if(r_front>=8 & r_front<11)
	RJMP _0xDC
_0xDB:
	__GETW2SX 79
	LDI  R30,LOW(8)
	LDI  R31,HIGH(8)
	CALL __GEW12U
	PUSH R30
	LDI  R30,LOW(11)
	LDI  R31,HIGH(11)
	CALL __LTW12U
	POP  R26
	AND  R30,R26
	BREQ _0xDD
;    1638  {
;    1639   RF_distance=2;
	LDI  R19,LOW(2)
;    1640  }
;    1641  else if(r_front>=4 & r_front<8)
	RJMP _0xDE
_0xDD:
	__GETW2SX 79
	LDI  R30,LOW(4)
	LDI  R31,HIGH(4)
	CALL __GEW12U
	PUSH R30
	LDI  R30,LOW(8)
	LDI  R31,HIGH(8)
	CALL __LTW12U
	POP  R26
	AND  R30,R26
	BREQ _0xDF
;    1642  {
;    1643   RF_distance=1;
	LDI  R19,LOW(1)
;    1644  }
;    1645  else if(r_front<4)
	RJMP _0xE0
_0xDF:
	__GETW2SX 79
	CPI  R26,LOW(0x4)
	LDI  R30,HIGH(0x4)
	CPC  R27,R30
	BRSH _0xE1
;    1646  {
;    1647   RF_distance=0;
	LDI  R19,LOW(0)
;    1648  }
;    1649  
;    1650  if(l_front>=18)
_0xE1:
_0xE0:
_0xDE:
_0xDC:
_0xDA:
_0xD8:
	__GETW2SX 81
	CPI  R26,LOW(0x12)
	LDI  R30,HIGH(0x12)
	CPC  R27,R30
	BRLO _0xE2
;    1651  {
;    1652   LF_distance=5;
	LDI  R18,LOW(5)
;    1653  }
;    1654  else if(l_front>=14 & l_front<18)
	RJMP _0xE3
_0xE2:
	__GETW2SX 81
	LDI  R30,LOW(14)
	LDI  R31,HIGH(14)
	CALL __GEW12U
	PUSH R30
	LDI  R30,LOW(18)
	LDI  R31,HIGH(18)
	CALL __LTW12U
	POP  R26
	AND  R30,R26
	BREQ _0xE4
;    1655  {
;    1656   LF_distance=4;
	LDI  R18,LOW(4)
;    1657  }
;    1658  else if(l_front>=11 & l_front<14)
	RJMP _0xE5
_0xE4:
	__GETW2SX 81
	LDI  R30,LOW(11)
	LDI  R31,HIGH(11)
	CALL __GEW12U
	PUSH R30
	LDI  R30,LOW(14)
	LDI  R31,HIGH(14)
	CALL __LTW12U
	POP  R26
	AND  R30,R26
	BREQ _0xE6
;    1659  {
;    1660   LF_distance=3;
	LDI  R18,LOW(3)
;    1661  }
;    1662  else if(l_front>=8 & l_front<11)
	RJMP _0xE7
_0xE6:
	__GETW2SX 81
	LDI  R30,LOW(8)
	LDI  R31,HIGH(8)
	CALL __GEW12U
	PUSH R30
	LDI  R30,LOW(11)
	LDI  R31,HIGH(11)
	CALL __LTW12U
	POP  R26
	AND  R30,R26
	BREQ _0xE8
;    1663  {
;    1664   LF_distance=2;
	LDI  R18,LOW(2)
;    1665  }
;    1666  else if(l_front>=4 & l_front<8)
	RJMP _0xE9
_0xE8:
	__GETW2SX 81
	LDI  R30,LOW(4)
	LDI  R31,HIGH(4)
	CALL __GEW12U
	PUSH R30
	LDI  R30,LOW(8)
	LDI  R31,HIGH(8)
	CALL __LTW12U
	POP  R26
	AND  R30,R26
	BREQ _0xEA
;    1667  {
;    1668   LF_distance=1;
	LDI  R18,LOW(1)
;    1669  }
;    1670  else if(l_front<4)
	RJMP _0xEB
_0xEA:
	__GETW2SX 81
	CPI  R26,LOW(0x4)
	LDI  R30,HIGH(0x4)
	CPC  R27,R30
	BRSH _0xEC
;    1671  {
;    1672   LF_distance=0;
	LDI  R18,LOW(0)
;    1673  }
;    1674  
;    1675  if(c_front>=IRMAX)
_0xEC:
_0xEB:
_0xE9:
_0xE7:
_0xE5:
_0xE3:
	CALL SUBOPT_0x13
	CP   R26,R30
	CPC  R27,R31
	BRLO _0xED
;    1676  {
;    1677   C_distance=6;
	LDI  R20,LOW(6)
;    1678  }
;    1679  else if(c_front>=18 & c_front<IRMAX)
	RJMP _0xEE
_0xED:
	__GETW2SX 77
	LDI  R30,LOW(18)
	LDI  R31,HIGH(18)
	CALL __GEW12U
	PUSH R30
	CALL SUBOPT_0x13
	CALL __LTW12U
	POP  R26
	AND  R30,R26
	BREQ _0xEF
;    1680  {
;    1681   C_distance=5;
	LDI  R20,LOW(5)
;    1682  }
;    1683  else if(c_front>=14 & c_front<18)
	RJMP _0xF0
_0xEF:
	__GETW2SX 77
	LDI  R30,LOW(14)
	LDI  R31,HIGH(14)
	CALL __GEW12U
	PUSH R30
	LDI  R30,LOW(18)
	LDI  R31,HIGH(18)
	CALL __LTW12U
	POP  R26
	AND  R30,R26
	BREQ _0xF1
;    1684  {
;    1685   C_distance=4;
	LDI  R20,LOW(4)
;    1686  }
;    1687  else if(c_front>=11 & c_front<14)
	RJMP _0xF2
_0xF1:
	__GETW2SX 77
	LDI  R30,LOW(11)
	LDI  R31,HIGH(11)
	CALL __GEW12U
	PUSH R30
	LDI  R30,LOW(14)
	LDI  R31,HIGH(14)
	CALL __LTW12U
	POP  R26
	AND  R30,R26
	BREQ _0xF3
;    1688  {
;    1689   C_distance=3;
	LDI  R20,LOW(3)
;    1690  }
;    1691  else if(c_front>=8 & c_front<11)
	RJMP _0xF4
_0xF3:
	__GETW2SX 77
	LDI  R30,LOW(8)
	LDI  R31,HIGH(8)
	CALL __GEW12U
	PUSH R30
	LDI  R30,LOW(11)
	LDI  R31,HIGH(11)
	CALL __LTW12U
	POP  R26
	AND  R30,R26
	BREQ _0xF5
;    1692  {
;    1693   C_distance=2;
	LDI  R20,LOW(2)
;    1694  }
;    1695  else if(c_front>=2 & c_front<8)
	RJMP _0xF6
_0xF5:
	__GETW2SX 77
	LDI  R30,LOW(2)
	LDI  R31,HIGH(2)
	CALL __GEW12U
	PUSH R30
	LDI  R30,LOW(8)
	LDI  R31,HIGH(8)
	CALL __LTW12U
	POP  R26
	AND  R30,R26
	BREQ _0xF7
;    1696  {
;    1697   C_distance=1;
	LDI  R20,LOW(1)
;    1698  }
;    1699  else if(c_front<2)
	RJMP _0xF8
_0xF7:
	__GETW2SX 77
	CPI  R26,LOW(0x2)
	LDI  R30,HIGH(0x2)
	CPC  R27,R30
	BRSH _0xF9
;    1700  {
;    1701   C_distance=0;
	LDI  R20,LOW(0)
;    1702  }
;    1703  
;    1704  left_front=LF_distance;
_0xF9:
_0xF8:
_0xF6:
_0xF4:
_0xF2:
_0xF0:
_0xEE:
	MOV  R30,R18
	LDI  R31,0
	STS  _left_front,R30
	STS  _left_front+1,R31
;    1705  right_front=RF_distance;
	MOV  R30,R19
	LDI  R31,0
	STS  _right_front,R30
	STS  _right_front+1,R31
;    1706  center_front=C_distance;
	MOV  R30,R20
	LDI  R31,0
	STS  _center_front,R30
	STS  _center_front+1,R31
;    1707  
;    1708  if(LF_distance>L_distance)
	CP   R16,R18
	BRSH _0xFA
;    1709  {
;    1710   L_distance=LF_distance;
	MOV  R16,R18
;    1711  }
;    1712  
;    1713  if(RF_distance>R_distance)
_0xFA:
	CP   R17,R19
	BRSH _0xFB
;    1714  {
;    1715   R_distance=RF_distance;
	MOV  R17,R19
;    1716  }
;    1717  
;    1718  return table[L_distance,R_distance];
_0xFB:
	MOV  R30,R16
	LDI  R31,0
	LDI  R26,LOW(12)
	LDI  R27,HIGH(12)
	CALL __MULW12U
	MOVW R26,R28
	ADIW R26,5
	CALL SUBOPT_0x14
	CALL __LOADLOCR5
	ADIW R28,63
	ADIW R28,24
	RET
;    1719 } 
;    1720 
;    1721 
;    1722 /********************************************
;    1723 This function analyses the sonar readings and
;    1724 figures out how the motors should react.
;    1725 ********************************************/
;    1726 int analyse_sonar()
;    1727 {
_analyse_sonar:
;    1728  char L_distance;
;    1729  char R_distance;
;    1730  char left;
;    1731  char right;
;    1732 /*
;    1733 S=straight
;    1734 l=slight left
;    1735 L=left
;    1736 C=Counter Clockwise rotation
;    1737 r=slight right
;    1738 R=right
;    1739 c=clockwise rotation
;    1740 B=backwards
;    1741 */
;    1742 int table[5][5] = {{'S','S','l','L','C'}, //L_distance=0
;    1743                    {'S','S','l','L','C'},
;    1744                    {'r','l','L','C','C'},
;    1745                    {'r','R','c','c','c'},
;    1746                    {'R','R','c','c','B'}};//L_distance=4
;    1747  
;    1748  left=SonarInches[0];
	SBIW R28,50
	LDI  R24,50
	LDI  R26,LOW(0)
	LDI  R27,HIGH(0)
	LDI  R30,LOW(_0xFC*2)
	LDI  R31,HIGH(_0xFC*2)
	CALL __INITLOCB
	CALL __SAVELOCR4
;	L_distance -> R16
;	R_distance -> R17
;	left -> R18
;	right -> R19
;	table -> Y+4
	LDS  R18,_SonarInches
;    1749  right=SonarInches[1];
	__GETBRMN 19,_SonarInches,2
;    1750            
;    1751  if(left<=7)
	LDI  R30,LOW(7)
	CP   R30,R18
	BRLO _0xFD
;    1752  {
;    1753   L_distance=4;
	LDI  R16,LOW(4)
;    1754  }
;    1755  else if(left>=8 & left<=9)
	RJMP _0xFE
_0xFD:
	MOV  R26,R18
	LDI  R30,LOW(8)
	CALL __GEB12U
	PUSH R30
	LDI  R30,LOW(9)
	CALL __LEB12U
	POP  R26
	AND  R30,R26
	BREQ _0xFF
;    1756  {
;    1757   L_distance=3;
	LDI  R16,LOW(3)
;    1758  }
;    1759  else if(left>=10 & left<=11)
	RJMP _0x100
_0xFF:
	MOV  R26,R18
	LDI  R30,LOW(10)
	CALL __GEB12U
	PUSH R30
	LDI  R30,LOW(11)
	CALL __LEB12U
	POP  R26
	AND  R30,R26
	BREQ _0x101
;    1760  {
;    1761   L_distance=2;
	LDI  R16,LOW(2)
;    1762  }
;    1763  else if(left>=12 & left<=13)
	RJMP _0x102
_0x101:
	MOV  R26,R18
	LDI  R30,LOW(12)
	CALL __GEB12U
	PUSH R30
	LDI  R30,LOW(13)
	CALL __LEB12U
	POP  R26
	AND  R30,R26
	BREQ _0x103
;    1764  {
;    1765   L_distance=1;
	LDI  R16,LOW(1)
;    1766  }
;    1767  else if(left>13)
	RJMP _0x104
_0x103:
	LDI  R30,LOW(13)
	CP   R30,R18
	BRSH _0x105
;    1768  {
;    1769   L_distance=0;
	LDI  R16,LOW(0)
;    1770  }
;    1771  
;    1772 
;    1773  if(right<=7)
_0x105:
_0x104:
_0x102:
_0x100:
_0xFE:
	LDI  R30,LOW(7)
	CP   R30,R19
	BRLO _0x106
;    1774  {
;    1775   R_distance=4;
	LDI  R17,LOW(4)
;    1776  }
;    1777  else if(right>=8 & right<=9)
	RJMP _0x107
_0x106:
	MOV  R26,R19
	LDI  R30,LOW(8)
	CALL __GEB12U
	PUSH R30
	LDI  R30,LOW(9)
	CALL __LEB12U
	POP  R26
	AND  R30,R26
	BREQ _0x108
;    1778  {
;    1779   R_distance=3;
	LDI  R17,LOW(3)
;    1780  }
;    1781  else if(right>=10 & right<=11)
	RJMP _0x109
_0x108:
	MOV  R26,R19
	LDI  R30,LOW(10)
	CALL __GEB12U
	PUSH R30
	LDI  R30,LOW(11)
	CALL __LEB12U
	POP  R26
	AND  R30,R26
	BREQ _0x10A
;    1782  {
;    1783   R_distance=2;
	LDI  R17,LOW(2)
;    1784  }
;    1785  else if(right>=12 & right<=13)
	RJMP _0x10B
_0x10A:
	MOV  R26,R19
	LDI  R30,LOW(12)
	CALL __GEB12U
	PUSH R30
	LDI  R30,LOW(13)
	CALL __LEB12U
	POP  R26
	AND  R30,R26
	BREQ _0x10C
;    1786  {
;    1787   R_distance=1;
	LDI  R17,LOW(1)
;    1788  }
;    1789  else if(right>13)
	RJMP _0x10D
_0x10C:
	LDI  R30,LOW(13)
	CP   R30,R19
	BRSH _0x10E
;    1790  {
;    1791   R_distance=0;
	LDI  R17,LOW(0)
;    1792  } 
;    1793  
;    1794  return table[L_distance,R_distance];
_0x10E:
_0x10D:
_0x10B:
_0x109:
_0x107:
	MOV  R30,R16
	LDI  R31,0
	LDI  R26,LOW(10)
	LDI  R27,HIGH(10)
	CALL __MULW12U
	MOVW R26,R28
	ADIW R26,4
	CALL SUBOPT_0x14
	CALL __LOADLOCR4
	ADIW R28,54
	RET
;    1795 }
;    1796 
;    1797 
;    1798 void arbitrator(char sonar_dir, char ir_dir)
;    1799 {
_arbitrator:
;    1800 PORTB.0^=1;
	LDI  R30,0
	SBIC 0x18,0
	LDI  R30,1
	CALL SUBOPT_0x1
;    1801  if(LeftSwitch==0 & RightSwitch==1)
	LDI  R30,0
	SBIC 0x1,7
	LDI  R30,1
	LDI  R26,LOW(0)
	CALL __EQB12
	PUSH R30
	LDI  R30,0
	SBIC 0x1,4
	LDI  R30,1
	LDI  R26,LOW(1)
	CALL __EQB12
	POP  R26
	AND  R30,R26
	BREQ _0x10F
;    1802  {
;    1803   motor_ctrl('B');
	LDI  R30,LOW(66)
	LDI  R31,HIGH(66)
	RJMP _0x20A
;    1804  }
;    1805  else if(RightSwitch==0 & LeftSwitch==1)
_0x10F:
	LDI  R30,0
	SBIC 0x1,4
	LDI  R30,1
	LDI  R26,LOW(0)
	CALL __EQB12
	PUSH R30
	LDI  R30,0
	SBIC 0x1,7
	LDI  R30,1
	LDI  R26,LOW(1)
	CALL __EQB12
	POP  R26
	AND  R30,R26
	BREQ _0x111
;    1806  {
;    1807   motor_ctrl('B');
	LDI  R30,LOW(66)
	LDI  R31,HIGH(66)
	RJMP _0x20A
;    1808  }
;    1809  else if(LeftSwitch==0 & RightSwitch==0)
_0x111:
	LDI  R30,0
	SBIC 0x1,7
	LDI  R30,1
	LDI  R26,LOW(0)
	CALL __EQB12
	PUSH R30
	LDI  R30,0
	SBIC 0x1,4
	LDI  R30,1
	CALL __EQB12
	POP  R26
	AND  R30,R26
	BREQ _0x113
;    1810  {
;    1811   motor_ctrl('B');
	LDI  R30,LOW(66)
	LDI  R31,HIGH(66)
	RJMP _0x20A
;    1812  }
;    1813  else if(sonar_dir==ir_dir)
_0x113:
	LD   R30,Y
	LDD  R26,Y+1
	CP   R30,R26
	BRNE _0x115
;    1814  {
;    1815   motor_ctrl(sonar_dir);
	RJMP _0x20B
;    1816  }
;    1817  else if(sonar_dir=='S' & ir_dir!='S')
_0x115:
	LDD  R26,Y+1
	LDI  R30,LOW(83)
	CALL __EQB12
	PUSH R30
	LD   R26,Y
	LDI  R30,LOW(83)
	CALL __NEB12
	POP  R26
	AND  R30,R26
	BREQ _0x117
;    1818  {
;    1819   motor_ctrl(ir_dir);
	LD   R30,Y
	RJMP _0x20C
;    1820  }
;    1821  else if(sonar_dir!='S' & ir_dir=='S')
_0x117:
	LDD  R26,Y+1
	LDI  R30,LOW(83)
	CALL __NEB12
	PUSH R30
	LD   R26,Y
	LDI  R30,LOW(83)
	CALL __EQB12
	POP  R26
	AND  R30,R26
	BREQ _0x119
;    1822  {
;    1823   motor_ctrl(sonar_dir);
	RJMP _0x20B
;    1824  }
;    1825  else if((sonar_dir=='l'|sonar_dir=='r') & (ir_dir=='R'|ir_dir=='L'|ir_dir=='C'|ir_dir=='c'|ir_dir=='B')) 
_0x119:
	LDD  R26,Y+1
	LDI  R30,LOW(108)
	CALL __EQB12
	PUSH R30
	LDI  R30,LOW(114)
	CALL __EQB12
	POP  R26
	OR   R30,R26
	PUSH R30
	LD   R26,Y
	LDI  R30,LOW(82)
	CALL __EQB12
	PUSH R30
	LDI  R30,LOW(76)
	CALL __EQB12
	POP  R26
	OR   R30,R26
	PUSH R30
	LD   R26,Y
	LDI  R30,LOW(67)
	CALL __EQB12
	POP  R26
	OR   R30,R26
	PUSH R30
	LD   R26,Y
	LDI  R30,LOW(99)
	CALL __EQB12
	POP  R26
	OR   R30,R26
	PUSH R30
	LD   R26,Y
	LDI  R30,LOW(66)
	CALL __EQB12
	POP  R26
	OR   R30,R26
	POP  R26
	AND  R30,R26
	BREQ _0x11B
;    1826  {
;    1827   motor_ctrl(ir_dir);
	LD   R30,Y
	RJMP _0x20C
;    1828  } 
;    1829  else if((ir_dir=='l'|ir_dir=='r') & (sonar_dir=='R'|sonar_dir=='L'|sonar_dir=='C'|sonar_dir=='c'|sonar_dir=='B')) 
_0x11B:
	LD   R26,Y
	LDI  R30,LOW(108)
	CALL __EQB12
	PUSH R30
	LDI  R30,LOW(114)
	CALL __EQB12
	POP  R26
	OR   R30,R26
	PUSH R30
	LDD  R26,Y+1
	LDI  R30,LOW(82)
	CALL __EQB12
	PUSH R30
	LDI  R30,LOW(76)
	CALL __EQB12
	POP  R26
	OR   R30,R26
	PUSH R30
	LDD  R26,Y+1
	LDI  R30,LOW(67)
	CALL __EQB12
	POP  R26
	OR   R30,R26
	PUSH R30
	LDD  R26,Y+1
	LDI  R30,LOW(99)
	CALL __EQB12
	POP  R26
	OR   R30,R26
	PUSH R30
	LDD  R26,Y+1
	LDI  R30,LOW(66)
	CALL __EQB12
	POP  R26
	OR   R30,R26
	POP  R26
	AND  R30,R26
	BREQ _0x11D
;    1830  {
;    1831   motor_ctrl(sonar_dir);
;    1832  }
;    1833  else
_0x11D:
;    1834  {
;    1835   motor_ctrl(sonar_dir);
_0x20B:
	LDD  R30,Y+1
_0x20C:
	LDI  R31,0
_0x20A:
	ST   -Y,R31
	ST   -Y,R30
	CALL _motor_ctrl
;    1836   }
;    1837 } 
	RJMP _0x1F9
;    1838   
;    1839 void gripper()
;    1840 {
_gripper:
;    1841   motor_ctrl('P');
	CALL SUBOPT_0x15
;    1842   delay_ms(500);
	CALL SUBOPT_0xC
;    1843   new_reading=0;
	BLD  R2,1
;    1844         while(object_ready==0)
_0x11F:
	SBRC R2,5
	RJMP _0x121
;    1845         {  
;    1846         grip_ctrl('C');
	LDI  R30,LOW(67)
	ST   -Y,R30
	CALL _grip_ctrl
;    1847         }
	RJMP _0x11F
_0x121:
;    1848   object_ready=0;
	CLT
	BLD  R2,5
;    1849   delay_ms(500);
	CALL SUBOPT_0x16
;    1850   tilt_ctrl('U');
	CALL SUBOPT_0x17
;    1851   got_object=1;
	SET
	BLD  R3,4
;    1852  
;    1853 }
	RET
;    1854 
;    1855 char approach_object()
;    1856 {
_approach_object:
;    1857  char dir;
;    1858  analyse_ir(); 
	ST   -Y,R16
;	dir -> R16
	CALL _analyse_ir
;    1859  
;    1860  if(center_front==0)
	LDS  R30,_center_front
	LDS  R31,_center_front+1
	SBIW R30,0
	BRNE _0x122
;    1861  {
;    1862   dir=0;
	LDI  R16,LOW(0)
;    1863  }
;    1864  else if(center_front==6 & got_object==0)
	RJMP _0x123
_0x122:
	LDS  R26,_center_front
	LDS  R27,_center_front+1
	LDI  R30,LOW(6)
	LDI  R31,HIGH(6)
	CALL __EQW12
	PUSH R30
	LDI  R30,0
	SBRC R3,4
	LDI  R30,1
	LDI  R26,LOW(0)
	CALL __EQB12
	POP  R26
	AND  R30,R26
	BREQ _0x124
;    1865  {
;    1866   dir='G';
	LDI  R16,LOW(71)
;    1867  }
;    1868  else if((center_front>0 & center_front<6 & right_front==left_front)|(center_front==4)|(center_front==5))
	RJMP _0x125
_0x124:
	CALL SUBOPT_0x18
	PUSH R30
	LDS  R26,_center_front
	LDS  R27,_center_front+1
	LDI  R30,LOW(6)
	LDI  R31,HIGH(6)
	CALL __LTW12
	POP  R26
	AND  R30,R26
	PUSH R30
	CALL SUBOPT_0x19
	POP  R26
	AND  R30,R26
	PUSH R30
	LDS  R26,_center_front
	LDS  R27,_center_front+1
	LDI  R30,LOW(4)
	LDI  R31,HIGH(4)
	CALL __EQW12
	POP  R26
	OR   R30,R26
	PUSH R30
	LDS  R26,_center_front
	LDS  R27,_center_front+1
	LDI  R30,LOW(5)
	LDI  R31,HIGH(5)
	CALL __EQW12
	POP  R26
	OR   R30,R26
	BREQ _0x126
;    1869  {
;    1870   dir=2;
	LDI  R16,LOW(2)
;    1871  }
;    1872  else if(center_front>0 & center_front<4 & right_front>left_front)
	RJMP _0x127
_0x126:
	CALL SUBOPT_0x18
	PUSH R30
	CALL SUBOPT_0x1A
	POP  R26
	AND  R30,R26
	PUSH R30
	LDS  R30,_left_front
	LDS  R31,_left_front+1
	LDS  R26,_right_front
	LDS  R27,_right_front+1
	CALL __GTW12
	POP  R26
	AND  R30,R26
	BREQ _0x128
;    1873  {
;    1874   dir='>';
	LDI  R16,LOW(62)
;    1875  }
;    1876  else if(center_front>0 & center_front<4 & right_front<left_front)
	RJMP _0x129
_0x128:
	CALL SUBOPT_0x18
	PUSH R30
	CALL SUBOPT_0x1A
	POP  R26
	AND  R30,R26
	PUSH R30
	LDS  R30,_left_front
	LDS  R31,_left_front+1
	LDS  R26,_right_front
	LDS  R27,_right_front+1
	CALL __LTW12
	POP  R26
	AND  R30,R26
	BREQ _0x12A
;    1877  {
;    1878    dir='<';
	LDI  R16,LOW(60)
;    1879  }
;    1880  else
	RJMP _0x12B
_0x12A:
;    1881  {
;    1882   dir=0;
	LDI  R16,LOW(0)
;    1883  }
_0x12B:
_0x129:
_0x127:
_0x125:
_0x123:
;    1884  
;    1885 return dir; 
	MOV  R30,R16
	RJMP _0x1FA
;    1886 }
;    1887 
;    1888 char GetObject()
;    1889 {
_GetObject:
;    1890  char cam_dir;
;    1891  char ir_dir;
;    1892 
;    1893  ir_dir=approach_object();
	ST   -Y,R17
	ST   -Y,R16
;	cam_dir -> R16
;	ir_dir -> R17
	CALL _approach_object
	MOV  R17,R30
;    1894  
;    1895         if(wait_for_trackdata()==1 & color<8)
	CALL SUBOPT_0x1B
	PUSH R30
	LDS  R26,_color
	LDI  R30,LOW(8)
	CALL __LTB12U
	POP  R26
	AND  R30,R26
	BREQ _0x12C
;    1896         {
;    1897         new_trackdata=0;
	CLT
	BLD  R3,2
;    1898         cam_dir=track_object(find_object_color());
	RCALL _find_object_color
	CALL SUBOPT_0x1C
;    1899         }
;    1900         else
	RJMP _0x12D
_0x12C:
;    1901         {
;    1902         cam_dir=0;
	LDI  R16,LOW(0)
;    1903         adjust_leds();
	RCALL _adjust_leds
;    1904         }
_0x12D:
;    1905  
;    1906  if(ir_dir=='G')
	CPI  R17,71
	BRNE _0x12E
;    1907  { 
;    1908  gripper();
	CALL _gripper
;    1909  }
;    1910  else if(cam_dir==0 & ir_dir==0)
	RJMP _0x12F
_0x12E:
	MOV  R26,R16
	LDI  R30,LOW(0)
	CALL __EQB12
	PUSH R30
	CALL SUBOPT_0x1D
	POP  R26
	AND  R30,R26
	BREQ _0x130
;    1911  {
;    1912  motor_ctrl('P');
	RJMP _0x20D
;    1913  }
;    1914  else if(cam_dir!=0 & (ir_dir==0|center_front<2) )
_0x130:
	MOV  R26,R16
	LDI  R30,LOW(0)
	CALL __NEB12
	PUSH R30
	CALL SUBOPT_0x1D
	PUSH R30
	LDS  R26,_center_front
	LDS  R27,_center_front+1
	LDI  R30,LOW(2)
	LDI  R31,HIGH(2)
	CALL __LTW12
	POP  R26
	OR   R30,R26
	POP  R26
	AND  R30,R26
	BREQ _0x132
;    1915  {
;    1916   motor_ctrl(cam_dir);
	MOV  R30,R16
	LDI  R31,0
	RJMP _0x20E
;    1917  }
;    1918  else if(ir_dir!='G' & ir_dir!=0 & center_front>1)
_0x132:
	MOV  R26,R17
	LDI  R30,LOW(71)
	CALL __NEB12
	PUSH R30
	LDI  R30,LOW(0)
	CALL __NEB12
	POP  R26
	AND  R30,R26
	PUSH R30
	LDS  R26,_center_front
	LDS  R27,_center_front+1
	LDI  R30,LOW(1)
	LDI  R31,HIGH(1)
	CALL __GTW12
	POP  R26
	AND  R30,R26
	BREQ _0x134
;    1919  {
;    1920   motor_ctrl(ir_dir);
	MOV  R30,R17
	LDI  R31,0
	RJMP _0x20E
;    1921  }
;    1922  else
_0x134:
;    1923  {
;    1924   motor_ctrl('P');
_0x20D:
	LDI  R30,LOW(80)
	LDI  R31,HIGH(80)
_0x20E:
	ST   -Y,R31
	ST   -Y,R30
	CALL _motor_ctrl
;    1925  }
_0x12F:
;    1926 
;    1927 LCD_Display(50); 
	CALL SUBOPT_0x1E
;    1928 return ir_dir; 
	MOV  R30,R17
	RJMP _0x1FB
;    1929 }
;    1930 #include <mega128.h>
;    1931 
;    1932 #define laser_size      5
;    1933 
;    1934 char object_cd[8];

	.DSEG
_object_cd:
	.BYTE 0x8
;    1935 unsigned char laser_center;
_laser_center:
	.BYTE 0x1
;    1936 char dest;
_dest:
	.BYTE 0x1
;    1937 
;    1938 
;    1939 void LookForLaser();
;    1940 void LookForHome(char known);
;    1941 void FindLaserOnObject();
;    1942 void TakeHome();
;    1943 void FindObject();
;    1944 void DropObject();
;    1945 char find_laser();
;    1946 char track_laser();
;    1947 void look_around();
;    1948 
;    1949 
;    1950 void adjust_leds()
;    1951 {

	.CSEG
_adjust_leds:
;    1952 led_dc+=5;
	LDI  R30,LOW(5)
	ADD  R8,R30
;    1953  if(led_dc>125)
	LDI  R30,LOW(125)
	CP   R30,R8
	BRSH _0x136
;    1954  {
;    1955  led_dc=0;
	CLR  R8
;    1956  }
;    1957  
;    1958 }
_0x136:
	RET
;    1959 /********************************************
;    1960 
;    1961 ********************************************/
;    1962 void LookForLaser()
;    1963 {
_LookForLaser:
;    1964 led_dc=0;
	CLR  R8
;    1965 color=0;
	CALL SUBOPT_0x1F
;    1966 dest=0;
;    1967 FindLaserOnObject();
	RCALL _FindLaserOnObject
;    1968 FindObject();
	RCALL _FindObject
;    1969 } 
	RET
;    1970 
;    1971 void FindLaserOnObject()
;    1972 {
_FindLaserOnObject:
;    1973 char Loaded;
;    1974 char i;
;    1975 Loaded=0;
	ST   -Y,R17
	ST   -Y,R16
;	Loaded -> R16
;	i -> R17
	LDI  R16,LOW(0)
;    1976 color=0;
	CALL SUBOPT_0x1F
;    1977 dest=0;
;    1978 laser_center=0;
	LDI  R30,LOW(0)
	STS  _laser_center,R30
;    1979                      
;    1980 if(track_laser()==1)
	RCALL _track_laser
	CPI  R30,LOW(0x1)
	BRNE _0x137
;    1981 {
;    1982 led_dc=75;
	CALL SUBOPT_0x20
;    1983 new_trackdata=0;
	BLD  R3,2
;    1984 }
;    1985 
;    1986 LCD_Display(100);
_0x137:
	CALL SUBOPT_0x21
;    1987 
;    1988 if(wait_for_trackdata()==1 & laser_center!=0)
	CALL SUBOPT_0x1B
	PUSH R30
	LDS  R26,_laser_center
	LDI  R30,LOW(0)
	CALL __NEB12
	POP  R26
	AND  R30,R26
	BREQ _0x138
;    1989 {
;    1990  new_trackdata=0; 
	CLT
	BLD  R3,2
;    1991         for(i=0;i<blobs;i+=1)           //cycle through all tracked colors looking for known color
	LDI  R17,LOW(0)
_0x13A:
	LDS  R30,_blobs
	CP   R17,R30
	BRSH _0x13B
;    1992         { 
;    1993                 if(object[i][0]<8 & object[i][0]>0 & (object[i][2]-laser_center)<15)     //test for proximity to laser center
	CALL SUBOPT_0x22
	LDI  R30,LOW(8)
	CALL __LTB12U
	PUSH R30
	CALL SUBOPT_0x22
	LDI  R30,LOW(0)
	CALL __GTB12U
	POP  R26
	AND  R30,R26
	PUSH R30
	CALL SUBOPT_0x23
	CALL SUBOPT_0x24
	POP  R26
	AND  R30,R26
	BREQ _0x13C
;    1994                 {
;    1995                 color=object[i][0];
	CALL SUBOPT_0x23
	CALL SUBOPT_0x25
;    1996                         while(Loaded!='G')              //Approach and then pickup with gripper
_0x13D:
	CPI  R16,71
	BREQ _0x13F
;    1997                         { 
;    1998                         Loaded=GetObject();
	CALL _GetObject
	MOV  R16,R30
;    1999                         if(Loaded=='G')
	CPI  R16,71
	BREQ _0x13F
;    2000                                 break;
;    2001                         }
	RJMP _0x13D
_0x13F:
;    2002                         motor_ctrl('c'); 
	CALL SUBOPT_0x26
;    2003                         LCD_Display(1750);    
;    2004                         LookForHome(0);          //Look for Destination and then transfer it
	LDI  R30,LOW(0)
	ST   -Y,R30
	RCALL _LookForHome
;    2005                         new_trackdata=0;
	CLT
	BLD  R3,2
;    2006                         break;                                //Start process over again
	RJMP _0x13B
;    2007                 }              
;    2008       
;    2009       }
_0x13C:
	SUBI R17,-LOW(1)
	RJMP _0x13A
_0x13B:
;    2010  }
;    2011 }
_0x138:
	RJMP _0x1FB
;    2012 
;    2013 char track_laser()
;    2014 {
_track_laser:
	PUSH R15
;    2015 char laser;
;    2016 bit found_once;
;    2017 led_dc=0;
	ST   -Y,R16
;	laser -> R16
;	found_once -> R15.0
	CLR  R8
;    2018 found_once=0;
	CLT
	BLD  R15,0
;    2019  while(1)            //approach while the laser is trackable,get location
_0x141:
;    2020  {
;    2021         LCD_Display(100);
;	found_once -> R15.0
	CALL SUBOPT_0x21
;    2022         laser=find_laser();
	RCALL _find_laser
	MOV  R16,R30
;    2023         if(laser==8)      //break if no laser is found
	CPI  R16,8
	BREQ _0x143
;    2024         {
;    2025         break;
;	found_once -> R15.0
;    2026         }
;    2027         found_once=1;        
	SET
	BLD  R15,0
;    2028         motor_ctrl(track_object(laser));
	ST   -Y,R16
	CALL _track_object
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	CALL _motor_ctrl
;    2029         laser_center=object[laser][2];         //x position of laser
	CALL SUBOPT_0x27
	ADD  R30,R26
	ADC  R31,R27
	LDD  R30,Z+2
	STS  _laser_center,R30
;    2030  }
	RJMP _0x141
_0x143:
;    2031  return found_once;  
	LDI  R30,0
	SBRC R15,0
	LDI  R30,1
	LD   R16,Y+
	POP  R15
	RET
;    2032 }
;    2033 
;    2034 char wait_for_trackdata()
;    2035 {
_wait_for_trackdata:
	PUSH R15
;    2036 bit new_data;
;    2037 new_data=1;
;	new_data -> R15.0
	SET
	BLD  R15,0
;    2038 LB=0;
	LDI  R30,LOW(0)
	STS  _LB,R30
;    2039 while(new_trackdata==0)             //wait for new packets
_0x145:
	SBRC R3,2
	RJMP _0x147
;    2040 { 
;    2041  if(LB>2)                        //LB is inc in T2OVF
;	new_data -> R15.0
	LDS  R26,_LB
	LDI  R30,LOW(2)
	CP   R30,R26
	BRSH _0x148
;    2042  {
;    2043   new_data=0;                                  //if too many, break out of loop    
;	new_data -> R15.0
	CLT
	BLD  R15,0
;    2044   break;
	RJMP _0x147
;    2045  }
;    2046  
;    2047 } 
_0x148:
	RJMP _0x145
_0x147:
;    2048 return new_data;                 //return one if new data available, zero if no new packets rx before timeout(LB)
	LDI  R30,0
	SBRC R15,0
	LDI  R30,1
	POP  R15
	RET
;    2049 }
;    2050 
;    2051 char find_laser()
;    2052 {
_find_laser:
;    2053 char k,laser;
;    2054  
;    2055 if(wait_for_trackdata()==1)
	ST   -Y,R17
	ST   -Y,R16
;	k -> R16
;	laser -> R17
	CALL _wait_for_trackdata
	CPI  R30,LOW(0x1)
	BRNE _0x149
;    2056 {
;    2057 for(k=0;k<blobs;k+=1)
	LDI  R16,LOW(0)
_0x14B:
	LDS  R30,_blobs
	CP   R16,R30
	BRSH _0x14C
;    2058         {
;    2059         if(object[k][0]==0)             //Find slot
	CALL SUBOPT_0x27
	ADD  R26,R30
	ADC  R27,R31
	LD   R30,X
	CPI  R30,0
	BRNE _0x14D
;    2060                 {
;    2061                 laser=k;
	MOV  R17,R16
;    2062                 break;                  //break out and go home
	RJMP _0x14C
;    2063                 }
;    2064         if(k==blobs-1)
_0x14D:
	CALL SUBOPT_0x28
	BRNE _0x14E
;    2065                 {
;    2066                 laser=8;
	LDI  R17,LOW(8)
;    2067                 motor_ctrl('P');        //turn off motors
	CALL SUBOPT_0x15
;    2068                 }
;    2069         }
_0x14E:
	SUBI R16,-LOW(1)
	RJMP _0x14B
_0x14C:
;    2070   new_trackdata=0;
	CLT
	BLD  R3,2
;    2071   LB=0;
	LDI  R30,LOW(0)
	STS  _LB,R30
;    2072 }
;    2073 else                            //No new tracking packets have come in
	RJMP _0x14F
_0x149:
;    2074 {
;    2075  motor_ctrl('P');
	CALL SUBOPT_0x15
;    2076  laser=8;
	LDI  R17,LOW(8)
;    2077 }  
_0x14F:
;    2078  return laser;
	MOV  R30,R17
	RJMP _0x1FB
;    2079 }
;    2080 
;    2081 char find_dest_color()
;    2082 {
_find_dest_color:
;    2083  char k,slot;
;    2084  k=0;
	ST   -Y,R17
	ST   -Y,R16
;	k -> R16
;	slot -> R17
	LDI  R16,LOW(0)
;    2085   for(k=0;k<blobs;k+=1)         //look for a colors slot position in tracking packet
	LDI  R16,LOW(0)
_0x151:
	LDS  R30,_blobs
	CP   R16,R30
	BRSH _0x152
;    2086         {
;    2087         if(object[k][0]==dest)              //Find destination slot
	CALL SUBOPT_0x27
	ADD  R26,R30
	ADC  R27,R31
	LD   R30,X
	LDS  R26,_dest
	CP   R30,R26
	BRNE _0x153
;    2088                 {
;    2089                 slot=k;
	MOV  R17,R16
;    2090                 break;                                        //break out and go home
	RJMP _0x152
;    2091                 }
;    2092         if(k==blobs-1)
_0x153:
	CALL SUBOPT_0x28
	BRNE _0x154
;    2093                 {
;    2094                 slot=8;
	LDI  R17,LOW(8)
;    2095                 adjust_leds();
	CALL _adjust_leds
;    2096                 motor_ctrl('C');        //turn off motors,could be stuck in loop until dest is found
	CALL SUBOPT_0x29
;    2097                 }
;    2098         }
_0x154:
	SUBI R16,-LOW(1)
	RJMP _0x151
_0x152:
;    2099  return slot;
	MOV  R30,R17
	RJMP _0x1FB
;    2100 } 
;    2101 
;    2102 char find_object_color()
;    2103 {
_find_object_color:
;    2104  char k,slot;
;    2105  k=0;
	ST   -Y,R17
	ST   -Y,R16
;	k -> R16
;	slot -> R17
	LDI  R16,LOW(0)
;    2106  for(k=0;k<blobs;k+=1)
	LDI  R16,LOW(0)
_0x156:
	LDS  R30,_blobs
	CP   R16,R30
	BRSH _0x157
;    2107  {
;    2108         if(object[k][0]==color)              //Find destination slot
	CALL SUBOPT_0x27
	CALL SUBOPT_0x2A
	CP   R30,R26
	BRNE _0x158
;    2109                 {
;    2110                 slot=k;
	MOV  R17,R16
;    2111                 break;                                        //break out and go home
	RJMP _0x157
;    2112                 }
;    2113         if(k==blobs-1)
_0x158:
	CALL SUBOPT_0x28
	BRNE _0x159
;    2114                 {
;    2115                 slot=8;
	LDI  R17,LOW(8)
;    2116                 adjust_leds();
	CALL _adjust_leds
;    2117                 //motor_ctrl('P');        //turn off motors,could be stuck in loop until object is found
;    2118                 }
;    2119  }
_0x159:
	SUBI R16,-LOW(1)
	RJMP _0x156
_0x157:
;    2120  
;    2121  return slot;
	MOV  R30,R17
_0x1FB:
	LD   R16,Y+
	LD   R17,Y+
	RET
;    2122 } 
;    2123  
;    2124 void LookForHome(char known)
;    2125 {
_LookForHome:
;    2126 char k;
;    2127 laser_center=0;
	ST   -Y,R16
;	known -> Y+1
;	k -> R16
	LDI  R30,LOW(0)
	STS  _laser_center,R30
;    2128 k=0;
	LDI  R16,LOW(0)
;    2129  if(known==0)
	LDD  R30,Y+1
	CPI  R30,0
	BREQ PC+3
	JMP _0x15A
;    2130  { 
;    2131  while(got_object==1)
_0x15B:
	SBRS R3,4
	RJMP _0x15D
;    2132  {
;    2133         if(track_laser()==1)
	CALL _track_laser
	CPI  R30,LOW(0x1)
	BRNE _0x15E
;    2134         {
;    2135         led_dc=75;
	CALL SUBOPT_0x20
;    2136         new_trackdata=0;
	BLD  R3,2
;    2137         }
;    2138         else
	RJMP _0x15F
_0x15E:
;    2139         {
;    2140          //motor_ctrl('>');
;    2141          left_speed=2;
	LDI  R30,LOW(2)
	LDI  R31,HIGH(2)
	STS  _left_speed,R30
	STS  _left_speed+1,R31
;    2142          right_speed=-2;
	LDI  R30,LOW(65534)
	LDI  R31,HIGH(65534)
	STS  _right_speed,R30
	STS  _right_speed+1,R31
;    2143         }
_0x15F:
;    2144         LCD_Display(50);
	CALL SUBOPT_0x1E
;    2145      
;    2146         if(wait_for_trackdata()==1 & laser_center!=8)         //look for laser
	CALL SUBOPT_0x1B
	PUSH R30
	LDS  R26,_laser_center
	LDI  R30,LOW(8)
	CALL __NEB12
	POP  R26
	AND  R30,R26
	BREQ _0x160
;    2147         {
;    2148         new_trackdata=0;
	CLT
	BLD  R3,2
;    2149                 for(k=0;k<blobs;k+=1)
	LDI  R16,LOW(0)
_0x162:
	LDS  R30,_blobs
	CP   R16,R30
	BRSH _0x163
;    2150                 { 
;    2151                 if(object[k][0]<8 & object[k][0]>0 & object[k][0]!=color & (object[k][2]-laser_center)<15)      //test for proximity
	CALL SUBOPT_0x27
	CALL SUBOPT_0x2B
	PUSH R30
	CALL SUBOPT_0x27
	CALL SUBOPT_0x2C
	POP  R26
	AND  R30,R26
	PUSH R30
	CALL SUBOPT_0x27
	CALL SUBOPT_0x2A
	CALL __NEB12
	POP  R26
	AND  R30,R26
	PUSH R30
	CALL SUBOPT_0x27
	CALL SUBOPT_0x24
	POP  R26
	AND  R30,R26
	BREQ _0x164
;    2152                 {
;    2153                 object_cd[color]=object[k][0];      //store objects color and destination
	CALL SUBOPT_0x2D
	PUSH R31
	PUSH R30
	CALL SUBOPT_0x27
	ADD  R26,R30
	ADC  R27,R31
	LD   R30,X
	POP  R26
	POP  R27
	ST   X,R30
;    2154                 dest=object_cd[color];             //assign destination
	CALL SUBOPT_0x2D
	LD   R30,Z
	STS  _dest,R30
;    2155                 TakeHome();                        //Look for destination to take it
	RCALL _TakeHome
;    2156                 break;
	RJMP _0x163
;    2157                 }       
;    2158                 }
_0x164:
	SUBI R16,-LOW(1)
	RJMP _0x162
_0x163:
;    2159         }
;    2160         else
	RJMP _0x165
_0x160:
;    2161         {
;    2162         // left_speed=3;
;    2163         // right_speed=-3;
;    2164         motor_ctrl('P');
	CALL SUBOPT_0x15
;    2165         }
_0x165:
;    2166  }
	RJMP _0x15B
_0x15D:
;    2167  }
;    2168 //the object is recognized and its destination known.
;    2169 else
	RJMP _0x166
_0x15A:
;    2170 {   
;    2171    TakeHome();
	RCALL _TakeHome
;    2172 } 
_0x166:
;    2173 color=0;
	CALL SUBOPT_0x1F
;    2174 dest=0; 
;    2175 } 
	LDD  R16,Y+0
	RJMP _0x1F9
;    2176 
;    2177 void TakeHome()
;    2178 { 
_TakeHome:
;    2179 char camera_dir;
;    2180 while(1)
	ST   -Y,R16
;	camera_dir -> R16
_0x167:
;    2181 {
;    2182         if(wait_for_trackdata()==1)
	CALL _wait_for_trackdata
	CPI  R30,LOW(0x1)
	BRNE _0x16A
;    2183         {
;    2184         camera_dir=track_object(find_dest_color());
	CALL _find_dest_color
	CALL SUBOPT_0x1C
;    2185         new_trackdata=0;
	CLT
	BLD  R3,2
;    2186         }
;    2187         else
	RJMP _0x16B
_0x16A:
;    2188         {
;    2189          camera_dir='>';
	LDI  R16,LOW(62)
;    2190         }
_0x16B:
;    2191         
;    2192  analyse_ir();
	CALL _analyse_ir
;    2193  
;    2194         if(((right_front==left_front & right_front>2)|SonarInches[0]<6|SonarInches[1]<6)&camera_dir=='S')
	CALL SUBOPT_0x19
	PUSH R30
	LDS  R26,_right_front
	LDS  R27,_right_front+1
	LDI  R30,LOW(2)
	LDI  R31,HIGH(2)
	CALL __GTW12
	POP  R26
	AND  R30,R26
	PUSH R30
	LDS  R26,_SonarInches
	LDS  R27,_SonarInches+1
	LDI  R30,LOW(6)
	LDI  R31,HIGH(6)
	CALL __LTW12
	POP  R26
	OR   R30,R26
	PUSH R30
	__GETW2MN _SonarInches,2
	LDI  R30,LOW(6)
	LDI  R31,HIGH(6)
	CALL __LTW12
	POP  R26
	OR   R30,R26
	PUSH R30
	MOV  R26,R16
	LDI  R30,LOW(83)
	CALL __EQB12
	POP  R26
	AND  R30,R26
	BREQ _0x16C
;    2195         {
;    2196         DropObject();
	RCALL _DropObject
;    2197         break;
	RJMP _0x169
;    2198         }
;    2199         else if(camera_dir!=0)
_0x16C:
	CPI  R16,0
	BREQ _0x16E
;    2200         {
;    2201          motor_ctrl(camera_dir);
	MOV  R30,R16
	LDI  R31,0
	RJMP _0x20F
;    2202         }
;    2203         else if(camera_dir==0)
_0x16E:
	CPI  R16,0
	BRNE _0x170
;    2204         {
;    2205          motor_ctrl('>');
	LDI  R30,LOW(62)
	LDI  R31,HIGH(62)
_0x20F:
	ST   -Y,R31
	ST   -Y,R30
	CALL _motor_ctrl
;    2206         }
;    2207  LCD_Display(100);
_0x170:
	CALL SUBOPT_0x21
;    2208 }
	RJMP _0x167
_0x169:
;    2209 }
	RJMP _0x1FA
;    2210 
;    2211 void DropObject()
;    2212 {
_DropObject:
;    2213  motor_ctrl('P');
	CALL SUBOPT_0x15
;    2214  delay_ms(250);
	LDI  R30,LOW(250)
	LDI  R31,HIGH(250)
	ST   -Y,R31
	ST   -Y,R30
	CALL _delay_ms
;    2215  tilt_ctrl('C');
	CALL SUBOPT_0x2E
;    2216  delay_ms(500);
	CALL SUBOPT_0x16
;    2217  grip_ctrl('O');        //open clamp
	CALL SUBOPT_0x2F
;    2218  motor_ctrl('B');
	LDI  R30,LOW(66)
	LDI  R31,HIGH(66)
	ST   -Y,R31
	ST   -Y,R30
	CALL _motor_ctrl
;    2219  delay_ms(500);
	CALL SUBOPT_0x16
;    2220  motor_ctrl('C');
	CALL SUBOPT_0x29
;    2221  delay_ms(1400);
	LDI  R30,LOW(1400)
	LDI  R31,HIGH(1400)
	ST   -Y,R31
	ST   -Y,R30
	CALL _delay_ms
;    2222  got_object=0;
	CLT
	BLD  R3,4
;    2223 }
	RET
;    2224 
;    2225 void FindObject()
;    2226 {
_FindObject:
;    2227 char Loaded;
;    2228 Loaded=0;
	ST   -Y,R16
;	Loaded -> R16
	LDI  R16,LOW(0)
;    2229 
;    2230 if(wait_for_trackdata()==1)
	CALL _wait_for_trackdata
	CPI  R30,LOW(0x1)
	BREQ PC+3
	JMP _0x171
;    2231 {
;    2232  new_trackdata=0;
	CLT
	BLD  R3,2
;    2233  for (i=0;i<blobs;i+=1) 
	LDI  R30,LOW(0)
	STS  _i,R30
_0x173:
	LDS  R30,_blobs
	LDS  R26,_i
	CP   R26,R30
	BRSH _0x174
;    2234    {
;    2235      if(object[i][0]<8 & object[i][0]>0 & object_cd[object[i][0]]!=0)  //Determine if familiar
	CALL SUBOPT_0x30
	CALL SUBOPT_0x2B
	PUSH R30
	CALL SUBOPT_0x30
	CALL SUBOPT_0x2C
	POP  R26
	AND  R30,R26
	PUSH R30
	CALL SUBOPT_0x30
	ADD  R26,R30
	ADC  R27,R31
	LD   R30,X
	LDI  R31,0
	SUBI R30,LOW(-_object_cd)
	SBCI R31,HIGH(-_object_cd)
	LD   R30,Z
	LDI  R26,LOW(0)
	CALL __NEB12
	POP  R26
	AND  R30,R26
	BREQ _0x175
;    2236      {          
;    2237         color=object[i][0];         //object color
	CALL SUBOPT_0x30
	CALL SUBOPT_0x25
;    2238         dest=object_cd[color];
	CALL SUBOPT_0x2D
	LD   R30,Z
	STS  _dest,R30
;    2239         break;       
	RJMP _0x174
;    2240      }
;    2241      else if(i==blobs-1)
_0x175:
	LDS  R30,_blobs
	SUBI R30,LOW(1)
	LDS  R26,_i
	CP   R30,R26
	BRNE _0x177
;    2242      {
;    2243      adjust_leds(); 
	CALL _adjust_leds
;    2244      //color=0;   //non-existant color choice
;    2245      break; 
	RJMP _0x174
;    2246      }
;    2247     }
_0x177:
	LDS  R30,_i
	SUBI R30,-LOW(1)
	STS  _i,R30
	RJMP _0x173
_0x174:
;    2248     
;    2249 if(color!=0)
	LDS  R30,_color
	CPI  R30,0
	BREQ _0x178
;    2250 {
;    2251 while(Loaded!='G')
_0x179:
	CPI  R16,71
	BREQ _0x17B
;    2252 {       
;    2253  Loaded=GetObject();
	CALL _GetObject
	MOV  R16,R30
;    2254 }
	RJMP _0x179
_0x17B:
;    2255  motor_ctrl('c'); 
	CALL SUBOPT_0x26
;    2256  LCD_Display(1750);
;    2257  LookForHome(1);
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _LookForHome
;    2258 }
;    2259 }
_0x178:
;    2260 
;    2261 }
_0x171:
_0x1FA:
	LD   R16,Y+
	RET
;    2262 
;    2263 void LCD_Display(int delay)
;    2264 {  
_LCD_Display:
;    2265      lcd_clear();      
	CALL _lcd_clear
;    2266  /*    
;    2267      lcd_PrintInt(IR_Result[0][18]);
;    2268      lcd_putsf(" ");
;    2269      lcd_PrintInt(IR_Result[1][18]);
;    2270      lcd_putsf(" "); 
;    2271      lcd_PrintInt(IR_Result[3][18]);
;    2272      lcd_putsf(" ");
;    2273      lcd_PrintInt(IR_Result[2][18]);
;    2274      lcd_putsf(" ");
;    2275      lcd_PrintInt(IR_Result[4][18]);
;    2276      lcd_putsf("_");
;    2277      lcd_PrintInt(SonarInches[0]);
;    2278      lcd_putsf(" ");
;    2279      lcd_PrintInt(SonarInches[1]);
;    2280   */   
;    2281      
;    2282    //  for(k=6;k<=18;k+=1)
;    2283    //  {
;    2284    //   temp=IR_Result[4][k];
;    2285    
;    2286       lcd_PrintInt(IR_Result[3][18]);
	__GETD1MN _IR_Result,300
	CALL SUBOPT_0x31
;    2287       lcd_gotoxy(2,0);
	LDI  R30,LOW(2)
	CALL SUBOPT_0x32
;    2288       lcd_PrintInt(IR_Result[4][18]);
	__GETD1MN _IR_Result,376
	CALL SUBOPT_0x31
;    2289       lcd_gotoxy(4,0);
	LDI  R30,LOW(4)
	CALL SUBOPT_0x32
;    2290       lcd_PrintInt(IR_Result[2][18]);
	__GETD1MN _IR_Result,224
	CALL SUBOPT_0x31
;    2291       lcd_gotoxy(6,0);
	LDI  R30,LOW(6)
	CALL SUBOPT_0x32
;    2292       lcd_putsf("_");
	__POINTW1FN _0,97
	ST   -Y,R31
	ST   -Y,R30
	CALL _lcd_putsf
;    2293       lcd_PrintInt(led_dc); 
	MOV  R30,R8
	CALL SUBOPT_0x33
;    2294       lcd_gotoxy(10,0);
	LDI  R30,LOW(10)
	CALL SUBOPT_0x32
;    2295       lcd_putsf("_");
	__POINTW1FN _0,97
	ST   -Y,R31
	ST   -Y,R30
	CALL _lcd_putsf
;    2296       lcd_PrintInt(num_blobs);
	LDS  R30,_num_blobs
	CALL SUBOPT_0x33
;    2297       num_blobs=0;
	LDI  R30,LOW(0)
	STS  _num_blobs,R30
;    2298       lcd_putsf("_");
	__POINTW1FN _0,97
	ST   -Y,R31
	ST   -Y,R30
	CALL _lcd_putsf
;    2299       lcd_PrintInt(object[0][0]);
	LDS  R30,_object
	CALL SUBOPT_0x33
;    2300       lcd_PrintInt(object[1][0]);
	__GETB1MN _object,4
	CALL SUBOPT_0x33
;    2301       lcd_PrintInt(object[2][0]); 
	__GETB1MN _object,8
	CALL SUBOPT_0x33
;    2302       lcd_putsf("_");
	__POINTW1FN _0,97
	ST   -Y,R31
	ST   -Y,R30
	CALL _lcd_putsf
;    2303       lcd_PrintInt(color);
	LDS  R30,_color
	CALL SUBOPT_0x33
;    2304       lcd_PrintInt(dest);
	LDS  R30,_dest
	CALL SUBOPT_0x33
;    2305       
;    2306       
;    2307      // lcd_gotoxy(15,0);
;    2308      // lcd_putsf("_");
;    2309      // lcd_PrintInt(IRMAX);
;    2310     /// }
;    2311      
;    2312      lcd_gotoxy(0,1);
	LDI  R30,LOW(0)
	ST   -Y,R30
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL _lcd_gotoxy
;    2313      lcd_PrintInt(Amps);
	ST   -Y,R12
	ST   -Y,R11
	CALL _lcd_PrintInt
;    2314      
;    2315   //   lcd_putsf(" ");
;    2316   //   lcd_PrintInt(led_dc); 
;    2317 
;    2318      lcd_putsf("_");
	__POINTW1FN _0,97
	ST   -Y,R31
	ST   -Y,R30
	CALL _lcd_putsf
;    2319      lcd_PrintInt(left_front);
	LDS  R30,_left_front
	LDS  R31,_left_front+1
	ST   -Y,R31
	ST   -Y,R30
	CALL _lcd_PrintInt
;    2320      lcd_putsf(" ");
	__POINTW1FN _0,95
	ST   -Y,R31
	ST   -Y,R30
	CALL _lcd_putsf
;    2321      lcd_PrintInt(center_front);
	LDS  R30,_center_front
	LDS  R31,_center_front+1
	ST   -Y,R31
	ST   -Y,R30
	CALL _lcd_PrintInt
;    2322      lcd_putsf(" ");
	__POINTW1FN _0,95
	ST   -Y,R31
	ST   -Y,R30
	CALL _lcd_putsf
;    2323      lcd_PrintInt(right_front); 
	LDS  R30,_right_front
	LDS  R31,_right_front+1
	ST   -Y,R31
	ST   -Y,R30
	CALL _lcd_PrintInt
;    2324      lcd_putsf("_");
	__POINTW1FN _0,97
	ST   -Y,R31
	ST   -Y,R30
	CALL _lcd_putsf
;    2325      lcd_PrintInt(left_speed);
	LDS  R30,_left_speed
	LDS  R31,_left_speed+1
	ST   -Y,R31
	ST   -Y,R30
	CALL _lcd_PrintInt
;    2326      lcd_putsf(" ");
	__POINTW1FN _0,95
	ST   -Y,R31
	ST   -Y,R30
	CALL _lcd_putsf
;    2327      lcd_PrintInt(right_speed);
	LDS  R30,_right_speed
	LDS  R31,_right_speed+1
	ST   -Y,R31
	ST   -Y,R30
	CALL _lcd_PrintInt
;    2328      lcd_putsf(" ");
	__POINTW1FN _0,95
	ST   -Y,R31
	ST   -Y,R30
	CALL _lcd_putsf
;    2329      lcd_putchar(approach_object());
	CALL _approach_object
	ST   -Y,R30
	CALL _lcd_putchar
;    2330      lcd_putsf(" ");
	__POINTW1FN _0,95
	ST   -Y,R31
	ST   -Y,R30
	CALL _lcd_putsf
;    2331      lcd_PrintInt(SonarInches[0]);
	LDS  R30,_SonarInches
	LDS  R31,_SonarInches+1
	ST   -Y,R31
	ST   -Y,R30
	CALL _lcd_PrintInt
;    2332      lcd_putsf(" ");
	__POINTW1FN _0,95
	ST   -Y,R31
	ST   -Y,R30
	CALL _lcd_putsf
;    2333      lcd_PrintInt(SonarInches[1]);          
	__GETW1MN _SonarInches,2
	ST   -Y,R31
	ST   -Y,R30
	CALL _lcd_PrintInt
;    2334      
;    2335      delay_ms(delay);
	LD   R30,Y
	LDD  R31,Y+1
	ST   -Y,R31
	ST   -Y,R30
	CALL _delay_ms
;    2336 }
_0x1F9:
	ADIW R28,2
	RET
;    2337 #include <mega128.h> 
;    2338 #include <lcd.h>
;    2339 
;    2340 #define ADC_VREF_TYPE 0x00
;    2341 
;    2342 // Declare your global variables here
;    2343 //char i;
;    2344 
;    2345 int k;

	.DSEG
_k:
	.BYTE 0x2
;    2346 char x;
_x:
	.BYTE 0x1
;    2347 char temp1;
_temp1:
	.BYTE 0x1
;    2348 char Dir[]="PSCLl<>rRcB";
_Dir:
	.BYTE 0xC
;    2349 void main(void)
;    2350 {

	.CSEG
_main:
;    2351 // Declare your local variables here
;    2352 
;    2353 // Input/Output Ports initialization
;    2354 // Port A initialization
;    2355 // OUT
;    2356 // State=0 
;    2357 PORTA=0x00;
	LDI  R30,LOW(0)
	OUT  0x1B,R30
;    2358 DDRA=0xFF;
	LDI  R30,LOW(255)
	OUT  0x1A,R30
;    2359 
;    2360 // Port B initialization
;    2361 // Func7=OUT Func6=OUT Func5=OUT Func4=OUT Func3=OUT Func2=OUT Func1=In Func0=LED 
;    2362 // State7=0 State6=0 State5=0 State4=0 State3=0 State2=0 State1=T State0=0 
;    2363 PORTB=0x00;
	LDI  R30,LOW(0)
	OUT  0x18,R30
;    2364 DDRB=0xFD;
	LDI  R30,LOW(253)
	OUT  0x17,R30
;    2365 
;    2366 // Port C initialization
;    2367 // Func=OUT 
;    2368 // State=0
;    2369 PORTC=0x00;
	LDI  R30,LOW(0)
	OUT  0x15,R30
;    2370 DDRC=0xFF;
	LDI  R30,LOW(255)
	OUT  0x14,R30
;    2371 
;    2372 // Port D initialization
;    2373 // Func7=OUT Func6=OUT Func5=In Func4=In Func3=In Func2=In Func1=In Func0=In 
;    2374 // State7=0 State6=0 State5=T State4=T State3=T State2=T State1=T State0=T 
;    2375 PORTD=0x00;
	LDI  R30,LOW(0)
	OUT  0x12,R30
;    2376 DDRD=0xC0;
	LDI  R30,LOW(192)
	OUT  0x11,R30
;    2377 
;    2378 // Port E initialization
;    2379 // Func7=In Func6=In Func5=In Func4=In Func3=OUT Func2=In Func1=In Func0=In 
;    2380 // State7=T State6=T State5=T State4=T State3=0 State2=T State1=T State0=T 
;    2381 PORTE=0x00;
	LDI  R30,LOW(0)
	OUT  0x3,R30
;    2382 DDRE=0x08;
	LDI  R30,LOW(8)
	OUT  0x2,R30
;    2383 
;    2384 // Port F initialization
;    2385 // Func7=In Func6=In Func5=In Func4=In Func3=In Func2=In Func1=In Func0=In 
;    2386 // State7=T State6=T State5=T State4=T State3=T State2=T State1=T State0=T 
;    2387 PORTF=0x00;
	LDI  R30,LOW(0)
	STS  0x62,R30
;    2388 DDRF=0x00;
	STS  0x61,R30
;    2389 
;    2390 // Port G initialization
;    2391 // Func4=In Func3=In Func2=In Func1=In Func0=In 
;    2392 // State4=T State3=T State2=T State1=T State0=T 
;    2393 PORTG=0x00;
	STS  0x65,R30
;    2394 DDRG=0x00;
	STS  0x64,R30
;    2395 
;    2396 init_timer0();
	CALL _init_timer0
;    2397 
;    2398 init_timer1();
	CALL _init_timer1
;    2399 
;    2400 init_timer2();
	CALL _init_timer2
;    2401 
;    2402 init_timer3();
	CALL _init_timer3
;    2403 
;    2404 // Analog Comparator initialization
;    2405 // Analog Comparator: Off
;    2406 // Analog Comparator Input Capture by Timer/Counter 1: Off
;    2407 ACSR=0x80;
	LDI  R30,LOW(128)
	OUT  0x8,R30
;    2408 SFIOR=0x00;
	LDI  R30,LOW(0)
	OUT  0x20,R30
;    2409 
;    2410 lcd_init(20);
	LDI  R30,LOW(20)
	ST   -Y,R30
	CALL _lcd_init
;    2411 
;    2412 init_keypad();
	CALL _init_keypad
;    2413 
;    2414 init_ADC();
	CALL _init_ADC
;    2415 
;    2416 init_UART0();
	CALL _init_UART0
;    2417 
;    2418 init_camera();
	CALL _init_camera
;    2419 delay_ms(300);
	LDI  R30,LOW(300)
	LDI  R31,HIGH(300)
	ST   -Y,R31
	ST   -Y,R30
	CALL _delay_ms
;    2420 // Global enable interrupts
;    2421 #asm("sei")
	sei
;    2422 
;    2423 
;    2424 while (1)
_0x17C:
;    2425 {
;    2426       lcd_clear();
	CALL _lcd_clear
;    2427 LCD_Display(100);           
	CALL SUBOPT_0x21
;    2428 if(button==1)
	LDI  R30,LOW(1)
	CP   R30,R7
	BRNE _0x17F
;    2429       {
;    2430        motor_ctrl(analyse_sonar());
	CALL _analyse_sonar
	ST   -Y,R31
	ST   -Y,R30
	CALL _motor_ctrl
;    2431       }
;    2432       else if(button==2)
	RJMP _0x180
_0x17F:
	LDI  R30,LOW(2)
	CP   R30,R7
	BRNE _0x181
;    2433       {
;    2434        //motor_ctrl(analyse_ir());
;    2435        color=2;
	STS  _color,R30
;    2436        GetObject();
	CALL _GetObject
;    2437       } 
;    2438       else if(button==0)
	RJMP _0x182
_0x181:
	TST  R7
	BRNE _0x183
;    2439       {
;    2440        got_object=0;
	CLT
	BLD  R3,4
;    2441        left_speed=0;
	LDI  R30,0
	STS  _left_speed,R30
	STS  _left_speed+1,R30
;    2442        right_speed=0;
	LDI  R30,0
	STS  _right_speed,R30
	STS  _right_speed+1,R30
;    2443        analyse_ir();
	CALL _analyse_ir
;    2444       } 
;    2445       else if(button==3)
	RJMP _0x184
_0x183:
	LDI  R30,LOW(3)
	CP   R30,R7
	BRNE _0x185
;    2446       {
;    2447        arbitrator(analyse_sonar(),analyse_ir());
	CALL _analyse_sonar
	ST   -Y,R30
	CALL _analyse_ir
	ST   -Y,R30
	CALL _arbitrator
;    2448       }
;    2449       else if(button==4)
	RJMP _0x186
_0x185:
	LDI  R30,LOW(4)
	CP   R30,R7
	BRNE _0x187
;    2450       {
;    2451        gripper();
	CALL _gripper
;    2452        }
;    2453        else if(button==5)
	RJMP _0x188
_0x187:
	LDI  R30,LOW(5)
	CP   R30,R7
	BRNE _0x189
;    2454        {
;    2455         grip_ctrl('O');
	CALL SUBOPT_0x2F
;    2456        }
;    2457        else if(button==6)
	RJMP _0x18A
_0x189:
	LDI  R30,LOW(6)
	CP   R30,R7
	BRNE _0x18B
;    2458        {
;    2459         object_cd[4]=5; //hardwire object color to destination
	LDI  R30,LOW(5)
	__PUTB1MN _object_cd,4
;    2460         color=4;
	LDI  R30,LOW(4)
	STS  _color,R30
;    2461         FindObject();
	CALL _FindObject
;    2462        }
;    2463        else if(button==7)
	RJMP _0x18C
_0x18B:
	LDI  R30,LOW(7)
	CP   R30,R7
	BRNE _0x18D
;    2464        {
;    2465         tilt_ctrl('U');
	CALL SUBOPT_0x17
;    2466        }
;    2467        else if(button==8)
	RJMP _0x18E
_0x18D:
	LDI  R30,LOW(8)
	CP   R30,R7
	BRNE _0x18F
;    2468        {
;    2469         tilt_ctrl('C');
	CALL SUBOPT_0x2E
;    2470        }
;    2471        else if(button==9)
	RJMP _0x190
_0x18F:
	LDI  R30,LOW(9)
	CP   R30,R7
	BRNE _0x191
;    2472        {
;    2473         tilt_ctrl('D');
	LDI  R30,LOW(68)
	ST   -Y,R30
	CALL _tilt_ctrl
;    2474         }
;    2475         else if(button==10)
	RJMP _0x192
_0x191:
	LDI  R30,LOW(10)
	CP   R30,R7
	BRNE _0x193
;    2476         {
;    2477         while(button==10)
_0x194:
	LDI  R30,LOW(10)
	CP   R30,R7
	BRNE _0x196
;    2478          LookForLaser();
	CALL _LookForLaser
;    2479          //FindLaserOnObject();
;    2480          //LookForLaser();
;    2481          //GetObject(0);
;    2482          //FindObject();
;    2483          //LookForHome(0);
;    2484          //TakeHome(0);
;    2485          }
	RJMP _0x194
_0x196:
;    2486          else if (button==11)
	RJMP _0x197
_0x193:
	LDI  R30,LOW(11)
	CP   R30,R7
	BRNE _0x198
;    2487          {
;    2488          analyse_ir();
	CALL _analyse_ir
;    2489          IRMAX=IR_Result[4][18];
	__GETD1MN _IR_Result,376
	CALL __CFD1
	STS  _IRMAX,R30
;    2490          /* x+=1;
;    2491           button=0; 
;    2492           if(x==11)
;    2493           {
;    2494            x=0;
;    2495           }  */
;    2496              
;    2497 }    
;    2498 
;    2499 
;    2500                     
;    2501    LCD_Display(100);
_0x198:
_0x197:
_0x192:
_0x190:
_0x18E:
_0x18C:
_0x18A:
_0x188:
_0x186:
_0x184:
_0x182:
_0x180:
	CALL SUBOPT_0x21
;    2502    
;    2503 
;    2504 
;    2505 }
	RJMP _0x17C
;    2506 }
_0x199:
	RJMP _0x199

_itoa:
    ld   r26,y+
    ld   r27,y+
    ld   r30,y+
    ld   r31,y+
    adiw r30,0
    brpl __itoa0
    com  r30
    com  r31
    adiw r30,1
    ldi  r22,'-'
    st   x+,r22
__itoa0:
    clt
    ldi  r24,low(10000)
    ldi  r25,high(10000)
    rcall __itoa1
    ldi  r24,low(1000)
    ldi  r25,high(1000)
    rcall __itoa1
    ldi  r24,100
    clr  r25
    rcall __itoa1
    ldi  r24,10
    rcall __itoa1
    mov  r22,r30
    rcall __itoa5
    clr  r22
    st   x,r22
    ret
__itoa1:
    clr	 r22
__itoa2:
    cp   r30,r24
    cpc  r31,r25
    brlo __itoa3
    inc  r22
    sub  r30,r24
    sbc  r31,r25
    brne __itoa2
__itoa3:
    tst  r22
    brne __itoa4
    brts __itoa5
    ret
__itoa4:
    set
__itoa5:
    subi r22,-0x30
    st   x+,r22
    ret
    .equ __lcd_direction=__lcd_port-1
    .equ __lcd_pin=__lcd_port-2
    .equ __lcd_rs=0
    .equ __lcd_rd=1
    .equ __lcd_enable=2
    .equ __lcd_busy_flag=7

	.DSEG
__base_y_G10:
	.BYTE 0x4
__lcd_x:
	.BYTE 0x1
__lcd_y:
	.BYTE 0x1
__lcd_maxx:
	.BYTE 0x1

	.CSEG
__lcd_delay_G10:
    ldi   r31,15
__lcd_delay0:
    dec   r31
    brne  __lcd_delay0
	RET
__lcd_ready:
    in    r26,__lcd_direction
    andi  r26,0xf                 ;set as input
    out   __lcd_direction,r26
    sbi   __lcd_port,__lcd_rd     ;RD=1
    cbi   __lcd_port,__lcd_rs     ;RS=0
__lcd_busy:
	CALL __lcd_delay_G10
    sbi   __lcd_port,__lcd_enable ;EN=1
	CALL __lcd_delay_G10
    in    r26,__lcd_pin
    cbi   __lcd_port,__lcd_enable ;EN=0
	CALL __lcd_delay_G10
    sbi   __lcd_port,__lcd_enable ;EN=1
	CALL __lcd_delay_G10
    cbi   __lcd_port,__lcd_enable ;EN=0
    sbrc  r26,__lcd_busy_flag
    rjmp  __lcd_busy
	RET
__lcd_write_nibble_G10:
    andi  r26,0xf0
    or    r26,r27
    out   __lcd_port,r26          ;write
    sbi   __lcd_port,__lcd_enable ;EN=1
	CALL __lcd_delay_G10
    cbi   __lcd_port,__lcd_enable ;EN=0
	CALL __lcd_delay_G10
	RET
__lcd_write_data:
    cbi  __lcd_port,__lcd_rd 	  ;RD=0
    in    r26,__lcd_direction
    ori   r26,0xf0 | (1<<__lcd_rs) | (1<<__lcd_rd) | (1<<__lcd_enable) ;set as output    
    out   __lcd_direction,r26
    in    r27,__lcd_port
    andi  r27,0xf
    ld    r26,y
	CALL __lcd_write_nibble_G10
    ld    r26,y
    swap  r26
	CALL __lcd_write_nibble_G10
    sbi   __lcd_port,__lcd_rd     ;RD=1
	ADIW R28,1
	RET
__lcd_read_nibble_G10:
    sbi   __lcd_port,__lcd_enable ;EN=1
	CALL __lcd_delay_G10
    in    r30,__lcd_pin           ;read
    cbi   __lcd_port,__lcd_enable ;EN=0
	CALL __lcd_delay_G10
    andi  r30,0xf0
	RET
_lcd_read_byte0_G10:
	CALL __lcd_delay_G10
	CALL __lcd_read_nibble_G10
    mov   r26,r30
	CALL __lcd_read_nibble_G10
    cbi   __lcd_port,__lcd_rd     ;RD=0
    swap  r30
    or    r30,r26
	RET
_lcd_gotoxy:
	CALL __lcd_ready
	LD   R30,Y
	LDI  R31,0
	SUBI R30,LOW(-__base_y_G10)
	SBCI R31,HIGH(-__base_y_G10)
	LD   R30,Z
	LDD  R26,Y+1
	ADD  R30,R26
	ST   -Y,R30
	CALL __lcd_write_data
	LDD  R30,Y+1
	STS  __lcd_x,R30
	LD   R30,Y
	STS  __lcd_y,R30
	ADIW R28,2
	RET
_lcd_clear:
	CALL __lcd_ready
	LDI  R30,LOW(2)
	CALL SUBOPT_0x34
	LDI  R30,LOW(12)
	CALL SUBOPT_0x34
	LDI  R30,LOW(1)
	ST   -Y,R30
	CALL __lcd_write_data
	LDI  R30,LOW(0)
	STS  __lcd_y,R30
	STS  __lcd_x,R30
	RET
_lcd_putchar:
    push r30
    push r31
    ld   r26,y
    set
    cpi  r26,10
    breq __lcd_putchar1
    clt
	LDS  R30,__lcd_x
	SUBI R30,-LOW(1)
	STS  __lcd_x,R30
	LDS  R30,__lcd_maxx
	LDS  R26,__lcd_x
	CP   R30,R26
	BRSH _0x19B
	__lcd_putchar1:
	LDS  R30,__lcd_y
	SUBI R30,-LOW(1)
	STS  __lcd_y,R30
	LDI  R30,LOW(0)
	ST   -Y,R30
	LDS  R30,__lcd_y
	ST   -Y,R30
	CALL _lcd_gotoxy
	brts __lcd_putchar0
_0x19B:
    rcall __lcd_ready
    sbi  __lcd_port,__lcd_rs ;RS=1
    ld   r26,y
    st   -y,r26
    rcall __lcd_write_data
__lcd_putchar0:
    pop  r31
    pop  r30
	ADIW R28,1
	RET
_lcd_puts:
    ldd  r31,y+1
    ld   r30,y
__lcd_puts0:
    ld   r26,z+
    tst  r26
    breq __lcd_puts1
    st   -y,r26    
    rcall _lcd_putchar
    rjmp __lcd_puts0
__lcd_puts1:
	ADIW R28,2
	RET
_lcd_putsf:
    ld   r30,y
    ldd  r31,y+1
__lcd_putsf0:
	elpm
    tst  r0
    breq __lcd_putsf1
    adiw r30,1
    st   -y,r0
    rcall _lcd_putchar
    rjmp __lcd_putsf0
__lcd_putsf1:
	ADIW R28,2
	RET
__long_delay_G10:
    clr   r26
    clr   r27
__long_delay0:
    sbiw  r26,1         ;2 cycles
    brne  __long_delay0 ;2 cycles
	RET
__lcd_init_write_G10:
    cbi  __lcd_port,__lcd_rd 	  ;RD=0
    in    r26,__lcd_direction
    ori   r26,0xf7                ;set as output
    out   __lcd_direction,r26
    in    r27,__lcd_port
    andi  r27,0xf
    ld    r26,y
	CALL __lcd_write_nibble_G10
    sbi   __lcd_port,__lcd_rd     ;RD=1
	ADIW R28,1
	RET
_lcd_init:
    cbi   __lcd_port,__lcd_enable ;EN=0
    cbi   __lcd_port,__lcd_rs     ;RS=0
	LD   R30,Y
	STS  __lcd_maxx,R30
	SUBI R30,-LOW(128)
	__PUTB1MN __base_y_G10,2
	LD   R30,Y
	SUBI R30,-LOW(192)
	__PUTB1MN __base_y_G10,3
	CALL SUBOPT_0x35
	CALL SUBOPT_0x35
	CALL SUBOPT_0x35
	CALL __long_delay_G10
	LDI  R30,LOW(32)
	ST   -Y,R30
	CALL __lcd_init_write_G10
	CALL __long_delay_G10
	LDI  R30,LOW(40)
	CALL SUBOPT_0x36
	LDI  R30,LOW(4)
	CALL SUBOPT_0x36
	LDI  R30,LOW(133)
	CALL SUBOPT_0x36
    in    r26,__lcd_direction
    andi  r26,0xf                 ;set as input
    out   __lcd_direction,r26
    sbi   __lcd_port,__lcd_rd     ;RD=1
	CALL _lcd_read_byte0_G10
	CPI  R30,LOW(0x5)
	BREQ _0x19C
	LDI  R30,LOW(0)
	RJMP _0x1F8
_0x19C:
	CALL __lcd_ready
	LDI  R30,LOW(6)
	ST   -Y,R30
	CALL __lcd_write_data
	CALL _lcd_clear
	LDI  R30,LOW(1)
_0x1F8:
	ADIW R28,1
	RET
_getchar:
     sbis usr,rxc
     rjmp _getchar
     in   r30,udr
	RET
_putchar:
     sbis usr,udre
     rjmp _putchar
     ld   r30,y
     out  udr,r30
	ADIW R28,1
	RET
__put_G11:
	put:
	LD   R26,Y
	LDD  R27,Y+1
	CALL __GETW1P
	SBIW R30,0
	BREQ _0x19D
	CALL __GETW1P
	ADIW R30,1
	ST   X+,R30
	ST   X,R31
	SBIW R30,1
	LDD  R26,Y+2
	STD  Z+0,R26
	RJMP _0x19E
_0x19D:
	LDD  R30,Y+2
	ST   -Y,R30
	CALL _putchar
_0x19E:
	ADIW R28,3
	RET
__print_G11:
	SBIW R28,6
	CALL __SAVELOCR6
	LDI  R16,0
_0x19F:
	LDD  R30,Y+16
	LDD  R31,Y+16+1
	ADIW R30,1
	STD  Y+16,R30
	STD  Y+16+1,R31
	SBIW R30,1
	LPM  R30,Z
	MOV  R19,R30
	CPI  R30,0
	BRNE PC+3
	JMP _0x1A1
	MOV  R30,R16
	CPI  R30,0
	BRNE _0x1A5
	CPI  R19,37
	BRNE _0x1A6
	LDI  R16,LOW(1)
	RJMP _0x1A7
_0x1A6:
	CALL SUBOPT_0x37
_0x1A7:
	RJMP _0x1A4
_0x1A5:
	CPI  R30,LOW(0x1)
	BRNE _0x1A8
	CPI  R19,37
	BRNE _0x1A9
	CALL SUBOPT_0x37
	LDI  R16,LOW(0)
	RJMP _0x1A4
_0x1A9:
	LDI  R16,LOW(2)
	LDI  R21,LOW(0)
	LDI  R17,LOW(0)
	CPI  R19,45
	BRNE _0x1AA
	LDI  R17,LOW(1)
	RJMP _0x1A4
_0x1AA:
	CPI  R19,43
	BRNE _0x1AB
	LDI  R21,LOW(43)
	RJMP _0x1A4
_0x1AB:
	CPI  R19,32
	BRNE _0x1AC
	LDI  R21,LOW(32)
	RJMP _0x1A4
_0x1AC:
	RJMP _0x1AD
_0x1A8:
	CPI  R30,LOW(0x2)
	BRNE _0x1AE
_0x1AD:
	LDI  R20,LOW(0)
	LDI  R16,LOW(3)
	CPI  R19,48
	BRNE _0x1AF
	ORI  R17,LOW(128)
	RJMP _0x1A4
_0x1AF:
	RJMP _0x1B0
_0x1AE:
	CPI  R30,LOW(0x3)
	BREQ PC+3
	JMP _0x1A4
_0x1B0:
	CPI  R19,48
	BRLO _0x1B3
	CPI  R19,58
	BRLO _0x1B4
_0x1B3:
	RJMP _0x1B2
_0x1B4:
	MOV  R26,R20
	LDI  R30,LOW(10)
	MUL  R30,R26
	MOV  R30,R0
	MOV  R20,R30
	MOV  R30,R19
	SUBI R30,LOW(48)
	ADD  R20,R30
	RJMP _0x1A4
_0x1B2:
	MOV  R30,R19
	CPI  R30,LOW(0x63)
	BRNE _0x1B8
	CALL SUBOPT_0x38
	LD   R30,X
	CALL SUBOPT_0x39
	RJMP _0x1B9
_0x1B8:
	CPI  R30,LOW(0x73)
	BRNE _0x1BB
	CALL SUBOPT_0x38
	CALL SUBOPT_0x3A
	CALL _strlen
	MOV  R16,R30
	RJMP _0x1BC
_0x1BB:
	CPI  R30,LOW(0x70)
	BRNE _0x1BE
	CALL SUBOPT_0x38
	CALL SUBOPT_0x3A
	CALL _strlenf
	MOV  R16,R30
	ORI  R17,LOW(8)
_0x1BC:
	ORI  R17,LOW(2)
	ANDI R17,LOW(127)
	LDI  R18,LOW(0)
	RJMP _0x1BF
_0x1BE:
	CPI  R30,LOW(0x64)
	BREQ _0x1C2
	CPI  R30,LOW(0x69)
	BRNE _0x1C3
_0x1C2:
	ORI  R17,LOW(4)
	RJMP _0x1C4
_0x1C3:
	CPI  R30,LOW(0x75)
	BRNE _0x1C5
_0x1C4:
	LDI  R30,LOW(_tbl10_G11*2)
	LDI  R31,HIGH(_tbl10_G11*2)
	STD  Y+6,R30
	STD  Y+6+1,R31
	LDI  R16,LOW(5)
	RJMP _0x1C6
_0x1C5:
	CPI  R30,LOW(0x58)
	BRNE _0x1C8
	ORI  R17,LOW(8)
	RJMP _0x1C9
_0x1C8:
	CPI  R30,LOW(0x78)
	BREQ PC+3
	JMP _0x1F7
_0x1C9:
	LDI  R30,LOW(_tbl16_G11*2)
	LDI  R31,HIGH(_tbl16_G11*2)
	STD  Y+6,R30
	STD  Y+6+1,R31
	LDI  R16,LOW(4)
_0x1C6:
	SBRS R17,2
	RJMP _0x1CB
	CALL SUBOPT_0x38
	CALL __GETW1P
	STD  Y+10,R30
	STD  Y+10+1,R31
	LDD  R26,Y+10
	LDD  R27,Y+10+1
	SBIW R26,0
	BRGE _0x1CC
	CALL __ANEGW1
	STD  Y+10,R30
	STD  Y+10+1,R31
	LDI  R21,LOW(45)
_0x1CC:
	CPI  R21,0
	BREQ _0x1CD
	SUBI R16,-LOW(1)
	RJMP _0x1CE
_0x1CD:
	ANDI R17,LOW(251)
_0x1CE:
	RJMP _0x1CF
_0x1CB:
	CALL SUBOPT_0x38
	CALL __GETW1P
	STD  Y+10,R30
	STD  Y+10+1,R31
_0x1CF:
_0x1BF:
	SBRC R17,0
	RJMP _0x1D0
_0x1D1:
	CP   R16,R20
	BRSH _0x1D3
	SBRS R17,7
	RJMP _0x1D4
	SBRS R17,2
	RJMP _0x1D5
	ANDI R17,LOW(251)
	MOV  R19,R21
	SUBI R16,LOW(1)
	RJMP _0x1D6
_0x1D5:
	LDI  R19,LOW(48)
_0x1D6:
	RJMP _0x1D7
_0x1D4:
	LDI  R19,LOW(32)
_0x1D7:
	CALL SUBOPT_0x37
	SUBI R20,LOW(1)
	RJMP _0x1D1
_0x1D3:
_0x1D0:
	MOV  R18,R16
	SBRS R17,1
	RJMP _0x1D8
_0x1D9:
	CPI  R18,0
	BREQ _0x1DB
	SBRS R17,3
	RJMP _0x1DC
	LDD  R30,Y+6
	LDD  R31,Y+6+1
	ADIW R30,1
	STD  Y+6,R30
	STD  Y+6+1,R31
	SBIW R30,1
	LPM  R30,Z
	RJMP _0x210
_0x1DC:
	LDD  R26,Y+6
	LDD  R27,Y+6+1
	LD   R30,X+
	STD  Y+6,R26
	STD  Y+6+1,R27
_0x210:
	ST   -Y,R30
	CALL SUBOPT_0x3B
	CPI  R20,0
	BREQ _0x1DE
	SUBI R20,LOW(1)
_0x1DE:
	SUBI R18,LOW(1)
	RJMP _0x1D9
_0x1DB:
	RJMP _0x1DF
_0x1D8:
_0x1E1:
	LDI  R19,LOW(48)
	LDD  R30,Y+6
	LDD  R31,Y+6+1
	ADIW R30,2
	STD  Y+6,R30
	STD  Y+6+1,R31
	SBIW R30,2
	CALL __GETW1PF
	STD  Y+8,R30
	STD  Y+8+1,R31
                                      ldd  r26,y+10  ;R26,R27=n
                                      ldd  r27,y+11
                                  calc_digit:
                                      cp   r26,r30
                                      cpc  r27,r31
                                      brlo calc_digit_done
	SUBI R19,-LOW(1)
	                                  sub  r26,r30
	                                  sbc  r27,r31
	                                  brne calc_digit
                                  calc_digit_done:
                                      std  Y+10,r26 ;n=R26,R27
                                      std  y+11,r27
	LDI  R30,LOW(57)
	CP   R30,R19
	BRSH _0x1E3
	SBRS R17,3
	RJMP _0x1E4
	SUBI R19,-LOW(7)
	RJMP _0x1E5
_0x1E4:
	SUBI R19,-LOW(39)
_0x1E5:
_0x1E3:
	SBRC R17,4
	RJMP _0x1E7
	LDI  R30,LOW(48)
	CP   R30,R19
	BRLO _0x1E9
	LDD  R26,Y+8
	LDD  R27,Y+8+1
	CPI  R26,LOW(0x1)
	LDI  R30,HIGH(0x1)
	CPC  R27,R30
	BRNE _0x1E8
_0x1E9:
	ORI  R17,LOW(16)
	RJMP _0x1EB
_0x1E8:
	CP   R20,R18
	BRLO _0x1ED
	SBRS R17,0
	RJMP _0x1EE
_0x1ED:
	RJMP _0x1EC
_0x1EE:
	LDI  R19,LOW(32)
	SBRS R17,7
	RJMP _0x1EF
	LDI  R19,LOW(48)
	ORI  R17,LOW(16)
_0x1EB:
	SBRS R17,2
	RJMP _0x1F0
	ANDI R17,LOW(251)
	ST   -Y,R21
	RCALL SUBOPT_0x3B
	CPI  R20,0
	BREQ _0x1F1
	SUBI R20,LOW(1)
_0x1F1:
_0x1F0:
_0x1EF:
_0x1E7:
	RCALL SUBOPT_0x37
	CPI  R20,0
	BREQ _0x1F2
	SUBI R20,LOW(1)
_0x1F2:
_0x1EC:
	SUBI R18,LOW(1)
	LDD  R26,Y+8
	LDD  R27,Y+8+1
	LDI  R30,LOW(1)
	LDI  R31,HIGH(1)
	CP   R30,R26
	CPC  R31,R27
	BRSH _0x1E2
	RJMP _0x1E1
_0x1E2:
_0x1DF:
	SBRS R17,0
	RJMP _0x1F3
_0x1F4:
	CPI  R20,0
	BREQ _0x1F6
	SUBI R20,LOW(1)
	LDI  R30,LOW(32)
	RCALL SUBOPT_0x39
	RJMP _0x1F4
_0x1F6:
_0x1F3:
_0x1F7:
_0x1B9:
	LDI  R16,LOW(0)
_0x1A4:
	RJMP _0x19F
_0x1A1:
	CALL __LOADLOCR6
	ADIW R28,18
	RET
_printf:
	PUSH R15
	MOV  R15,R24
	SBIW R28,2
	ST   -Y,R17
	ST   -Y,R16
	MOVW R26,R28
	CALL __ADDW2R15
	__PUTW2R 16,17
	LDI  R30,0
	STD  Y+2,R30
	STD  Y+2+1,R30
	MOVW R26,R28
	ADIW R26,4
	CALL __ADDW2R15
	CALL __GETW1P
	ST   -Y,R31
	ST   -Y,R30
	ST   -Y,R17
	ST   -Y,R16
	MOVW R30,R28
	ADIW R30,6
	ST   -Y,R31
	ST   -Y,R30
	CALL __print_G11
	LDD  R17,Y+1
	LDD  R16,Y+0
	ADIW R28,4
	POP  R15
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 10 TIMES
SUBOPT_0x0:
	ST   -Y,R0
	ST   -Y,R1
	ST   -Y,R15
	ST   -Y,R22
	ST   -Y,R23
	ST   -Y,R24
	ST   -Y,R25
	ST   -Y,R26
	ST   -Y,R27
	ST   -Y,R30
	ST   -Y,R31
	IN   R30,SREG
	ST   -Y,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 6 TIMES
SUBOPT_0x1:
	LDI  R26,LOW(1)
	EOR  R30,R26
	CALL __BSTB1
	IN   R26,0x18
	BLD  R26,0
	OUT  0x18,R26
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES
SUBOPT_0x2:
	LDI  R30,LOW(100)
	LDI  R31,HIGH(100)
	ST   -Y,R31
	ST   -Y,R30
	CALL _delay_ms
	LD   R30,Y+
	OUT  SREG,R30
	LD   R31,Y+
	LD   R30,Y+
	LD   R27,Y+
	LD   R26,Y+
	LD   R25,Y+
	LD   R24,Y+
	LD   R23,Y+
	LD   R22,Y+
	LD   R15,Y+
	LD   R1,Y+
	LD   R0,Y+
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 6 TIMES
SUBOPT_0x3:
	LD   R30,Y+
	OUT  SREG,R30
	LD   R31,Y+
	LD   R30,Y+
	LD   R27,Y+
	LD   R26,Y+
	LD   R25,Y+
	LD   R24,Y+
	LD   R23,Y+
	LD   R22,Y+
	LD   R15,Y+
	LD   R1,Y+
	LD   R0,Y+
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES
SUBOPT_0x4:
	MOV  R30,R4
	LDI  R26,LOW(_adc_data)
	LDI  R27,HIGH(_adc_data)
	LDI  R31,0
	LSL  R30
	ROL  R31
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 11 TIMES
SUBOPT_0x5:
	LDS  R30,_ir_sensor
	LDI  R26,LOW(_IR_Result)
	LDI  R27,HIGH(_IR_Result)
	LDI  R31,0
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES
SUBOPT_0x6:
	__GETD1N 0x0
	CALL __PUTDP1
	RJMP SUBOPT_0x5

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES
SUBOPT_0x7:
	ADD  R26,R30
	ADC  R27,R31
	MOV  R30,R16
	LDI  R31,0
	CALL __LSLW2
	ADD  R26,R30
	ADC  R27,R31
	CALL __GETD1P
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES
SUBOPT_0x8:
	LDS  R26,_temp
	LDS  R27,_temp+1
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	CALL __GTW12
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES
SUBOPT_0x9:
	LD   R26,Y
	LDD  R27,Y+1
	LDI  R30,LOW(65526)
	LDI  R31,HIGH(65526)
	CALL __GEW12
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES
SUBOPT_0xA:
	LD   R26,Y
	LDD  R27,Y+1
	LDI  R30,LOW(10)
	LDI  R31,HIGH(10)
	CALL __LEW12
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES
SUBOPT_0xB:
	LD   R26,Y
	LDD  R27,Y+1
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	CALL __NEW12
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES
SUBOPT_0xC:
	LDI  R30,LOW(500)
	LDI  R31,HIGH(500)
	ST   -Y,R31
	ST   -Y,R30
	CALL _delay_ms
	CLT
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES
SUBOPT_0xD:
	RCALL _printf
	ADIW R28,2
	JMP  _get_ack

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES
SUBOPT_0xE:
	LD   R30,Y
	LDI  R26,LOW(_object)
	LDI  R27,HIGH(_object)
	LDI  R31,0
	CALL __LSLW2
	ADD  R30,R26
	ADC  R31,R27
	LDD  R30,Z+2
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 7 TIMES
SUBOPT_0xF:
	MOV  R30,R20
	LDI  R26,LOW(_blob_info)
	LDI  R27,HIGH(_blob_info)
	LDI  R31,0
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES
SUBOPT_0x10:
	SUB  R26,R30
	MOV  R30,R26
	LSR  R30
	LDI  R31,0
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES
SUBOPT_0x11:
	MOV  R30,R20
	LDI  R26,LOW(_object)
	LDI  R27,HIGH(_object)
	LDI  R31,0
	CALL __LSLW2
	ADD  R30,R26
	ADC  R31,R27
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES
SUBOPT_0x12:
	LDI  R30,LOW(1000)
	LDI  R31,HIGH(1000)
	ST   -Y,R31
	ST   -Y,R30
	JMP  _delay_ms

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES
SUBOPT_0x13:
	LDS  R30,_IRMAX
	__GETW2SX 77
	LDI  R31,0
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES
SUBOPT_0x14:
	ADD  R26,R30
	ADC  R27,R31
	MOV  R30,R17
	LDI  R31,0
	LSL  R30
	ROL  R31
	ADD  R26,R30
	ADC  R27,R31
	CALL __GETW1P
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 5 TIMES
SUBOPT_0x15:
	LDI  R30,LOW(80)
	LDI  R31,HIGH(80)
	ST   -Y,R31
	ST   -Y,R30
	JMP  _motor_ctrl

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES
SUBOPT_0x16:
	LDI  R30,LOW(500)
	LDI  R31,HIGH(500)
	ST   -Y,R31
	ST   -Y,R30
	JMP  _delay_ms

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES
SUBOPT_0x17:
	LDI  R30,LOW(85)
	ST   -Y,R30
	JMP  _tilt_ctrl

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES
SUBOPT_0x18:
	LDS  R26,_center_front
	LDS  R27,_center_front+1
	LDI  R30,LOW(0)
	LDI  R31,HIGH(0)
	CALL __GTW12
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES
SUBOPT_0x19:
	LDS  R30,_left_front
	LDS  R31,_left_front+1
	LDS  R26,_right_front
	LDS  R27,_right_front+1
	CALL __EQW12
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES
SUBOPT_0x1A:
	LDS  R26,_center_front
	LDS  R27,_center_front+1
	LDI  R30,LOW(4)
	LDI  R31,HIGH(4)
	CALL __LTW12
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES
SUBOPT_0x1B:
	CALL _wait_for_trackdata
	LDI  R26,LOW(1)
	CALL __EQB12
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES
SUBOPT_0x1C:
	ST   -Y,R30
	CALL _track_object
	MOV  R16,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES
SUBOPT_0x1D:
	MOV  R26,R17
	LDI  R30,LOW(0)
	CALL __EQB12
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES
SUBOPT_0x1E:
	LDI  R30,LOW(50)
	LDI  R31,HIGH(50)
	ST   -Y,R31
	ST   -Y,R30
	JMP  _LCD_Display

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES
SUBOPT_0x1F:
	LDI  R30,LOW(0)
	STS  _color,R30
	STS  _dest,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES
SUBOPT_0x20:
	LDI  R30,LOW(75)
	MOV  R8,R30
	CLT
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 5 TIMES
SUBOPT_0x21:
	LDI  R30,LOW(100)
	LDI  R31,HIGH(100)
	ST   -Y,R31
	ST   -Y,R30
	JMP  _LCD_Display

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES
SUBOPT_0x22:
	MOV  R30,R17
	LDI  R26,LOW(_object)
	LDI  R27,HIGH(_object)
	LDI  R31,0
	CALL __LSLW2
	ADD  R26,R30
	ADC  R27,R31
	LD   R26,X
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES
SUBOPT_0x23:
	MOV  R30,R17
	LDI  R26,LOW(_object)
	LDI  R27,HIGH(_object)
	LDI  R31,0
	CALL __LSLW2
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES
SUBOPT_0x24:
	ADD  R30,R26
	ADC  R31,R27
	LDD  R30,Z+2
	LDS  R26,_laser_center
	SUB  R30,R26
	MOV  R26,R30
	LDI  R30,LOW(15)
	CALL __LTB12U
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES
SUBOPT_0x25:
	ADD  R26,R30
	ADC  R27,R31
	LD   R30,X
	STS  _color,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES
SUBOPT_0x26:
	LDI  R30,LOW(99)
	LDI  R31,HIGH(99)
	ST   -Y,R31
	ST   -Y,R30
	CALL _motor_ctrl
	LDI  R30,LOW(1750)
	LDI  R31,HIGH(1750)
	ST   -Y,R31
	ST   -Y,R30
	JMP  _LCD_Display

;OPTIMIZER ADDED SUBROUTINE, CALLED 9 TIMES
SUBOPT_0x27:
	MOV  R30,R16
	LDI  R26,LOW(_object)
	LDI  R27,HIGH(_object)
	LDI  R31,0
	CALL __LSLW2
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES
SUBOPT_0x28:
	LDS  R30,_blobs
	SUBI R30,LOW(1)
	CP   R30,R16
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES
SUBOPT_0x29:
	LDI  R30,LOW(67)
	LDI  R31,HIGH(67)
	ST   -Y,R31
	ST   -Y,R30
	JMP  _motor_ctrl

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES
SUBOPT_0x2A:
	ADD  R26,R30
	ADC  R27,R31
	LD   R30,X
	LDS  R26,_color
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES
SUBOPT_0x2B:
	ADD  R26,R30
	ADC  R27,R31
	LD   R26,X
	LDI  R30,LOW(8)
	CALL __LTB12U
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES
SUBOPT_0x2C:
	ADD  R26,R30
	ADC  R27,R31
	LD   R26,X
	LDI  R30,LOW(0)
	CALL __GTB12U
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES
SUBOPT_0x2D:
	LDS  R30,_color
	LDI  R31,0
	SUBI R30,LOW(-_object_cd)
	SBCI R31,HIGH(-_object_cd)
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES
SUBOPT_0x2E:
	LDI  R30,LOW(67)
	ST   -Y,R30
	JMP  _tilt_ctrl

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES
SUBOPT_0x2F:
	LDI  R30,LOW(79)
	ST   -Y,R30
	JMP  _grip_ctrl

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES
SUBOPT_0x30:
	LDS  R30,_i
	LDI  R26,LOW(_object)
	LDI  R27,HIGH(_object)
	LDI  R31,0
	CALL __LSLW2
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES
SUBOPT_0x31:
	CALL __CFD1
	ST   -Y,R31
	ST   -Y,R30
	JMP  _lcd_PrintInt

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES
SUBOPT_0x32:
	ST   -Y,R30
	LDI  R30,LOW(0)
	ST   -Y,R30
	JMP  _lcd_gotoxy

;OPTIMIZER ADDED SUBROUTINE, CALLED 7 TIMES
SUBOPT_0x33:
	LDI  R31,0
	ST   -Y,R31
	ST   -Y,R30
	JMP  _lcd_PrintInt

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES
SUBOPT_0x34:
	ST   -Y,R30
	CALL __lcd_write_data
	JMP  __lcd_ready

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES
SUBOPT_0x35:
	CALL __long_delay_G10
	LDI  R30,LOW(48)
	ST   -Y,R30
	JMP  __lcd_init_write_G10

;OPTIMIZER ADDED SUBROUTINE, CALLED 3 TIMES
SUBOPT_0x36:
	ST   -Y,R30
	CALL __lcd_write_data
	JMP  __long_delay_G10

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES
SUBOPT_0x37:
	ST   -Y,R19
	LDD  R30,Y+13
	LDD  R31,Y+13+1
	ST   -Y,R31
	ST   -Y,R30
	JMP  __put_G11

;OPTIMIZER ADDED SUBROUTINE, CALLED 5 TIMES
SUBOPT_0x38:
	LDD  R26,Y+14
	LDD  R27,Y+14+1
	SBIW R26,4
	STD  Y+14,R26
	STD  Y+14+1,R27
	ADIW R26,4
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES
SUBOPT_0x39:
	ST   -Y,R30
	LDD  R30,Y+13
	LDD  R31,Y+13+1
	ST   -Y,R31
	ST   -Y,R30
	JMP  __put_G11

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES
SUBOPT_0x3A:
	CALL __GETW1P
	STD  Y+6,R30
	STD  Y+6+1,R31
	ST   -Y,R31
	ST   -Y,R30
	RET

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES
SUBOPT_0x3B:
	LDD  R30,Y+13
	LDD  R31,Y+13+1
	ST   -Y,R31
	ST   -Y,R30
	JMP  __put_G11

_strlen:
	ld   r26,y+
	ld   r27,y+
	clr  r30
	clr  r31
__strlen0:
	ld   r22,x+
	tst  r22
	breq __strlen1
	adiw r30,1
	rjmp __strlen0
__strlen1:
	ret

_strlenf:
	clr  r26
	clr  r27
	ld   r30,y+
	ld   r31,y+
__strlenf0:
	lpm  r0,z+
	tst  r0
	breq __strlenf1
	adiw r26,1
	rjmp __strlenf0
__strlenf1:
	movw r30,r26
	ret

_delay_ms:
	ld   r30,y+
	ld   r31,y+
	adiw r30,0
	breq __delay_ms1
__delay_ms0:
	__DELAY_USW 0xE66
	wdr
	sbiw r30,1
	brne __delay_ms0
__delay_ms1:
	ret

__ADDW2R15:
	CLR  R0
	ADD  R26,R15
	ADC  R27,R0
	RET

__ANEGW1:
	COM  R30
	COM  R31
	ADIW R30,1
	RET

__ANEGD1:
	COM  R30
	COM  R31
	COM  R22
	COM  R23
	SUBI R30,-1
	SBCI R31,-1
	SBCI R22,-1
	SBCI R23,-1
	RET

__LSLW2:
	LSL  R30
	ROL  R31
	LSL  R30
	ROL  R31
	RET

__CWD1:
	MOV  R22,R31
	ADD  R22,R22
	SBC  R22,R22
	MOV  R23,R22
	RET

__EQB12:
	CP   R30,R26
	LDI  R30,1
	BREQ __EQB12T
	CLR  R30
__EQB12T:
	RET

__NEB12:
	CP   R30,R26
	LDI  R30,1
	BRNE __NEB12T
	CLR  R30
__NEB12T:
	RET

__LEB12U:
	CP   R30,R26
	LDI  R30,1
	BRSH __LEB12U1
	CLR  R30
__LEB12U1:
	RET

__GEB12U:
	CP   R26,R30
	LDI  R30,1
	BRSH __GEB12U1
	CLR  R30
__GEB12U1:
	RET

__LTB12U:
	CP   R26,R30
	LDI  R30,1
	BRLO __LTB12U1
	CLR  R30
__LTB12U1:
	RET

__GTB12U:
	CP   R30,R26
	LDI  R30,1
	BRLO __GTB12U1
	CLR  R30
__GTB12U1:
	RET

__EQW12:
	CP   R30,R26
	CPC  R31,R27
	LDI  R30,1
	BREQ __EQW12T
	CLR  R30
__EQW12T:
	RET

__NEW12:
	CP   R30,R26
	CPC  R31,R27
	LDI  R30,1
	BRNE __NEW12T
	CLR  R30
__NEW12T:
	RET

__LEW12:
	CP   R30,R26
	CPC  R31,R27
	LDI  R30,1
	BRGE __LEW12T
	CLR  R30
__LEW12T:
	RET

__GEW12:
	CP   R26,R30
	CPC  R27,R31
	LDI  R30,1
	BRGE __GEW12T
	CLR  R30
__GEW12T:
	RET

__LTW12:
	CP   R26,R30
	CPC  R27,R31
	LDI  R30,1
	BRLT __LTW12T
	CLR  R30
__LTW12T:
	RET

__GTW12:
	CP   R30,R26
	CPC  R31,R27
	LDI  R30,1
	BRLT __GTW12T
	CLR  R30
__GTW12T:
	RET

__GEW12U:
	CP   R26,R30
	CPC  R27,R31
	LDI  R30,1
	BRSH __GEW12UT
	CLR  R30
__GEW12UT:
	RET

__LTW12U:
	CP   R26,R30
	CPC  R27,R31
	LDI  R30,1
	BRLO __LTW12UT
	CLR  R30
__LTW12UT:
	RET

__MULW12U:
	MUL  R31,R26
	MOV  R31,R0
	MUL  R30,R27
	ADD  R31,R0
	MUL  R30,R26
	MOV  R30,R0
	ADD  R31,R1
	RET

__MULW12:
	RCALL __CHKSIGNW
	RCALL __MULW12U
	BRTC __MULW121
	RCALL __ANEGW1
__MULW121:
	RET

__DIVW21U:
	CLR  R0
	CLR  R1
	LDI  R25,16
__DIVW21U1:
	LSL  R26
	ROL  R27
	ROL  R0
	ROL  R1
	SUB  R0,R30
	SBC  R1,R31
	BRCC __DIVW21U2
	ADD  R0,R30
	ADC  R1,R31
	RJMP __DIVW21U3
__DIVW21U2:
	SBR  R26,1
__DIVW21U3:
	DEC  R25
	BRNE __DIVW21U1
	MOVW R30,R26
	MOVW R26,R0
	RET

__DIVW21:
	RCALL __CHKSIGNW
	RCALL __DIVW21U
	BRTC __DIVW211
	RCALL __ANEGW1
__DIVW211:
	RET

__MODW21:
	CLT
	SBRS R27,7
	RJMP __MODW211
	COM  R26
	COM  R27
	ADIW R26,1
	SET
__MODW211:
	SBRC R31,7
	RCALL __ANEGW1
	RCALL __DIVW21U
	MOVW R30,R26
	BRTC __MODW212
	RCALL __ANEGW1
__MODW212:
	RET

__CHKSIGNW:
	CLT
	SBRS R31,7
	RJMP __CHKSW1
	RCALL __ANEGW1
	SET
__CHKSW1:
	SBRS R27,7
	RJMP __CHKSW2
	COM  R26
	COM  R27
	ADIW R26,1
	BLD  R0,0
	INC  R0
	BST  R0,0
__CHKSW2:
	RET

__GETW1P:
	LD   R30,X+
	LD   R31,X
	SBIW R26,1
	RET

__GETD1P:
	LD   R30,X+
	LD   R31,X+
	LD   R22,X+
	LD   R23,X
	SBIW R26,3
	RET

__PUTDP1:
	ST   X+,R30
	ST   X+,R31
	ST   X+,R22
	ST   X,R23
	RET

__GETW1PF:
	LPM  R0,Z+
	LPM  R31,Z
	MOV  R30,R0
	RET

__SWAPD12:
	MOV  R1,R24
	MOV  R24,R22
	MOV  R22,R1
	MOV  R1,R25
	MOV  R25,R23
	MOV  R23,R1

__SWAPW12:
	MOV  R1,R27
	MOV  R27,R31
	MOV  R31,R1

__SWAPB12:
	MOV  R1,R26
	MOV  R26,R30
	MOV  R30,R1
	RET

__REPACK:
	LDI  R21,0x80
	EOR  R21,R23
	BRNE __REPACK0
	PUSH R21
	RJMP __ZERORES
__REPACK0:
	CPI  R21,0xFF
	BREQ __REPACK1
	LSL  R22
	LSL  R0
	ROR  R21
	ROR  R22
	MOV  R23,R21
	RET
__REPACK1:
	PUSH R21
	TST  R0
	BRMI __REPACK2
	RJMP __MAXRES
__REPACK2:
	RJMP __MINRES

__UNPACK:
	LDI  R21,0x80
	MOV  R1,R25
	AND  R1,R21
	LSL  R24
	ROL  R25
	EOR  R25,R21
	LSL  R21
	ROR  R24

__UNPACK1:
	LDI  R21,0x80
	MOV  R0,R23
	AND  R0,R21
	LSL  R22
	ROL  R23
	EOR  R23,R21
	LSL  R21
	ROR  R22
	RET

__CFD1:
	PUSH R21
	RCALL __UNPACK1
	CPI  R23,0x80
	BRLO __CFD10
	CPI  R23,0xFF
	BRCC __CFD10
	RJMP __ZERORES
__CFD10:
	LDI  R21,22
	SUB  R21,R23
	BRPL __CFD11
	NEG  R21
	CPI  R21,8
	BRLO __CFD17
	SER  R30
	SER  R31
	SER  R22
	LDI  R23,0x7F
	RJMP __CFD15
__CFD17:
	CLR  R23
	TST  R21
	BREQ __CFD15
__CFD18:
	LSL  R30
	ROL  R31
	ROL  R22
	ROL  R23
	DEC  R21
	BRNE __CFD18
	RJMP __CFD15
__CFD11:
	CLR  R23
__CFD12:
	CPI  R21,8
	BRLO __CFD13
	MOV  R30,R31
	MOV  R31,R22
	MOV  R22,R23
	SUBI R21,8
	RJMP __CFD12
__CFD13:
	TST  R21
	BREQ __CFD15
__CFD14:
	LSR  R23
	ROR  R22
	ROR  R31
	ROR  R30
	DEC  R21
	BRNE __CFD14
__CFD15:
	TST  R0
	BRPL __CFD16
	RCALL __ANEGD1
__CFD16:
	POP  R21
	RET

__CDF1U:
	SET
	RJMP __CDF1U0
__CDF1:
	CLT
__CDF1U0:
	SBIW R30,0
	SBCI R22,0
	SBCI R23,0
	BREQ __CDF10
	CLR  R0
	BRTS __CDF11
	TST  R23
	BRPL __CDF11
	COM  R0
	RCALL __ANEGD1
__CDF11:
	MOV  R1,R23
	LDI  R23,30
	TST  R1
__CDF12:
	BRMI __CDF13
	DEC  R23
	LSL  R30
	ROL  R31
	ROL  R22
	ROL  R1
	RJMP __CDF12
__CDF13:
	MOV  R30,R31
	MOV  R31,R22
	MOV  R22,R1
	PUSH R21
	RCALL __REPACK
	POP  R21
__CDF10:
	RET

__SWAPACC:
	MOV  R21,R30
	MOV  R30,R26
	MOV  R26,R21
	MOV  R21,R31
	MOV  R31,R27
	MOV  R27,R21
	MOV  R21,R22
	MOV  R22,R24
	MOV  R24,R21
	MOV  R21,R23
	MOV  R23,R25
	MOV  R25,R21
	MOV  R21,R0
	MOV  R0,R1
	MOV  R1,R21
	RET

__UADD12:
	ADD  R30,R26
	ADC  R31,R27
	ADC  R22,R24
	RET

__NEGMAN1:
	COM  R30
	COM  R31
	COM  R22
	SUBI R30,-1
	SBCI R31,-1
	SBCI R22,-1
	RET

__SUBF12:
	PUSH R21
	RCALL __UNPACK
	CPI  R25,0x80
	BREQ __ADDF129
	LDI  R21,0x80
	EOR  R1,R21

	RJMP __ADDF120

__ADDF12:
	PUSH R21
	RCALL __UNPACK
	CPI  R25,0x80
	BREQ __ADDF129

__ADDF120:
	CPI  R23,0x80
	BREQ __ADDF128
__ADDF121:
	MOV  R21,R23
	SUB  R21,R25
	BRVS __ADDF129
	BRPL __ADDF122
	RCALL __SWAPACC
	RJMP __ADDF121
__ADDF122:
	CPI  R21,24
	BRLO __ADDF123
	CLR  R26
	CLR  R27
	CLR  R24
__ADDF123:
	CPI  R21,8
	BRLO __ADDF124
	MOV  R26,R27
	MOV  R27,R24
	CLR  R24
	SUBI R21,8
	RJMP __ADDF123
__ADDF124:
	TST  R21
	BREQ __ADDF126
__ADDF125:
	LSR  R24
	ROR  R27
	ROR  R26
	DEC  R21
	BRNE __ADDF125
__ADDF126:
	MOV  R21,R0
	EOR  R21,R1
	BRMI __ADDF127
	RCALL __UADD12
	BRCC __ADDF129
	ROR  R22
	ROR  R31
	ROR  R30
	INC  R23
	BRVC __ADDF129
	RJMP __MAXRES
__ADDF128:
	RCALL __SWAPACC
__ADDF129:
	RCALL __REPACK
	POP  R21
	RET
__ADDF127:
	SUB  R30,R26
	SBC  R31,R27
	SBC  R22,R24
	BREQ __ZERORES
	BRCC __ADDF1210
	COM  R0
	RCALL __NEGMAN1
__ADDF1210:
	TST  R22
	BRMI __ADDF129
	LSL  R30
	ROL  R31
	ROL  R22
	DEC  R23
	BRVC __ADDF1210

__MINRES:
	SER  R30
	SER  R31
	LDI  R22,0x7F
	SER  R23
	POP  R21
	RET

__ZERORES:
	CLR  R30
	CLR  R31
	CLR  R22
	CLR  R23
	POP  R21
	RET

__MAXRES:
	SER  R30
	SER  R31
	LDI  R22,0x7F
	LDI  R23,0x7F
	POP  R21
	RET

__DIVF21:
	PUSH R21
	RCALL __UNPACK
	CPI  R23,0x80
	BRNE __DIVF210
	TST  R1
__DIVF211:
	BRPL __MAXRES
	RJMP __MINRES
__DIVF210:
	CPI  R25,0x80
	BRNE __DIVF218
__DIVF217:
	RJMP __ZERORES
__DIVF218:
	EOR  R0,R1
	SEC
	SBC  R25,R23
	BRVC __DIVF216
	BRLT __DIVF217
	TST  R0
	RJMP __DIVF211
__DIVF216:
	MOV  R23,R25
	LSR  R22
	ROR  R31
	ROR  R30
	LSR  R24
	ROR  R27
	ROR  R26
	PUSH R20
	CLR  R1
	CLR  R20
	CLR  R21
	LDI  R25,24
__DIVF212:
	CP   R26,R30
	CPC  R27,R31
	CPC  R24,R22
	BRLO __DIVF213
	SUB  R26,R30
	SBC  R27,R31
	SBC  R24,R22
	SEC
	RJMP __DIVF214
__DIVF213:
	CLC
__DIVF214:
	ROL  R1
	ROL  R20
	ROL  R21
	ROL  R26
	ROL  R27
	ROL  R24
	DEC  R25
	BRNE __DIVF212
	MOV  R30,R1
	MOV  R31,R20
	MOV  R22,R21
	LSR  R26
	ADC  R30,R25
	ADC  R31,R25
	ADC  R22,R25
	POP  R20
	TST  R22
	BRMI __DIVF215
	LSL  R30
	ROL  R31
	ROL  R22
	DEC  R23
	BRVS __DIVF217
__DIVF215:
	RCALL __REPACK
	POP  R21
	RET

__BSTB1:
	CLT
	CLR  R0
	CPSE R30,R0
	SET
	RET

__SAVELOCR6:
	ST   -Y,R21
__SAVELOCR5:
	ST   -Y,R20
__SAVELOCR4:
	ST   -Y,R19
__SAVELOCR3:
	ST   -Y,R18
__SAVELOCR2:
	ST   -Y,R17
	ST   -Y,R16
	RET

__LOADLOCR6:
	LDD  R21,Y+5
__LOADLOCR5:
	LDD  R20,Y+4
__LOADLOCR4:
	LDD  R19,Y+3
__LOADLOCR3:
	LDD  R18,Y+2
__LOADLOCR2:
	LDD  R17,Y+1
	LD   R16,Y
	RET

__INITLOCB:
__INITLOCW:
	ADD R26,R28
	ADC R27,R29
__INITLOC0:
	LPM  R0,Z+
	ST   X+,R0
	DEC  R24
	BRNE __INITLOC0
	RET

;END OF CODE MARKER
__END_OF_CODE:
