/*****************************************************
This program was produced by the
CodeWizardAVR V1.25.8a Evaluation
Automatic Program Generator
 Copyright 1998-2007 Pavel Haiduc, HP InfoTech s.r.l.
http://www.hpinfotech.com

Project : L-DOR
Version : 1.0
Date    : 2/9/2008
Author  : Freeware, for evaluation and non-commercial use only
Company : 
Comments: 


Chip type           : ATmega128
Program type        : Application
Clock frequency     : 14.745600 MHz
Memory model        : Small
External SRAM size  : 0
Data Stack size     : 1024
*****************************************************/

#include <mega128.h> 
#include <stdlib.h> 
//#include <inttypes.h>
#include <delay.h> 
#include <lcd.h>

#define IR_Cycle_Speed 50

int analyse_ir();
void LCD_Display(int delay);
// Declare your global variables here 
char channel=0;
unsigned int adc_data[4];



// Alphanumeric LCD Module functions
#asm
   .equ __lcd_port=0x15 ;PORTC
#endasm
#include <stdlib.h>
#include <lcd.h>
/*
void lcd_PrintFloat(float number)
{
 char decimal[1];
 ftoa(number, *decimal, decimal);
 lcd_puts(decimal);
} */             

void lcd_PrintInt(int number)
{
unsigned char character[1];
        itoa(number, character);
        lcd_puts(character);
}
#include <mega128.h>
#include <io.h>

#define R1 PORTB.2 
#define R2 PORTB.3
#define R3 PORTD.6
#define R4 PORTD.7

#define C1 PIND.0
#define C2 PIND.1
#define C3 PINE.5
#define C4 PINE.6

char row; 
char col;
char button;




void init_keypad()
{
R1=0;
R2=0;
R3=0;
R4=0;
// External Interrupt(s) initialization
// INT0: On
// INT0 Mode: Low level
// INT1: On
// INT1 Mode: Low level
// INT2: Off
// INT3: Off
// INT4: Off
// INT5: On
// INT5 Mode: Low level
// INT6: On
// INT6 Mode: Low level
// INT7: Off
EICRA=0x00;
EICRB=0x00;
EIMSK=0x63;
EIFR=0x63;
} 

// External Interrupt 0 service routine
interrupt [EXT_INT0] void ext_int0_isr(void)
{ 
PORTB.0^=1;

R1=1;
col=~C1;
R1=0;
if(col==0)
{
button=1;
}
else{
        R2=1;
        col=~C1;
        R2=0;
        if(col==0)
        {
        button=4;
        }
        else{
                R3=1;
                col=~C1;
                R3=0;
                if(col==0)
                {
                button=7;
                }
                else{
                        R4=1;
                        col=~C1;
                        R4=0;
                        if(col==0)
                        {
                        button=14;
                        }
                }
        }
}             


delay_ms(100);
}


// External Interrupt 1 service routine
interrupt [EXT_INT1] void ext_int1_isr(void)
{
PORTB.0^=1;
R1=1;
col=~C2;
R1=0;
if(col==0)
{
button=2;
}
else{
        R2=1;
        col=~C2;
        R2=0;
        if(col==0)
        {
        button=5;
        }
        else{
                R3=1;
                col=~C2;
                R3=0;
                if(col==0)
                {
                button=8;
                }
                else{
                        R4=1;
                        col=~C2;
                        R4=0;
                        if(col==0)
                        {
                        button=0;
                        }
                }
        }
}
delay_ms(100);
}

// External Interrupt 5 service routine
interrupt [EXT_INT5] void ext_int5_isr(void)
{
PORTB.0^=1;
R1=1;
col=~C3;
R1=0;
if(col==0)
{
button=3;
}
else{
        R2=1;
        col=~C3;
        R2=0;
        if(col==0)
        {
        button=6;
        }
        else{
                R3=1;
                col=~C3;
                R3=0;
                if(col==0)
                {
                button=9;
                }
                else{
                        R4=1;
                        col=~C3;
                        R4=0;
                        if(col==0)
                        {
                        button=15;
                        }
                }
        }
}
delay_ms(100);
}

// External Interrupt 6 service routine
interrupt [EXT_INT6] void ext_int6_isr(void)
{ 
PORTB.0^=1;
R1=1;
col=~C4;
R1=0;
if(col==0)
{
button=10;
}
else{
        R2=1;
        col=~C4;
        R2=0;
        if(col==0)
        {
        button=11;
        }
        else{
                R3=1;
                col=~C4;
                R3=0;
                if(col==0)
                {
                button=12;
                }
                else{
                        R4=1;
                        col=~C4;
                        R4=0;
                        if(col==0)
                        {
                        button=13;
                        }
                }
        }
}
delay_ms(100);
}
#include <mega128.h>

#define led_ocr OCR0
#define LED     PORTB.4

char led_dc=75;

void led_off()
{
if(TCCR0!=0x4E)
{
 TCCR0&=0xCF;
}
}

void led_on()
{
if(TCCR0!=0x6E)
{
 TCCR0|=0x20;
 }
}

void adj_led()
{                                     
 if(button==14)
 {
        if(led_dc<=120)
        {
        led_dc+=5;
        }
        else
        {
         LED=0;
         led_dc=0;
        }
  button=0; 
 }
 
 if(button==15)
 {
        if(led_dc>=5)
        {
        led_dc-=5;
        }
        else
        {
         led_dc=125;
        }
 button=0;
 }

}

// Timer 0 overflow interrupt service routine
interrupt [TIM0_OVF] void timer0_ovf_isr(void)
{ 

adj_led();

if(led_dc!=0 & led_dc!=125)
{
led_on();
LED=0;
led_ocr=led_dc;
}
else if(led_dc==0)
{
 led_off();
}
else if(led_dc==125)
{
 led_off();
 LED=1;
}
}


// Timer 0 output compare interrupt service routine
interrupt [TIM0_COMP] void timer0_comp_isr(void)
{

}

void init_timer0()
{
// Timer/Counter 0 initialization
// Clock source: System Clock
// Clock value: 14.400 kHz
// Mode: Fast PWM top=FFh
// OC0 output: Non-Inverted PWM
ASSR=0x00;
TCCR0=0x6E;
TCNT0=0x00;
led_ocr=0x00;   //OCR0

// Timer(s)/Counter(s) Interrupt(s) initialization
TIMSK|=0x03;

} 

#include <mega128.h>

bit read_current;
unsigned int amp_smpl;
int Amps;
char smpl;
bit new_reading;

void ammeter()
{
 amp_smpl+=adc_data[3]/10;
 smpl+=1;
 if(smpl==20)
 {
  Amps=amp_smpl/20;
  smpl=0;
  amp_smpl=0;
  new_reading=1;
 }
 read_current=0;
}
#include <mega128.h>

#define Sonar1_EN PORTA.5
#define Sonar2_EN PORTA.6
#define Sonar1 1
#define Sonar2 2
#define Samples 2
#define num_of_samples 2

//Global variables
int SonarInches[2];
unsigned int SonarResult;
int sonar_samples;
bit sonar_sel=0;
bit read_sonar;
char sonar_cntr=0;
char s_samp;

/*****************************************
This function averages the sonar samples 
from the ADC. It is called in the ADC ISR. 
*****************************************/

void Read_Sonar()
{
 SonarResult+=adc_data[channel];
 sonar_samples+=1;
        if(sonar_samples==num_of_samples)
        {
        SonarInches[sonar_sel]=SonarResult/sonar_samples/2;
        SonarResult=0;
        sonar_samples=0;
        read_sonar=0;
                if(sonar_sel==0) //alternate the sonar being sampled
                {
                sonar_sel=1;     
                }
                else                    
                {
                 sonar_sel=0;
                }
        }
 }



/********************************************
This enables the sonar to take a reading and
changes the A/D channel when a sample is ready.
*******************************************/

void Enable_Sonar()
{
if(sonar_cntr==1)
 {
        if(sonar_sel==0)
        {
         Sonar1_EN=1;
         }
         else
         {
          Sonar2_EN=1;
         }
 }
 else if(sonar_cntr==2)
 {
  Sonar2_EN=0;
  Sonar1_EN=0;
 }
  else if(sonar_cntr==10)
 {
  sonar_cntr=0;
  read_sonar=1;
 } 
   
sonar_cntr+=1;
}
#include <mega128.h>
#define ADC_VREF_TYPE 0x00


#define IR_Toggle PORTA.0
#define IR_Reset PORTA.1
#define IR_SelA PORTA.2
#define IR_SelB PORTA.3
#define IR_SelC PORTA.4


#define IR_Cycle_Speed 50
#define NumSamples 20
#define Number_of_Sensors 5


// Global variables  
int IR_Intensity=0;
int scnt;
//int cntr;
double IR_Result[Number_of_Sensors][19];
int temp;
double samples;
char ir_sensor;
char IRMAX=25;




void Change_IR_Sensor()
{
 if((ir_sensor+1)==Number_of_Sensors)
 {
  IR_SelA=0;
  IR_SelB=0;
  IR_SelC=0;
  ir_sensor=0;
 }
 else if(ir_sensor==0)
 {
  IR_SelA=1;
  IR_SelB=0;
  IR_SelC=0;
  ir_sensor=1;
  }
  else if(ir_sensor==1)
  {
  IR_SelA=0;
  IR_SelB=1;
  IR_SelC=0;
  ir_sensor=2;
  }
  else if(ir_sensor==2)
  {
   IR_SelA=1;
   IR_SelB=1;
   IR_SelC=0;
   ir_sensor=3;
  }
  else if(ir_sensor==3)
  {
   IR_SelA=0;
   IR_SelB=0;
   IR_SelC=1;
   ir_sensor=4;
  }
  else if(ir_sensor==4)
  {
   IR_SelA=1;
   IR_SelB=0;
   IR_SelC=1;
   ir_sensor=5;
  }
  else if(ir_sensor==5)
  {
   
   IR_SelA=0;
   IR_SelB=1;
   IR_SelC=1;
   ir_sensor=6;
  }
  else if(ir_sensor==6)
  {
   
   IR_SelA=0;
   IR_SelB=0;
   IR_SelC=0;
   ir_sensor=0;
  }
  
}


/***********************************************************
	Function Name: Decrease_IR_Level
	Function Description: This function toggles the 
	IR level down one notch at a time, then resets the
	IR level to zero(Full power).
	NOTES: 
        Inputs: none
        Outputs: IR_Toggle, IR_Reset, IR_Intensity
***********************************************************/  
void Decrease_IR_Level(){
        char i;
        IR_Toggle = 1;             //Keep clock line high until  a number of counts has passed
                  
        if (IR_Intensity==15){     //There are 16 levels. 1=High...15=off
                IR_Reset=0;        //Trigger the sync. memory reset    
                IR_Toggle=0;
                IR_Intensity=0;
                IR_Result[ir_sensor][16]=0;
                IR_Result[ir_sensor][17]=0;
                IR_Result[ir_sensor][18]=0;
                for(i=0;i<16;i++)
                {
                 IR_Result[ir_sensor][16]+=IR_Result[ir_sensor][i];
                }
                for(i=2;i<16;i++)
                { 
                        temp=IR_Result[ir_sensor][i];
                        if(temp>0 & i<7)
                        {
                         IR_Result[ir_sensor][18]+=temp/4;
                        }
                        else if(temp>0 & i>=7 & i<8)
                        {
                        IR_Result[ir_sensor][18]+=temp/3;
                        }
                        else if(temp>0 & i>=8 & i<10)
                        {
                        IR_Result[ir_sensor][18]+=temp;
                        }
                        else if(temp>0 & i>=10)
                        {                             
                        IR_Result[ir_sensor][18]+=temp*2;
                        }
                
                }
                
                
                Change_IR_Sensor();
                delay_us(10);
        }                    
        else{ 
                IR_Reset = 1;       //Active low reset
                IR_Toggle = 0;      //Pull counter clock line low,(Low-to-high edge trigger)
                IR_Intensity++;
                delay_us(1);
                }
        
      IR_Toggle=1;
}            
    
    
/***********************************************************
	Function Name: Avg_IR_Samples
	Function Description: This function collects a thousand samples
	from the IR sensors and averages them. This will produce a number
	between 207 to 500. This function is run in the ADISR.
	NOTES: 
        Inputs: adc_data
        Outputs: IR_Result
***********************************************************/
void Avg_IR_Samples()
{
        samples=samples+adc_data[0];
        scnt+=1;
        if (scnt==NumSamples)
        {
                IR_Result[ir_sensor][IR_Intensity]=samples/NumSamples/50-4; 
                samples=0;
                scnt=0;
                Decrease_IR_Level();             
        }                                          
} 


/*
void Change_IR_Level(int level){
                int i;
                IR_Reset = 0;       //Active low reset
                IR_Toggle = 0;      //Pull counter clock line low,(Low-to-high edge trigger)
                IR_Intensity=0;
                delay_us(1);
                IR_Toggle = 1;
                delay_us(1); 
                IR_Reset = 1;       //Active low reset               
        for(i=1;i<=level;i++) {
                        delay_us(1);
                        IR_Toggle = 0;      //Pull counter clock line low,(Low-to-high edge trigger)
                        IR_Intensity++;
                        delay_us(1);
                        IR_Toggle = 1;
                        }          
      IR_Toggle=1;
}*/




   
#include <mega128.h> 

#define IR_Toggle PORTA.0
#define IR_Reset PORTA.1
#define IR_SelA PORTA.2
#define IR_SelB PORTA.3
#define IR_SelC PORTA.4

#define IR 0
#define S1 1;
#define S2 2;
#define A  3; 

#define FIRST_ADC_INPUT 0
#define LAST_ADC_INPUT 3
#define ADC_VREF_TYPE 0x00

#define motor_changespeed 1
#define sway_speed 50
char LB;
char adc_index;
char t2ctr;
void adjust_speed(); 
void TimeOutWD();

bit look;
char look_cntr;              
                    
void init_ADC()
{ 
// ADC initialization
// ADC Clock frequency: 115.200 kHz
// ADC Voltage Reference: AREF pin
ADMUX=ADC_VREF_TYPE;
ADCSRA=0xDF;

 IR_SelA=0;
 IR_SelB=0;
 IR_SelC=0;
 ir_sensor=0;
 IR_Toggle=0;
 IR_Reset=1;
} 

// ADC interrupt service routine
interrupt [ADC_INT] void adc_isr(void)
{
// Read the AD conversion result
adc_data[channel]=ADCW;
//sample rate: 115kHz 
// Select next ADC input
if(read_sonar==0)
        Avg_IR_Samples();
if(channel>0 & channel<3 & read_sonar==1)
        Read_Sonar();
if(channel==3)
        ammeter();
        
if(read_sonar==1)
{
 channel=sonar_sel+1;
}
else if(read_current==1)
{
 channel=3;
}
else
 {
 channel=0;
 }
ADMUX=(FIRST_ADC_INPUT|ADC_VREF_TYPE)+channel;
// Start the AD conversion
ADCSRA|=0x40;   //Start another conversion
} 

void init_timer2()
{
// Timer/Counter 2 initialization
// Clock source: System Clock
// Clock value: 14.400 kHz
// Mode: Normal top=FFh
// OC2 output: Disconnected
TCCR2=0x05;
TCNT2=0x00;
OCR2=0x00;
// Timer(s)/Counter(s) Interrupt(s) initialization
TIMSK|=0x40;
}

// Timer 2 overflow interrupt service routine
interrupt [TIM2_OVF] void timer2_ovf_isr(void)
{ 
 Enable_Sonar();
 TimeOutWD();
 
 t2ctr+=1;
 if(t2ctr == motor_changespeed)
 {
 t2ctr=0;
 adjust_speed();
 }
 
 LB+=1;
 
 if(look_cntr==sway_speed)
 {
 look_cntr=0;
 look^=1;
 }
 else
 {  
 look_cntr+=1;
 }
}

/*
// Read the AD conversion result
unsigned int read_adc(unsigned char adc_input)
{
ADMUX=adc_input | (ADC_VREF_TYPE & 0xff);
// Delay needed for the stabilization of the ADC input voltage
delay_us(10);
// Start the AD conversion
ADCSRA|=0x40;
// Wait for the AD conversion to complete
while ((ADCSRA & 0x10)==0);
ADCSRA|=0x10;
return ADCW;
} 
*/
#define Lservo PORTB.7   //OC1C
#define Rservo PORTB.6   //OC1B
#define Gripper PORTB.5  //OC1A
#define Tilter PORTE.4     //OC3A


#define ls_och OCR1CH
#define ls_ocl OCR1CL

#define rs_och OCR1BH
#define rs_ocl OCR1BL

#define gr_och OCR1AH
#define gr_ocl OCR1AL

#define ti_och OCR3AH
#define ti_ocl OCR3AL

#define top 500
#define tilt_max 475

#define tilt_up 448
#define tilt_down 466

#define tilt_min 445 
#define center 456
#define grip_max 482
#define grip_min 462
#define stopped 482
#define l_neutral 456
#define r_neutral 484

#define grip_strength 22

#include <mega128.h> 

//Global Variables
signed int l_speed=top;
signed int r_speed=top;
int grip_pos=470;
int tilt_pos=center;
int cntr;
int lspd=0;
int rspd=0;
int gpos=470;
int tpos=center;
bit object_ready;

signed int left_speed;
signed int right_speed;

void init_timer1()
{
// Timer/Counter 1 initialization
// Clock source: System Clock
// Clock value: 56.700 kHz
// Mode: Ph. & fr. cor. PWM top=ICR1
// OC1A output: Inverted
// OC1B output: Inverted
// OC1C output: Inverted
// Noise Canceler: Off
// Input Capture on Rising Edge
// Timer 1 Overflow Interrupt: Off
// Input Capture Interrupt: On
// Compare A Match Interrupt: On
// Compare B Match Interrupt: On
// Compare C Match Interrupt: On
TCCR1A=0xFC;
TCCR1B=0x54;
TCNT1H=0x00;
TCNT1L=0x00;

ICR1H=0x01;  //TOP=500
ICR1L=0xF4;

gr_och=grip_min/256;         //OCR1AH
gr_ocl=grip_min%256;         //OCR1AL;

rs_och=top/256;         //OCR1BH
rs_ocl=top%256;         //OCR1BL

ls_och=top/256;         //OCR1CH
ls_ocl=top%256;         //OCR1CL

TIMSK|=0x18;
ETIMSK|=0x01;
}

void init_timer3()
{
 // Timer/Counter 3 initialization
// Clock source: System Clock
// Clock value: 56.700 kHz
// Mode: Ph. & fr. cor. PWM top=ICR3
// Noise Canceler: Off
// Input Capture on Rising Edge
// OC3A output: Inverted
// OC3B output: Discon.
// OC3C output: Discon.
// Timer 3 Overflow Interrupt: Off
// Input Capture Interrupt: On
// Compare A Match Interrupt: On
// Compare B Match Interrupt: Off
// Compare C Match Interrupt: Off
TCCR3A=0xC0;
TCCR3B=0x54;
TCNT3H=0x00;
TCNT3L=0x00;

ICR3H=0x01;     //TOP=500
ICR3L=0xF4;

ti_och=center/256;         //OCR3AH
ti_ocl=center%256;         //OCR3AL

OCR3BH=0x00;
OCR3BL=0x00;
OCR3CH=0x00;
OCR3CL=0x00;

ETIMSK|=0x10;
}

void Lmotor_ctrl(signed int spd){
                 if(spd>=-10 & spd<=10 & spd!=0)
                 {
                  l_speed=l_neutral-spd;
                 }
                 else if(spd==0)
                 {
                  l_speed=top;
                 }        
        
        ls_och=l_speed/256;
        ls_ocl=l_speed%256;     
}

void Rmotor_ctrl(signed int spd){ 
                 if(spd>=-10 & spd <=10 & spd!=0)
                {
                  r_speed=r_neutral+spd;
                 }
                 else if(spd==0)
                 {
                  r_speed=top;
                 }
 
        rs_och=r_speed/256;
        rs_ocl=r_speed%256;     
}

void grip_ctrl(char pos){
        
         if(pos=='O')
         {
          grip_pos=center;
         }
         else if(pos=='C')
         {
          if(Amps<=grip_strength & grip_pos<grip_max)
           {
                if(new_reading==1)
                {
                grip_pos+=1;
                new_reading=0;
                }
           }
           else if(Amps>grip_strength | grip_pos==grip_max)
           {
            object_ready=1;
           }
         }  
 
        gr_och=grip_pos/256;
        gr_ocl=grip_pos%256; 
}

void tilt_ctrl(char pos){
        if(pos=='D')
        {
        tilt_pos=tilt_down;
        }
        else if(pos=='C')
        {
        tilt_pos=center;
        }
        else if(pos=='U')
        {
        tilt_pos=tilt_up;
        }
        
        ti_och=tilt_pos/256;
        ti_ocl=tilt_pos%256; 
}


void adjust_speed()
{
if(rspd<right_speed)
{
rspd+=1;
}
else if(rspd>right_speed)
{
rspd-=1;
}

if(lspd<left_speed)
{
 lspd+=1;
}
else if(lspd>left_speed)
{
 lspd-=1;
}


}

// Timer 3 output compare A interrupt service routine
interrupt [TIM3_COMPA] void timer3_compa_isr(void)
{ 
/*
 if(button==3)
 {
  tpos+=2;
  tilt_ctrl(tpos);
  button=0;
 }
 else if(button==6)
 {
  tpos-=2;
  tilt_ctrl(tpos);
  button=0;
  }
  PORTB.0^=1; 
  */
}

// Timer 1 output compare A interrupt service routine
interrupt [TIM1_COMPA] void timer1_compa_isr(void)
{
 read_current=1;
 /*
 if(button==7)
 {
  gpos+=1;
  grip_ctrl(gpos);
  button=0;
 }
 else if(button==8)
 {
  grip_ctrl('C');
  
  }
*/ 
}

// Timer 1 output compare B interrupt service routine
interrupt [TIM1_COMPB] void timer1_compb_isr(void)
{

Rmotor_ctrl(rspd);
/*
 if(button==4)
 {
  right_speed+=1;
  Rmotor_ctrl(right_speed);
  button=0;
 }
 else if(button==5)
 {
  right_speed-=1;
  Rmotor_ctrl(right_speed);
  button=0;
  }
*/ 
}

// Timer 1 output compare C interrupt service routine
interrupt [TIM1_COMPC] void timer1_compc_isr(void)
{

Lmotor_ctrl(lspd);

/*
 if(button==1)
 {
  left_speed+=1;
  Lmotor_ctrl(left_speed);
  button=0;
 }
 else if(button==2)
 {
  left_speed-=1;
  Lmotor_ctrl(left_speed);
  button=0;
  }
*/
 } 
 
 
/**************************************
This function controls the motors.
**************************************/
void motor_ctrl(int direction)
{ 
 if(direction=='c')
 {
  left_speed=10;
  right_speed=-10;
 }
 else if(direction=='C')
 {
  left_speed=-10;
  right_speed=10;
 }
  else if(direction=='r')
 {
  left_speed=5;
  right_speed=2;
 }
 else if(direction=='l')
 {
  left_speed=2;
  right_speed=5;
 } 
 else if(direction=='R')
 {
  left_speed=10;
  right_speed=0;
 } 
 else if(direction=='L')
 {
  left_speed=0;
  right_speed=10;
 } 
 else if(direction=='S')
 {
  left_speed=10;
  right_speed=10;
 }
  else if(direction=='B')
 {
  left_speed=-10;
  right_speed=-10;
 }
 else if(direction=='P')
 {
  left_speed=0;
  right_speed=0;
 }
 else if(direction=='>')
 {
  left_speed=3;
  right_speed=1;
 }
 else if(direction=='<')
 {
  left_speed=1;
  right_speed=2;
 }
 else
 {
  left_speed=direction;
  right_speed=direction;   
 }
  
}

#include <mega128.h>
#include <lcd.h> 
#include <delay.h>
#include <stdlib.h>
#include <stdio.h> 

#define EOL 0xFF        //end of line
#define SOL 0x0A        //start of line
#define CR 13           // carriage return
#define TTL 30 

#define x_min 12
#define x_max 175
#define y_min 1
#define y_max 143
#define x_center 82
#define y_center 71
#define offset 20 

#define RXB8 1
#define TXB8 0
#define UPE 2
#define OVR 3
#define FE 4
#define UDRE 5
#define RXC 7

#define FRAMING_ERROR (1<<FE)
#define PARITY_ERROR (1<<UPE)
#define DATA_OVERRUN (1<<OVR)
#define DATA_REGISTER_EMPTY (1<<UDRE)
#define RX_COMPLETE (1<<RXC)

// USART0 Receiver buffer
#define RX_BUFFER_SIZE0 8
char rx_buffer0[RX_BUFFER_SIZE0];

#if RX_BUFFER_SIZE0<256
unsigned char rx_wr_index0,rx_rd_index0,rx_counter0;
#else
unsigned int rx_wr_index0,rx_rd_index0,rx_counter0;
#endif

// This flag is set on USART0 Receiver buffer overflow
bit rx_buffer_overflow0;
 
char blob_info[8][5];
char blobs;
char num_blobs;

char blob_xsize;
char blob_ysize;
char blob_xcenter;
char blob_ycenter;
bit cam_mtr_ctrl=0;

bit TimeOut;
char ttl_cntr;

bit camera_ready = 0;
bit new_trackdata;
bit ACK;
int test;
unsigned char object[8][4];     // blob[color][size]

char i;

void get_ack();

void init_UART0()
{
// USART0 initialization
// Communication Parameters: 8 Data, 1 Stop, No Parity
// USART0 Receiver: On
// USART0 Transmitter: On
// USART0 Mode: Asynchronous
// USART0 Baud rate: 115200
UCSR0A=0x00;
UCSR0B=0x98;
UCSR0C=0x06;
UBRR0H=0x00;
UBRR0L=0x07;
}

unsigned char UART_Rx(void){
        TimeOut=1;
        ttl_cntr=0;
        //wait for data to be received or ttl to expire
        while(!(UCSR0A & (1<<RXC)));// & TimeOut==1);
        //Return Rx data from buffer
     //   if (TimeOut==1)
     //   {
                return UDR0;  
     //   }
     //   else
     //   {
     //           return 0;     //Return zero because TTL expired
     //   }
}

void TimeOutWD()
{ 
if (TimeOut==1)
{
 if(ttl_cntr==TTL)
 {
  TimeOut=0;
 }
 else
 {
 ttl_cntr+=1;
 }
}
}


void get_ack()
{
 char i;
 char ack[]="ACK\r"; 

        for(i=0;i<4;i++)
        { 
         
         if(UART_Rx()==ack[i])  
         {
          ACK=1;
         }
         else{
          lcd_clear();
          lcd_putsf("No ACK!");
          delay_ms(500);
          ACK=0;
          break;
          }
         }

}

char ping_cam(void)
{

  //turn off UART interrupt
  UCSR0B=0x18;
 printf("DT\r");       //disable tracking
 get_ack();
 delay_ms(500);
 ACK=0;
 //printf("PG\r");       //ping

 do
 {
  delay_ms(10);
  printf("PG\r");       //ping
  get_ack();
 }
  while(ACK==0);
  //turn on UART interrupt  
UCSR0B=0x98; 
 if( ACK==1 )
 {
  return 1;
  ACK=0;
  }
  else{
  return 0;
  }
}
 
/********************************************
This function will return relative position
of the color of the object in the function call.
********************************************/
char track_object(char slot)
{
if(slot<8)
{
 if(object[slot][2]>(x_center+offset))
 {
  return 'r';
 }
 else if(object[slot][2]<(x_center-offset))
 {
  return 'l';
 }
 else if(object[slot][2]<=(x_center+offset) & object[slot][2]>=(x_center-offset))
 {
  return 'S';
 } 
}
else
{
 return 0;
}
}

/********************************************
This function receives the tracking packet
from the camera and stores it in blob_info.
It is called from the UART_ISR.
********************************************/
void tracking_packet(void)
{
 int xlength,ylength;
 char i,j;
 char start;
 char data;
 i=0;
 j=0;
 blobs=UART_Rx();        //This is the number of blobs
 num_blobs=blobs;
while(data!=EOL)       //Read the tracking packet
{
 data=UART_Rx();
 if(data!=EOL)
 {
 blob_info[i][j]=data;
 j+=1;
        if(j==5)
        {
         j=0;
         i+=1;
        }
 }
}

for(i=0;i<blobs;i+=1)
 {
         xlength=(blob_info[i][3]-blob_info[i][1])/2;    
         ylength=(blob_info[i][4]-blob_info[i][2])/2;
         object[i][0]=blob_info[i][0];                     //color
         object[i][1]=xlength*ylength;                     //area
         object[i][2]=xlength+blob_info[i][1];             //x position of blob
         
 }
 
new_trackdata=1;         //signal that data is new
data=0;
start=0;
UCSR0B=0x98; 
}



void disable_tracking(void)
{
        printf("DT\r");   
} 

void enable_tracking(void)
{ 
#asm ("cli")
        printf("ET\r");
#asm ("sei")    
 }
 
 void toggle_AWB()
 {
 /*
 reg:0x12 AWB                   on=>0x2C/44     off=>0x28/40 
 reg:0x2D Light Filter          on=>0x07        off=>0x03 
 reg:0x13 Enable AutoAdjust     on=>0x01        off=>0x00
 */
  printf("CR 18 40 45 3 19 0\r");
  get_ack();
  printf("CR 18 44 45 7 19 1\r"); 
  get_ack();
 }
 
 void init_camera()
{
lcd_clear();
lcd_putsf("Waiting for Camera");
delay_ms(1000);
ping_cam();        
lcd_clear();
lcd_putsf("Camera Ready!"); 
toggle_AWB();
enable_tracking();
camera_ready=1;
delay_ms(1000);
} 

void track()
{ 

while (1)
      {
       lcd_clear();
       lcd_putsf("TI ");
       for(i=0;i<5;i++)
       {
        test=blob_info[0][i];
        lcd_PrintInt(test);
        lcd_putsf(" ");
        delay_ms(1);
        }
        
        
        lcd_gotoxy(0,1);
        lcd_PrintInt(blob_xcenter);
        lcd_putsf(" ");
        lcd_PrintInt(blob_ycenter);
        delay_ms(50);
       
       if(button==1)
       {
        cam_mtr_ctrl=1;
        button=0;
       }
       else if(button==2)
       {
        cam_mtr_ctrl=0;
        left_speed=0;
        right_speed=0;
        button=0;
       }
      
} 
        
}

// USART0 Receiver interrupt service routine
interrupt [USART0_RXC] void usart0_rx_isr(void)
{
char status,data;
status=UCSR0A;
data=UDR0;

if(data==SOL)
{
PORTB.0^=1;
 //turn off UART interrupt
  UCSR0B=0x18;
  tracking_packet();  
}


}
      
#include <mega128.h>

#define LeftSwitch PINE.7
#define RightSwitch PINE.4

#define ir_N    5
#define ir_VF   10
#define ir_F    15
#define ir_Near    25
#define ir_VN   35

 int left_front;
 int right_front;
 int center_front;
 bit got_object;

char find_object_color();
char wait_for_trackdata();
void adjust_leds();
char color;
 
/********************************************
This function takes all the ir sensor data
and returns a value indicating the proximity
of an object in front of it.
********************************************/
int analyse_ir()
{
 char L_distance;
 char R_distance;
 char LF_distance;
 char RF_distance;
 char C_distance;
 unsigned int left;
 unsigned int right;
 unsigned int l_front;
 unsigned int r_front;
 unsigned int c_front;

/*
S=straight
l=slight left
L=left
C=Counter Clockwise rotation
r=slight right
R=right
c=clockwise rotation
B=backwards
*/
int table[6][6] = {{'S','S','l','L','L','C'}, //L_distance=0
                   {'S','S','l','L','C','C'},
                   {'r','r','S','C','C','C'},
                   {'r','R','c','S','C','C'},
                   {'r','R','c','c','B','B'},
                   {'c','c','c','c','B','B'}};//L_distance=5
 
 left=IR_Result[0][18];
 right=IR_Result[1][18];
 l_front=IR_Result[3][18];
 r_front=IR_Result[2][18];
 c_front=IR_Result[4][18];
           
 if(left>=16)
 {
  L_distance=5;
 }
 else if(left>=13 & left<16)
 {
  L_distance=4;
 }
 else if(left>=11 & left<13)
 {
  L_distance=3;
 }
 else if(left>=8 & left<11)
 {
  L_distance=2;
 }
 else if(left>=4 & left<8)
 {
  L_distance=1;
 }
 else if(left<4)
 {
  L_distance=0;
 }
 

  if(right>=16)
 {
  R_distance=5;
 }
 else if(right>=13 & right<16)
 {
  R_distance=4;
 }
 else if(right>=11 & right<13)
 {
  R_distance=3;
 }
 else if(right>=8 & right<11)
 {
  R_distance=2;
 }
 else if(right>=4 & right<8)
 {
  R_distance=1;
 }
 else if(right<4)
 {
  R_distance=0;
 }
 
 if(r_front>=16)
 {
  RF_distance=5;
 }
 else if(r_front>=13 & r_front<16)
 {
  RF_distance=4;
 }
 else if(r_front>=11 & r_front<13)
 {
  RF_distance=3;
 }
 else if(r_front>=8 & r_front<11)
 {
  RF_distance=2;
 }
 else if(r_front>=4 & r_front<8)
 {
  RF_distance=1;
 }
 else if(r_front<4)
 {
  RF_distance=0;
 }
 
 if(l_front>=18)
 {
  LF_distance=5;
 }
 else if(l_front>=14 & l_front<18)
 {
  LF_distance=4;
 }
 else if(l_front>=11 & l_front<14)
 {
  LF_distance=3;
 }
 else if(l_front>=8 & l_front<11)
 {
  LF_distance=2;
 }
 else if(l_front>=4 & l_front<8)
 {
  LF_distance=1;
 }
 else if(l_front<4)
 {
  LF_distance=0;
 }
 
 if(c_front>=IRMAX)
 {
  C_distance=6;
 }
 else if(c_front>=18 & c_front<IRMAX)
 {
  C_distance=5;
 }
 else if(c_front>=14 & c_front<18)
 {
  C_distance=4;
 }
 else if(c_front>=11 & c_front<14)
 {
  C_distance=3;
 }
 else if(c_front>=8 & c_front<11)
 {
  C_distance=2;
 }
 else if(c_front>=2 & c_front<8)
 {
  C_distance=1;
 }
 else if(c_front<2)
 {
  C_distance=0;
 }
 
 left_front=LF_distance;
 right_front=RF_distance;
 center_front=C_distance;
 
 if(LF_distance>L_distance)
 {
  L_distance=LF_distance;
 }
 
 if(RF_distance>R_distance)
 {
  R_distance=RF_distance;
 }
 
 return table[L_distance,R_distance];
} 


/********************************************
This function analyses the sonar readings and
figures out how the motors should react.
********************************************/
int analyse_sonar()
{
 char L_distance;
 char R_distance;
 char left;
 char right;
/*
S=straight
l=slight left
L=left
C=Counter Clockwise rotation
r=slight right
R=right
c=clockwise rotation
B=backwards
*/
int table[5][5] = {{'S','S','l','L','C'}, //L_distance=0
                   {'S','S','l','L','C'},
                   {'r','l','L','C','C'},
                   {'r','R','c','c','c'},
                   {'R','R','c','c','B'}};//L_distance=4
 
 left=SonarInches[0];
 right=SonarInches[1];
           
 if(left<=7)
 {
  L_distance=4;
 }
 else if(left>=8 & left<=9)
 {
  L_distance=3;
 }
 else if(left>=10 & left<=11)
 {
  L_distance=2;
 }
 else if(left>=12 & left<=13)
 {
  L_distance=1;
 }
 else if(left>13)
 {
  L_distance=0;
 }
 

 if(right<=7)
 {
  R_distance=4;
 }
 else if(right>=8 & right<=9)
 {
  R_distance=3;
 }
 else if(right>=10 & right<=11)
 {
  R_distance=2;
 }
 else if(right>=12 & right<=13)
 {
  R_distance=1;
 }
 else if(right>13)
 {
  R_distance=0;
 } 
 
 return table[L_distance,R_distance];
}


void arbitrator(char sonar_dir, char ir_dir)
{
PORTB.0^=1;
 if(LeftSwitch==0 & RightSwitch==1)
 {
  motor_ctrl('B');
 }
 else if(RightSwitch==0 & LeftSwitch==1)
 {
  motor_ctrl('B');
 }
 else if(LeftSwitch==0 & RightSwitch==0)
 {
  motor_ctrl('B');
 }
 else if(sonar_dir==ir_dir)
 {
  motor_ctrl(sonar_dir);
 }
 else if(sonar_dir=='S' & ir_dir!='S')
 {
  motor_ctrl(ir_dir);
 }
 else if(sonar_dir!='S' & ir_dir=='S')
 {
  motor_ctrl(sonar_dir);
 }
 else if((sonar_dir=='l'|sonar_dir=='r') & (ir_dir=='R'|ir_dir=='L'|ir_dir=='C'|ir_dir=='c'|ir_dir=='B')) 
 {
  motor_ctrl(ir_dir);
 } 
 else if((ir_dir=='l'|ir_dir=='r') & (sonar_dir=='R'|sonar_dir=='L'|sonar_dir=='C'|sonar_dir=='c'|sonar_dir=='B')) 
 {
  motor_ctrl(sonar_dir);
 }
 else
 {
  motor_ctrl(sonar_dir);
  }
} 
  
void gripper()
{
  motor_ctrl('P');
  delay_ms(500);
  new_reading=0;
        while(object_ready==0)
        {  
        grip_ctrl('C');
        }
  object_ready=0;
  delay_ms(500);
  tilt_ctrl('U');
  got_object=1;
 
}

char approach_object()
{
 char dir;
 analyse_ir(); 
 
 if(center_front==0)
 {
  dir=0;
 }
 else if(center_front==6 & got_object==0)
 {
  dir='G';
 }
 else if((center_front>0 & center_front<6 & right_front==left_front)|(center_front==4)|(center_front==5))
 {
  dir=2;
 }
 else if(center_front>0 & center_front<4 & right_front>left_front)
 {
  dir='>';
 }
 else if(center_front>0 & center_front<4 & right_front<left_front)
 {
   dir='<';
 }
 else
 {
  dir=0;
 }
 
return dir; 
}

char GetObject()
{
 char cam_dir;
 char ir_dir;

 ir_dir=approach_object();
 
        if(wait_for_trackdata()==1 & color<8)
        {
        new_trackdata=0;
        cam_dir=track_object(find_object_color());
        }
        else
        {
        cam_dir=0;
        adjust_leds();
        }
 
 if(ir_dir=='G')
 { 
 gripper();
 }
 else if(cam_dir==0 & ir_dir==0)
 {
 motor_ctrl('P');
 }
 else if(cam_dir!=0 & (ir_dir==0|center_front<2) )
 {
  motor_ctrl(cam_dir);
 }
 else if(ir_dir!='G' & ir_dir!=0 & center_front>1)
 {
  motor_ctrl(ir_dir);
 }
 else
 {
  motor_ctrl('P');
 }

LCD_Display(50); 
return ir_dir; 
}
#include <mega128.h>

#define laser_size      5

char object_cd[8];
unsigned char laser_center;
char dest;


void LookForLaser();
void LookForHome(char known);
void FindLaserOnObject();
void TakeHome();
void FindObject();
void DropObject();
char find_laser();
char track_laser();
void look_around();


void adjust_leds()
{
led_dc+=5;
 if(led_dc>125)
 {
 led_dc=0;
 }
 
}
/********************************************

********************************************/
void LookForLaser()
{
led_dc=0;
color=0;
dest=0;
FindLaserOnObject();
FindObject();
} 

void FindLaserOnObject()
{
char Loaded;
char i;
Loaded=0;
color=0;
dest=0;
laser_center=0;
                     
if(track_laser()==1)
{
led_dc=75;
new_trackdata=0;
}

LCD_Display(100);

if(wait_for_trackdata()==1 & laser_center!=0)
{
 new_trackdata=0; 
        for(i=0;i<blobs;i+=1)           //cycle through all tracked colors looking for known color
        { 
                if(object[i][0]<8 & object[i][0]>0 & (object[i][2]-laser_center)<15)     //test for proximity to laser center
                {
                color=object[i][0];
                        while(Loaded!='G')              //Approach and then pickup with gripper
                        { 
                        Loaded=GetObject();
                        if(Loaded=='G')
                                break;
                        }
                        motor_ctrl('c'); 
                        LCD_Display(1750);    
                        LookForHome(0);          //Look for Destination and then transfer it
                        new_trackdata=0;
                        break;                                //Start process over again
                }              
      
      }
 }
}

char track_laser()
{
char laser;
bit found_once;
led_dc=0;
found_once=0;
 while(1)            //approach while the laser is trackable,get location
 {
        LCD_Display(100);
        laser=find_laser();
        if(laser==8)      //break if no laser is found
        {
        break;
        }
        found_once=1;        
        motor_ctrl(track_object(laser));
        laser_center=object[laser][2];         //x position of laser
 }
 return found_once;  
}

char wait_for_trackdata()
{
bit new_data;
new_data=1;
LB=0;
while(new_trackdata==0)             //wait for new packets
{ 
 if(LB>2)                        //LB is inc in T2OVF
 {
  new_data=0;                                  //if too many, break out of loop    
  break;
 }
 
} 
return new_data;                 //return one if new data available, zero if no new packets rx before timeout(LB)
}

char find_laser()
{
char k,laser;
 
if(wait_for_trackdata()==1)
{
for(k=0;k<blobs;k+=1)
        {
        if(object[k][0]==0)             //Find slot
                {
                laser=k;
                break;                  //break out and go home
                }
        if(k==blobs-1)
                {
                laser=8;
                motor_ctrl('P');        //turn off motors
                }
        }
  new_trackdata=0;
  LB=0;
}
else                            //No new tracking packets have come in
{
 motor_ctrl('P');
 laser=8;
}  
 return laser;
}

char find_dest_color()
{
 char k,slot;
 k=0;
  for(k=0;k<blobs;k+=1)         //look for a colors slot position in tracking packet
        {
        if(object[k][0]==dest)              //Find destination slot
                {
                slot=k;
                break;                                        //break out and go home
                }
        if(k==blobs-1)
                {
                slot=8;
                adjust_leds();
                motor_ctrl('C');        //turn off motors,could be stuck in loop until dest is found
                }
        }
 return slot;
} 

char find_object_color()
{
 char k,slot;
 k=0;
 for(k=0;k<blobs;k+=1)
 {
        if(object[k][0]==color)              //Find destination slot
                {
                slot=k;
                break;                                        //break out and go home
                }
        if(k==blobs-1)
                {
                slot=8;
                adjust_leds();
                //motor_ctrl('P');        //turn off motors,could be stuck in loop until object is found
                }
 }
 
 return slot;
} 
 
void LookForHome(char known)
{
char k;
laser_center=0;
k=0;
 if(known==0)
 { 
 while(got_object==1)
 {
        if(track_laser()==1)
        {
        led_dc=75;
        new_trackdata=0;
        }
        else
        {
         //motor_ctrl('>');
         left_speed=2;
         right_speed=-2;
        }
        LCD_Display(50);
     
        if(wait_for_trackdata()==1 & laser_center!=8)         //look for laser
        {
        new_trackdata=0;
                for(k=0;k<blobs;k+=1)
                { 
                if(object[k][0]<8 & object[k][0]>0 & object[k][0]!=color & (object[k][2]-laser_center)<15)      //test for proximity
                {
                object_cd[color]=object[k][0];      //store objects color and destination
                dest=object_cd[color];             //assign destination
                TakeHome();                        //Look for destination to take it
                break;
                }       
                }
        }
        else
        {
        // left_speed=3;
        // right_speed=-3;
        motor_ctrl('P');
        }
 }
 }
//the object is recognized and its destination known.
else
{   
   TakeHome();
} 
color=0;
dest=0; 
} 

void TakeHome()
{ 
char camera_dir;
while(1)
{
        if(wait_for_trackdata()==1)
        {
        camera_dir=track_object(find_dest_color());
        new_trackdata=0;
        }
        else
        {
         camera_dir='>';
        }
        
 analyse_ir();
 
        if(((right_front==left_front & right_front>2)|SonarInches[0]<6|SonarInches[1]<6)&camera_dir=='S')
        {
        DropObject();
        break;
        }
        else if(camera_dir!=0)
        {
         motor_ctrl(camera_dir);
        }
        else if(camera_dir==0)
        {
         motor_ctrl('>');
        }
 LCD_Display(100);
}
}

void DropObject()
{
 motor_ctrl('P');
 delay_ms(250);
 tilt_ctrl('C');
 delay_ms(500);
 grip_ctrl('O');        //open clamp
 motor_ctrl('B');
 delay_ms(500);
 motor_ctrl('C');
 delay_ms(1400);
 got_object=0;
}

void FindObject()
{
char Loaded;
Loaded=0;

if(wait_for_trackdata()==1)
{
 new_trackdata=0;
 for (i=0;i<blobs;i+=1) 
   {
     if(object[i][0]<8 & object[i][0]>0 & object_cd[object[i][0]]!=0)  //Determine if familiar
     {          
        color=object[i][0];         //object color
        dest=object_cd[color];
        break;       
     }
     else if(i==blobs-1)
     {
     adjust_leds(); 
     //color=0;   //non-existant color choice
     break; 
     }
    }
    
if(color!=0)
{
while(Loaded!='G')
{       
 Loaded=GetObject();
}
 motor_ctrl('c'); 
 LCD_Display(1750);
 LookForHome(1);
}
}

}

void LCD_Display(int delay)
{  
     lcd_clear();      
 /*    
     lcd_PrintInt(IR_Result[0][18]);
     lcd_putsf(" ");
     lcd_PrintInt(IR_Result[1][18]);
     lcd_putsf(" "); 
     lcd_PrintInt(IR_Result[3][18]);
     lcd_putsf(" ");
     lcd_PrintInt(IR_Result[2][18]);
     lcd_putsf(" ");
     lcd_PrintInt(IR_Result[4][18]);
     lcd_putsf("_");
     lcd_PrintInt(SonarInches[0]);
     lcd_putsf(" ");
     lcd_PrintInt(SonarInches[1]);
  */   
     
   //  for(k=6;k<=18;k+=1)
   //  {
   //   temp=IR_Result[4][k];
   
      lcd_PrintInt(IR_Result[3][18]);
      lcd_gotoxy(2,0);
      lcd_PrintInt(IR_Result[4][18]);
      lcd_gotoxy(4,0);
      lcd_PrintInt(IR_Result[2][18]);
      lcd_gotoxy(6,0);
      lcd_putsf("_");
      lcd_PrintInt(led_dc); 
      lcd_gotoxy(10,0);
      lcd_putsf("_");
      lcd_PrintInt(num_blobs);
      num_blobs=0;
      lcd_putsf("_");
      lcd_PrintInt(object[0][0]);
      lcd_PrintInt(object[1][0]);
      lcd_PrintInt(object[2][0]); 
      lcd_putsf("_");
      lcd_PrintInt(color);
      lcd_PrintInt(dest);
      
      
     // lcd_gotoxy(15,0);
     // lcd_putsf("_");
     // lcd_PrintInt(IRMAX);
    /// }
     
     lcd_gotoxy(0,1);
     lcd_PrintInt(Amps);
     
  //   lcd_putsf(" ");
  //   lcd_PrintInt(led_dc); 

     lcd_putsf("_");
     lcd_PrintInt(left_front);
     lcd_putsf(" ");
     lcd_PrintInt(center_front);
     lcd_putsf(" ");
     lcd_PrintInt(right_front); 
     lcd_putsf("_");
     lcd_PrintInt(left_speed);
     lcd_putsf(" ");
     lcd_PrintInt(right_speed);
     lcd_putsf(" ");
     lcd_putchar(approach_object());
     lcd_putsf(" ");
     lcd_PrintInt(SonarInches[0]);
     lcd_putsf(" ");
     lcd_PrintInt(SonarInches[1]);          
     
     delay_ms(delay);
}
#include <mega128.h> 
#include <lcd.h>

#define ADC_VREF_TYPE 0x00

// Declare your global variables here
//char i;

int k;
char x;
char temp1;
char Dir[]="PSCLl<>rRcB";
void main(void)
{
// Declare your local variables here

// Input/Output Ports initialization
// Port A initialization
// OUT
// State=0 
PORTA=0x00;
DDRA=0xFF;

// Port B initialization
// Func7=OUT Func6=OUT Func5=OUT Func4=OUT Func3=OUT Func2=OUT Func1=In Func0=LED 
// State7=0 State6=0 State5=0 State4=0 State3=0 State2=0 State1=T State0=0 
PORTB=0x00;
DDRB=0xFD;

// Port C initialization
// Func=OUT 
// State=0
PORTC=0x00;
DDRC=0xFF;

// Port D initialization
// Func7=OUT Func6=OUT Func5=In Func4=In Func3=In Func2=In Func1=In Func0=In 
// State7=0 State6=0 State5=T State4=T State3=T State2=T State1=T State0=T 
PORTD=0x00;
DDRD=0xC0;

// Port E initialization
// Func7=In Func6=In Func5=In Func4=In Func3=OUT Func2=In Func1=In Func0=In 
// State7=T State6=T State5=T State4=T State3=0 State2=T State1=T State0=T 
PORTE=0x00;
DDRE=0x08;

// Port F initialization
// Func7=In Func6=In Func5=In Func4=In Func3=In Func2=In Func1=In Func0=In 
// State7=T State6=T State5=T State4=T State3=T State2=T State1=T State0=T 
PORTF=0x00;
DDRF=0x00;

// Port G initialization
// Func4=In Func3=In Func2=In Func1=In Func0=In 
// State4=T State3=T State2=T State1=T State0=T 
PORTG=0x00;
DDRG=0x00;

init_timer0();

init_timer1();

init_timer2();

init_timer3();

// Analog Comparator initialization
// Analog Comparator: Off
// Analog Comparator Input Capture by Timer/Counter 1: Off
ACSR=0x80;
SFIOR=0x00;

lcd_init(20);

init_keypad();

init_ADC();

init_UART0();

init_camera();
delay_ms(300);
// Global enable interrupts
#asm("sei")


while (1)
{
      lcd_clear();
LCD_Display(100);           
if(button==1)
      {
       motor_ctrl(analyse_sonar());
      }
      else if(button==2)
      {
       //motor_ctrl(analyse_ir());
       color=2;
       GetObject();
      } 
      else if(button==0)
      {
       got_object=0;
       left_speed=0;
       right_speed=0;
       analyse_ir();
      } 
      else if(button==3)
      {
       arbitrator(analyse_sonar(),analyse_ir());
      }
      else if(button==4)
      {
       gripper();
       }
       else if(button==5)
       {
        grip_ctrl('O');
       }
       else if(button==6)
       {
        object_cd[4]=5; //hardwire object color to destination
        color=4;
        FindObject();
       }
       else if(button==7)
       {
        tilt_ctrl('U');
       }
       else if(button==8)
       {
        tilt_ctrl('C');
       }
       else if(button==9)
       {
        tilt_ctrl('D');
        }
        else if(button==10)
        {
        while(button==10)
         LookForLaser();
         //FindLaserOnObject();
         //LookForLaser();
         //GetObject(0);
         //FindObject();
         //LookForHome(0);
         //TakeHome(0);
         }
         else if (button==11)
         {
         analyse_ir();
         IRMAX=IR_Result[4][18];
         /* x+=1;
          button=0; 
          if(x==11)
          {
           x=0;
          }  */
             
}    


                    
   LCD_Display(100);
   


}
}
